/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.lib.persistence;

import android.app.Application;
import android.content.Context;
import android.os.AsyncTask;
import android.os.Looper;
import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import net.doo.snap.lib.persistence.OptimizationType;
import net.doo.snap.lib.persistence.Page;
import net.doo.snap.lib.util.FileUtils;
import net.doo.snap.lib.util.log.DebugLog;
import org.jetbrains.annotations.NotNull;

public class PageStoreStrategy {
    public static final String FILTERED_FOLDER = "filtered";
    private Application context;

    @Inject
    public PageStoreStrategy(Application context) {
        this.context = context;
    }

    @NotNull
    public File getPagesDir() throws IOException {
        return FileUtils.getExternalFilesDirOrShowError((Context)this.context, "snapping_pages");
    }

    @NotNull
    public File getPageDir(String pageId) throws IOException {
        return org.apache.commons.io.FileUtils.getFile((File)this.getPagesDir(), (String[])new String[]{pageId});
    }

    @NotNull
    public File getImageFile(@NotNull String pageId, @NotNull Page.ImageType imageType) throws IOException {
        return org.apache.commons.io.FileUtils.getFile((File)this.getPagesDir(), (String[])new String[]{pageId, imageType.getFileName()});
    }

    public File getFilteredPreviewFile(@NotNull String pageId, @NotNull OptimizationType optimizationType) throws IOException {
        return org.apache.commons.io.FileUtils.getFile((File)this.getPageDir(pageId), (String[])new String[]{FILTERED_FOLDER, optimizationType.getName()});
    }

    public void erasePage(String pageId) {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            new AsyncTask<String, Void, Void>(){

                protected Void doInBackground(String ... params) {
                    String pageId = params[0];
                    PageStoreStrategy.this.erasePageSync(pageId);
                    return null;
                }
            }.execute((Object[])new String[]{pageId});
        } else {
            this.erasePageSync(pageId);
        }
    }

    private void erasePageSync(String pageId) {
        try {
            File pageDir = this.getPageDir(pageId);
            if (pageDir.exists() && pageDir.isDirectory()) {
                org.apache.commons.io.FileUtils.deleteDirectory((File)pageDir);
            }
        }
        catch (IOException e) {
            DebugLog.logException(e);
        }
    }
}

