/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.lib.snap.camera.barcode.result;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.provider.ContactsContract;
import android.text.TextUtils;
import android.widget.Toast;
import com.google.zxing.client.result.ParsedResult;
import com.google.zxing.client.result.ParsedResultType;
import java.util.ArrayList;
import java.util.Locale;
import net.doo.snap.lib.snap.camera.barcode.Contents;
import net.doo.snap.lib.snap.camera.barcode.LocaleManager;
import net.doo.snap.lib.util.log.DebugLog;

public abstract class ResultHandler {
    private static final String TAG = ResultHandler.class.getSimpleName();
    private static final String[] EMAIL_TYPE_STRINGS = new String[]{"home", "work", "mobile"};
    private static final String[] PHONE_TYPE_STRINGS = new String[]{"home", "work", "mobile", "fax", "pager", "main"};
    private static final String[] ADDRESS_TYPE_STRINGS = new String[]{"home", "work"};
    private static final int[] EMAIL_TYPE_VALUES = new int[]{1, 2, 4};
    private static final int[] PHONE_TYPE_VALUES = new int[]{1, 3, 2, 4, 6, 12};
    private static final int[] ADDRESS_TYPE_VALUES = new int[]{1, 2};
    private static final int NO_TYPE = -1;
    private final ParsedResult result;
    private final Activity activity;

    ResultHandler(Activity activity, ParsedResult result) {
        this.result = result;
        this.activity = activity;
    }

    public ParsedResult getResult() {
        return this.result;
    }

    final Activity getActivity() {
        return this.activity;
    }

    public abstract int getButtonCount();

    public abstract int getButtonText(int var1);

    public abstract void handleButtonPress(int var1);

    public boolean areContentsSecure() {
        return false;
    }

    public CharSequence getDisplayContents() {
        String contents = this.result.getDisplayResult();
        return contents.replace("\r", "");
    }

    public abstract String getDisplayTitle();

    public abstract String getDisplaySubtitle();

    public abstract String getDisplayText();

    public abstract int getDisplayIconRes();

    public final ParsedResultType getType() {
        return this.result.getType();
    }

    final void addPhoneOnlyContact(String[] phoneNumbers, String[] phoneTypes) {
        this.addContact(null, null, null, phoneNumbers, phoneTypes, null, null, null, null, null, null, null, null, null, null, null);
    }

    final void addEmailOnlyContact(String[] emails, String[] emailTypes) {
        this.addContact(null, null, null, null, null, emails, emailTypes, null, null, null, null, null, null, null, null, null);
    }

    final void addContact(String[] names, String[] nicknames, String pronunciation, String[] phoneNumbers, String[] phoneTypes, String[] emails, String[] emailTypes, String note, String instantMessenger, String address, String addressType, String org, String title, String[] urls, String birthday, String[] geo) {
        int type;
        ContentValues row;
        Intent intent = new Intent("android.intent.action.INSERT_OR_EDIT", ContactsContract.Contacts.CONTENT_URI);
        intent.setType("vnd.android.cursor.item/contact");
        ResultHandler.putExtra(intent, "name", names != null ? names[0] : null);
        ResultHandler.putExtra(intent, "phonetic_name", pronunciation);
        int phoneCount = Math.min(phoneNumbers != null ? phoneNumbers.length : 0, Contents.PHONE_KEYS.length);
        for (int x = 0; x < phoneCount; ++x) {
            int type2;
            ResultHandler.putExtra(intent, Contents.PHONE_KEYS[x], phoneNumbers[x]);
            if (phoneTypes == null || x >= phoneTypes.length || (type2 = ResultHandler.toPhoneContractType(phoneTypes[x])) < 0) continue;
            intent.putExtra(Contents.PHONE_TYPE_KEYS[x], type2);
        }
        int emailCount = Math.min(emails != null ? emails.length : 0, Contents.EMAIL_KEYS.length);
        for (int x = 0; x < emailCount; ++x) {
            int type3;
            ResultHandler.putExtra(intent, Contents.EMAIL_KEYS[x], emails[x]);
            if (emailTypes == null || x >= emailTypes.length || (type3 = ResultHandler.toEmailContractType(emailTypes[x])) < 0) continue;
            intent.putExtra(Contents.EMAIL_TYPE_KEYS[x], type3);
        }
        ArrayList<ContentValues> data = new ArrayList<ContentValues>();
        if (urls != null) {
            for (String url : urls) {
                if (TextUtils.isEmpty((CharSequence)url)) continue;
                row = new ContentValues(2);
                row.put("mimetype", "vnd.android.cursor.item/website");
                row.put("data1", url);
                data.add(row);
                break;
            }
        }
        if (!TextUtils.isEmpty((CharSequence)birthday)) {
            ContentValues row2 = new ContentValues(3);
            row2.put("mimetype", "vnd.android.cursor.item/contact_event");
            row2.put("data2", Integer.valueOf(3));
            row2.put("data1", birthday);
            data.add(row2);
        }
        if (nicknames != null) {
            for (String nickname : nicknames) {
                if (TextUtils.isEmpty((CharSequence)nickname)) continue;
                row = new ContentValues(3);
                row.put("mimetype", "vnd.android.cursor.item/nickname");
                row.put("data2", Integer.valueOf(1));
                row.put("data1", nickname);
                data.add(row);
                break;
            }
        }
        if (!data.isEmpty()) {
            intent.putParcelableArrayListExtra("data", data);
        }
        StringBuilder aggregatedNotes = new StringBuilder();
        if (!TextUtils.isEmpty((CharSequence)note)) {
            aggregatedNotes.append('\n').append(note);
        }
        if (geo != null && geo.length > 2) {
            aggregatedNotes.append('\n').append(geo[0]).append(',').append(geo[1]);
        }
        if (aggregatedNotes.length() > 0) {
            ResultHandler.putExtra(intent, "notes", aggregatedNotes.substring(1));
        }
        ResultHandler.putExtra(intent, "im_handle", instantMessenger);
        ResultHandler.putExtra(intent, "postal", address);
        if (!TextUtils.isEmpty((CharSequence)addressType) && (type = ResultHandler.toAddressContractType(addressType)) >= 0) {
            intent.putExtra("postal_type", type);
        }
        ResultHandler.putExtra(intent, "company", org);
        ResultHandler.putExtra(intent, "job_title", title);
        this.launchIntent(intent);
    }

    private static int toEmailContractType(String typeString) {
        return ResultHandler.doToContractType(typeString, EMAIL_TYPE_STRINGS, EMAIL_TYPE_VALUES);
    }

    private static int toPhoneContractType(String typeString) {
        return ResultHandler.doToContractType(typeString, PHONE_TYPE_STRINGS, PHONE_TYPE_VALUES);
    }

    private static int toAddressContractType(String typeString) {
        return ResultHandler.doToContractType(typeString, ADDRESS_TYPE_STRINGS, ADDRESS_TYPE_VALUES);
    }

    private static int doToContractType(String typeString, String[] types, int[] values) {
        if (TextUtils.isEmpty((CharSequence)typeString)) {
            return -1;
        }
        for (int i = 0; i < types.length; ++i) {
            String type = types[i];
            if (!typeString.startsWith(type) && !typeString.startsWith(type.toUpperCase(Locale.ENGLISH))) continue;
            return values[i];
        }
        return -1;
    }

    final void sendEmail(String address, String subject, String body) {
        this.sendEmailFromUri("mailto:" + address, address, subject, body);
    }

    final void sendEmailFromUri(String uri, String email, String subject, String body) {
        Intent intent = new Intent("android.intent.action.SEND", Uri.parse((String)uri));
        if (!TextUtils.isEmpty((CharSequence)email)) {
            intent.putExtra("android.intent.extra.EMAIL", new String[]{email});
        }
        ResultHandler.putExtra(intent, "android.intent.extra.SUBJECT", subject);
        ResultHandler.putExtra(intent, "android.intent.extra.TEXT", body);
        intent.setType("text/plain");
        this.launchIntent(intent);
    }

    final void sendSMS(String phoneNumber, String body) {
        this.sendSMSFromUri("smsto:" + phoneNumber, body);
    }

    final void sendSMSFromUri(String uri, String body) {
        Intent intent = new Intent("android.intent.action.SENDTO", Uri.parse((String)uri));
        ResultHandler.putExtra(intent, "sms_body", body);
        intent.putExtra("compose_mode", true);
        this.launchIntent(intent);
    }

    final void sendMMS(String phoneNumber, String subject, String body) {
        this.sendMMSFromUri("mmsto:" + phoneNumber, subject, body);
    }

    final void sendMMSFromUri(String uri, String subject, String body) {
        Intent intent = new Intent("android.intent.action.SENDTO", Uri.parse((String)uri));
        if (TextUtils.isEmpty((CharSequence)subject)) {
            ResultHandler.putExtra(intent, "subject", this.activity.getString(2131296345));
        } else {
            ResultHandler.putExtra(intent, "subject", subject);
        }
        ResultHandler.putExtra(intent, "sms_body", body);
        intent.putExtra("compose_mode", true);
        this.launchIntent(intent);
    }

    final void dialPhone(String phoneNumber) {
        this.launchIntent(new Intent("android.intent.action.DIAL", Uri.parse((String)("tel:" + phoneNumber))));
    }

    final void dialPhoneFromUri(String uri) {
        this.launchIntent(new Intent("android.intent.action.DIAL", Uri.parse((String)uri)));
    }

    final void openMap(String geoURI) {
        this.launchIntent(new Intent("android.intent.action.VIEW", Uri.parse((String)geoURI)));
    }

    final void searchMap(String address) {
        this.launchIntent(new Intent("android.intent.action.VIEW", Uri.parse((String)("geo:0,0?q=" + Uri.encode((String)address)))));
    }

    final void getDirections(double latitude, double longitude) {
        this.launchIntent(new Intent("android.intent.action.VIEW", Uri.parse((String)("http://maps.google." + LocaleManager.getCountryTLD() + "/maps?f=d&daddr=" + latitude + ',' + longitude))));
    }

    final void openProductSearch(String upc) {
        Uri uri = Uri.parse((String)("http://www.google." + LocaleManager.getProductSearchCountryTLD() + "/m/products?q=" + upc + "&source=zxing"));
        this.launchIntent(new Intent("android.intent.action.VIEW", uri));
    }

    final void openBookSearch(String isbn) {
        Uri uri = Uri.parse((String)("http://books.google." + LocaleManager.getBookSearchCountryTLD() + "/books?vid=isbn" + isbn));
        this.launchIntent(new Intent("android.intent.action.VIEW", uri));
    }

    final void openURL(String url) {
        if (url.startsWith("HTTP://")) {
            url = "http" + url.substring(4);
        } else if (url.startsWith("HTTPS://")) {
            url = "https" + url.substring(5);
        }
        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
        try {
            this.launchIntent(intent);
        }
        catch (ActivityNotFoundException ignored) {
            DebugLog.w(TAG, "Nothing available to handle " + intent);
            Toast.makeText((Context)this.activity, (CharSequence)this.activity.getString(2131296349), (int)0).show();
        }
    }

    final void webSearch(String query) {
        Intent intent = new Intent("android.intent.action.WEB_SEARCH");
        intent.putExtra("query", query);
        this.launchIntent(intent);
    }

    final void rawLaunchIntent(Intent intent) {
        if (intent != null) {
            intent.addFlags(524288);
            DebugLog.d(TAG, "Launching intent: " + intent + " with extras: " + intent.getExtras());
            this.activity.startActivity(intent);
        }
    }

    final void launchIntent(Intent intent) {
        try {
            this.rawLaunchIntent(intent);
        }
        catch (ActivityNotFoundException ignored) {
            DebugLog.logException(ignored);
            Toast.makeText((Context)this.activity, (CharSequence)this.activity.getString(2131296349), (int)0).show();
        }
    }

    private static void putExtra(Intent intent, String key, String value) {
        if (!TextUtils.isEmpty((CharSequence)value)) {
            intent.putExtra(key, value);
        }
    }
}

