/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.lib.ui.widget;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.view.animation.LinearInterpolator;
import net.doo.snap.lib.util.ThemesHelper;

public class ShutterDrawable
extends Drawable {
    private static final float FIRST_ROTATION_SPEED_DEGREES_PER_SEC = 143.0f;
    private static final float SECOND_ROTATION_SPEED_DEGREES_PER_SEC = 36.0f;
    private final Paint bitmapPaint = new Paint(1);
    private final Bitmap normal;
    private final Bitmap outerCircle;
    private final Bitmap innerCircleFirst;
    private final Bitmap innerCircleSecond;
    private final Bitmap outerCircleActive;
    private final Bitmap innerCircleFirstActive;
    private final Bitmap innerCircleSecondActive;
    private Bitmap outerCircleBitmap;
    private Bitmap innerCircleFirstBitmap;
    private Bitmap innerCircleSecondBitmap;
    private boolean animated = false;
    private float animationProgressFirst = 0.0f;
    private float animationProgressSecond = 0.0f;
    private ValueAnimator firstAnimator;
    private ValueAnimator secondAnimator;

    public ShutterDrawable(Context context) {
        Resources resources = context.getResources();
        this.normal = BitmapFactory.decodeResource((Resources)resources, (int)ThemesHelper.getResourceId(context, 2130772022));
        this.outerCircle = BitmapFactory.decodeResource((Resources)resources, (int)ThemesHelper.getResourceId(context, 2130772072));
        this.innerCircleFirst = BitmapFactory.decodeResource((Resources)resources, (int)ThemesHelper.getResourceId(context, 2130772070));
        this.innerCircleSecond = BitmapFactory.decodeResource((Resources)resources, (int)ThemesHelper.getResourceId(context, 2130772068));
        this.outerCircleActive = BitmapFactory.decodeResource((Resources)resources, (int)ThemesHelper.getResourceId(context, 2130772073));
        this.innerCircleFirstActive = BitmapFactory.decodeResource((Resources)resources, (int)ThemesHelper.getResourceId(context, 2130772071));
        this.innerCircleSecondActive = BitmapFactory.decodeResource((Resources)resources, (int)ThemesHelper.getResourceId(context, 2130772069));
        this.setActive(false);
    }

    public int getIntrinsicWidth() {
        return this.normal.getWidth();
    }

    public int getIntrinsicHeight() {
        return this.normal.getHeight();
    }

    public void draw(Canvas canvas) {
        Rect bounds = this.getBounds();
        float centerX = bounds.centerX();
        float centerY = bounds.centerY();
        if (!this.animated) {
            canvas.drawBitmap(this.normal, centerX - (float)(this.normal.getWidth() >>> 1), centerY - (float)(this.normal.getHeight() >>> 1), this.bitmapPaint);
            return;
        }
        canvas.drawBitmap(this.outerCircleBitmap, centerX - (float)(this.outerCircleBitmap.getWidth() >>> 1), centerY - (float)(this.outerCircleBitmap.getHeight() >>> 1), this.bitmapPaint);
        canvas.save();
        canvas.rotate(360.0f * this.animationProgressFirst, centerX, centerY);
        canvas.drawBitmap(this.innerCircleFirstBitmap, centerX - (float)(this.innerCircleFirstBitmap.getWidth() >>> 1), centerY - (float)(this.innerCircleFirstBitmap.getHeight() >>> 1), this.bitmapPaint);
        canvas.restore();
        canvas.save();
        canvas.rotate(360.0f * this.animationProgressSecond, centerX, centerY);
        canvas.drawBitmap(this.innerCircleSecondBitmap, centerX - (float)(this.innerCircleSecondBitmap.getWidth() >>> 1), centerY - (float)(this.innerCircleSecondBitmap.getHeight() >>> 1), this.bitmapPaint);
        canvas.restore();
    }

    public void setAlpha(int alpha) {
        this.bitmapPaint.setAlpha(alpha);
    }

    public void setColorFilter(ColorFilter colorFilter) {
        this.bitmapPaint.setColorFilter(colorFilter);
    }

    public int getOpacity() {
        return -3;
    }

    public void startAnimation() {
        if (this.animated) {
            return;
        }
        this.animated = true;
        this.firstAnimator = this.buildAnimator(143.0f, 0.0f, 1.0f);
        this.firstAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                ShutterDrawable.this.animationProgressFirst = ((Float)valueAnimator.getAnimatedValue()).floatValue();
                ShutterDrawable.this.invalidateSelf();
            }
        });
        this.secondAnimator = this.buildAnimator(36.0f, 1.0f, 0.0f);
        this.secondAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                ShutterDrawable.this.animationProgressSecond = ((Float)valueAnimator.getAnimatedValue()).floatValue();
                ShutterDrawable.this.invalidateSelf();
            }
        });
        this.firstAnimator.start();
        this.secondAnimator.start();
        this.invalidateSelf();
    }

    private ValueAnimator buildAnimator(float speed, float ... values) {
        ValueAnimator animator2 = ValueAnimator.ofFloat((float[])values);
        animator2.setRepeatCount(-1);
        animator2.setDuration((long)(360.0f / speed * 1000.0f));
        animator2.setInterpolator((TimeInterpolator)new LinearInterpolator());
        animator2.setRepeatMode(1);
        return animator2;
    }

    public void stopAnimation() {
        if (!this.animated) {
            return;
        }
        this.animated = false;
        this.firstAnimator.cancel();
        this.firstAnimator = null;
        this.secondAnimator.cancel();
        this.secondAnimator = null;
        this.invalidateSelf();
    }

    public void setActive(boolean isActive) {
        this.outerCircleBitmap = isActive ? this.outerCircleActive : this.outerCircle;
        this.innerCircleFirstBitmap = isActive ? this.innerCircleFirstActive : this.innerCircleFirst;
        this.innerCircleSecondBitmap = isActive ? this.innerCircleSecondActive : this.innerCircleSecond;
    }
}

