/*
 * Copyright 2009-2011 Jon Stevens et al.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package de.aflx.sardine.impl.handler;

import java.io.IOException;
import java.io.InputStream;

import ch.boye.httpclientandroidlib.HttpEntity;
import ch.boye.httpclientandroidlib.HttpResponse;
import ch.boye.httpclientandroidlib.StatusLine;
import de.aflx.sardine.impl.SardineException;

/**
 * @version $Id: LockResponseHandler.java 276 2011-06-28 08:13:28Z dkocher@sudo.ch $
 */
public class LockResponseHandler extends ValidatingResponseHandler<String>
{
	public String handleResponse(HttpResponse response) throws IOException
	{
		super.validateResponse(response);

		// Process the response from the server.
		HttpEntity entity = response.getEntity();
		if (entity == null)
		{
			StatusLine statusLine = response.getStatusLine();
			throw new SardineException("No entity found in response", statusLine.getStatusCode(),
					statusLine.getReasonPhrase());
		}
		return this.getToken(entity.getContent());
	}

	/**
	 * Helper method for getting the Multistatus response processor.
	 *
	 * @param stream The input to read the status
	 * @return Multistatus element parsed from the stream
	 * @throws java.io.IOException When there is a JAXB error
	 */
	protected String getToken(InputStream stream)
			throws IOException
	{
		return "XXX";
		//Prop prop = SardineUtil.unmarshal(stream);
		//return prop.getLockdiscovery().getActivelock().iterator().next().getLocktoken().getHref().iterator().next();
	}
}
