/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.file;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.util.IncorrectOperationException;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public final class PsiFileImplUtil {
    private PsiFileImplUtil() {
    }

    public static PsiFile setName(@NotNull PsiFile file2, @NotNull String newName2) throws IncorrectOperationException {
        if (file2 == null) {
            PsiFileImplUtil.$$$reportNull$$$0(0);
        }
        if (newName2 == null) {
            PsiFileImplUtil.$$$reportNull$$$0(1);
        }
        VirtualFile vFile = file2.getViewProvider().getVirtualFile();
        PsiManagerImpl manager = (PsiManagerImpl)file2.getManager();
        try {
            FileDocumentManager fdm;
            Document doc;
            FileType newFileType = FileTypeRegistry.getInstance().getFileTypeByFileName(newName2);
            if ((UnknownFileType.INSTANCE.equals(newFileType) || newFileType.isBinary()) && (doc = (fdm = FileDocumentManager.getInstance()).getCachedDocument(vFile)) != null) {
                fdm.saveDocumentAsIs(doc);
            }
            vFile.rename(manager, newName2);
        }
        catch (IOException e) {
            throw new IncorrectOperationException(e);
        }
        return file2.getViewProvider().isPhysical() ? manager.findFile(vFile) : file2;
    }

    public static void checkSetName(@NotNull PsiFile file2, @NotNull String name) throws IncorrectOperationException {
        VirtualFile vFile;
        VirtualFile parentFile;
        if (file2 == null) {
            PsiFileImplUtil.$$$reportNull$$$0(2);
        }
        if (name == null) {
            PsiFileImplUtil.$$$reportNull$$$0(3);
        }
        if ((parentFile = (vFile = file2.getVirtualFile()).getParent()) == null) {
            return;
        }
        VirtualFile child = parentFile.findChild(name);
        if (child != null && !child.equals(vFile)) {
            throw new IncorrectOperationException("File " + child.getPresentableUrl() + " already exists.");
        }
    }

    public static void doDelete(@NotNull PsiFile file2) throws IncorrectOperationException {
        if (file2 == null) {
            PsiFileImplUtil.$$$reportNull$$$0(4);
        }
        PsiManagerImpl manager = (PsiManagerImpl)file2.getManager();
        VirtualFile vFile = file2.getVirtualFile();
        try {
            vFile.delete(manager);
        }
        catch (IOException e) {
            throw new IncorrectOperationException(e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/file/PsiFileImplUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "checkSetName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "doDelete";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

