/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.backend.generators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirFakeSourceElementKind;
import org.jetbrains.kotlin.fir.FirRendererKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.SessionUtilsKt;
import org.jetbrains.kotlin.fir.backend.ConversionUtilsKt;
import org.jetbrains.kotlin.fir.backend.Fir2IrBuiltIns;
import org.jetbrains.kotlin.fir.backend.Fir2IrClassifierStorage;
import org.jetbrains.kotlin.fir.backend.Fir2IrComponents;
import org.jetbrains.kotlin.fir.backend.Fir2IrConversionScope;
import org.jetbrains.kotlin.fir.backend.Fir2IrDeclarationStorage;
import org.jetbrains.kotlin.fir.backend.Fir2IrImplicitCastInserter;
import org.jetbrains.kotlin.fir.backend.Fir2IrSignatureComposer;
import org.jetbrains.kotlin.fir.backend.Fir2IrTypeConverter;
import org.jetbrains.kotlin.fir.backend.Fir2IrVisibilityConverter;
import org.jetbrains.kotlin.fir.backend.Fir2IrVisitor;
import org.jetbrains.kotlin.fir.backend.generators.AdapterGenerator;
import org.jetbrains.kotlin.fir.backend.generators.AnnotationGenerator;
import org.jetbrains.kotlin.fir.backend.generators.CallAndReferenceGenerator;
import org.jetbrains.kotlin.fir.backend.generators.FakeOverrideGenerator;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirField;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirTypeParametersOwner;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirCallableReferenceAccess;
import org.jetbrains.kotlin.fir.expressions.FirDelegatedConstructorCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirNamedArgumentExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccess;
import org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.FirVarargArgumentsExpression;
import org.jetbrains.kotlin.fir.expressions.FirVariableAssignment;
import org.jetbrains.kotlin.fir.expressions.impl.FirNoReceiverExpression;
import org.jetbrains.kotlin.fir.expressions.impl.FirResolvedArgumentList;
import org.jetbrains.kotlin.fir.references.FirDelegateFieldReference;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.references.FirSuperReference;
import org.jetbrains.kotlin.fir.references.impl.FirReferencePlaceholderForResolvedAnnotations;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.resolve.calls.ArgumentsKt;
import org.jetbrains.kotlin.fir.resolve.inference.InferenceUtilsKt;
import org.jetbrains.kotlin.fir.scopes.FirScope;
import org.jetbrains.kotlin.fir.scopes.KotlinScopeProviderKt;
import org.jetbrains.kotlin.fir.symbols.AbstractFirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFieldSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeInferenceContext;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeLookupTagBasedType;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeProjection;
import org.jetbrains.kotlin.fir.types.FirTypeProjectionWithVariance;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFileKt;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.descriptors.IrBuiltIns;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperator;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrVarargElement;
import org.jetbrains.kotlin.ir.expressions.impl.IrBlockImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstructorCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrErrorCallExpressionImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrErrorExpressionImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrFunctionReferenceImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetEnumValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetFieldImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetObjectValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrLocalDelegatedPropertyReferenceImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrPropertyReferenceImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrSetFieldImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrSetValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrSpreadElementImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrTypeOperatorCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrVarargImpl;
import org.jetbrains.kotlin.ir.symbols.IrBindableSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrEnumEntrySymbol;
import org.jetbrains.kotlin.ir.symbols.IrFieldSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrLocalDelegatedPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.symbols.IrVariableSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.util.SymbolTable;
import org.jetbrains.kotlin.psi2ir.generators.CallGeneratorKt;
import org.jetbrains.kotlin.types.AbstractTypeApproximator;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u00b9\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u000f\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J$\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020G2\b\u0010H\u001a\u0004\u0018\u00010I2\b\b\u0002\u0010J\u001a\u00020KH\u0002J\u0015\u0010L\u001a\u00020E2\u0006\u0010M\u001a\u00020NH\u0000\u00a2\u0006\u0002\bOJ!\u0010L\u001a\u0004\u0018\u00010E2\u0006\u0010M\u001a\u00020N2\b\u0010P\u001a\u0004\u0018\u00010QH\u0000\u00a2\u0006\u0002\bOJ4\u0010R\u001a\u00020E2\u0006\u0010S\u001a\u00020T2\u0006\u0010U\u001a\u00020V2\b\u0010W\u001a\u0004\u0018\u00010E2\b\b\u0002\u0010J\u001a\u00020K2\b\b\u0002\u0010X\u001a\u00020KJ\u0018\u0010Y\u001a\u00020E2\u0006\u0010P\u001a\u00020Q2\b\u0010W\u001a\u0004\u0018\u00010EJ\u000e\u0010Z\u001a\u00020E2\u0006\u0010[\u001a\u00020\\J\u0018\u0010]\u001a\u00020E2\u0006\u0010^\u001a\u00020_2\b\u0010W\u001a\u0004\u0018\u00010EJ,\u0010`\u001a\u00020a2\u0006\u0010b\u001a\u00020c2\u0006\u0010d\u001a\u00020c2\u0006\u0010e\u001a\u00020f2\n\b\u0002\u0010g\u001a\u0004\u0018\u00010hH\u0002J$\u0010i\u001a\u00020K2\f\u0010j\u001a\b\u0012\u0004\u0012\u00020I0k2\f\u0010l\u001a\b\u0012\u0004\u0012\u00020I0mH\u0002J\u0018\u0010n\u001a\u00020K2\u0006\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020IH\u0002JJ\u0010o\u001a\u00020E*\u0006\u0012\u0002\b\u00030p2\"\u0010q\u001a\u001e\u0012\u0004\u0012\u00020G\u0012\u0004\u0012\u00020I0rj\u000e\u0012\u0004\u0012\u00020G\u0012\u0004\u0012\u00020I`s2\f\u0010l\u001a\b\u0012\u0004\u0012\u00020I0m2\u0006\u0010J\u001a\u00020KH\u0002J\u001e\u0010t\u001a\u00020E*\u00020E2\u0006\u0010F\u001a\u00020G2\b\u0010H\u001a\u0004\u0018\u00010IH\u0002J#\u0010u\u001a\u00020E*\u00020E2\b\u0010v\u001a\u0004\u0018\u00010w2\u0006\u0010J\u001a\u00020KH\u0000\u00a2\u0006\u0002\bxJ\u001e\u0010y\u001a\u00020E*\u00020E2\u0006\u0010S\u001a\u00020T2\b\u0010W\u001a\u0004\u0018\u00010EH\u0002J(\u0010z\u001a\u00020E*\u00020E2\u0006\u0010F\u001a\u00020G2\b\u0010H\u001a\u0004\u0018\u00010I2\b\b\u0002\u0010{\u001a\u00020KH\u0002J\u0019\u0010|\u001a\u00020E*\u00020E2\u0006\u0010}\u001a\u00020TH\u0000\u00a2\u0006\u0002\b~J\u0018\u0010\u007f\u001a\u0004\u0018\u00010E*\u00020T2\b\u0010W\u001a\u0004\u0018\u00010EH\u0002J\u0019\u0010\u0080\u0001\u001a\u0004\u0018\u00010E*\u00020T2\b\u0010W\u001a\u0004\u0018\u00010EH\u0002J(\u0010\u0081\u0001\u001a\u0004\u0018\u00010E*\u00020T2\b\u0010W\u001a\u0004\u0018\u00010E2\u0007\u0010\u0082\u0001\u001a\u00020KH\u0000\u00a2\u0006\u0003\b\u0083\u0001J\u0019\u0010\u0084\u0001\u001a\u0005\u0018\u00010\u0085\u0001*\u00020T2\u0007\u0010\u0086\u0001\u001a\u00020cH\u0002J\u001c\u0010\u0087\u0001\u001a\u0005\u0018\u00010\u0088\u0001*\u00020G2\n\u0010\u0089\u0001\u001a\u0005\u0018\u00010\u008a\u0001H\u0002J\u000e\u0010\u008b\u0001\u001a\u00020h*\u00030\u008c\u0001H\u0002J\r\u0010\u008b\u0001\u001a\u00020h*\u00020VH\u0002J\u0018\u0010\u008d\u0001\u001a\u0005\u0018\u00010\u008e\u0001*\u00020T2\u0006\u0010g\u001a\u00020hH\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u00020\u000bX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0010\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u0012\u0010\u0011\u001a\u00020\u0012X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0012\u0010\u0015\u001a\u00020\u0000X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0012\u0010\u0018\u001a\u00020\u0019X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001c\u001a\u00020\u001dX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0012\u0010 \u001a\u00020!X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0012\u0010$\u001a\u00020%X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u0012\u0010(\u001a\u00020)X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b*\u0010+R\u0012\u0010,\u001a\u00020-X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b.\u0010/R\u0012\u00100\u001a\u000201X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b2\u00103R\u0012\u00104\u001a\u000205X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b6\u00107R\u0012\u00108\u001a\u000209X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b:\u0010;R\u0012\u0010<\u001a\u00020=X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b>\u0010?R\u0012\u0010@\u001a\u00020AX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bB\u0010CR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u008f\u0001"}, d2={"Lorg/jetbrains/kotlin/fir/backend/generators/CallAndReferenceGenerator;", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrComponents;", "components", "visitor", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrVisitor;", "conversionScope", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrConversionScope;", "(Lorg/jetbrains/kotlin/fir/backend/Fir2IrComponents;Lorg/jetbrains/kotlin/fir/backend/Fir2IrVisitor;Lorg/jetbrains/kotlin/fir/backend/Fir2IrConversionScope;)V", "adapterGenerator", "Lorg/jetbrains/kotlin/fir/backend/generators/AdapterGenerator;", "annotationGenerator", "Lorg/jetbrains/kotlin/fir/backend/generators/AnnotationGenerator;", "getAnnotationGenerator", "()Lorg/jetbrains/kotlin/fir/backend/generators/AnnotationGenerator;", "approximator", "org/jetbrains/kotlin/fir/backend/generators/CallAndReferenceGenerator$approximator$1", "Lorg/jetbrains/kotlin/fir/backend/generators/CallAndReferenceGenerator$approximator$1;", "builtIns", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrBuiltIns;", "getBuiltIns", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrBuiltIns;", "callGenerator", "getCallGenerator", "()Lorg/jetbrains/kotlin/fir/backend/generators/CallAndReferenceGenerator;", "classifierStorage", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrClassifierStorage;", "getClassifierStorage", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrClassifierStorage;", "declarationStorage", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrDeclarationStorage;", "getDeclarationStorage", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrDeclarationStorage;", "fakeOverrideGenerator", "Lorg/jetbrains/kotlin/fir/backend/generators/FakeOverrideGenerator;", "getFakeOverrideGenerator", "()Lorg/jetbrains/kotlin/fir/backend/generators/FakeOverrideGenerator;", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/descriptors/IrBuiltIns;", "getIrBuiltIns", "()Lorg/jetbrains/kotlin/ir/descriptors/IrBuiltIns;", "irFactory", "Lorg/jetbrains/kotlin/ir/declarations/IrFactory;", "getIrFactory", "()Lorg/jetbrains/kotlin/ir/declarations/IrFactory;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "getScopeSession", "()Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "signatureComposer", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrSignatureComposer;", "getSignatureComposer", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrSignatureComposer;", "symbolTable", "Lorg/jetbrains/kotlin/ir/util/SymbolTable;", "getSymbolTable", "()Lorg/jetbrains/kotlin/ir/util/SymbolTable;", "typeConverter", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrTypeConverter;", "getTypeConverter", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrTypeConverter;", "visibilityConverter", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrVisibilityConverter;", "getVisibilityConverter", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrVisibilityConverter;", "convertArgument", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "argument", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "parameter", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "annotationMode", "", "convertToGetObject", "qualifier", "Lorg/jetbrains/kotlin/fir/expressions/FirResolvedQualifier;", "convertToGetObject$fir2ir", "callableReferenceAccess", "Lorg/jetbrains/kotlin/fir/expressions/FirCallableReferenceAccess;", "convertToIrCall", "qualifiedAccess", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccess;", "typeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "explicitReceiverExpression", "variableAsFunctionMode", "convertToIrCallableReference", "convertToIrConstructorCall", "annotationCall", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotationCall;", "convertToIrSetCall", "variableAssignment", "Lorg/jetbrains/kotlin/fir/expressions/FirVariableAssignment;", "generateErrorCallExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrErrorCallExpression;", "startOffset", "", "endOffset", "calleeReference", "Lorg/jetbrains/kotlin/fir/references/FirReference;", "type", "Lorg/jetbrains/kotlin/ir/types/IrType;", "needArgumentReordering", "parametersInActualOrder", "", "valueParameters", "", "needSamConversion", "applyArgumentsWithReorderingIfNeeded", "Lorg/jetbrains/kotlin/ir/expressions/IrMemberAccessExpression;", "argumentMapping", "Ljava/util/LinkedHashMap;", "Lkotlin/collections/LinkedHashMap;", "applyAssigningArrayElementsToVarargInNamedForm", "applyCallArguments", "call", "Lorg/jetbrains/kotlin/fir/expressions/FirCall;", "applyCallArguments$fir2ir", "applyReceivers", "applySamConversionIfNeeded", "shouldUnwrapVarargType", "applyTypeArguments", "access", "applyTypeArguments$fir2ir", "findIrDispatchReceiver", "findIrExtensionReceiver", "findIrReceiver", "isDispatch", "findIrReceiver$fir2ir", "findTypeParameter", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeParameter;", "index", "superQualifierSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "callSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "toIrType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "tryConvertToSamConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrTypeOperatorCall;", "fir2ir"})
public final class CallAndReferenceGenerator
implements Fir2IrComponents {
    @NotNull
    private final Fir2IrComponents components;
    @NotNull
    private final Fir2IrVisitor visitor;
    @NotNull
    private final Fir2IrConversionScope conversionScope;
    @NotNull
    private final approximator.1 approximator;
    @NotNull
    private final AdapterGenerator adapterGenerator;

    public CallAndReferenceGenerator(@NotNull Fir2IrComponents components2, @NotNull Fir2IrVisitor visitor2, @NotNull Fir2IrConversionScope conversionScope) {
        Intrinsics.checkNotNullParameter(components2, "components");
        Intrinsics.checkNotNullParameter(visitor2, "visitor");
        Intrinsics.checkNotNullParameter(conversionScope, "conversionScope");
        this.components = components2;
        this.visitor = visitor2;
        this.conversionScope = conversionScope;
        ConeInferenceContext coneInferenceContext = SessionUtilsKt.getTypeContext(this.getSession());
        this.approximator = new AbstractTypeApproximator(coneInferenceContext){};
        this.adapterGenerator = new AdapterGenerator(this.components, this.conversionScope);
    }

    @Override
    @NotNull
    public AnnotationGenerator getAnnotationGenerator() {
        return this.components.getAnnotationGenerator();
    }

    @Override
    @NotNull
    public Fir2IrBuiltIns getBuiltIns() {
        return this.components.getBuiltIns();
    }

    @Override
    @NotNull
    public CallAndReferenceGenerator getCallGenerator() {
        return this.components.getCallGenerator();
    }

    @Override
    @NotNull
    public Fir2IrClassifierStorage getClassifierStorage() {
        return this.components.getClassifierStorage();
    }

    @Override
    @NotNull
    public Fir2IrDeclarationStorage getDeclarationStorage() {
        return this.components.getDeclarationStorage();
    }

    @Override
    @NotNull
    public FakeOverrideGenerator getFakeOverrideGenerator() {
        return this.components.getFakeOverrideGenerator();
    }

    @Override
    @NotNull
    public IrBuiltIns getIrBuiltIns() {
        return this.components.getIrBuiltIns();
    }

    @Override
    @NotNull
    public IrFactory getIrFactory() {
        return this.components.getIrFactory();
    }

    @Override
    @NotNull
    public ScopeSession getScopeSession() {
        return this.components.getScopeSession();
    }

    @Override
    @NotNull
    public FirSession getSession() {
        return this.components.getSession();
    }

    @Override
    @NotNull
    public Fir2IrSignatureComposer getSignatureComposer() {
        return this.components.getSignatureComposer();
    }

    @Override
    @NotNull
    public SymbolTable getSymbolTable() {
        return this.components.getSymbolTable();
    }

    @Override
    @NotNull
    public Fir2IrTypeConverter getTypeConverter() {
        return this.components.getTypeConverter();
    }

    @Override
    @NotNull
    public Fir2IrVisibilityConverter getVisibilityConverter() {
        return this.components.getVisibilityConverter();
    }

    private final IrType toIrType(FirTypeRef $this$toIrType) {
        Fir2IrTypeConverter fir2IrTypeConverter = this.getTypeConverter();
        boolean bl = false;
        boolean bl2 = false;
        Fir2IrTypeConverter $this$toIrType_u24lambda_u2d0 = fir2IrTypeConverter;
        boolean bl3 = false;
        return Fir2IrTypeConverter.toIrType$default($this$toIrType_u24lambda_u2d0, $this$toIrType, null, 1, null);
    }

    private final IrType toIrType(ConeKotlinType $this$toIrType) {
        Fir2IrTypeConverter fir2IrTypeConverter = this.getTypeConverter();
        boolean bl = false;
        boolean bl2 = false;
        Fir2IrTypeConverter $this$toIrType_u24lambda_u2d1 = fir2IrTypeConverter;
        boolean bl3 = false;
        return Fir2IrTypeConverter.toIrType$default($this$toIrType_u24lambda_u2d1, $this$toIrType, null, null, 3, null);
    }

    @NotNull
    public final IrExpression convertToIrCallableReference(@NotNull FirCallableReferenceAccess callableReferenceAccess, @Nullable IrExpression explicitReceiverExpression) {
        Intrinsics.checkNotNullParameter(callableReferenceAccess, "callableReferenceAccess");
        IrSymbol symbol2 = ConversionUtilsKt.toSymbolForCall$default(callableReferenceAccess.getCalleeReference(), this.getSession(), this.getClassifierStorage(), this.getDeclarationStorage(), this.conversionScope, false, 16, null);
        IrType type2 = this.toIrType(callableReferenceAccess.getTypeRef());
        FirSourceElement firSourceElement = callableReferenceAccess.getSource();
        boolean isForDelegate = Intrinsics.areEqual(firSourceElement == null ? null : firSourceElement.getKind(), FirFakeSourceElementKind.DefaultAccessor.INSTANCE);
        IrStatementOrigin.PROPERTY_REFERENCE_FOR_DELEGATE origin = isForDelegate ? IrStatementOrigin.PROPERTY_REFERENCE_FOR_DELEGATE.INSTANCE : null;
        return this.applyReceivers(this.applyTypeArguments$fir2ir((IrExpression)ConversionUtilsKt.convertWithOffsets(callableReferenceAccess, (Function2)new Function2<Integer, Integer, IrExpression>(symbol2, callableReferenceAccess, this, type2, origin, explicitReceiverExpression){
            final /* synthetic */ IrSymbol $symbol;
            final /* synthetic */ FirCallableReferenceAccess $callableReferenceAccess;
            final /* synthetic */ CallAndReferenceGenerator this$0;
            final /* synthetic */ IrType $type;
            final /* synthetic */ IrStatementOrigin.PROPERTY_REFERENCE_FOR_DELEGATE $origin;
            final /* synthetic */ IrExpression $explicitReceiverExpression;
            {
                this.$symbol = $symbol;
                this.$callableReferenceAccess = $callableReferenceAccess;
                this.this$0 = $receiver;
                this.$type = $type;
                this.$origin = $origin;
                this.$explicitReceiverExpression = $explicitReceiverExpression;
                super(2);
            }

            @NotNull
            public final IrExpression invoke(int startOffset, int endOffset) {
                IrExpression irExpression;
                IrSymbol irSymbol = this.$symbol;
                if (irSymbol instanceof IrPropertySymbol) {
                    int n;
                    IrField irField;
                    IrProperty referencedProperty = (IrProperty)((IrPropertySymbol)this.$symbol).getOwner();
                    IrSimpleFunction referencedPropertyGetter = referencedProperty.getGetter();
                    Object $this$coneType$iv = this.$callableReferenceAccess.getTypeRef();
                    boolean $i$f$getConeType = false;
                    FirTypeRef $this$coneTypeUnsafe$iv$iv = $this$coneType$iv;
                    boolean $i$f$coneTypeUnsafe = false;
                    ConeKotlinType coneKotlinType = ((FirResolvedTypeRef)$this$coneTypeUnsafe$iv$iv).getType();
                    if (coneKotlinType == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinType");
                    }
                    IrSimpleFunctionSymbol referencedPropertySetterSymbol = InferenceUtilsKt.isKMutableProperty(coneKotlinType, this.this$0.getSession()) ? (($this$coneType$iv = referencedProperty.getSetter()) == null ? null : (IrSimpleFunctionSymbol)((IrFunction)$this$coneType$iv).getSymbol()) : null;
                    IrFieldSymbol backingFieldSymbol = referencedPropertyGetter != null ? null : ((irField = referencedProperty.getBackingField()) == null ? null : (IrFieldSymbol)irField.getSymbol());
                    IrSimpleFunction irSimpleFunction = referencedPropertyGetter;
                    Object object = irSimpleFunction == null ? null : irSimpleFunction.getTypeParameters();
                    int n2 = object == null ? 0 : (n = object.size());
                    object = referencedPropertyGetter;
                    irExpression = new IrPropertyReferenceImpl(startOffset, endOffset, this.$type, (IrPropertySymbol)this.$symbol, n2, backingFieldSymbol, object == null ? null : (IrSimpleFunctionSymbol)((IrFunction)object).getSymbol(), referencedPropertySetterSymbol, this.$origin);
                } else if (irSymbol instanceof IrLocalDelegatedPropertySymbol) {
                    IrSimpleFunction referencedProperty;
                    irExpression = new IrLocalDelegatedPropertyReferenceImpl(startOffset, endOffset, this.$type, (IrLocalDelegatedPropertySymbol)this.$symbol, (IrVariableSymbol)((IrLocalDelegatedProperty)((IrLocalDelegatedPropertySymbol)this.$symbol).getOwner()).getDelegate().getSymbol(), (IrSimpleFunctionSymbol)((IrLocalDelegatedProperty)((IrLocalDelegatedPropertySymbol)this.$symbol).getOwner()).getGetter().getSymbol(), (referencedProperty = ((IrLocalDelegatedProperty)((IrLocalDelegatedPropertySymbol)this.$symbol).getOwner()).getSetter()) == null ? null : (IrSimpleFunctionSymbol)referencedProperty.getSymbol(), this.$origin);
                } else if (irSymbol instanceof IrFieldSymbol) {
                    int n;
                    IrPropertySymbol irPropertySymbol;
                    Object object;
                    Object object2;
                    IrField referencedField = (IrField)((IrFieldSymbol)this.$symbol).getOwner();
                    Object referencedPropertySetterSymbol = referencedField.getCorrespondingPropertySymbol();
                    if (referencedPropertySetterSymbol == null) {
                        object2 = this.this$0;
                        object = this.$callableReferenceAccess;
                        boolean bl = false;
                        boolean bl2 = false;
                        CallAndReferenceGenerator $this$invoke_u24lambda_u2d0 = object2;
                        boolean bl3 = false;
                        FirFieldSymbol firSymbol = (FirFieldSymbol)((FirResolvedNamedReference)((FirCallableReferenceAccess)object).getCalleeReference()).getResolvedSymbol();
                        irPropertySymbol = $this$invoke_u24lambda_u2d0.getDeclarationStorage().getOrCreateIrPropertyByPureField((FirField)firSymbol.getFir(), referencedField.getParent()).getSymbol();
                    } else {
                        irPropertySymbol = referencedPropertySetterSymbol;
                    }
                    IrPropertySymbol propertySymbol = irPropertySymbol;
                    object = this.$type;
                    object2 = object instanceof IrSimpleType ? (IrSimpleType)object : null;
                    referencedPropertySetterSymbol = object2 == null ? null : object2.getArguments();
                    irExpression = new IrPropertyReferenceImpl(startOffset, endOffset, this.$type, propertySymbol, referencedPropertySetterSymbol == null ? 0 : (n = referencedPropertySetterSymbol.size()), (IrFieldSymbol)this.$symbol, referencedField.isStatic() ? null : ((referencedPropertySetterSymbol = ((IrProperty)propertySymbol.getOwner()).getGetter()) == null ? null : (IrSimpleFunctionSymbol)((IrFunction)referencedPropertySetterSymbol).getSymbol()), referencedField.isStatic() ? null : ((referencedPropertySetterSymbol = ((IrProperty)propertySymbol.getOwner()).getSetter()) == null ? null : (IrSimpleFunctionSymbol)((IrFunction)referencedPropertySetterSymbol).getSymbol()), this.$origin);
                } else if (irSymbol instanceof IrConstructorSymbol) {
                    int n;
                    IrConstructor constructor2 = (IrConstructor)((IrConstructorSymbol)this.$symbol).getOwner();
                    Object referencedPropertySetterSymbol = constructor2.getParent();
                    IrClass klass = referencedPropertySetterSymbol instanceof IrClass ? (IrClass)referencedPropertySetterSymbol : null;
                    IrClass irClass2 = klass;
                    referencedPropertySetterSymbol = irClass2 == null ? null : irClass2.getTypeParameters();
                    irExpression = new IrFunctionReferenceImpl(startOffset, endOffset, this.$type, (IrFunctionSymbol)this.$symbol, constructor2.getTypeParameters().size() + (referencedPropertySetterSymbol == null ? 0 : (n = referencedPropertySetterSymbol.size())), constructor2.getValueParameters().size(), (IrFunctionSymbol)this.$symbol, null, 128, null);
                } else if (irSymbol instanceof IrFunctionSymbol) {
                    boolean constructor2 = IrTypeUtilsKt.isFunctionTypeOrSubtype(this.$type);
                    boolean bl = false;
                    if (_Assertions.ENABLED && !constructor2) {
                        boolean bl4 = false;
                        String string2 = "Callable reference whose symbol refers to a function should be of functional type.";
                        throw (Throwable)((Object)new AssertionError((Object)string2));
                    }
                    IrSimpleType cfr_ignored_0 = (IrSimpleType)this.$type;
                    IrFunction function2 = ((IrFunctionSymbol)this.$symbol).getOwner();
                    if (CallAndReferenceGenerator.access$getAdapterGenerator$p(this.this$0).needToGenerateAdaptedCallableReference$fir2ir(this.$callableReferenceAccess, (IrSimpleType)this.$type, function2)) {
                        AdapterGenerator adapterGenerator = CallAndReferenceGenerator.access$getAdapterGenerator$p(this.this$0);
                        FirCallableReferenceAccess firCallableReferenceAccess = this.$callableReferenceAccess;
                        IrExpression irExpression2 = this.$explicitReceiverExpression;
                        IrSymbol irSymbol2 = this.$symbol;
                        boolean bl5 = false;
                        boolean bl6 = false;
                        AdapterGenerator $this$invoke_u24lambda_u2d2 = adapterGenerator;
                        boolean bl7 = false;
                        FirTypeRef $this$coneType$iv = firCallableReferenceAccess.getTypeRef();
                        boolean $i$f$getConeType = false;
                        FirTypeRef $this$coneTypeUnsafe$iv$iv = $this$coneType$iv;
                        boolean $i$f$coneTypeUnsafe = false;
                        ConeKotlinType coneKotlinType = ((FirResolvedTypeRef)$this$coneTypeUnsafe$iv$iv).getType();
                        if (coneKotlinType == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinType");
                        }
                        IrSimpleType adaptedType = $this$invoke_u24lambda_u2d2.kFunctionTypeToFunctionType$fir2ir(coneKotlinType);
                        irExpression = $this$invoke_u24lambda_u2d2.generateAdaptedCallableReference$fir2ir(firCallableReferenceAccess, irExpression2, (IrFunctionSymbol)irSymbol2, adaptedType);
                    } else {
                        irExpression = new IrFunctionReferenceImpl(startOffset, endOffset, this.$type, (IrFunctionSymbol)this.$symbol, function2.getTypeParameters().size(), function2.getValueParameters().size(), (IrFunctionSymbol)this.$symbol, null, 128, null);
                    }
                } else {
                    irExpression = new IrErrorCallExpressionImpl(startOffset, endOffset, this.$type, Intrinsics.stringPlus("Unsupported callable reference: ", FirRendererKt.render$default(this.$callableReferenceAccess, null, 1, null)));
                }
                return irExpression;
            }
        }), callableReferenceAccess), callableReferenceAccess, explicitReceiverExpression);
    }

    private final IrTypeOperatorCall tryConvertToSamConstructorCall(FirQualifiedAccess $this$tryConvertToSamConstructorCall, IrType type2) {
        FirResolvedNamedReference firResolvedNamedReference;
        FirReference firReference = $this$tryConvertToSamConstructorCall.getCalleeReference();
        FirResolvedNamedReference firResolvedNamedReference2 = firResolvedNamedReference = firReference instanceof FirResolvedNamedReference ? (FirResolvedNamedReference)firReference : null;
        if (firResolvedNamedReference == null) {
            return null;
        }
        FirResolvedNamedReference calleeReference = firResolvedNamedReference;
        Object fir = calleeReference.getResolvedSymbol().getFir();
        if ($this$tryConvertToSamConstructorCall instanceof FirFunctionCall && fir instanceof FirSimpleFunction && Intrinsics.areEqual(((FirSimpleFunction)fir).getOrigin(), FirDeclarationOrigin.SamConstructor.INSTANCE)) {
            return (IrTypeOperatorCall)ConversionUtilsKt.convertWithOffsets($this$tryConvertToSamConstructorCall, (Function2)new Function2<Integer, Integer, IrTypeOperatorCallImpl>(type2, this, $this$tryConvertToSamConstructorCall){
                final /* synthetic */ IrType $type;
                final /* synthetic */ CallAndReferenceGenerator this$0;
                final /* synthetic */ FirQualifiedAccess $this_tryConvertToSamConstructorCall;
                {
                    this.$type = $type;
                    this.this$0 = $receiver;
                    this.$this_tryConvertToSamConstructorCall = $receiver2;
                    super(2);
                }

                @NotNull
                public final IrTypeOperatorCallImpl invoke(int startOffset, int endOffset) {
                    FirCall $this$argument$iv = (FirCall)((Object)this.$this_tryConvertToSamConstructorCall);
                    boolean $i$f$getArgument = false;
                    return new IrTypeOperatorCallImpl(startOffset, endOffset, this.$type, IrTypeOperator.SAM_CONVERSION, this.$type, Fir2IrVisitor.convertToIrExpression$fir2ir$default(CallAndReferenceGenerator.access$getVisitor$p(this.this$0), CollectionsKt.first($this$argument$iv.getArgumentList().getArguments()), false, 2, null));
                }
            });
        }
        return null;
    }

    private final IrClassSymbol superQualifierSymbol(FirExpression $this$superQualifierSymbol, IrSymbol callSymbol) {
        FirClassSymbol firClassSymbol;
        ConeClassLikeType coneClassLikeType;
        FirTypeRef superTypeRef;
        if (!($this$superQualifierSymbol instanceof FirQualifiedAccess)) {
            return null;
        }
        FirReference dispatchReceiverReference = ((FirQualifiedAccess)((Object)$this$superQualifierSymbol)).getCalleeReference();
        if (!(dispatchReceiverReference instanceof FirSuperReference)) {
            return null;
        }
        FirTypeRef $this$coneTypeSafe$iv = superTypeRef = ((FirSuperReference)dispatchReceiverReference).getSuperTypeRef();
        boolean $i$f$coneTypeSafe = false;
        boolean bl = false;
        FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
        ConeKotlinType coneKotlinType = firResolvedTypeRef == null ? null : firResolvedTypeRef.getType();
        if (!(coneKotlinType instanceof ConeClassLikeType)) {
            coneKotlinType = null;
        }
        if ((coneClassLikeType = (ConeClassLikeType)((ConeKotlinType)((ConeClassLikeType)coneKotlinType))) == null) {
            return null;
        }
        ConeClassLikeType coneSuperType = coneClassLikeType;
        FirClassLikeSymbol<?> firClassLikeSymbol = LookupTagUtilsKt.toSymbol(TypeExpansionUtilsKt.fullyExpandedType$default(coneSuperType, this.getSession(), null, 2, null).getLookupTag(), this.getSession());
        FirClassSymbol firClassSymbol2 = firClassSymbol = firClassLikeSymbol instanceof FirClassSymbol ? (FirClassSymbol)firClassLikeSymbol : null;
        if (firClassSymbol != null) {
            return this.getClassifierStorage().getIrClassSymbol(firClassSymbol);
        }
        return null;
    }

    @NotNull
    public final IrExpression convertToIrCall(@NotNull FirQualifiedAccess qualifiedAccess, @NotNull FirTypeRef typeRef, @Nullable IrExpression explicitReceiverExpression, boolean annotationMode, boolean variableAsFunctionMode) {
        Intrinsics.checkNotNullParameter(qualifiedAccess, "qualifiedAccess");
        Intrinsics.checkNotNullParameter(typeRef, "typeRef");
        try {
            IrType type2 = this.toIrType(typeRef);
            IrTypeOperatorCall samConstructorCall = this.tryConvertToSamConstructorCall(qualifiedAccess, type2);
            if (samConstructorCall != null) {
                return samConstructorCall;
            }
            IrSymbol symbol2 = ConversionUtilsKt.toSymbolForCall$default(qualifiedAccess.getCalleeReference(), this.getSession(), this.getClassifierStorage(), this.getDeclarationStorage(), this.conversionScope, false, 16, null);
            return this.applyReceivers(this.applyTypeArguments$fir2ir(this.applyCallArguments$fir2ir((IrExpression)ConversionUtilsKt.convertWithOffsets(qualifiedAccess, (Function2)new Function2<Integer, Integer, IrExpression>(qualifiedAccess, this, symbol2, type2, variableAsFunctionMode){
                final /* synthetic */ FirQualifiedAccess $qualifiedAccess;
                final /* synthetic */ CallAndReferenceGenerator this$0;
                final /* synthetic */ IrSymbol $symbol;
                final /* synthetic */ IrType $type;
                final /* synthetic */ boolean $variableAsFunctionMode;
                {
                    this.$qualifiedAccess = $qualifiedAccess;
                    this.this$0 = $receiver;
                    this.$symbol = $symbol;
                    this.$type = $type;
                    this.$variableAsFunctionMode = $variableAsFunctionMode;
                    super(2);
                }

                @NotNull
                public final IrExpression invoke(int startOffset, int endOffset) {
                    IrExpression irExpression;
                    FirExpression dispatchReceiver = this.$qualifiedAccess.getDispatchReceiver();
                    if (this.$qualifiedAccess.getCalleeReference() instanceof FirSuperReference && !(dispatchReceiver instanceof FirNoReceiverExpression)) {
                        return Fir2IrVisitor.convertToIrExpression$fir2ir$default(CallAndReferenceGenerator.access$getVisitor$p(this.this$0), dispatchReceiver, false, 2, null);
                    }
                    IrSymbol irSymbol = this.$symbol;
                    if (irSymbol instanceof IrConstructorSymbol) {
                        irExpression = IrConstructorCallImpl.Companion.fromSymbolOwner$default(IrConstructorCallImpl.Companion, startOffset, endOffset, this.$type, (IrConstructorSymbol)this.$symbol, null, 16, null);
                    } else if (irSymbol instanceof IrSimpleFunctionSymbol) {
                        irExpression = new IrCallImpl(startOffset, endOffset, this.$type, (IrSimpleFunctionSymbol)this.$symbol, ((IrSimpleFunction)((IrSimpleFunctionSymbol)this.$symbol).getOwner()).getTypeParameters().size(), ((IrSimpleFunction)((IrSimpleFunctionSymbol)this.$symbol).getOwner()).getValueParameters().size(), ConversionUtilsKt.statementOrigin(this.$qualifiedAccess.getCalleeReference()), CallAndReferenceGenerator.access$superQualifierSymbol(this.this$0, dispatchReceiver, this.$symbol));
                    } else if (irSymbol instanceof IrLocalDelegatedPropertySymbol) {
                        irExpression = new IrCallImpl(startOffset, endOffset, this.$type, (IrSimpleFunctionSymbol)((IrLocalDelegatedProperty)((IrLocalDelegatedPropertySymbol)this.$symbol).getOwner()).getGetter().getSymbol(), ((IrLocalDelegatedProperty)((IrLocalDelegatedPropertySymbol)this.$symbol).getOwner()).getGetter().getTypeParameters().size(), 0, IrStatementOrigin.GET_LOCAL_PROPERTY.INSTANCE, CallAndReferenceGenerator.access$superQualifierSymbol(this.this$0, dispatchReceiver, this.$symbol));
                    } else if (irSymbol instanceof IrPropertySymbol) {
                        IrSimpleFunction getter2 = ((IrProperty)((IrPropertySymbol)this.$symbol).getOwner()).getGetter();
                        IrField backingField2 = ((IrProperty)((IrPropertySymbol)this.$symbol).getOwner()).getBackingField();
                        irExpression = getter2 != null ? (IrExpression)new IrCallImpl(startOffset, endOffset, this.$type, (IrSimpleFunctionSymbol)getter2.getSymbol(), getter2.getTypeParameters().size(), 0, IrStatementOrigin.GET_PROPERTY.INSTANCE, CallAndReferenceGenerator.access$superQualifierSymbol(this.this$0, dispatchReceiver, this.$symbol)) : (backingField2 != null ? (IrExpression)new IrGetFieldImpl(startOffset, endOffset, (IrFieldSymbol)backingField2.getSymbol(), this.$type, null, CallAndReferenceGenerator.access$superQualifierSymbol(this.this$0, dispatchReceiver, this.$symbol), 16, null) : (IrExpression)new IrErrorCallExpressionImpl(startOffset, endOffset, this.$type, Intrinsics.stringPlus("No getter or backing field found for ", FirRendererKt.render$default(this.$qualifiedAccess.getCalleeReference(), null, 1, null))));
                    } else if (irSymbol instanceof IrFieldSymbol) {
                        IrStatementOrigin.GET_PROPERTY gET_PROPERTY = IrStatementOrigin.GET_PROPERTY.INSTANCE;
                        FirQualifiedAccess firQualifiedAccess = this.$qualifiedAccess;
                        boolean bl = false;
                        boolean bl2 = false;
                        IrStatementOrigin.GET_PROPERTY gET_PROPERTY2 = gET_PROPERTY;
                        IrType irType = this.$type;
                        IrFieldSymbol irFieldSymbol = (IrFieldSymbol)this.$symbol;
                        int n = endOffset;
                        int n2 = startOffset;
                        boolean bl3 = false;
                        boolean bl4 = !(firQualifiedAccess.getCalleeReference() instanceof FirDelegateFieldReference);
                        IrClassSymbol irClassSymbol = CallAndReferenceGenerator.access$superQualifierSymbol(this.this$0, dispatchReceiver, this.$symbol);
                        IrStatementOrigin irStatementOrigin = bl4 ? gET_PROPERTY : null;
                        IrType irType2 = irType;
                        IrFieldSymbol irFieldSymbol2 = irFieldSymbol;
                        int n3 = n;
                        int n4 = n2;
                        irExpression = new IrGetFieldImpl(n4, n3, irFieldSymbol2, irType2, irStatementOrigin, irClassSymbol);
                    } else {
                        irExpression = irSymbol instanceof IrValueSymbol ? (IrExpression)new IrGetValueImpl(startOffset, endOffset, this.$type, (IrValueSymbol)this.$symbol, this.$variableAsFunctionMode ? (IrStatementOrigin)IrStatementOrigin.VARIABLE_AS_FUNCTION.INSTANCE : ConversionUtilsKt.statementOrigin(this.$qualifiedAccess.getCalleeReference())) : (irSymbol instanceof IrEnumEntrySymbol ? (IrExpression)new IrGetEnumValueImpl(startOffset, endOffset, this.$type, (IrEnumEntrySymbol)this.$symbol) : (IrExpression)CallAndReferenceGenerator.access$generateErrorCallExpression(this.this$0, startOffset, endOffset, this.$qualifiedAccess.getCalleeReference(), this.$type));
                    }
                    return irExpression;
                }
            }), qualifiedAccess instanceof FirCall ? (FirCall)((Object)qualifiedAccess) : null, annotationMode), qualifiedAccess), qualifiedAccess, explicitReceiverExpression);
        }
        catch (Throwable e) {
            String string2;
            IrFile irFile = this.conversionScope.containingFileIfAny();
            throw new IllegalStateException("Error while translating " + FirRendererKt.render$default(qualifiedAccess, null, 1, null) + " from file " + (irFile == null ? "???" : ((string2 = IrFileKt.getName(irFile)) == null ? "???" : string2)) + " to BE IR", e);
        }
    }

    public static /* synthetic */ IrExpression convertToIrCall$default(CallAndReferenceGenerator callAndReferenceGenerator, FirQualifiedAccess firQualifiedAccess, FirTypeRef firTypeRef, IrExpression irExpression, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            bl2 = false;
        }
        return callAndReferenceGenerator.convertToIrCall(firQualifiedAccess, firTypeRef, irExpression, bl, bl2);
    }

    @NotNull
    public final IrExpression convertToIrSetCall(@NotNull FirVariableAssignment variableAssignment, @Nullable IrExpression explicitReceiverExpression) {
        Intrinsics.checkNotNullParameter(variableAssignment, "variableAssignment");
        try {
            IrType type2 = this.getIrBuiltIns().getUnitType();
            FirReference calleeReference = variableAssignment.getCalleeReference();
            IrSymbol symbol2 = ConversionUtilsKt.toSymbolForCall(calleeReference, this.getSession(), this.getClassifierStorage(), this.getDeclarationStorage(), this.conversionScope, false);
            IrStatementOrigin.EQ origin = IrStatementOrigin.EQ.INSTANCE;
            return this.applyReceivers(this.applyTypeArguments$fir2ir((IrExpression)ConversionUtilsKt.convertWithOffsets(variableAssignment, (Function2)new Function2<Integer, Integer, IrExpression>(this, variableAssignment, symbol2, type2, origin, calleeReference){
                final /* synthetic */ CallAndReferenceGenerator this$0;
                final /* synthetic */ FirVariableAssignment $variableAssignment;
                final /* synthetic */ IrSymbol $symbol;
                final /* synthetic */ IrType $type;
                final /* synthetic */ IrStatementOrigin.EQ $origin;
                final /* synthetic */ FirReference $calleeReference;
                {
                    this.this$0 = $receiver;
                    this.$variableAssignment = $variableAssignment;
                    this.$symbol = $symbol;
                    this.$type = $type;
                    this.$origin = $origin;
                    this.$calleeReference = $calleeReference;
                    super(2);
                }

                @NotNull
                public final IrExpression invoke(int startOffset, int endOffset) {
                    IrExpression irExpression;
                    IrExpression assignedValue = Fir2IrVisitor.convertToIrExpression$fir2ir$default(CallAndReferenceGenerator.access$getVisitor$p(this.this$0), this.$variableAssignment.getRValue(), false, 2, null);
                    IrSymbol irSymbol = this.$symbol;
                    if (irSymbol instanceof IrFieldSymbol) {
                        IrSetFieldImpl irSetFieldImpl = new IrSetFieldImpl(startOffset, endOffset, (IrFieldSymbol)this.$symbol, this.$type, this.$origin, null, 32, null);
                        boolean bl = false;
                        boolean bl2 = false;
                        IrSetFieldImpl $this$invoke_u24lambda_u2d0 = irSetFieldImpl;
                        boolean bl3 = false;
                        $this$invoke_u24lambda_u2d0.setValue(assignedValue);
                        irExpression = irSetFieldImpl;
                    } else if (irSymbol instanceof IrLocalDelegatedPropertySymbol) {
                        IrSimpleFunction setter2 = ((IrLocalDelegatedProperty)((IrLocalDelegatedPropertySymbol)this.$symbol).getOwner()).getSetter();
                        if (setter2 != null) {
                            IrCallImpl irCallImpl = new IrCallImpl(startOffset, endOffset, this.$type, (IrSimpleFunctionSymbol)setter2.getSymbol(), setter2.getTypeParameters().size(), 1, this.$origin, CallAndReferenceGenerator.access$superQualifierSymbol(this.this$0, this.$variableAssignment.getDispatchReceiver(), this.$symbol));
                            boolean bl = false;
                            boolean $this$invoke_u24lambda_u2d0 = false;
                            IrCallImpl $this$invoke_u24lambda_u2d1 = irCallImpl;
                            boolean bl4 = false;
                            $this$invoke_u24lambda_u2d1.putValueArgument(0, assignedValue);
                            irExpression = irCallImpl;
                        } else {
                            irExpression = CallAndReferenceGenerator.generateErrorCallExpression$default(this.this$0, startOffset, endOffset, this.$calleeReference, null, 8, null);
                        }
                    } else if (irSymbol instanceof IrPropertySymbol) {
                        IrProperty irProperty2 = (IrProperty)((IrPropertySymbol)this.$symbol).getOwner();
                        IrSimpleFunction setter3 = irProperty2.getSetter();
                        IrField backingField2 = irProperty2.getBackingField();
                        if (setter3 != null) {
                            IrCallImpl $this$invoke_u24lambda_u2d0 = new IrCallImpl(startOffset, endOffset, this.$type, (IrSimpleFunctionSymbol)setter3.getSymbol(), setter3.getTypeParameters().size(), 1, this.$origin, CallAndReferenceGenerator.access$superQualifierSymbol(this.this$0, this.$variableAssignment.getDispatchReceiver(), this.$symbol));
                            boolean $this$invoke_u24lambda_u2d1 = false;
                            boolean bl = false;
                            IrCallImpl $this$invoke_u24lambda_u2d2 = $this$invoke_u24lambda_u2d0;
                            boolean bl5 = false;
                            $this$invoke_u24lambda_u2d2.putValueArgument(0, assignedValue);
                            irExpression = $this$invoke_u24lambda_u2d0;
                        } else if (backingField2 != null) {
                            IrSetFieldImpl $this$invoke_u24lambda_u2d0 = new IrSetFieldImpl(startOffset, endOffset, (IrFieldSymbol)backingField2.getSymbol(), this.$type, null, CallAndReferenceGenerator.access$superQualifierSymbol(this.this$0, this.$variableAssignment.getDispatchReceiver(), this.$symbol));
                            boolean $this$invoke_u24lambda_u2d1 = false;
                            boolean bl = false;
                            IrSetFieldImpl $this$invoke_u24lambda_u2d3 = $this$invoke_u24lambda_u2d0;
                            boolean bl6 = false;
                            $this$invoke_u24lambda_u2d3.setValue(assignedValue);
                            irExpression = $this$invoke_u24lambda_u2d0;
                        } else {
                            irExpression = CallAndReferenceGenerator.generateErrorCallExpression$default(this.this$0, startOffset, endOffset, this.$calleeReference, null, 8, null);
                        }
                    } else if (irSymbol instanceof IrSimpleFunctionSymbol) {
                        IrCallImpl irCallImpl = new IrCallImpl(startOffset, endOffset, this.$type, (IrSimpleFunctionSymbol)this.$symbol, ((IrSimpleFunction)((IrSimpleFunctionSymbol)this.$symbol).getOwner()).getTypeParameters().size(), 1, this.$origin, null, 128, null);
                        boolean bl = false;
                        boolean bl7 = false;
                        IrCallImpl $this$invoke_u24lambda_u2d4 = irCallImpl;
                        boolean bl8 = false;
                        $this$invoke_u24lambda_u2d4.putValueArgument(0, assignedValue);
                        irExpression = irCallImpl;
                    } else {
                        irExpression = irSymbol instanceof IrVariableSymbol ? (IrExpression)new IrSetValueImpl(startOffset, endOffset, this.$type, (IrValueSymbol)this.$symbol, assignedValue, this.$origin) : (IrExpression)CallAndReferenceGenerator.generateErrorCallExpression$default(this.this$0, startOffset, endOffset, this.$calleeReference, null, 8, null);
                    }
                    return irExpression;
                }
            }), variableAssignment), variableAssignment, explicitReceiverExpression);
        }
        catch (Throwable e) {
            String string2;
            IrFile irFile = this.conversionScope.containingFileIfAny();
            throw new IllegalStateException("Error while translating " + FirRendererKt.render$default(variableAssignment, null, 1, null) + " from file " + (irFile == null ? "???" : ((string2 = IrFileKt.getName(irFile)) == null ? "???" : string2)) + " to BE IR", e);
        }
    }

    @NotNull
    public final IrExpression convertToIrConstructorCall(@NotNull FirAnnotationCall annotationCall) {
        ConeLookupTagBasedType coneType;
        Intrinsics.checkNotNullParameter(annotationCall, "annotationCall");
        FirTypeRef $this$coneTypeSafe$iv = annotationCall.getAnnotationTypeRef();
        boolean $i$f$coneTypeSafe = false;
        boolean bl = false;
        Object object = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
        ConeKotlinType coneKotlinType = object == null ? null : ((FirResolvedTypeRef)object).getType();
        if (!(coneKotlinType instanceof ConeLookupTagBasedType)) {
            coneKotlinType = null;
        }
        IrType type2 = ($i$f$coneTypeSafe = (coneType = (ConeLookupTagBasedType)((ConeKotlinType)((ConeLookupTagBasedType)coneKotlinType)))) == null ? null : this.toIrType($i$f$coneTypeSafe);
        object = type2;
        IrClassifierSymbol symbol2 = object == null ? null : IrTypesKt.getClassifierOrNull((IrType)object);
        return this.applyCallArguments$fir2ir((IrExpression)ConversionUtilsKt.convertWithOffsets(annotationCall, (Function2)new Function2<Integer, Integer, IrExpression>(symbol2, annotationCall, this, type2, coneType){
            final /* synthetic */ IrClassifierSymbol $symbol;
            final /* synthetic */ FirAnnotationCall $annotationCall;
            final /* synthetic */ CallAndReferenceGenerator this$0;
            final /* synthetic */ IrType $type;
            final /* synthetic */ ConeLookupTagBasedType $coneType;
            {
                this.$symbol = $symbol;
                this.$annotationCall = $annotationCall;
                this.this$0 = $receiver;
                this.$type = $type;
                this.$coneType = $coneType;
                super(2);
            }

            @NotNull
            public final IrExpression invoke(int startOffset, int endOffset) {
                IrExpression irExpression;
                IrClassifierSymbol irClassifierSymbol = this.$symbol;
                if (irClassifierSymbol instanceof IrClassSymbol) {
                    IrBindableSymbol irConstructor2;
                    IrBindableSymbol irBindableSymbol;
                    boolean bl;
                    IrBindableSymbol irBindableSymbol2;
                    Object object;
                    IrClass irClass2 = (IrClass)((IrClassSymbol)this.$symbol).getOwner();
                    Object object2 = FirExpressionUtilKt.toResolvedCallableSymbol(this.$annotationCall);
                    Object object3 = object = object2 instanceof FirConstructorSymbol ? (FirConstructorSymbol)object2 : null;
                    if (object == null) {
                        irBindableSymbol2 = null;
                    } else {
                        object2 = object;
                        CallAndReferenceGenerator callAndReferenceGenerator = this.this$0;
                        bl = false;
                        boolean bl2 = false;
                        FirConstructorSymbol it = object2;
                        boolean bl3 = false;
                        irBindableSymbol2 = callAndReferenceGenerator.getDeclarationStorage().getIrConstructorSymbol(it);
                    }
                    IrBindableSymbol irBindableSymbol3 = irBindableSymbol2;
                    if (irBindableSymbol3 == null) {
                        Object object4;
                        object = this.this$0;
                        object2 = this.$coneType;
                        boolean bl4 = false;
                        bl = false;
                        Object $this$invoke_u24lambda_u2d2 = object;
                        boolean bl5 = false;
                        Object object5 = LookupTagUtilsKt.toSymbol(((ConeLookupTagBasedType)object2).getLookupTag(), ((CallAndReferenceGenerator)$this$invoke_u24lambda_u2d2).getSession());
                        Object var14_19 = object5 == null ? null : ((AbstractFirBasedSymbol)object5).getFir();
                        FirClass fir = var14_19 instanceof FirClass ? (FirClass)var14_19 : null;
                        Ref.ObjectRef<FirConstructorSymbol> constructorSymbol = new Ref.ObjectRef<FirConstructorSymbol>();
                        object5 = fir;
                        if (object5 != null && (object4 = KotlinScopeProviderKt.unsubstitutedScope(object5, ((CallAndReferenceGenerator)$this$invoke_u24lambda_u2d2).getSession(), ((CallAndReferenceGenerator)$this$invoke_u24lambda_u2d2).getScopeSession(), true)) != null) {
                            ((FirScope)object4).processDeclaredConstructors((Function1<? super FirConstructorSymbol, Unit>)new Function1<FirConstructorSymbol, Unit>(constructorSymbol){
                                final /* synthetic */ Ref.ObjectRef<FirConstructorSymbol> $constructorSymbol;
                                {
                                    this.$constructorSymbol = $constructorSymbol;
                                    super(1);
                                }

                                public final void invoke(@NotNull FirConstructorSymbol it) {
                                    Intrinsics.checkNotNullParameter(it, "it");
                                    if (((FirConstructor)it.getFir()).isPrimary() && this.$constructorSymbol.element == null) {
                                        this.$constructorSymbol.element = it;
                                    }
                                }
                            });
                        }
                        if ((object5 = (FirConstructorSymbol)constructorSymbol.element) == null) {
                            irBindableSymbol = null;
                        } else {
                            object4 = object5;
                            boolean bl6 = false;
                            boolean bl7 = false;
                            Object it = object4;
                            boolean bl8 = false;
                            irBindableSymbol = ((CallAndReferenceGenerator)$this$invoke_u24lambda_u2d2).getDeclarationStorage().getIrConstructorSymbol((FirConstructorSymbol)it);
                        }
                    } else {
                        irBindableSymbol = irConstructor2 = irBindableSymbol3;
                    }
                    if (irConstructor2 == null) {
                        irExpression = new IrErrorCallExpressionImpl(startOffset, endOffset, this.$type, Intrinsics.stringPlus("No annotation constructor found: ", irClass2.getName()));
                    } else {
                        int n = ((IrConstructor)irConstructor2.getOwner()).getValueParameters().size();
                        irExpression = new IrConstructorCallImpl(startOffset, endOffset, this.$type, (IrConstructorSymbol)irConstructor2, 0, 0, n, null, 128, null);
                    }
                } else {
                    IrType irType = this.$type;
                    irExpression = new IrErrorCallExpressionImpl(startOffset, endOffset, irType == null ? (IrType)ConversionUtilsKt.createErrorType() : irType, Intrinsics.stringPlus("Unresolved reference: ", FirRendererKt.render$default(this.$annotationCall, null, 1, null)));
                }
                return irExpression;
            }
        }), annotationCall, true);
    }

    @NotNull
    public final IrExpression convertToGetObject$fir2ir(@NotNull FirResolvedQualifier qualifier) {
        Intrinsics.checkNotNullParameter(qualifier, "qualifier");
        IrExpression irExpression = this.convertToGetObject$fir2ir(qualifier, null);
        Intrinsics.checkNotNull(irExpression);
        return irExpression;
    }

    @Nullable
    public final IrExpression convertToGetObject$fir2ir(@NotNull FirResolvedQualifier qualifier, @Nullable FirCallableReferenceAccess callableReferenceAccess) {
        boolean classIdMatched;
        FirClassLikeSymbol<?> classSymbol;
        ConeClassLikeType coneClassLikeType;
        Intrinsics.checkNotNullParameter(qualifier, "qualifier");
        FirTypeRef $this$coneType$iv = qualifier.getTypeRef();
        boolean $i$f$getConeType = false;
        FirTypeRef $this$coneTypeUnsafe$iv$iv = $this$coneType$iv;
        boolean $i$f$coneTypeUnsafe = false;
        ConeKotlinType coneKotlinType = ((FirResolvedTypeRef)$this$coneTypeUnsafe$iv$iv).getType();
        if (coneKotlinType == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinType");
        }
        Object object = coneKotlinType;
        ConeClassLikeType coneClassLikeType2 = coneClassLikeType = object instanceof ConeClassLikeType ? (ConeClassLikeType)object : null;
        FirClassLikeSymbol<?> firClassLikeSymbol = coneClassLikeType == null ? null : (classSymbol = (object = coneClassLikeType.getLookupTag()) == null ? null : LookupTagUtilsKt.toSymbol((ConeClassLikeLookupTag)object, this.getSession()));
        if (callableReferenceAccess != null && classSymbol instanceof FirRegularClassSymbol && !(classIdMatched = Intrinsics.areEqual(classSymbol.getClassId(), qualifier.getClassId()))) {
            FirRegularClass $this$isCompanion$iv = (FirRegularClass)((FirRegularClassSymbol)classSymbol).getFir();
            boolean $i$f$isCompanion = false;
            if (!$this$isCompanion$iv.getStatus().isCompanion() || !Intrinsics.areEqual(classSymbol.getClassId().getOuterClassId(), qualifier.getClassId())) {
                return null;
            }
            FirResolvedNamedReference resolvedReference = (FirResolvedNamedReference)callableReferenceAccess.getCalleeReference();
            FirCallableSymbol firCallableSymbol = (FirCallableSymbol)resolvedReference.getResolvedSymbol();
            if (!Intrinsics.areEqual(ClassMembersKt.dispatchReceiverClassOrNull(firCallableSymbol), classSymbol.toLookupTag())) {
                return null;
            }
        }
        IrType irType = this.toIrType(qualifier.getTypeRef());
        return (IrExpression)ConversionUtilsKt.convertWithOffsets(qualifier, (Function2)new Function2<Integer, Integer, IrExpression>(classSymbol, irType, this, qualifier){
            final /* synthetic */ FirClassLikeSymbol<?> $classSymbol;
            final /* synthetic */ IrType $irType;
            final /* synthetic */ CallAndReferenceGenerator this$0;
            final /* synthetic */ FirResolvedQualifier $qualifier;
            {
                this.$classSymbol = $classSymbol;
                this.$irType = $irType;
                this.this$0 = $receiver;
                this.$qualifier = $qualifier;
                super(2);
            }

            @NotNull
            public final IrExpression invoke(int startOffset, int endOffset) {
                return this.$classSymbol != null ? (IrExpression)new IrGetObjectValueImpl(startOffset, endOffset, this.$irType, (IrClassSymbol)ConversionUtilsKt.toSymbol$default(this.$classSymbol, this.this$0.getSession(), this.this$0.getClassifierStorage(), null, 4, null)) : (IrExpression)new IrErrorCallExpressionImpl(startOffset, endOffset, this.$irType, "Resolved qualifier " + FirRendererKt.render$default(this.$qualifier, null, 1, null) + " does not have correctly resolved type");
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final IrExpression applyCallArguments$fir2ir(@NotNull IrExpression $this$applyCallArguments, @Nullable FirCall call2, boolean annotationMode) {
        Object object;
        block20: {
            IrExpression irExpression;
            block16: {
                int argumentsCount;
                block17: {
                    Object object2;
                    List<FirValueParameter> valueParameters2;
                    List<FirValueParameter> destination$iv$iv;
                    IrMemberAccessExpression $this$applyCallArguments_u24lambda_u2d2;
                    Object $this$arguments$iv;
                    block18: {
                        LinkedHashMap<FirExpression, FirValueParameter> argumentMapping;
                        block19: {
                            FirFunction firFunction;
                            Object $this$filterIsInstance$iv;
                            Object firClass;
                            List<FirDeclaration> $i$f$coneTypeSafe22;
                            Object coneClassLikeType;
                            FirReference calleeReference;
                            Intrinsics.checkNotNullParameter($this$applyCallArguments, "<this>");
                            if (call2 == null) {
                                return $this$applyCallArguments;
                            }
                            irExpression = $this$applyCallArguments;
                            if (!(irExpression instanceof IrMemberAccessExpression)) break block16;
                            $this$arguments$iv = call2;
                            boolean $i$f$getArguments = false;
                            argumentsCount = $this$arguments$iv.getArgumentList().getArguments().size();
                            if (argumentsCount > ((IrMemberAccessExpression)$this$applyCallArguments).getValueArgumentsCount()) break block17;
                            $this$arguments$iv = $this$applyCallArguments;
                            boolean bl = false;
                            boolean bl2 = false;
                            $this$applyCallArguments_u24lambda_u2d2 = (IrMemberAccessExpression)$this$arguments$iv;
                            boolean bl3 = false;
                            FirCall firCall = call2;
                            FirReference firReference = firCall instanceof FirFunctionCall ? (FirReference)((FirFunctionCall)call2).getCalleeReference() : (firCall instanceof FirDelegatedConstructorCall ? ((FirDelegatedConstructorCall)call2).getCalleeReference() : (calleeReference = firCall instanceof FirAnnotationCall ? ((FirAnnotationCall)call2).getCalleeReference() : null));
                            if (Intrinsics.areEqual(calleeReference, FirReferencePlaceholderForResolvedAnnotations.INSTANCE)) {
                                FirConstructor firConstructor;
                                ConeClassLikeLookupTag coneClassLikeLookupTag;
                                Object object3;
                                FirTypeRef $this$coneTypeSafe$iv = ((FirAnnotationCall)call2).getAnnotationTypeRef();
                                boolean $i$f$coneTypeSafe22 = false;
                                boolean bl4 = false;
                                Object object4 = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
                                ConeKotlinType coneKotlinType = object4 == null ? null : ((FirResolvedTypeRef)object4).getType();
                                if (!(coneKotlinType instanceof ConeClassLikeType)) {
                                    coneKotlinType = null;
                                }
                                object4 = (object3 = (coneClassLikeType = (ConeClassLikeType)((ConeKotlinType)((ConeClassLikeType)coneKotlinType)))) == null ? null : ((coneClassLikeLookupTag = ((ConeClassLikeType)object3).getLookupTag()) == null ? null : LookupTagUtilsKt.toSymbol(coneClassLikeLookupTag, this.getSession()));
                                $i$f$coneTypeSafe22 = object4 instanceof FirRegularClassSymbol ? (FirRegularClassSymbol)object4 : null;
                                object4 = firClass = $i$f$coneTypeSafe22 == null ? null : (FirRegularClass)((AbstractFirBasedSymbol)((Object)$i$f$coneTypeSafe22)).getFir();
                                List<FirDeclaration> list2 = $i$f$coneTypeSafe22 = object4 == null ? null : ((FirRegularClass)object4).getDeclarations();
                                if ($i$f$coneTypeSafe22 == null) {
                                    firConstructor = null;
                                } else {
                                    void $this$filterIsInstanceTo$iv$iv;
                                    $this$filterIsInstance$iv = $i$f$coneTypeSafe22;
                                    boolean $i$f$filterIsInstance = false;
                                    Object object5 = $this$filterIsInstance$iv;
                                    destination$iv$iv = new ArrayList();
                                    boolean $i$f$filterIsInstanceTo = false;
                                    for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                                        if (!(element$iv$iv instanceof FirConstructor)) continue;
                                        destination$iv$iv.add((FirValueParameter)element$iv$iv);
                                    }
                                    object4 = destination$iv$iv;
                                    firConstructor = (FirConstructor)CollectionsKt.firstOrNull(object4);
                                }
                                firFunction = firConstructor;
                            } else {
                                $i$f$coneTypeSafe22 = calleeReference instanceof FirResolvedNamedReference ? (FirResolvedNamedReference)calleeReference : null;
                                firClass = $i$f$coneTypeSafe22 == null ? null : ((FirResolvedNamedReference)((Object)$i$f$coneTypeSafe22)).getResolvedSymbol();
                                coneClassLikeType = firClass instanceof FirFunctionSymbol ? (FirFunctionSymbol)firClass : null;
                                firFunction = coneClassLikeType == null ? null : (FirFunction)((AbstractFirBasedSymbol)coneClassLikeType).getFir();
                            }
                            FirFunction function2 = firFunction;
                            firClass = function2;
                            valueParameters2 = firClass == null ? null : firClass.getValueParameters();
                            FirCall $this$argumentMapping$iv = call2;
                            boolean $i$f$getArgumentMapping = false;
                            $this$filterIsInstance$iv = $this$argumentMapping$iv.getArgumentList();
                            FirResolvedArgumentList $i$f$filterIsInstance = $this$filterIsInstance$iv instanceof FirResolvedArgumentList ? (FirResolvedArgumentList)$this$filterIsInstance$iv : null;
                            LinkedHashMap<FirExpression, FirValueParameter> linkedHashMap = argumentMapping = $i$f$filterIsInstance == null ? null : $i$f$filterIsInstance.getMapping();
                            if (argumentMapping == null) break block18;
                            if (annotationMode) break block19;
                            object2 = argumentMapping;
                            $i$f$getArgumentMapping = false;
                            if (!(!object2.isEmpty())) break block18;
                        }
                        if (valueParameters2 != null) {
                            return this.applyArgumentsWithReorderingIfNeeded($this$applyCallArguments_u24lambda_u2d2, argumentMapping, valueParameters2, annotationMode);
                        }
                    }
                    FirCall $this$arguments$iv2 = call2;
                    boolean $i$f$getArguments = false;
                    object2 = $this$arguments$iv2.getArgumentList().getArguments().iterator();
                    int n = 0;
                    while (object2.hasNext()) {
                        int index2 = n++;
                        FirExpression argument = (FirExpression)object2.next();
                        destination$iv$iv = valueParameters2;
                        FirValueParameter valueParameter = destination$iv$iv == null ? null : destination$iv$iv.get(index2);
                        IrExpression argumentExpression = CallAndReferenceGenerator.convertArgument$default(this, argument, valueParameter, false, 4, null);
                        $this$applyCallArguments_u24lambda_u2d2.putValueArgument(index2, argumentExpression);
                    }
                    object = $this$arguments$iv;
                    break block20;
                }
                Comparable name = $this$applyCallArguments instanceof IrCallImpl ? (Comparable)((IrSimpleFunction)((IrCallImpl)$this$applyCallArguments).getSymbol().getOwner()).getName() : (Comparable)((Object)"???");
                IrErrorCallExpressionImpl irErrorCallExpressionImpl = new IrErrorCallExpressionImpl($this$applyCallArguments.getStartOffset(), $this$applyCallArguments.getEndOffset(), $this$applyCallArguments.getType(), "Cannot bind " + argumentsCount + " arguments to " + name + " call with " + ((IrMemberAccessExpression)$this$applyCallArguments).getValueArgumentsCount() + " parameters");
                boolean bl = false;
                boolean $this$applyCallArguments_u24lambda_u2d2 = false;
                IrErrorCallExpressionImpl $this$applyCallArguments_u24lambda_u2d3 = irErrorCallExpressionImpl;
                boolean bl5 = false;
                FirCall $this$arguments$iv = call2;
                boolean $i$f$getArguments = false;
                for (FirExpression argument : $this$arguments$iv.getArgumentList().getArguments()) {
                    $this$applyCallArguments_u24lambda_u2d3.addArgument(Fir2IrVisitor.convertToIrExpression$fir2ir$default(this.visitor, argument, false, 2, null));
                }
                object = irErrorCallExpressionImpl;
                break block20;
            }
            if (irExpression instanceof IrErrorCallExpressionImpl) {
                IrExpression irExpression2 = $this$applyCallArguments;
                boolean bl = false;
                boolean bl6 = false;
                IrErrorCallExpressionImpl $this$applyCallArguments_u24lambda_u2d4 = (IrErrorCallExpressionImpl)irExpression2;
                boolean bl7 = false;
                FirCall $this$arguments$iv = call2;
                boolean $i$f$getArguments = false;
                for (FirExpression argument : $this$arguments$iv.getArgumentList().getArguments()) {
                    $this$applyCallArguments_u24lambda_u2d4.addArgument(Fir2IrVisitor.convertToIrExpression$fir2ir$default(this.visitor, argument, false, 2, null));
                }
                object = irExpression2;
            } else {
                object = $this$applyCallArguments;
            }
        }
        return object;
    }

    private final IrExpression applyArgumentsWithReorderingIfNeeded(IrMemberAccessExpression<?> $this$applyArgumentsWithReorderingIfNeeded, LinkedHashMap<FirExpression, FirValueParameter> argumentMapping, List<? extends FirValueParameter> valueParameters2, boolean annotationMode) {
        FirValueParameter parameter;
        Object object;
        if (!annotationMode) {
            object = argumentMapping.values();
            Intrinsics.checkNotNullExpressionValue(object, "argumentMapping.values");
            if (this.needArgumentReordering((Collection<? extends FirValueParameter>)object, valueParameters2)) {
                object = new IrBlockImpl($this$applyArgumentsWithReorderingIfNeeded.getStartOffset(), $this$applyArgumentsWithReorderingIfNeeded.getEndOffset(), $this$applyArgumentsWithReorderingIfNeeded.getType(), IrStatementOrigin.ARGUMENTS_REORDERING_FOR_CALL.INSTANCE);
                boolean bl = false;
                boolean bl2 = false;
                Object $this$applyArgumentsWithReorderingIfNeeded_u24lambda_u2d6 = object;
                boolean $i$a$-apply-CallAndReferenceGenerator$applyArgumentsWithReorderingIfNeeded$22 = false;
                Object object2 = argumentMapping;
                boolean bl3 = false;
                Iterator iterator2 = object2.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Object object3 = object2 = iterator2.next();
                    boolean bl4 = false;
                    FirExpression argument = (FirExpression)object3.getKey();
                    Object object4 = object2;
                    boolean bl5 = false;
                    FirValueParameter parameter2 = (FirValueParameter)object4.getValue();
                    int parameterIndex = valueParameters2.indexOf(parameter2);
                    IrExpression irArgument = CallAndReferenceGenerator.convertArgument$default(this, argument, parameter2, false, 4, null);
                    if (CallGeneratorKt.hasNoSideEffects(irArgument)) {
                        $this$applyArgumentsWithReorderingIfNeeded.putValueArgument(parameterIndex, irArgument);
                        continue;
                    }
                    IrVariable irVariable2 = this.getDeclarationStorage().declareTemporaryVariable(irArgument, parameter2.getName().asString());
                    boolean bl6 = false;
                    boolean bl7 = false;
                    IrVariable $this$applyArgumentsWithReorderingIfNeeded_u24lambda_u2d6_u24lambda_u2d5 = irVariable2;
                    boolean bl8 = false;
                    $this$applyArgumentsWithReorderingIfNeeded_u24lambda_u2d6_u24lambda_u2d5.setParent(this.conversionScope.parentFromStack());
                    IrVariable tempVar = irVariable2;
                    ((IrContainerExpression)$this$applyArgumentsWithReorderingIfNeeded_u24lambda_u2d6).getStatements().add(tempVar);
                    $this$applyArgumentsWithReorderingIfNeeded.putValueArgument(parameterIndex, new IrGetValueImpl(((IrBlockImpl)$this$applyArgumentsWithReorderingIfNeeded_u24lambda_u2d6).getStartOffset(), ((IrBlockImpl)$this$applyArgumentsWithReorderingIfNeeded_u24lambda_u2d6).getEndOffset(), tempVar.getSymbol(), null));
                }
                ((IrContainerExpression)$this$applyArgumentsWithReorderingIfNeeded_u24lambda_u2d6).getStatements().add($this$applyArgumentsWithReorderingIfNeeded);
                return (IrExpression)object;
            }
        }
        Object object5 = argumentMapping;
        boolean bl = false;
        object = object5.entrySet().iterator();
        while (object.hasNext()) {
            Object $this$applyArgumentsWithReorderingIfNeeded_u24lambda_u2d6 = object5 = (Map.Entry)object.next();
            boolean $i$a$-apply-CallAndReferenceGenerator$applyArgumentsWithReorderingIfNeeded$22 = false;
            FirExpression argument = (FirExpression)$this$applyArgumentsWithReorderingIfNeeded_u24lambda_u2d6.getKey();
            Object $i$a$-apply-CallAndReferenceGenerator$applyArgumentsWithReorderingIfNeeded$22 = object5;
            boolean bl9 = false;
            parameter = (FirValueParameter)$i$a$-apply-CallAndReferenceGenerator$applyArgumentsWithReorderingIfNeeded$22.getValue();
            IrExpression argumentExpression = this.convertArgument(argument, parameter, annotationMode);
            $this$applyArgumentsWithReorderingIfNeeded.putValueArgument(valueParameters2.indexOf(parameter), argumentExpression);
        }
        if (annotationMode) {
            object = valueParameters2.iterator();
            int n = 0;
            while (object.hasNext()) {
                int index2 = n++;
                parameter = (FirValueParameter)object.next();
                if (!parameter.isVararg() || argumentMapping.containsValue(parameter)) continue;
                IrType elementType = this.toIrType(parameter.getReturnTypeRef());
                $this$applyArgumentsWithReorderingIfNeeded.putValueArgument(index2, new IrVarargImpl(-1, -1, elementType, org.jetbrains.kotlin.ir.types.IrTypeUtilsKt.toArrayOrPrimitiveArrayType(elementType, this.getIrBuiltIns())));
            }
        }
        return $this$applyArgumentsWithReorderingIfNeeded;
    }

    private final boolean needArgumentReordering(Collection<? extends FirValueParameter> parametersInActualOrder, List<? extends FirValueParameter> valueParameters2) {
        int lastValueParameterIndex = -1;
        for (FirValueParameter firValueParameter : parametersInActualOrder) {
            int index2 = valueParameters2.indexOf(firValueParameter);
            if (index2 < lastValueParameterIndex) {
                return true;
            }
            lastValueParameterIndex = index2;
        }
        return false;
    }

    private final IrExpression convertArgument(FirExpression argument, FirValueParameter parameter, boolean annotationMode) {
        boolean bl;
        boolean bl2;
        Fir2IrComponents fir2IrComponents;
        IrExpression irArgument = null;
        irArgument = this.visitor.convertToIrExpression$fir2ir(argument, annotationMode);
        if (parameter != null) {
            fir2IrComponents = this.visitor.getImplicitCastInserter$fir2ir();
            bl2 = false;
            bl = false;
            Fir2IrComponents $this$convertArgument_u24lambda_u2d7 = fir2IrComponents;
            boolean bl3 = false;
            irArgument = ((Fir2IrImplicitCastInserter)$this$convertArgument_u24lambda_u2d7).cast$fir2ir(irArgument, argument, argument.getTypeRef(), parameter.getReturnTypeRef());
        }
        fir2IrComponents = this.adapterGenerator;
        bl2 = false;
        bl = false;
        Fir2IrComponents $this$convertArgument_u24lambda_u2d8 = fir2IrComponents;
        boolean bl4 = false;
        FirValueParameter firValueParameter = parameter;
        if ((firValueParameter == null ? null : firValueParameter.getReturnTypeRef()) instanceof FirResolvedTypeRef) {
            irArgument = ((AdapterGenerator)$this$convertArgument_u24lambda_u2d8).applySuspendConversionIfNeeded$fir2ir(irArgument, argument, parameter);
            irArgument = CallAndReferenceGenerator.applySamConversionIfNeeded$default(this, irArgument, argument, parameter, false, 4, null);
        }
        return this.applyAssigningArrayElementsToVarargInNamedForm(irArgument, argument, parameter);
    }

    static /* synthetic */ IrExpression convertArgument$default(CallAndReferenceGenerator callAndReferenceGenerator, FirExpression firExpression2, FirValueParameter firValueParameter, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return callAndReferenceGenerator.convertArgument(firExpression2, firValueParameter, bl);
    }

    private final IrExpression applySamConversionIfNeeded(IrExpression $this$applySamConversionIfNeeded, FirExpression argument, FirValueParameter parameter, boolean shouldUnwrapVarargType) {
        if (parameter == null) {
            return $this$applySamConversionIfNeeded;
        }
        if ($this$applySamConversionIfNeeded instanceof IrVararg) {
            if (!(argument instanceof FirVarargArgumentsExpression) || ((FirVarargArgumentsExpression)argument).getArguments().size() != ((IrVararg)$this$applySamConversionIfNeeded).getElements().size()) {
                return $this$applySamConversionIfNeeded;
            }
            Map argumentMapping = MapsKt.toMap(CollectionsKt.zip((Iterable)((IrVararg)$this$applySamConversionIfNeeded).getElements(), (Iterable)((FirVarargArgumentsExpression)argument).getArguments()));
            List irVarargElements = TypeIntrinsics.asMutableList(((IrVararg)$this$applySamConversionIfNeeded).getElements());
            irVarargElements.replaceAll((UnaryOperator)new UnaryOperator<IrVarargElement>(argumentMapping, this, parameter){
                final /* synthetic */ Map<IrVarargElement, FirExpression> $argumentMapping;
                final /* synthetic */ CallAndReferenceGenerator this$0;
                final /* synthetic */ FirValueParameter $parameter;
                {
                    this.$argumentMapping = $argumentMapping;
                    this.this$0 = $receiver;
                    this.$parameter = $parameter;
                }

                @NotNull
                public final IrVarargElement apply(@NotNull IrVarargElement irVarargElement) {
                    IrVarargElement irVarargElement2;
                    Intrinsics.checkNotNullParameter(irVarargElement, "irVarargElement");
                    if (irVarargElement instanceof IrExpression) {
                        FirExpression firExpression2 = this.$argumentMapping.get(irVarargElement);
                        if (firExpression2 == null) {
                            String string2 = Intrinsics.stringPlus("Can't find the original FirExpression for ", RenderIrElementKt.render(irVarargElement));
                            boolean bl = false;
                            throw (Throwable)new IllegalStateException(string2.toString());
                        }
                        FirExpression firVarargArgument = firExpression2;
                        irVarargElement2 = CallAndReferenceGenerator.access$applySamConversionIfNeeded(this.this$0, (IrExpression)irVarargElement, firVarargArgument, this.$parameter, true);
                    } else {
                        irVarargElement2 = irVarargElement;
                    }
                    return irVarargElement2;
                }
            });
            return $this$applySamConversionIfNeeded;
        }
        if (!this.needSamConversion(argument, parameter)) {
            return $this$applySamConversionIfNeeded;
        }
        IrType samType = this.toIrType(parameter.getReturnTypeRef());
        if (shouldUnwrapVarargType) {
            samType = org.jetbrains.kotlin.ir.types.IrTypeUtilsKt.getArrayElementType(samType, this.getIrBuiltIns());
        }
        if (!ConversionUtilsKt.isSamType(samType)) {
            return $this$applySamConversionIfNeeded;
        }
        return new IrTypeOperatorCallImpl($this$applySamConversionIfNeeded.getStartOffset(), $this$applySamConversionIfNeeded.getEndOffset(), samType, IrTypeOperator.SAM_CONVERSION, samType, $this$applySamConversionIfNeeded);
    }

    static /* synthetic */ IrExpression applySamConversionIfNeeded$default(CallAndReferenceGenerator callAndReferenceGenerator, IrExpression irExpression, FirExpression firExpression2, FirValueParameter firValueParameter, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return callAndReferenceGenerator.applySamConversionIfNeeded(irExpression, firExpression2, firValueParameter, bl);
    }

    private final boolean needSamConversion(FirExpression argument, FirValueParameter parameter) {
        ConeKotlinType expectedType2 = ArgumentsKt.getExpectedTypeForSAMConversion(argument, parameter);
        if (expectedType2 instanceof ConeTypeParameterType || InferenceUtilsKt.isBuiltinFunctionalType(expectedType2, this.getSession())) {
            return false;
        }
        return ArgumentsKt.isFunctional(argument, this.getSession());
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression applyAssigningArrayElementsToVarargInNamedForm(IrExpression $this$applyAssigningArrayElementsToVarargInNamedForm, FirExpression argument, FirValueParameter parameter) {
        block11: {
            block10: {
                boolean bl;
                block9: {
                    FirValueParameter firValueParameter;
                    if (!($this$applyAssigningArrayElementsToVarargInNamedForm instanceof IrVarargImpl) || !Intrinsics.areEqual((firValueParameter = parameter) == null ? null : Boolean.valueOf(firValueParameter.isVararg()), true) || !(argument instanceof FirVarargArgumentsExpression)) break block10;
                    Iterable $this$none$iv = ((FirVarargArgumentsExpression)argument).getArguments();
                    boolean $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$none$iv) {
                            FirExpression it = (FirExpression)element$iv;
                            boolean bl2 = false;
                            if (!(it instanceof FirNamedArgumentExpression)) continue;
                            bl = false;
                            break block9;
                        }
                        bl = true;
                    }
                }
                if (!bl) break block11;
            }
            return $this$applyAssigningArrayElementsToVarargInNamedForm;
        }
        Iterable $this$forEachIndexed$iv = ((IrVarargImpl)$this$applyAssigningArrayElementsToVarargInNamedForm).getElements();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void irVarargElement;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            IrVarargElement irVarargElement2 = (IrVarargElement)item$iv;
            int i = n;
            boolean bl3 = false;
            if (irVarargElement instanceof IrSpreadElement || !(((FirVarargArgumentsExpression)argument).getArguments().get(i) instanceof FirNamedArgumentExpression) || !(irVarargElement instanceof IrExpression) || !IrTypePredicatesKt.isArray(((IrExpression)irVarargElement).getType())) continue;
            ((IrVarargImpl)$this$applyAssigningArrayElementsToVarargInNamedForm).getElements().set(i, new IrSpreadElementImpl(irVarargElement.getStartOffset(), irVarargElement.getEndOffset(), (IrExpression)irVarargElement));
        }
        return $this$applyAssigningArrayElementsToVarargInNamedForm;
    }

    @NotNull
    public final IrExpression applyTypeArguments$fir2ir(@NotNull IrExpression $this$applyTypeArguments, @NotNull FirQualifiedAccess access) {
        IrExpression irExpression;
        Intrinsics.checkNotNullParameter($this$applyTypeArguments, "<this>");
        Intrinsics.checkNotNullParameter(access, "access");
        IrExpression irExpression2 = $this$applyTypeArguments;
        if (irExpression2 instanceof IrMemberAccessExpression) {
            int argumentsCount = access.getTypeArguments().size();
            if (argumentsCount <= ((IrMemberAccessExpression)$this$applyTypeArguments).getTypeArgumentsCount()) {
                IrExpression irExpression3 = $this$applyTypeArguments;
                boolean bl = false;
                boolean bl2 = false;
                IrMemberAccessExpression $this$applyTypeArguments_u24lambda_u2d11 = (IrMemberAccessExpression)irExpression3;
                boolean bl3 = false;
                Iterator<FirTypeProjection> iterator2 = access.getTypeArguments().iterator();
                int n = 0;
                while (iterator2.hasNext()) {
                    int index2 = n++;
                    FirTypeProjection argument = iterator2.next();
                    FirTypeParameter typeParameter = this.findTypeParameter(access, index2);
                    FirTypeRef argumentFirType = ((FirTypeProjectionWithVariance)argument).getTypeRef();
                    FirTypeParameter firTypeParameter = typeParameter;
                    IrType argumentIrType = Intrinsics.areEqual(firTypeParameter == null ? null : Boolean.valueOf(firTypeParameter.isReified()), true) ? this.toIrType(TypeUtilsKt.approximatedIfNeededOrSelf$default(argumentFirType, this.approximator, Visibilities.Public.INSTANCE, false, 4, null)) : this.toIrType(argumentFirType);
                    $this$applyTypeArguments_u24lambda_u2d11.putTypeArgument(index2, argumentIrType);
                }
                irExpression = irExpression3;
            } else {
                Comparable name = $this$applyTypeArguments instanceof IrCallImpl ? (Comparable)((IrSimpleFunction)((IrCallImpl)$this$applyTypeArguments).getSymbol().getOwner()).getName() : (Comparable)((Object)"???");
                irExpression = new IrErrorExpressionImpl($this$applyTypeArguments.getStartOffset(), $this$applyTypeArguments.getEndOffset(), $this$applyTypeArguments.getType(), "Cannot bind " + argumentsCount + " type arguments to " + name + " call with " + ((IrMemberAccessExpression)$this$applyTypeArguments).getTypeArgumentsCount() + " type parameters");
            }
        } else if (irExpression2 instanceof IrBlockImpl) {
            IrStatement lastStatement;
            IrExpression irExpression4 = $this$applyTypeArguments;
            boolean bl = false;
            boolean bl4 = false;
            IrBlockImpl $this$applyTypeArguments_u24lambda_u2d12 = (IrBlockImpl)irExpression4;
            boolean bl5 = false;
            Collection bl3 = $this$applyTypeArguments_u24lambda_u2d12.getStatements();
            boolean bl6 = false;
            if (!bl3.isEmpty() && (lastStatement = CollectionsKt.last($this$applyTypeArguments_u24lambda_u2d12.getStatements())) instanceof IrExpression) {
                $this$applyTypeArguments_u24lambda_u2d12.getStatements().set($this$applyTypeArguments_u24lambda_u2d12.getStatements().size() - 1, this.applyTypeArguments$fir2ir((IrExpression)lastStatement, access));
            }
            irExpression = irExpression4;
        } else {
            irExpression = $this$applyTypeArguments;
        }
        return irExpression;
    }

    private final FirTypeParameter findTypeParameter(FirQualifiedAccess $this$findTypeParameter, int index2) {
        FirTypeParametersOwner firTypeParametersOwner;
        FirResolvedNamedReference firResolvedNamedReference;
        Object object = $this$findTypeParameter.getCalleeReference();
        FirResolvedNamedReference firResolvedNamedReference2 = firResolvedNamedReference = object instanceof FirResolvedNamedReference ? (FirResolvedNamedReference)object : null;
        List<FirTypeParameter> list2 = firResolvedNamedReference == null ? null : ((object = firResolvedNamedReference.getResolvedSymbol()) == null ? null : (List<FirTypeParameter>)((AbstractFirBasedSymbol)object).getFir());
        FirTypeParametersOwner firTypeParametersOwner2 = firTypeParametersOwner = list2 instanceof FirTypeParametersOwner ? (FirTypeParametersOwner)((Object)list2) : null;
        return firTypeParametersOwner == null ? null : ((list2 = firTypeParametersOwner.getTypeParameters()) == null ? null : list2.get(index2));
    }

    private final IrExpression findIrDispatchReceiver(FirQualifiedAccess $this$findIrDispatchReceiver, IrExpression explicitReceiverExpression) {
        return this.findIrReceiver$fir2ir($this$findIrDispatchReceiver, explicitReceiverExpression, true);
    }

    private final IrExpression findIrExtensionReceiver(FirQualifiedAccess $this$findIrExtensionReceiver, IrExpression explicitReceiverExpression) {
        return this.findIrReceiver$fir2ir($this$findIrExtensionReceiver, explicitReceiverExpression, false);
    }

    @Nullable
    public final IrExpression findIrReceiver$fir2ir(@NotNull FirQualifiedAccess $this$findIrReceiver, @Nullable IrExpression explicitReceiverExpression, boolean isDispatch) {
        Object object;
        Object object2;
        Object object3;
        FirExpression firReceiver;
        Intrinsics.checkNotNullParameter($this$findIrReceiver, "<this>");
        FirExpression firExpression2 = firReceiver = isDispatch ? $this$findIrReceiver.getDispatchReceiver() : $this$findIrReceiver.getExtensionReceiver();
        if (Intrinsics.areEqual(firReceiver, $this$findIrReceiver.getExplicitReceiver())) {
            return explicitReceiverExpression;
        }
        if (firReceiver instanceof FirResolvedQualifier) {
            return this.convertToGetObject$fir2ir((FirResolvedQualifier)firReceiver, $this$findIrReceiver instanceof FirCallableReferenceAccess ? (FirCallableReferenceAccess)$this$findIrReceiver : null);
        }
        FirStatement firStatement = firReceiver;
        boolean bl = false;
        boolean bl2 = false;
        FirExpression it = firStatement;
        boolean bl3 = false;
        Object object4 = object3 = !(it instanceof FirNoReceiverExpression) ? firStatement : null;
        if (object3 == null) {
            object2 = null;
        } else {
            firStatement = object3;
            bl = false;
            bl2 = false;
            it = firStatement;
            boolean bl4 = false;
            object2 = Fir2IrVisitor.convertToIrExpression$fir2ir$default(this.visitor, it, false, 2, null);
        }
        Object object5 = object2;
        if (object5 == null) {
            object3 = explicitReceiverExpression;
            if (object3 == null) {
                firStatement = $this$findIrReceiver;
                bl = false;
                bl2 = false;
                FirStatement $this$findIrReceiver_u24lambda_u2d15 = firStatement;
                boolean bl5 = false;
                if ($this$findIrReceiver_u24lambda_u2d15 instanceof FirCallableReferenceAccess) {
                    return null;
                }
                String name = isDispatch ? "Dispatch" : "Extension";
                String string2 = name + " receiver expected: " + FirRendererKt.render$default($this$findIrReceiver_u24lambda_u2d15, null, 1, null) + " to " + FirRendererKt.render$default($this$findIrReceiver_u24lambda_u2d15.getCalleeReference(), null, 1, null);
                boolean bl6 = false;
                throw (Throwable)new IllegalStateException(string2.toString());
            }
            object = object3;
        } else {
            object = object5;
        }
        return object;
    }

    private final IrExpression applyReceivers(IrExpression $this$applyReceivers, FirQualifiedAccess qualifiedAccess, IrExpression explicitReceiverExpression) {
        IrExpression irExpression;
        IrExpression irExpression2 = $this$applyReceivers;
        if (irExpression2 instanceof IrMemberAccessExpression) {
            IrFunction ownerFunction;
            IrFunction irFunction2;
            IrFunction irFunction3;
            IrSymbolOwner irSymbolOwner = ((IrMemberAccessExpression)$this$applyReceivers).getSymbol().getOwner();
            IrFunction irFunction4 = irFunction3 = irSymbolOwner instanceof IrFunction ? (IrFunction)irSymbolOwner : null;
            if (irFunction3 == null) {
                IrSymbolOwner irSymbolOwner2 = ((IrMemberAccessExpression)$this$applyReceivers).getSymbol().getOwner();
                irSymbolOwner = irSymbolOwner2 instanceof IrProperty ? (IrProperty)irSymbolOwner2 : null;
                irFunction2 = irSymbolOwner == null ? null : ((IrProperty)irSymbolOwner).getGetter();
            } else {
                irFunction2 = irFunction3;
            }
            irFunction3 = ownerFunction = irFunction2;
            if ((irFunction3 == null ? null : irFunction3.getDispatchReceiverParameter()) != null) {
                ((IrMemberAccessExpression)$this$applyReceivers).setDispatchReceiver(this.findIrDispatchReceiver(qualifiedAccess, explicitReceiverExpression));
            }
            if (((irFunction3 = ownerFunction) == null ? null : irFunction3.getExtensionReceiverParameter()) != null) {
                ((IrMemberAccessExpression)$this$applyReceivers).setExtensionReceiver(this.findIrExtensionReceiver(qualifiedAccess, explicitReceiverExpression));
            }
            irExpression = $this$applyReceivers;
        } else if (irExpression2 instanceof IrFieldAccessExpression) {
            IrField ownerField = (IrField)((IrFieldAccessExpression)$this$applyReceivers).getSymbol().getOwner();
            if (!ownerField.isStatic()) {
                ((IrFieldAccessExpression)$this$applyReceivers).setReceiver(this.findIrDispatchReceiver(qualifiedAccess, explicitReceiverExpression));
            }
            irExpression = $this$applyReceivers;
        } else if (irExpression2 instanceof IrBlockImpl) {
            IrStatement lastStatement;
            IrExpression irExpression3 = $this$applyReceivers;
            boolean bl = false;
            boolean bl2 = false;
            IrBlockImpl $this$applyReceivers_u24lambda_u2d16 = (IrBlockImpl)irExpression3;
            boolean bl3 = false;
            Collection collection = $this$applyReceivers_u24lambda_u2d16.getStatements();
            boolean bl4 = false;
            if (!collection.isEmpty() && (lastStatement = CollectionsKt.last($this$applyReceivers_u24lambda_u2d16.getStatements())) instanceof IrExpression) {
                $this$applyReceivers_u24lambda_u2d16.getStatements().set($this$applyReceivers_u24lambda_u2d16.getStatements().size() - 1, this.applyReceivers((IrExpression)lastStatement, qualifiedAccess, explicitReceiverExpression));
            }
            irExpression = irExpression3;
        } else {
            irExpression = $this$applyReceivers;
        }
        return irExpression;
    }

    private final IrErrorCallExpression generateErrorCallExpression(int startOffset, int endOffset, FirReference calleeReference, IrType type2) {
        IrType irType = type2;
        return new IrErrorCallExpressionImpl(startOffset, endOffset, irType == null ? (IrType)ConversionUtilsKt.createErrorType() : irType, Intrinsics.stringPlus("Unresolved reference: ", FirRendererKt.render$default(calleeReference, null, 1, null)));
    }

    static /* synthetic */ IrErrorCallExpression generateErrorCallExpression$default(CallAndReferenceGenerator callAndReferenceGenerator, int n, int n2, FirReference firReference, IrType irType, int n3, Object object) {
        if ((n3 & 8) != 0) {
            irType = null;
        }
        return callAndReferenceGenerator.generateErrorCallExpression(n, n2, firReference, irType);
    }

    public static final /* synthetic */ AdapterGenerator access$getAdapterGenerator$p(CallAndReferenceGenerator $this) {
        return $this.adapterGenerator;
    }

    public static final /* synthetic */ Fir2IrVisitor access$getVisitor$p(CallAndReferenceGenerator $this) {
        return $this.visitor;
    }

    public static final /* synthetic */ IrClassSymbol access$superQualifierSymbol(CallAndReferenceGenerator $this, FirExpression $receiver, IrSymbol callSymbol) {
        return $this.superQualifierSymbol($receiver, callSymbol);
    }

    public static final /* synthetic */ IrErrorCallExpression access$generateErrorCallExpression(CallAndReferenceGenerator $this, int startOffset, int endOffset, FirReference calleeReference, IrType type2) {
        return $this.generateErrorCallExpression(startOffset, endOffset, calleeReference, type2);
    }

    public static final /* synthetic */ IrExpression access$applySamConversionIfNeeded(CallAndReferenceGenerator $this, IrExpression $receiver, FirExpression argument, FirValueParameter parameter, boolean shouldUnwrapVarargType) {
        return $this.applySamConversionIfNeeded($receiver, argument, parameter, shouldUnwrapVarargType);
    }
}

