/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.BackendContext;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.IrElementTransformerVoidWithContext;
import org.jetbrains.kotlin.backend.common.ScopeWithIr;
import org.jetbrains.kotlin.backend.common.UtilsKt;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.Scope;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0016H\u0014J\u0010\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001eH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R&\u0010\b\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\f0\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/EnumWhenLowering;", "Lorg/jetbrains/kotlin/backend/common/IrElementTransformerVoidWithContext;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "subjectWithOrdinalStack", "", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "Lkotlin/Lazy;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "mapConstEnumEntry", "", "entry", "Lorg/jetbrains/kotlin/ir/declarations/IrEnumEntry;", "mapRuntimeEnumEntry", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "builder", "Lorg/jetbrains/kotlin/ir/builders/IrBuilderWithScope;", "subject", "visitBlock", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrBlock;", "visitCall", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "ir.backend.common"})
public class EnumWhenLowering
extends IrElementTransformerVoidWithContext
implements FileLoweringPass {
    @NotNull
    private final CommonBackendContext context;
    @NotNull
    private final List<Pair<IrVariable, Lazy<IrVariable>>> subjectWithOrdinalStack;

    public EnumWhenLowering(@NotNull CommonBackendContext context2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        this.context = context2;
        boolean bl = false;
        this.subjectWithOrdinalStack = new ArrayList();
    }

    @NotNull
    protected final CommonBackendContext getContext() {
        return this.context;
    }

    /*
     * WARNING - void declaration
     */
    protected int mapConstEnumEntry(@NotNull IrEnumEntry entry) {
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter(entry, "entry");
        Iterable $this$filterIsInstance$iv = IrUtilsKt.getParentAsClass(entry).getDeclarations();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof IrEnumEntry)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        int n = ((List)destination$iv$iv).indexOf(entry);
        boolean bl = false;
        boolean bl2 = false;
        int it = n;
        boolean bl3 = false;
        boolean bl4 = it >= 0;
        boolean bl5 = false;
        if (_Assertions.ENABLED && !bl4) {
            boolean bl6 = false;
            String string2 = "enum entry " + DumpIrTreeKt.dump$default(entry, false, 1, null) + " not in parent class";
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        return n;
    }

    @NotNull
    protected IrExpression mapRuntimeEnumEntry(@NotNull IrBuilderWithScope builder2, @NotNull IrExpression subject) {
        Intrinsics.checkNotNullParameter(builder2, "builder");
        Intrinsics.checkNotNullParameter(subject, "subject");
        IrClass irClass2 = IrTypesKt.getClass(subject.getType());
        Intrinsics.checkNotNull(irClass2);
        Object object = AdditionalIrUtilsKt.getPropertyGetter((IrClassSymbol)irClass2.getSymbol(), "ordinal");
        Intrinsics.checkNotNull(object);
        object = ExpressionHelpersKt.irCall(builder2, (IrSimpleFunctionSymbol)object);
        boolean bl = false;
        boolean bl2 = false;
        Object $this$mapRuntimeEnumEntry_u24lambda_u2d2 = object;
        boolean bl3 = false;
        ((IrMemberAccessExpression)$this$mapRuntimeEnumEntry_u24lambda_u2d2).setDispatchReceiver(subject);
        return (IrExpression)object;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter(irFile, "irFile");
        this.visitFile(irFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public IrExpression visitBlock(@NotNull IrBlock expression2) {
        IrClass irClass2;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        if (!Intrinsics.areEqual(expression2.getOrigin(), IrStatementOrigin.WHEN.INSTANCE)) {
            return super.visitBlock(expression2);
        }
        if (expression2.getStatements().size() != 2) {
            return super.visitBlock(expression2);
        }
        IrStatement subject = expression2.getStatements().get(0);
        if (!(subject instanceof IrVariable) || ((irClass2 = IrTypesKt.getClass(((IrVariable)subject).getType())) == null ? null : irClass2.getKind()) != ClassKind.ENUM_CLASS) {
            return super.visitBlock(expression2);
        }
        Lazy subjectOrdinalProvider2 = LazyKt.lazy((Function0)new Function0<IrVariable>(this, subject, expression2){
            final /* synthetic */ EnumWhenLowering this$0;
            final /* synthetic */ IrStatement $subject;
            final /* synthetic */ IrBlock $expression;
            {
                this.this$0 = $receiver;
                this.$subject = $subject;
                this.$expression = $expression;
                super(0);
            }

            @NotNull
            public final IrVariable invoke() {
                BackendContext backendContext = this.this$0.getContext();
                Object object = EnumWhenLowering.access$getCurrentScope(this.this$0);
                Intrinsics.checkNotNull(object);
                object = LowerUtilsKt.createIrBuilder(backendContext, ((ScopeWithIr)object).getScope().getScopeOwnerSymbol(), this.$subject.getStartOffset(), this.$subject.getEndOffset());
                IrStatement irStatement = this.$subject;
                EnumWhenLowering enumWhenLowering = this.this$0;
                IrBlock irBlock = this.$expression;
                boolean bl = false;
                boolean bl2 = false;
                Object $this$invoke_u24lambda_u2d1 = object;
                boolean bl3 = false;
                IrExpression integer = IrTypeUtilsKt.isNullable(((IrVariable)irStatement).getType()) ? (IrExpression)ExpressionHelpersKt.irIfNull((IrBuilderWithScope)$this$invoke_u24lambda_u2d1, ((IrBuilder)$this$invoke_u24lambda_u2d1).getContext().getIrBuiltIns().getIntType(), ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$invoke_u24lambda_u2d1, (IrValueDeclaration)irStatement), ExpressionHelpersKt.irInt$default((IrBuilderWithScope)$this$invoke_u24lambda_u2d1, -1, null, 2, null), enumWhenLowering.mapRuntimeEnumEntry((IrBuilderWithScope)$this$invoke_u24lambda_u2d1, ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$invoke_u24lambda_u2d1, (IrValueDeclaration)irStatement))) : enumWhenLowering.mapRuntimeEnumEntry((IrBuilderWithScope)$this$invoke_u24lambda_u2d1, ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$invoke_u24lambda_u2d1, (IrValueDeclaration)irStatement));
                IrVariable irVariable2 = Scope.createTemporaryVariable$default(((IrBuilderWithScope)$this$invoke_u24lambda_u2d1).getScope(), integer, null, false, null, null, 30, null);
                boolean bl4 = false;
                boolean bl5 = false;
                IrVariable it = irVariable2;
                boolean bl6 = false;
                irBlock.getStatements().add(1, it);
                return irVariable2;
            }
        });
        UtilsKt.push(this.subjectWithOrdinalStack, new Pair(subject, subjectOrdinalProvider2));
        try {
            IrElementTransformerVoidKt.transformChildrenVoid(expression2.getStatements().get(1), this);
        }
        finally {
            UtilsKt.pop(this.subjectWithOrdinalStack);
        }
        return expression2;
    }

    @Override
    @NotNull
    public IrExpression visitCall(@NotNull IrCall expression2) {
        int n;
        IrClassifierSymbol irClassifierSymbol;
        IrExpression irExpression;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        if (!Intrinsics.areEqual(expression2.getSymbol(), this.context.getIrBuiltIns().getEqeqSymbol())) {
            return super.visitCall(expression2);
        }
        IrExpression irExpression2 = expression2.getValueArgument(0);
        Intrinsics.checkNotNull(irExpression2);
        IrExpression lhs = irExpression2;
        Object object = expression2.getValueArgument(1);
        Intrinsics.checkNotNull(object);
        IrExpression rhs = object;
        Pair<IrVariable, Lazy<IrVariable>> pair = UtilsKt.peek(this.subjectWithOrdinalStack);
        if (pair == null) {
            return super.visitCall(expression2);
        }
        object = pair;
        IrVariable topmostSubject = (IrVariable)((Pair)object).component1();
        Lazy topmostOrdinalProvider = (Lazy)((Pair)object).component2();
        if (lhs instanceof IrGetValue && Intrinsics.areEqual(((IrGetValue)lhs).getSymbol().getOwner(), topmostSubject)) {
            irExpression = rhs;
        } else if (rhs instanceof IrGetValue && Intrinsics.areEqual(((IrGetValue)rhs).getSymbol().getOwner(), topmostSubject)) {
            irExpression = lhs;
        } else {
            return super.visitCall(expression2);
        }
        IrExpression other = irExpression;
        if (other instanceof IrGetEnumValue && Intrinsics.areEqual((irClassifierSymbol = IrTypesKt.getClassifierOrNull(topmostSubject.getType())) == null ? null : irClassifierSymbol.getOwner(), ((IrEnumEntry)((IrGetEnumValue)other).getSymbol().getOwner()).getParent())) {
            n = this.mapConstEnumEntry((IrEnumEntry)((IrGetEnumValue)other).getSymbol().getOwner());
        } else if (IrUtilsKt.isNullConst(other)) {
            n = -1;
        } else {
            return super.visitCall(expression2);
        }
        int entryOrdinal = n;
        IrVariable subjectOrdinal = (IrVariable)topmostOrdinalProvider.getValue();
        IrCallImpl irCallImpl = new IrCallImpl(expression2.getStartOffset(), expression2.getEndOffset(), expression2.getType(), expression2.getSymbol(), 0, 2, null, null, 192, null);
        boolean bl = false;
        boolean bl2 = false;
        IrCallImpl $this$visitCall_u24lambda_u2d3 = irCallImpl;
        boolean bl3 = false;
        $this$visitCall_u24lambda_u2d3.putValueArgument(0, new IrGetValueImpl(lhs.getStartOffset(), lhs.getEndOffset(), subjectOrdinal.getType(), subjectOrdinal.getSymbol(), null, 16, null));
        $this$visitCall_u24lambda_u2d3.putValueArgument(1, IrConstImpl.Companion.int(rhs.getStartOffset(), rhs.getEndOffset(), this.getContext().getIrBuiltIns().getIntType(), entryOrdinal));
        return irCallImpl;
    }

    public static final /* synthetic */ ScopeWithIr access$getCurrentScope(EnumWhenLowering $this) {
        return $this.getCurrentScope();
    }
}

