/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.codegen;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.backend.jvm.codegen.IrTypeMapper;
import org.jetbrains.kotlin.backend.jvm.intrinsics.SignatureString;
import org.jetbrains.kotlin.backend.jvm.lower.FunctionReferenceLowering;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.inline.ReifiedTypeInliner;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.descriptors.IrBasedDescriptorsKt;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.model.TypeParameterMarker;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J0\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0015\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u0018\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010\u001b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u0002H\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001c\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/codegen/IrInlineIntrinsicsSupport;", "Lorg/jetbrains/kotlin/codegen/inline/ReifiedTypeInliner$IntrinsicsSupport;", "Lorg/jetbrains/kotlin/ir/types/IrType;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "typeMapper", "Lorg/jetbrains/kotlin/backend/jvm/codegen/IrTypeMapper;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;Lorg/jetbrains/kotlin/backend/jvm/codegen/IrTypeMapper;)V", "generateCallableReference", "", "v", "Lorg/jetbrains/org/objectweb/asm/commons/InstructionAdapter;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationWithName;", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "implClass", "Lorg/jetbrains/org/objectweb/asm/Type;", "withArity", "", "generateFunctionReference", "generatePropertyReference", "property", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "generateTypeParameterContainer", "typeParameter", "Lorg/jetbrains/kotlin/types/model/TypeParameterMarker;", "putClassInstance", "type", "toKotlinType", "Lorg/jetbrains/kotlin/types/KotlinType;", "backend.jvm"})
public final class IrInlineIntrinsicsSupport
implements ReifiedTypeInliner.IntrinsicsSupport<IrType> {
    @NotNull
    private final JvmBackendContext context;
    @NotNull
    private final IrTypeMapper typeMapper;

    public IrInlineIntrinsicsSupport(@NotNull JvmBackendContext context2, @NotNull IrTypeMapper typeMapper2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(typeMapper2, "typeMapper");
        this.context = context2;
        this.typeMapper = typeMapper2;
    }

    @Override
    public void putClassInstance(@NotNull InstructionAdapter v, @NotNull IrType type2) {
        Intrinsics.checkNotNullParameter(v, "v");
        Intrinsics.checkNotNullParameter(type2, "type");
        ExpressionCodegen.Companion.generateClassInstance$backend_jvm(v, type2, this.typeMapper);
    }

    @Override
    public void generateTypeParameterContainer(@NotNull InstructionAdapter v, @NotNull TypeParameterMarker typeParameter) {
        Intrinsics.checkNotNullParameter(v, "v");
        Intrinsics.checkNotNullParameter(typeParameter, "typeParameter");
        boolean bl = typeParameter instanceof IrTypeParameterSymbol;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string2 = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        IrDeclarationParent parent2 = ((IrTypeParameter)((IrTypeParameterSymbol)typeParameter).getOwner()).getParent();
        if (parent2 instanceof IrClass) {
            this.putClassInstance(v, IrUtilsKt.getDefaultType((IrClass)parent2));
            Unit unit = Unit.INSTANCE;
            bl3 = false;
            bl4 = false;
            Unit it = unit;
            boolean bl6 = false;
            AsmUtil.wrapJavaClassIntoKClass(v);
        } else if (parent2 instanceof IrSimpleFunction) {
            bl2 = this.context.getState().getGenerateOptimizedCallableReferenceSuperClasses();
            bl3 = false;
            bl4 = false;
            if (!bl2) {
                boolean bl7 = false;
                String string3 = Intrinsics.stringPlus("typeOf() of a non-reified type parameter is only allowed if optimized callable references are enabled.\nPlease make sure API version is set to 1.4, and -Xno-optimized-callable-references is NOT used.\nContainer: ", parent2);
                throw (Throwable)new IllegalStateException(string3.toString());
            }
            IrPropertySymbol property2 = ((IrSimpleFunction)parent2).getCorrespondingPropertySymbol();
            if (property2 != null) {
                this.generatePropertyReference(v, (IrProperty)property2.getOwner());
            } else {
                this.generateFunctionReference(v, (IrFunction)parent2);
            }
        } else {
            String string4 = "Unknown parent of type parameter: " + RenderIrElementKt.render(parent2) + ' ' + ((IrTypeParameter)((IrTypeParameterSymbol)typeParameter).getOwner()).getName() + ')';
            bl3 = false;
            throw (Throwable)new IllegalStateException(string4.toString());
        }
    }

    private final void generateFunctionReference(InstructionAdapter v, IrFunction function2) {
        IrDeclarationWithName irDeclarationWithName = function2;
        Type type2 = AsmTypes.FUNCTION_REFERENCE_IMPL;
        Intrinsics.checkNotNullExpressionValue(type2, "FUNCTION_REFERENCE_IMPL");
        this.generateCallableReference(v, irDeclarationWithName, function2, type2, true);
    }

    private final void generatePropertyReference(InstructionAdapter v, IrProperty property2) {
        IrSimpleFunction irSimpleFunction = property2.getGetter();
        if (irSimpleFunction == null) {
            String string2 = Intrinsics.stringPlus("Property without getter: ", RenderIrElementKt.render(property2));
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        IrSimpleFunction getter2 = irSimpleFunction;
        int arity = org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.getAllParametersCount(getter2);
        Object object = property2.isVar() ? AsmTypes.MUTABLE_PROPERTY_REFERENCE_IMPL : AsmTypes.PROPERTY_REFERENCE_IMPL;
        Intrinsics.checkNotNullExpressionValue(object, "if (property.isVar) MUTA\u2026e PROPERTY_REFERENCE_IMPL");
        Type type2 = (Type)ArraysKt.getOrNull((Object[])object, arity);
        if (type2 == null) {
            object = "No property reference impl class with arity " + arity + " (" + RenderIrElementKt.render(property2);
            boolean bl = false;
            throw (Throwable)new IllegalStateException(object.toString());
        }
        Type implClass = type2;
        this.generateCallableReference(v, property2, getter2, implClass, false);
    }

    private final void generateCallableReference(InstructionAdapter v, IrDeclarationWithName declaration2, IrFunction function2, Type implClass, boolean withArity) {
        v.anew(implClass);
        v.dup();
        if (withArity) {
            v.iconst(org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.getAllParametersCount(function2));
        }
        this.putClassInstance(v, FunctionReferenceLowering.Companion.getOwnerKClassType$backend_jvm(declaration2.getParent(), this.context));
        v.aconst(declaration2.getName().asString());
        SignatureString.INSTANCE.generateSignatureString$backend_jvm(v, function2, this.context);
        v.iconst(FunctionReferenceLowering.Companion.getCallableReferenceTopLevelFlag$backend_jvm(declaration2));
        Type[] typeArray = new Type[]{AsmTypes.JAVA_CLASS_TYPE, AsmTypes.JAVA_STRING_TYPE, AsmTypes.JAVA_STRING_TYPE, Type.INT_TYPE};
        List parameterTypes = CollectionsKt.plus((Collection)(withArity ? CollectionsKt.listOf(Type.INT_TYPE) : CollectionsKt.emptyList()), (Iterable)CollectionsKt.listOf(typeArray));
        Collection $this$toTypedArray$iv = parameterTypes;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Type[] typeArray2 = thisCollection$iv.toArray(new Type[0]);
        if (typeArray2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        typeArray = typeArray2;
        v.invokespecial(implClass.getInternalName(), "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, Arrays.copyOf(typeArray, typeArray.length)), false);
    }

    @Override
    @NotNull
    public KotlinType toKotlinType(@NotNull IrType type2) {
        Intrinsics.checkNotNullParameter(type2, "type");
        return IrBasedDescriptorsKt.toIrBasedKotlinType(type2);
    }
}

