/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.lower.InnerClassesSupport;
import org.jetbrains.kotlin.backend.jvm.JvmLoweredDeclarationOrigin;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrFieldBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrValueParameterBuilder;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.load.java.JavaDescriptorVisibilities;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0007H\u0002J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0007H\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0011\u001a\u00020\tH\u0016J\u0010\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\tH\u0016R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/JvmInnerClassesSupport;", "Lorg/jetbrains/kotlin/backend/common/lower/InnerClassesSupport;", "irFactory", "Lorg/jetbrains/kotlin/ir/declarations/IrFactory;", "(Lorg/jetbrains/kotlin/ir/declarations/IrFactory;)V", "innerClassConstructors", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "originalInnerClassPrimaryConstructorByClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "outerThisDeclarations", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "createInnerClassConstructorWithOuterThisParameter", "oldConstructor", "getInnerClassConstructorWithOuterThisParameter", "innerClassConstructor", "getInnerClassOriginalPrimaryConstructorOrNull", "innerClass", "getOuterThisField", "backend.jvm"})
public final class JvmInnerClassesSupport
implements InnerClassesSupport {
    @NotNull
    private final IrFactory irFactory;
    @NotNull
    private final ConcurrentHashMap<IrClass, IrField> outerThisDeclarations;
    @NotNull
    private final ConcurrentHashMap<IrConstructor, IrConstructor> innerClassConstructors;
    @NotNull
    private final ConcurrentHashMap<IrClass, IrConstructor> originalInnerClassPrimaryConstructorByClass;

    public JvmInnerClassesSupport(@NotNull IrFactory irFactory) {
        Intrinsics.checkNotNullParameter(irFactory, "irFactory");
        this.irFactory = irFactory;
        this.outerThisDeclarations = new ConcurrentHashMap();
        this.innerClassConstructors = new ConcurrentHashMap();
        this.originalInnerClassPrimaryConstructorByClass = new ConcurrentHashMap();
    }

    @Override
    @NotNull
    public IrField getOuterThisField(@NotNull IrClass innerClass) {
        Intrinsics.checkNotNullParameter(innerClass, "innerClass");
        ConcurrentMap $this$getOrPut$iv = this.outerThisDeclarations;
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(innerClass);
        if (object == null) {
            boolean bl = false;
            boolean bl2 = innerClass.isInner();
            boolean bl3 = false;
            if (_Assertions.ENABLED && !bl2) {
                boolean bl4 = false;
                String string2 = Intrinsics.stringPlus("Class is not inner: ", DumpIrTreeKt.dump$default(innerClass, false, false, 3, null));
                throw (Throwable)((Object)new AssertionError((Object)string2));
            }
            IrFactory $this$buildField$iv = this.irFactory;
            boolean $i$f$buildField = false;
            IrFieldBuilder irFieldBuilder = new IrFieldBuilder();
            boolean bl5 = false;
            boolean bl6 = false;
            IrFieldBuilder $this$buildField_u24lambda_u2d4$iv = irFieldBuilder;
            boolean bl7 = false;
            IrFieldBuilder $this$getOuterThisField_u24lambda_u2d3_u24lambda_u2d1 = $this$buildField_u24lambda_u2d4$iv;
            boolean bl8 = false;
            Object object2 = Name.identifier("this$0");
            Intrinsics.checkNotNullExpressionValue(object2, "identifier(\"this$0\")");
            $this$getOuterThisField_u24lambda_u2d3_u24lambda_u2d1.setName((Name)object2);
            $this$getOuterThisField_u24lambda_u2d3_u24lambda_u2d1.setType(IrUtilsKt.getDefaultType(IrUtilsKt.getParentAsClass(innerClass)));
            $this$getOuterThisField_u24lambda_u2d3_u24lambda_u2d1.setOrigin(IrDeclarationOrigin.FIELD_FOR_OUTER_THIS.INSTANCE);
            object2 = JavaDescriptorVisibilities.PACKAGE_VISIBILITY;
            Intrinsics.checkNotNullExpressionValue(object2, "PACKAGE_VISIBILITY");
            $this$getOuterThisField_u24lambda_u2d3_u24lambda_u2d1.setVisibility((DescriptorVisibility)object2);
            $this$getOuterThisField_u24lambda_u2d3_u24lambda_u2d1.setFinal(true);
            IrField irField = DeclarationBuildersKt.buildField($this$buildField$iv, $this$buildField_u24lambda_u2d4$iv);
            bl3 = false;
            boolean bl9 = false;
            IrField $this$getOuterThisField_u24lambda_u2d3_u24lambda_u2d2 = irField;
            boolean bl10 = false;
            $this$getOuterThisField_u24lambda_u2d3_u24lambda_u2d2.setParent(innerClass);
            IrField irField2 = irField;
            boolean bl11 = false;
            boolean bl12 = false;
            IrField default$iv = irField2;
            boolean bl13 = false;
            object = $this$getOrPut$iv.putIfAbsent(innerClass, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        Object v = object;
        Intrinsics.checkNotNullExpressionValue(v, "outerThisDeclarations.ge\u2026s\n            }\n        }");
        return (IrField)v;
    }

    @Override
    @NotNull
    public IrConstructor getInnerClassConstructorWithOuterThisParameter(@NotNull IrConstructor innerClassConstructor) {
        Intrinsics.checkNotNullParameter(innerClassConstructor, "innerClassConstructor");
        IrClass innerClass = (IrClass)innerClassConstructor.getParent();
        boolean bl = innerClass.isInner();
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-JvmInnerClassesSupport$getInnerClassConstructorWithOuterThisParameter$22 = false;
            String $i$a$-assert-JvmInnerClassesSupport$getInnerClassConstructorWithOuterThisParameter$22 = Intrinsics.stringPlus("Class is not inner: ", DumpIrTreeKt.dump$default((IrClass)innerClassConstructor.getParent(), false, false, 3, null));
            throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-JvmInnerClassesSupport$getInnerClassConstructorWithOuterThisParameter$22));
        }
        ConcurrentMap $this$getOrPut$iv = this.innerClassConstructors;
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(innerClassConstructor);
        if (object == null) {
            boolean bl3 = false;
            IrConstructor irConstructor2 = this.createInnerClassConstructorWithOuterThisParameter(innerClassConstructor);
            boolean bl4 = false;
            boolean bl5 = false;
            IrConstructor default$iv = irConstructor2;
            boolean bl6 = false;
            object = $this$getOrPut$iv.putIfAbsent(innerClassConstructor, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        Object v = object;
        boolean bl7 = false;
        boolean bl8 = false;
        IrConstructor it = (IrConstructor)v;
        boolean bl9 = false;
        if (innerClassConstructor.isPrimary()) {
            Map map = this.originalInnerClassPrimaryConstructorByClass;
            boolean bl10 = false;
            map.put(innerClass, innerClassConstructor);
        }
        Object v2 = v;
        Intrinsics.checkNotNullExpressionValue(v2, "innerClassConstructors.g\u2026r\n            }\n        }");
        return (IrConstructor)v2;
    }

    @Override
    @Nullable
    public IrConstructor getInnerClassOriginalPrimaryConstructorOrNull(@NotNull IrClass innerClass) {
        Intrinsics.checkNotNullParameter(innerClass, "innerClass");
        boolean bl = innerClass.isInner();
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = Intrinsics.stringPlus("Class is not inner: ", innerClass);
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        return this.originalInnerClassPrimaryConstructorByClass.get(innerClass);
    }

    /*
     * WARNING - void declaration
     */
    private final IrConstructor createInnerClassConstructorWithOuterThisParameter(IrConstructor oldConstructor) {
        Collection<IrValueParameter> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        IrFactory $this$buildConstructor$iv = this.irFactory;
        boolean $i$f$buildConstructor = false;
        IrFunctionBuilder irFunctionBuilder = new IrFunctionBuilder();
        boolean bl = false;
        boolean bl2 = false;
        IrFunctionBuilder $this$buildConstructor_u24lambda_u2d18$iv = irFunctionBuilder;
        boolean $i$a$-run-DeclarationBuildersKt$buildConstructor$2$iv22 = false;
        IrFunctionBuilder $this$createInnerClassConstructorWithOuterThisParameter_u24lambda_u2d1022 = $this$buildConstructor_u24lambda_u2d18$iv;
        boolean bl3 = false;
        $this$createInnerClassConstructorWithOuterThisParameter_u24lambda_u2d1022.updateFrom(oldConstructor);
        $this$createInnerClassConstructorWithOuterThisParameter_u24lambda_u2d1022.setReturnType(oldConstructor.getReturnType());
        IrConstructor irConstructor2 = DeclarationBuildersKt.buildConstructor($this$buildConstructor$iv, $this$buildConstructor_u24lambda_u2d18$iv);
        boolean bl4 = false;
        boolean bl5 = false;
        IrConstructor $this$createInnerClassConstructorWithOuterThisParameter_u24lambda_u2d11 = irConstructor2;
        boolean bl6 = false;
        $this$createInnerClassConstructorWithOuterThisParameter_u24lambda_u2d11.setParent(oldConstructor.getParent());
        $this$createInnerClassConstructorWithOuterThisParameter_u24lambda_u2d11.setReturnType(oldConstructor.getReturnType());
        org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.copyAnnotationsFrom($this$createInnerClassConstructorWithOuterThisParameter_u24lambda_u2d11, oldConstructor);
        org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.copyTypeParametersFrom$default($this$createInnerClassConstructorWithOuterThisParameter_u24lambda_u2d11, oldConstructor, null, null, 6, null);
        boolean $i$f$buildValueParameter22 = false;
        IrValueParameterBuilder $i$a$-run-DeclarationBuildersKt$buildConstructor$2$iv22 = new IrValueParameterBuilder();
        boolean $this$createInnerClassConstructorWithOuterThisParameter_u24lambda_u2d1022 = false;
        bl3 = false;
        IrValueParameterBuilder $this$buildValueParameter_u24lambda_u2d24$iv = $i$a$-run-DeclarationBuildersKt$buildConstructor$2$iv22;
        boolean bl7 = false;
        IrValueParameterBuilder $this$createInnerClassConstructorWithOuterThisParameter_u24lambda_u2d11_u24lambda_u2d9 = $this$buildValueParameter_u24lambda_u2d24$iv;
        boolean bl82 = false;
        $this$createInnerClassConstructorWithOuterThisParameter_u24lambda_u2d11_u24lambda_u2d9.setOrigin(JvmLoweredDeclarationOrigin.FIELD_FOR_OUTER_THIS.INSTANCE);
        Name name = Name.identifier("this$0");
        Intrinsics.checkNotNullExpressionValue(name, "identifier(AsmUtil.CAPTURED_THIS_FIELD)");
        $this$createInnerClassConstructorWithOuterThisParameter_u24lambda_u2d11_u24lambda_u2d9.setName(name);
        $this$createInnerClassConstructorWithOuterThisParameter_u24lambda_u2d11_u24lambda_u2d9.setIndex(0);
        $this$createInnerClassConstructorWithOuterThisParameter_u24lambda_u2d11_u24lambda_u2d9.setType(IrUtilsKt.getDefaultType(IrUtilsKt.getParentAsClass(IrUtilsKt.getParentAsClass(oldConstructor))));
        IrValueParameter outerThisValueParameter = DeclarationBuildersKt.buildValueParameter(((IrDeclaration)$this$createInnerClassConstructorWithOuterThisParameter_u24lambda_u2d11).getFactory(), $this$buildValueParameter_u24lambda_u2d24$iv, (IrDeclarationParent)((Object)((IrDeclaration)$this$createInnerClassConstructorWithOuterThisParameter_u24lambda_u2d11)));
        Iterable $i$f$buildValueParameter22 = oldConstructor.getValueParameters();
        Collection collection2 = CollectionsKt.listOf(outerThisValueParameter);
        IrConstructor irConstructor3 = $this$createInnerClassConstructorWithOuterThisParameter_u24lambda_u2d11;
        boolean $i$f$map = false;
        void $this$createInnerClassConstructorWithOuterThisParameter_u24lambda_u2d1022 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrValueParameter bl82 = (IrValueParameter)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl9 = false;
            IrValueParameter irValueParameter = org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.copyTo$default((IrValueParameter)it, $this$createInnerClassConstructorWithOuterThisParameter_u24lambda_u2d11, null, it.getIndex() + 1, 0, 0, null, null, null, null, null, false, false, false, 8186, null);
            collection.add(irValueParameter);
        }
        collection = (List)destination$iv$iv;
        irConstructor3.setValueParameters(CollectionsKt.plus(collection2, (Iterable)collection));
        $this$createInnerClassConstructorWithOuterThisParameter_u24lambda_u2d11.setMetadata(oldConstructor.getMetadata());
        return irConstructor2;
    }
}

