/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.type;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import org.jetbrains.kotlin.fir.FirAnnotationContainer;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.analysis.checkers.FirAnnotationHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.type.FirTypeChecker;
import org.jetbrains.kotlin.fir.analysis.collectors.AbstractDiagnosticCollector;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.types.FirTypeRef;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/type/FirTypeAnnotationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/type/FirTypeChecker;", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/type/FirTypeRefChecker;", "()V", "check", "", "typeRef", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "checkers"})
public final class FirTypeAnnotationChecker
extends FirTypeChecker<FirTypeRef> {
    @NotNull
    public static final FirTypeAnnotationChecker INSTANCE = new FirTypeAnnotationChecker();

    private FirTypeAnnotationChecker() {
    }

    @Override
    public void check(@NotNull FirTypeRef typeRef, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(typeRef, "typeRef");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        for (FirAnnotationCall annotation2 : typeRef.getAnnotations()) {
            AnnotationUseSiteTarget useSiteTarget;
            Set<KotlinTarget> annotationTargets;
            boolean bl;
            CheckerContext it;
            List<String> list2;
            FirAnnotationContainer firAnnotationContainer;
            boolean $i$f$withSuppressedDiagnostics = false;
            FirAnnotationContainer firAnnotationContainer2 = firAnnotationContainer = (FirElement)annotation2 instanceof FirAnnotationContainer ? (FirAnnotationContainer)((FirElement)annotation2) : null;
            if (firAnnotationContainer == null) {
                list2 = null;
            } else {
                FirAnnotationContainer firAnnotationContainer3 = firAnnotationContainer;
                boolean bl2 = false;
                boolean bl3 = false;
                FirAnnotationContainer it$iv = firAnnotationContainer3;
                boolean bl4 = false;
                list2 = AbstractDiagnosticCollector.Companion.getDiagnosticsSuppressedForContainer(it$iv);
            }
            List<String> arguments$iv = list2;
            if (arguments$iv != null) {
                it = context2.addSuppressedDiagnostics((Collection<String>)arguments$iv, arguments$iv.contains("infos"), arguments$iv.contains("warnings"), arguments$iv.contains("errors"));
                bl = false;
                annotationTargets = FirAnnotationHelpersKt.getAllowedAnnotationTargets(annotation2, context2.getSession());
                if (annotationTargets.contains((Object)KotlinTarget.TYPE) || (useSiteTarget = annotation2.getUseSiteTarget()) != null && CollectionsKt.contains((Iterable)annotationTargets, KotlinTarget.Companion.getUSE_SITE_MAPPING().get((Object)useSiteTarget))) continue;
                DiagnosticReporterKt.reportOn$default(reporter, annotation2.getSource(), FirErrors.INSTANCE.getWRONG_ANNOTATION_TARGET(), "type usage", context2, null, 16, null);
                continue;
            }
            it = context2;
            bl = false;
            annotationTargets = FirAnnotationHelpersKt.getAllowedAnnotationTargets(annotation2, context2.getSession());
            if (annotationTargets.contains((Object)KotlinTarget.TYPE) || (useSiteTarget = annotation2.getUseSiteTarget()) != null && CollectionsKt.contains((Iterable)annotationTargets, KotlinTarget.Companion.getUSE_SITE_MAPPING().get((Object)useSiteTarget))) continue;
            DiagnosticReporterKt.reportOn$default(reporter, annotation2.getSource(), FirErrors.INSTANCE.getWRONG_ANNOTATION_TARGET(), "type usage", context2, null, 16, null);
        }
    }
}

