/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.types;

import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.types.ConeFlexibleTypeBoundsChecker;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeContext;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.types.model.TypeSystemContextHelpersKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fR\u0019\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/fir/types/CapturedArguments;", "", "capturedArguments", "", "Lorg/jetbrains/kotlin/fir/types/ConeTypeProjection;", "originalType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "([Lorg/jetbrains/kotlin/fir/types/ConeTypeProjection;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;)V", "getCapturedArguments", "()[Lorg/jetbrains/kotlin/fir/types/ConeTypeProjection;", "[Lorg/jetbrains/kotlin/fir/types/ConeTypeProjection;", "isSuitableForType", "", "type", "context", "Lorg/jetbrains/kotlin/fir/types/ConeTypeContext;", "resolve"})
final class CapturedArguments {
    @NotNull
    private final ConeTypeProjection[] capturedArguments;
    @NotNull
    private final ConeKotlinType originalType;

    public CapturedArguments(@NotNull ConeTypeProjection[] capturedArguments, @NotNull ConeKotlinType originalType) {
        Intrinsics.checkNotNullParameter(capturedArguments, "capturedArguments");
        Intrinsics.checkNotNullParameter(originalType, "originalType");
        this.capturedArguments = capturedArguments;
        this.originalType = originalType;
    }

    @NotNull
    public final ConeTypeProjection[] getCapturedArguments() {
        return this.capturedArguments;
    }

    public final boolean isSuitableForType(@NotNull ConeKotlinType type2, @NotNull ConeTypeContext context2) {
        boolean areConstructorsMatched;
        boolean areArgumentsMatched;
        block4: {
            boolean bl;
            Intrinsics.checkNotNullParameter(type2, "type");
            Intrinsics.checkNotNullParameter(context2, "context");
            Iterable<IndexedValue<ConeTypeProjection>> $this$all$iv = ArraysKt.withIndex(type2.getTypeArguments());
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                Iterator<IndexedValue<ConeTypeProjection>> iterator2 = $this$all$iv.iterator();
                while (iterator2.hasNext()) {
                    IndexedValue<ConeTypeProjection> element$iv;
                    IndexedValue<ConeTypeProjection> $dstr$i$typeArgumentsType = element$iv = iterator2.next();
                    boolean bl2 = false;
                    int i = $dstr$i$typeArgumentsType.component1();
                    ConeTypeProjection typeArgumentsType = $dstr$i$typeArgumentsType.component2();
                    if (this.originalType.getTypeArguments().length > i && Intrinsics.areEqual(typeArgumentsType, this.originalType.getTypeArguments()[i])) continue;
                    bl = false;
                    break block4;
                }
                bl = areArgumentsMatched = true;
            }
        }
        if (!areArgumentsMatched) {
            return false;
        }
        boolean bl = areConstructorsMatched = Intrinsics.areEqual(TypeSystemContextHelpersKt.typeConstructor(this.originalType, context2), TypeSystemContextHelpersKt.typeConstructor(type2, context2)) || ConeFlexibleTypeBoundsChecker.INSTANCE.areTypesMayBeLowerAndUpperBoundsOfSameFlexibleTypeByMutability(this.originalType, type2);
        return areConstructorsMatched;
    }
}

