/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter;

import java.lang.invoke.MethodType;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.builtins.UnsignedType;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrFileKt;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrErrorExpressionImpl;
import org.jetbrains.kotlin.ir.interpreter.CallInterceptor;
import org.jetbrains.kotlin.ir.interpreter.IrInterpreterEnvironment;
import org.jetbrains.kotlin.ir.interpreter.UtilsKt;
import org.jetbrains.kotlin.ir.interpreter.proxy.Proxy;
import org.jetbrains.kotlin.ir.interpreter.proxy.ProxyKt;
import org.jetbrains.kotlin.ir.interpreter.state.Complex;
import org.jetbrains.kotlin.ir.interpreter.state.ExceptionState;
import org.jetbrains.kotlin.ir.interpreter.state.Primitive;
import org.jetbrains.kotlin.ir.interpreter.state.State;
import org.jetbrains.kotlin.ir.interpreter.state.StateKt;
import org.jetbrains.kotlin.ir.interpreter.state.Wrapper;
import org.jetbrains.kotlin.ir.interpreter.state.reflection.KTypeState;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueParameterSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.types.impl.IrSimpleTypeBuilder;
import org.jetbrains.kotlin.ir.types.impl.IrSimpleTypeImplKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.util.capitalizeDecapitalize.CapitalizeDecapitalizeKt;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\u00b0\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a \u0010\b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\rH\u0000\u001a\"\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0013H\u0080\b\u00f8\u0001\u0000\u001a\f\u0010\u0014\u001a\u00020\r*\u00020\u0015H\u0000\u001a\u0016\u0010\u0016\u001a\u00020\r*\u0004\u0018\u00010\u00172\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\u001a\u0012\u0010\u0018\u001a\u00020\u0019*\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0001\u001a2\u0010\u001c\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001e0\u001d*\u00020\u00172\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u001dH\u0000\u001a\f\u0010%\u001a\u00020&*\u00020\u0017H\u0000\u001a\u000e\u0010'\u001a\u0004\u0018\u00010(*\u00020\u0017H\u0000\u001a\u000e\u0010)\u001a\u0004\u0018\u00010&*\u00020\u001aH\u0000\u001a\u000e\u0010*\u001a\u0004\u0018\u00010(*\u00020\u0017H\u0000\u001a\n\u0010+\u001a\u00020\u0017*\u00020\u0017\u001a\f\u0010,\u001a\u00020&*\u00020\u000bH\u0000\u001a\u000e\u0010-\u001a\u0004\u0018\u00010.*\u00020\u0017H\u0000\u001a\f\u0010/\u001a\u000200*\u000201H\u0000\u001a\u0014\u00102\u001a\u0004\u0018\u00010\u000b*\u0002012\u0006\u00103\u001a\u000204\u001a\u0014\u00105\u001a\u00020\u000f*\u0002062\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\u001a\u0014\u00107\u001a\u00020\r*\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u0001\u001a\f\u00108\u001a\u00020&*\u000209H\u0000\u001a\f\u0010:\u001a\u00020\r*\u00020\u000bH\u0000\u001a\f\u0010;\u001a\u00020\r*\u00020\u000bH\u0000\u001a\f\u0010<\u001a\u00020\r*\u00020\u000bH\u0000\u001a\f\u0010=\u001a\u00020\r*\u00020\u000bH\u0000\u001a\f\u0010>\u001a\u00020\r*\u00020\u000bH\u0000\u001a\f\u0010?\u001a\u00020\r*\u00020\u000bH\u0000\u001a\f\u0010@\u001a\u00020\r*\u00020\u000bH\u0000\u001a,\u0010A\u001a\u0006\u0012\u0002\b\u00030B*\u0004\u0018\u00010\u001e2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010C\u001a\u0002042\b\b\u0002\u0010D\u001a\u000204\u001a\u0014\u0010E\u001a\u00020F*\u00020$2\u0006\u0010G\u001a\u00020FH\u0000\u001a\u001e\u0010H\u001a\b\u0012\u0004\u0012\u0002HJ0I\"\u0004\b\u0000\u0010J*\b\u0012\u0004\u0012\u0002HJ0BH\u0000\u001a \u0010K\u001a\u0006\u0012\u0002\b\u00030I*\n\u0012\u0006\u0012\u0004\u0018\u00010\u001e0\u001d2\u0006\u0010L\u001a\u00020\u000bH\u0000\u001a\u0016\u0010M\u001a\u00020$*\u0004\u0018\u00010\u001e2\u0006\u0010\n\u001a\u00020\u000bH\u0000\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0003\"\u0011\u0010\u0006\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0003\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006N"}, d2={"compileTimeAnnotation", "Lorg/jetbrains/kotlin/name/FqName;", "getCompileTimeAnnotation", "()Lorg/jetbrains/kotlin/name/FqName;", "contractsDslAnnotation", "getContractsDslAnnotation", "evaluateIntrinsicAnnotation", "getEvaluateIntrinsicAnnotation", "getPrimitiveClass", "Ljava/lang/Class;", "irType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "asObject", "", "withExceptionHandler", "", "environment", "Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreterEnvironment;", "block", "Lkotlin/Function0;", "accessesTopLevelOrObjectField", "Lorg/jetbrains/kotlin/ir/expressions/IrFieldAccessExpression;", "checkCast", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "getAnnotation", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "Lorg/jetbrains/kotlin/ir/declarations/IrAnnotationContainer;", "annotation", "getArgsForMethodInvocation", "", "", "callInterceptor", "Lorg/jetbrains/kotlin/ir/interpreter/CallInterceptor;", "methodType", "Ljava/lang/invoke/MethodType;", "args", "Lorg/jetbrains/kotlin/ir/interpreter/state/State;", "getCapitalizedFileName", "", "getDispatchReceiver", "Lorg/jetbrains/kotlin/ir/symbols/IrValueParameterSymbol;", "getEvaluateIntrinsicValue", "getExtensionReceiver", "getLastOverridden", "getOnlyName", "getReceiver", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "getThisReceiver", "Lorg/jetbrains/kotlin/ir/symbols/IrValueSymbol;", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "getVarargType", "index", "", "handleUserException", "", "hasAnnotation", "internalName", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "isFunction", "isKFunction", "isPrimitiveArray", "isThrowable", "isTypeParameter", "isUnsigned", "isUnsignedArray", "toIrConst", "Lorg/jetbrains/kotlin/ir/expressions/IrConst;", "startOffset", "endOffset", "toIrExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "toPrimitive", "Lorg/jetbrains/kotlin/ir/interpreter/state/Primitive;", "T", "toPrimitiveStateArray", "type", "toState", "ir.interpreter"})
public final class UtilsKt {
    @NotNull
    private static final FqName compileTimeAnnotation = new FqName("kotlin.CompileTimeCalculation");
    @NotNull
    private static final FqName evaluateIntrinsicAnnotation = new FqName("kotlin.EvaluateIntrinsic");
    @NotNull
    private static final FqName contractsDslAnnotation = new FqName("kotlin.internal.ContractsDsl");

    @NotNull
    public static final FqName getCompileTimeAnnotation() {
        return compileTimeAnnotation;
    }

    @NotNull
    public static final FqName getEvaluateIntrinsicAnnotation() {
        return evaluateIntrinsicAnnotation;
    }

    @NotNull
    public static final FqName getContractsDslAnnotation() {
        return contractsDslAnnotation;
    }

    @Nullable
    public static final IrValueParameterSymbol getDispatchReceiver(@NotNull IrFunction $this$getDispatchReceiver) {
        Intrinsics.checkNotNullParameter($this$getDispatchReceiver, "<this>");
        IrValueParameter irValueParameter = $this$getDispatchReceiver.getDispatchReceiverParameter();
        return irValueParameter == null ? null : irValueParameter.getSymbol();
    }

    @Nullable
    public static final IrValueParameterSymbol getExtensionReceiver(@NotNull IrFunction $this$getExtensionReceiver) {
        Intrinsics.checkNotNullParameter($this$getExtensionReceiver, "<this>");
        IrValueParameter irValueParameter = $this$getExtensionReceiver.getExtensionReceiverParameter();
        return irValueParameter == null ? null : irValueParameter.getSymbol();
    }

    @Nullable
    public static final IrSymbol getReceiver(@NotNull IrFunction $this$getReceiver) {
        Intrinsics.checkNotNullParameter($this$getReceiver, "<this>");
        IrValueParameterSymbol irValueParameterSymbol = UtilsKt.getDispatchReceiver($this$getReceiver);
        return irValueParameterSymbol == null ? (IrSymbol)UtilsKt.getExtensionReceiver($this$getReceiver) : (IrSymbol)irValueParameterSymbol;
    }

    @NotNull
    public static final IrValueSymbol getThisReceiver(@NotNull IrFunctionAccessExpression $this$getThisReceiver) {
        Intrinsics.checkNotNullParameter($this$getThisReceiver, "<this>");
        IrValueParameter irValueParameter = IrUtilsKt.getParentAsClass(((IrFunctionSymbol)$this$getThisReceiver.getSymbol()).getOwner()).getThisReceiver();
        Intrinsics.checkNotNull(irValueParameter);
        return irValueParameter.getSymbol();
    }

    @NotNull
    public static final IrExpression toIrExpression(@NotNull State $this$toIrExpression, @NotNull IrExpression expression2) {
        IrExpression irExpression;
        Intrinsics.checkNotNullParameter($this$toIrExpression, "<this>");
        Intrinsics.checkNotNullParameter(expression2, "expression");
        int start = expression2.getStartOffset();
        int end = expression2.getEndOffset();
        IrType type2 = IrTypesKt.makeNotNull(expression2.getType());
        State state = $this$toIrExpression;
        if (state instanceof Primitive) {
            irExpression = ((Primitive)$this$toIrExpression).getValue() == null ? (IrExpression)UtilsKt.toIrConst(((Primitive)$this$toIrExpression).getValue(), type2, start, end) : (IrTypePredicatesKt.isPrimitiveType$default(type2, false, 1, null) || IrTypePredicatesKt.isString(type2) ? (IrExpression)UtilsKt.toIrConst(((Primitive)$this$toIrExpression).getValue(), type2, start, end) : expression2);
        } else if (state instanceof ExceptionState) {
            irExpression = new IrErrorExpressionImpl(expression2.getStartOffset(), expression2.getEndOffset(), expression2.getType(), Intrinsics.stringPlus("\n", ((ExceptionState)$this$toIrExpression).getFullDescription()));
        } else if (state instanceof Complex) {
            IrSimpleType stateType = IrUtilsKt.getDefaultType($this$toIrExpression.getIrClass());
            irExpression = IrTypePredicatesKt.isUnsignedType$default(stateType, false, 1, null) ? (IrExpression)UtilsKt.toIrConst(((Primitive)CollectionsKt.single($this$toIrExpression.getFields()).getState()).getValue(), type2, start, end) : expression2;
        } else {
            irExpression = expression2;
        }
        return irExpression;
    }

    @NotNull
    public static final State toState(@Nullable Object $this$toState, @NotNull IrType irType) {
        State state;
        Intrinsics.checkNotNullParameter(irType, "irType");
        Object object = $this$toState;
        if (object instanceof Proxy) {
            state = ((Proxy)$this$toState).getState();
        } else if (object instanceof State) {
            state = (State)$this$toState;
        } else if (((((((((((((((((object instanceof Boolean ? true : object instanceof Character) ? true : object instanceof Byte) ? true : object instanceof Short) ? true : object instanceof Integer) ? true : object instanceof Long) ? true : object instanceof String) ? true : object instanceof Float) ? true : object instanceof Double) ? true : object instanceof Object[]) ? true : object instanceof byte[]) ? true : object instanceof char[]) ? true : object instanceof short[]) ? true : object instanceof int[]) ? true : object instanceof long[]) ? true : object instanceof float[]) ? true : object instanceof double[]) ? true : object instanceof boolean[]) {
            state = new Primitive<Object>($this$toState, irType);
        } else if (object == null) {
            state = new Primitive<Object>($this$toState, irType);
        } else {
            Wrapper wrapper;
            IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(irType);
            if (irClassSymbol == null) {
                wrapper = null;
            } else {
                IrClass irClass2 = (IrClass)irClassSymbol.getOwner();
                if (irClass2 == null) {
                    wrapper = null;
                } else {
                    IrClass irClass3 = irClass2;
                    boolean bl = false;
                    boolean bl2 = false;
                    IrClass it = irClass3;
                    boolean bl3 = false;
                    wrapper = new Wrapper($this$toState, it);
                }
            }
            Wrapper wrapper2 = wrapper;
            state = wrapper2 == null ? new Wrapper($this$toState) : wrapper2;
        }
        return state;
    }

    @NotNull
    public static final IrConst<?> toIrConst(@Nullable Object $this$toIrConst, @NotNull IrType irType, int startOffset, int endOffset) {
        IrConst irConst;
        Intrinsics.checkNotNullParameter(irType, "irType");
        if ($this$toIrConst == null) {
            return IrConstImpl.Companion.constNull(startOffset, endOffset, irType);
        }
        IrType constType = IrTypesKt.makeNotNull(irType);
        PrimitiveType primitiveType = IrTypePredicatesKt.getPrimitiveType(irType);
        int n = primitiveType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[primitiveType.ordinal()];
        switch (n) {
            case 1: {
                irConst = IrConstImpl.Companion.boolean(startOffset, endOffset, constType, (Boolean)$this$toIrConst);
                break;
            }
            case 2: {
                irConst = IrConstImpl.Companion.char(startOffset, endOffset, constType, ((Character)$this$toIrConst).charValue());
                break;
            }
            case 3: {
                irConst = IrConstImpl.Companion.byte(startOffset, endOffset, constType, ((Number)$this$toIrConst).byteValue());
                break;
            }
            case 4: {
                irConst = IrConstImpl.Companion.short(startOffset, endOffset, constType, ((Number)$this$toIrConst).shortValue());
                break;
            }
            case 5: {
                irConst = IrConstImpl.Companion.int(startOffset, endOffset, constType, ((Number)$this$toIrConst).intValue());
                break;
            }
            case 6: {
                irConst = IrConstImpl.Companion.float(startOffset, endOffset, constType, ((Number)$this$toIrConst).floatValue());
                break;
            }
            case 7: {
                irConst = IrConstImpl.Companion.long(startOffset, endOffset, constType, ((Number)$this$toIrConst).longValue());
                break;
            }
            case 8: {
                irConst = IrConstImpl.Companion.double(startOffset, endOffset, constType, ((Number)$this$toIrConst).doubleValue());
                break;
            }
            case -1: {
                IrConstImpl<Object> irConstImpl;
                UnsignedType unsignedType = IrTypePredicatesKt.getUnsignedType(constType);
                int n2 = unsignedType == null ? -1 : WhenMappings.$EnumSwitchMapping$1[unsignedType.ordinal()];
                switch (n2) {
                    case 1: {
                        irConstImpl = IrConstImpl.Companion.byte(startOffset, endOffset, constType, ((Number)$this$toIrConst).byteValue());
                        break;
                    }
                    case 2: {
                        irConstImpl = IrConstImpl.Companion.short(startOffset, endOffset, constType, ((Number)$this$toIrConst).shortValue());
                        break;
                    }
                    case 3: {
                        irConstImpl = IrConstImpl.Companion.int(startOffset, endOffset, constType, ((Number)$this$toIrConst).intValue());
                        break;
                    }
                    case 4: {
                        irConstImpl = IrConstImpl.Companion.long(startOffset, endOffset, constType, ((Number)$this$toIrConst).longValue());
                        break;
                    }
                    case -1: {
                        if (IrTypePredicatesKt.isString(constType)) {
                            irConstImpl = IrConstImpl.Companion.string(startOffset, endOffset, constType, (String)$this$toIrConst);
                            break;
                        }
                        throw new UnsupportedOperationException(Intrinsics.stringPlus("Unsupported const element type ", RenderIrElementKt.render(constType)));
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                irConst = irConstImpl;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return irConst;
    }

    public static /* synthetic */ IrConst toIrConst$default(Object object, IrType irType, int n, int n2, int n3, Object object2) {
        if ((n3 & 2) != 0) {
            n = -1;
        }
        if ((n3 & 4) != 0) {
            n2 = -1;
        }
        return UtilsKt.toIrConst(object, irType, n, n2);
    }

    @NotNull
    public static final <T> Primitive<T> toPrimitive(@NotNull IrConst<T> $this$toPrimitive) {
        Primitive<Byte> primitive;
        Intrinsics.checkNotNullParameter($this$toPrimitive, "<this>");
        if (IrTypePredicatesKt.isByte($this$toPrimitive.getType())) {
            T t = $this$toPrimitive.getValue();
            if (t == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Number");
            }
            Primitive<Byte> primitive2 = new Primitive<Byte>(((Number)t).byteValue(), $this$toPrimitive.getType());
            primitive = primitive2;
        } else if (IrTypePredicatesKt.isShort($this$toPrimitive.getType())) {
            T t = $this$toPrimitive.getValue();
            if (t == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Number");
            }
            Primitive<Short> primitive3 = new Primitive<Short>(((Number)t).shortValue(), $this$toPrimitive.getType());
            primitive = primitive3;
        } else {
            primitive = new Primitive<T>($this$toPrimitive.getValue(), $this$toPrimitive.getType());
        }
        return primitive;
    }

    public static final boolean hasAnnotation(@Nullable IrAnnotationContainer $this$hasAnnotation, @NotNull FqName annotation2) {
        Intrinsics.checkNotNullParameter(annotation2, "annotation");
        Object object = $this$hasAnnotation;
        if (object == null) {
            return false;
        }
        object = $this$hasAnnotation.getAnnotations();
        boolean bl = false;
        if (!object.isEmpty()) {
            boolean bl2;
            block5: {
                Iterable $this$any$iv = $this$hasAnnotation.getAnnotations();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        IrConstructorCall it = (IrConstructorCall)element$iv;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual(IrUtilsKt.getFqNameWhenAvailable(IrUtilsKt.getParentAsClass((IrDeclaration)it.getSymbol().getOwner())), annotation2)) continue;
                        bl2 = true;
                        break block5;
                    }
                    bl2 = false;
                }
            }
            return bl2;
        }
        return false;
    }

    @NotNull
    public static final IrConstructorCall getAnnotation(@NotNull IrAnnotationContainer $this$getAnnotation, @NotNull FqName annotation2) {
        IrConstructorCall irConstructorCall;
        Object v0;
        IrConstructorCall it;
        block4: {
            Intrinsics.checkNotNullParameter($this$getAnnotation, "<this>");
            Intrinsics.checkNotNullParameter(annotation2, "annotation");
            Iterable $this$firstOrNull$iv = $this$getAnnotation.getAnnotations();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv2 : $this$firstOrNull$iv) {
                it = (IrConstructorCall)element$iv2;
                boolean bl = false;
                if (!Intrinsics.areEqual(IrUtilsKt.getFqNameWhenAvailable(IrUtilsKt.getParentAsClass((IrDeclaration)it.getSymbol().getOwner())), annotation2)) continue;
                v0 = element$iv2;
                break block4;
            }
            v0 = null;
        }
        IrConstructorCall irConstructorCall2 = v0;
        if (irConstructorCall2 == null) {
            Object element$iv2;
            block5: {
                Iterable $this$first$iv = ((IrClass)((IrFunction)$this$getAnnotation).getParent()).getAnnotations();
                boolean $i$f$first = false;
                for (Object element$iv2 : $this$first$iv) {
                    it = (IrConstructorCall)element$iv2;
                    boolean bl = false;
                    if (!Intrinsics.areEqual(IrUtilsKt.getFqNameWhenAvailable(IrUtilsKt.getParentAsClass((IrDeclaration)it.getSymbol().getOwner())), annotation2)) continue;
                    break block5;
                }
                throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            irConstructorCall = (IrConstructorCall)element$iv2;
        } else {
            irConstructorCall = irConstructorCall2;
        }
        return irConstructorCall;
    }

    @Nullable
    public static final String getEvaluateIntrinsicValue(@NotNull IrAnnotationContainer $this$getEvaluateIntrinsicValue) {
        Object object;
        Intrinsics.checkNotNullParameter($this$getEvaluateIntrinsicValue, "<this>");
        if ($this$getEvaluateIntrinsicValue instanceof IrClass && ((object = IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)$this$getEvaluateIntrinsicValue)) == null ? false : ((FqName)object).startsWith(Name.identifier("java")))) {
            object = IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)$this$getEvaluateIntrinsicValue);
            return object == null ? null : ((FqName)object).asString();
        }
        if (!UtilsKt.hasAnnotation($this$getEvaluateIntrinsicValue, evaluateIntrinsicAnnotation)) {
            return null;
        }
        object = UtilsKt.getAnnotation($this$getEvaluateIntrinsicValue, evaluateIntrinsicAnnotation).getValueArgument(0);
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrConst<*>");
        }
        return String.valueOf(((IrConst)object).getValue());
    }

    @Nullable
    public static final Class<?> getPrimitiveClass(@NotNull IrType irType, boolean asObject) {
        Class clazz;
        Intrinsics.checkNotNullParameter(irType, "irType");
        PrimitiveType primitiveType = IrTypePredicatesKt.getPrimitiveType(irType);
        int n = primitiveType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[primitiveType.ordinal()];
        switch (n) {
            case 1: {
                if (asObject) {
                    clazz = Boolean.class;
                    break;
                }
                clazz = Boolean.TYPE;
                break;
            }
            case 2: {
                if (asObject) {
                    clazz = Character.class;
                    break;
                }
                clazz = Character.TYPE;
                break;
            }
            case 3: {
                if (asObject) {
                    clazz = Byte.class;
                    break;
                }
                clazz = Byte.TYPE;
                break;
            }
            case 4: {
                if (asObject) {
                    clazz = Short.class;
                    break;
                }
                clazz = Short.TYPE;
                break;
            }
            case 5: {
                if (asObject) {
                    clazz = Integer.class;
                    break;
                }
                clazz = Integer.TYPE;
                break;
            }
            case 6: {
                if (asObject) {
                    clazz = Float.class;
                    break;
                }
                clazz = Float.TYPE;
                break;
            }
            case 7: {
                if (asObject) {
                    clazz = Long.class;
                    break;
                }
                clazz = Long.TYPE;
                break;
            }
            case 8: {
                if (asObject) {
                    clazz = Double.class;
                    break;
                }
                clazz = Double.TYPE;
                break;
            }
            default: {
                clazz = IrTypePredicatesKt.isString(irType) ? String.class : null;
            }
        }
        return clazz;
    }

    public static /* synthetic */ Class getPrimitiveClass$default(IrType irType, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return UtilsKt.getPrimitiveClass(irType, bl);
    }

    @NotNull
    public static final IrFunction getLastOverridden(@NotNull IrFunction $this$getLastOverridden) {
        Intrinsics.checkNotNullParameter($this$getLastOverridden, "<this>");
        if (!($this$getLastOverridden instanceof IrSimpleFunction)) {
            return $this$getLastOverridden;
        }
        return SequencesKt.last(SequencesKt.flattenSequenceOfIterable(SequencesKt.generateSequence(CollectionsKt.listOf($this$getLastOverridden), (Function1)getLastOverridden.1.INSTANCE)));
    }

    @NotNull
    public static final Primitive<?> toPrimitiveStateArray(@NotNull List<? extends Object> $this$toPrimitiveStateArray, @NotNull IrType type2) {
        Primitive<boolean[]> primitive;
        Intrinsics.checkNotNullParameter($this$toPrimitiveStateArray, "<this>");
        Intrinsics.checkNotNullParameter(type2, "type");
        if (IrTypePredicatesKt.isByteArray(type2)) {
            int n = 0;
            int n2 = $this$toPrimitiveStateArray.size();
            byte[] byArray = new byte[n2];
            while (n < n2) {
                int n3;
                Object object;
                if ((object = $this$toPrimitiveStateArray.get(n3 = n++)) == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Number");
                }
                byArray[n3] = ((Number)object).byteValue();
            }
            IrType irType = type2;
            byte[] byArray2 = byArray;
            primitive = new Primitive<boolean[]>((boolean[])byArray2, irType);
        } else if (IrTypePredicatesKt.isCharArray(type2)) {
            int n = 0;
            int n4 = $this$toPrimitiveStateArray.size();
            char[] cArray = new char[n4];
            while (n < n4) {
                int n5;
                Object object;
                if ((object = $this$toPrimitiveStateArray.get(n5 = n++)) == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Char");
                }
                cArray[n5] = ((Character)object).charValue();
            }
            IrType irType = type2;
            char[] cArray2 = cArray;
            primitive = new Primitive<boolean[]>((boolean[])cArray2, irType);
        } else if (IrTypePredicatesKt.isShortArray(type2)) {
            int n = 0;
            int n6 = $this$toPrimitiveStateArray.size();
            short[] sArray = new short[n6];
            while (n < n6) {
                int n7;
                Object object;
                if ((object = $this$toPrimitiveStateArray.get(n7 = n++)) == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Number");
                }
                sArray[n7] = ((Number)object).shortValue();
            }
            IrType irType = type2;
            short[] sArray2 = sArray;
            primitive = new Primitive<boolean[]>((boolean[])sArray2, irType);
        } else if (IrTypePredicatesKt.isIntArray(type2)) {
            int n = 0;
            int n8 = $this$toPrimitiveStateArray.size();
            int[] nArray = new int[n8];
            while (n < n8) {
                int n9;
                Object object;
                if ((object = $this$toPrimitiveStateArray.get(n9 = n++)) == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Number");
                }
                nArray[n9] = ((Number)object).intValue();
            }
            IrType irType = type2;
            int[] nArray2 = nArray;
            primitive = new Primitive<boolean[]>((boolean[])nArray2, irType);
        } else if (IrTypePredicatesKt.isLongArray(type2)) {
            int n = 0;
            int n10 = $this$toPrimitiveStateArray.size();
            long[] lArray = new long[n10];
            while (n < n10) {
                int n11;
                Object object;
                if ((object = $this$toPrimitiveStateArray.get(n11 = n++)) == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Number");
                }
                lArray[n11] = ((Number)object).longValue();
            }
            IrType irType = type2;
            long[] lArray2 = lArray;
            primitive = new Primitive<boolean[]>((boolean[])lArray2, irType);
        } else if (IrTypePredicatesKt.isFloatArray(type2)) {
            int n = 0;
            int n12 = $this$toPrimitiveStateArray.size();
            float[] fArray = new float[n12];
            while (n < n12) {
                int n13;
                Object object;
                if ((object = $this$toPrimitiveStateArray.get(n13 = n++)) == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Number");
                }
                fArray[n13] = ((Number)object).floatValue();
            }
            IrType irType = type2;
            float[] fArray2 = fArray;
            primitive = new Primitive<boolean[]>((boolean[])fArray2, irType);
        } else if (IrTypePredicatesKt.isDoubleArray(type2)) {
            int n = 0;
            int n14 = $this$toPrimitiveStateArray.size();
            double[] dArray = new double[n14];
            while (n < n14) {
                int n15;
                Object object;
                if ((object = $this$toPrimitiveStateArray.get(n15 = n++)) == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Number");
                }
                dArray[n15] = ((Number)object).doubleValue();
            }
            IrType irType = type2;
            double[] dArray2 = dArray;
            primitive = new Primitive<boolean[]>((boolean[])dArray2, irType);
        } else if (IrTypePredicatesKt.isBooleanArray(type2)) {
            int n = 0;
            int n16 = $this$toPrimitiveStateArray.size();
            boolean[] blArray = new boolean[n16];
            while (n < n16) {
                int n17;
                Object object;
                if ((object = $this$toPrimitiveStateArray.get(n17 = n++)) == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Boolean");
                }
                blArray[n17] = (Boolean)object;
            }
            IrType irType = type2;
            boolean[] blArray2 = blArray;
            primitive = new Primitive<boolean[]>(blArray2, irType);
        } else {
            Collection $this$toTypedArray$iv = $this$toPrimitiveStateArray;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            Object[] objectArray = thisCollection$iv.toArray(new Object[0]);
            if (objectArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            primitive = new Primitive<Object[]>(objectArray, type2);
        }
        return primitive;
    }

    @Nullable
    public static final IrType getVarargType(@NotNull IrFunctionAccessExpression $this$getVarargType, int index2) {
        IrSimpleType type2;
        IrSimpleType irSimpleType;
        Intrinsics.checkNotNullParameter($this$getVarargType, "<this>");
        Object object = ((IrFunctionSymbol)$this$getVarargType.getSymbol()).getOwner().getValueParameters().get(index2).getVarargElementType();
        if (object == null) {
            return null;
        }
        Object varargType = object;
        if ((object = IrTypesKt.getClassOrNull((IrType)varargType)) != null) {
            Object object2 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object2;
            boolean bl3 = false;
            return ((IrFunctionSymbol)$this$getVarargType.getSymbol()).getOwner().getValueParameters().get(index2).getType();
        }
        IrType irType = ((IrFunctionSymbol)$this$getVarargType.getSymbol()).getOwner().getValueParameters().get(index2).getType();
        IrSimpleType irSimpleType2 = irSimpleType = irType instanceof IrSimpleType ? (IrSimpleType)irType : null;
        if (irSimpleType == null) {
            return null;
        }
        IrSimpleType $this$buildSimpleType$iv = type2 = irSimpleType;
        boolean $i$f$buildSimpleType = false;
        IrSimpleTypeBuilder irSimpleTypeBuilder = IrSimpleTypeImplKt.toBuilder($this$buildSimpleType$iv);
        boolean bl = false;
        boolean bl4 = false;
        IrSimpleTypeBuilder $this$getVarargType_u24lambda_u2d5 = irSimpleTypeBuilder;
        boolean bl5 = false;
        IrTypeParameter typeParameter = (IrTypeParameter)IrTypesKt.getClassifierOrFail((IrType)varargType).getOwner();
        IrType irType2 = $this$getVarargType.getTypeArgument(typeParameter.getIndex());
        Intrinsics.checkNotNull(irType2);
        $this$getVarargType_u24lambda_u2d5.setArguments(CollectionsKt.listOf(IrSimpleTypeImplKt.makeTypeProjection(irType2, Variance.OUT_VARIANCE)));
        return IrSimpleTypeImplKt.buildSimpleType(irSimpleTypeBuilder);
    }

    @NotNull
    public static final String getCapitalizedFileName(@NotNull IrFunction $this$getCapitalizedFileName) {
        Intrinsics.checkNotNullParameter($this$getCapitalizedFileName, "<this>");
        return CapitalizeDecapitalizeKt.capitalizeAsciiOnly(StringsKt.replace$default(IrFileKt.getName(IrUtilsKt.getFile($this$getCapitalizedFileName)), ".kt", "Kt", false, 4, null));
    }

    public static final boolean isUnsigned(@NotNull IrType $this$isUnsigned) {
        Intrinsics.checkNotNullParameter($this$isUnsigned, "<this>");
        return IrTypePredicatesKt.getUnsignedType($this$isUnsigned) != null;
    }

    public static final boolean isFunction(@NotNull IrType $this$isFunction) {
        boolean bl;
        String string2;
        FqName fqName2;
        Intrinsics.checkNotNullParameter($this$isFunction, "<this>");
        IrClass irClass2 = IrTypesKt.getClass($this$isFunction);
        return irClass2 == null ? false : ((fqName2 = IrUtilsKt.getFqNameWhenAvailable(irClass2)) == null ? false : ((string2 = fqName2.asString()) == null ? false : (bl = StringsKt.startsWith$default(string2, "kotlin.Function", false, 2, null))));
    }

    public static final boolean isKFunction(@NotNull IrType $this$isKFunction) {
        boolean bl;
        String string2;
        FqName fqName2;
        Intrinsics.checkNotNullParameter($this$isKFunction, "<this>");
        IrClass irClass2 = IrTypesKt.getClass($this$isKFunction);
        return irClass2 == null ? false : ((fqName2 = IrUtilsKt.getFqNameWhenAvailable(irClass2)) == null ? false : ((string2 = fqName2.asString()) == null ? false : (bl = StringsKt.startsWith$default(string2, "kotlin.reflect.KFunction", false, 2, null))));
    }

    public static final boolean isTypeParameter(@NotNull IrType $this$isTypeParameter) {
        Intrinsics.checkNotNullParameter($this$isTypeParameter, "<this>");
        return IrTypesKt.getClassifierOrNull($this$isTypeParameter) instanceof IrTypeParameterSymbol;
    }

    public static final boolean isThrowable(@NotNull IrType $this$isThrowable) {
        FqName fqName2;
        Intrinsics.checkNotNullParameter($this$isThrowable, "<this>");
        IrClass irClass2 = IrTypesKt.getClass($this$isThrowable);
        return Intrinsics.areEqual(irClass2 == null ? null : ((fqName2 = IrUtilsKt.getFqNameWhenAvailable(irClass2)) == null ? null : fqName2.asString()), "kotlin.Throwable");
    }

    public static final boolean isUnsignedArray(@NotNull IrType $this$isUnsignedArray) {
        Intrinsics.checkNotNullParameter($this$isUnsignedArray, "<this>");
        if (!($this$isUnsignedArray instanceof IrSimpleType) || !(((IrSimpleType)$this$isUnsignedArray).getClassifier() instanceof IrClassSymbol)) {
            return false;
        }
        String[] stringArray = IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)((IrSimpleType)$this$isUnsignedArray).getClassifier().getOwner());
        String fqName2 = stringArray == null ? null : stringArray.asString();
        stringArray = new String[]{"kotlin.UByteArray", "kotlin.UShortArray", "kotlin.UIntArray", "kotlin.ULongArray"};
        return CollectionsKt.contains((Iterable)SetsKt.setOf(stringArray), fqName2);
    }

    public static final boolean isPrimitiveArray(@NotNull IrType $this$isPrimitiveArray) {
        boolean bl;
        Intrinsics.checkNotNullParameter($this$isPrimitiveArray, "<this>");
        IrClass irClass2 = IrTypesKt.getClass($this$isPrimitiveArray);
        if (irClass2 == null) {
            bl = false;
        } else {
            FqName fqName2 = IrUtilsKt.getFqNameWhenAvailable(irClass2);
            if (fqName2 == null) {
                bl = false;
            } else {
                FqNameUnsafe fqNameUnsafe = fqName2.toUnsafe();
                if (fqNameUnsafe == null) {
                    bl = false;
                } else {
                    boolean bl2;
                    FqNameUnsafe fqNameUnsafe2 = fqNameUnsafe;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    FqNameUnsafe it = fqNameUnsafe2;
                    boolean bl5 = false;
                    bl = bl2 = StandardNames.isPrimitiveArray(it);
                }
            }
        }
        return bl;
    }

    @NotNull
    public static final String internalName(@NotNull IrClass $this$internalName) {
        Intrinsics.checkNotNullParameter($this$internalName, "<this>");
        StringBuilder internalName2 = new StringBuilder($this$internalName.getName().asString());
        Sequence<IrDeclarationParent> $this$forEach$iv = SequencesKt.drop(SequencesKt.generateSequence($this$internalName instanceof IrDeclarationParent ? (IrDeclarationParent)$this$internalName : null, (Function1)internalName.1.INSTANCE), 1);
        boolean $i$f$forEach = false;
        Iterator<IrDeclarationParent> iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            String string2;
            IrDeclarationParent element$iv;
            IrDeclarationParent it = element$iv = iterator2.next();
            boolean bl = false;
            IrDeclarationParent irDeclarationParent = it;
            if (irDeclarationParent instanceof IrClass) {
                internalName2.insert(0, Intrinsics.stringPlus(((IrClass)it).getName().asString(), "$"));
                continue;
            }
            if (!(irDeclarationParent instanceof IrPackageFragment)) continue;
            String string3 = ((IrPackageFragment)it).getFqName().asString();
            boolean bl2 = false;
            boolean bl3 = false;
            String it2 = string3;
            boolean bl4 = false;
            Intrinsics.checkNotNullExpressionValue(it2, "it");
            CharSequence charSequence = it2;
            boolean bl5 = false;
            String string4 = string2 = charSequence.length() > 0 ? string3 : null;
            if (string2 == null) continue;
            string3 = string2;
            bl2 = false;
            bl3 = false;
            it2 = string3;
            boolean bl6 = false;
            internalName2.insert(0, Intrinsics.stringPlus(it2, "."));
        }
        String string5 = internalName2.toString();
        Intrinsics.checkNotNullExpressionValue(string5, "internalName.toString()");
        return string5;
    }

    public static final void withExceptionHandler(@NotNull IrInterpreterEnvironment environment, @NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter(environment, "environment");
        Intrinsics.checkNotNullParameter(block, "block");
        boolean $i$f$withExceptionHandler = false;
        try {
            block.invoke();
        }
        catch (Throwable e) {
            UtilsKt.handleUserException(e, environment);
        }
    }

    public static final void handleUserException(@NotNull Throwable $this$handleUserException, @NotNull IrInterpreterEnvironment environment) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter($this$handleUserException, "<this>");
            Intrinsics.checkNotNullParameter(environment, "environment");
            String exceptionName = $this$handleUserException.getClass().getSimpleName();
            Iterable $this$firstOrNull$iv = environment.getIrExceptions();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                IrClass it = (IrClass)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getName().asString(), exceptionName)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        IrClass irClass2 = v0;
        IrClass irExceptionClass = irClass2 == null ? (IrClass)environment.getIrBuiltIns().getThrowableClass().getOwner() : irClass2;
        environment.getCallStack().pushState(new ExceptionState($this$handleUserException, irExceptionClass, environment.getCallStack().getStackTrace()));
        environment.getCallStack().dropFramesUntilTryCatch();
    }

    public static final boolean checkCast(@Nullable IrFunction $this$checkCast, @NotNull IrInterpreterEnvironment environment) {
        IrType irType;
        Intrinsics.checkNotNullParameter(environment, "environment");
        IrFunction irFunction2 = $this$checkCast;
        if (irFunction2 == null) {
            return true;
        }
        IrType actualType = $this$checkCast.getReturnType();
        if (!(IrTypesKt.getClassifierOrNull(actualType) instanceof IrTypeParameterSymbol)) {
            return true;
        }
        State state = environment.getCallStack().getState($this$checkCast.getSymbol());
        State state2 = state instanceof KTypeState ? (KTypeState)state : null;
        IrType irType2 = irType = state2 == null ? null : state2.getIrType();
        if (irType == null) {
            return true;
        }
        IrType expectedType2 = irType;
        if (IrTypesKt.getClassifierOrFail(expectedType2) instanceof IrTypeParameterSymbol) {
            return true;
        }
        state2 = environment.getCallStack().peekState();
        if (state2 == null) {
            return true;
        }
        State actualState = state2;
        if (actualState instanceof Primitive && ((Primitive)actualState).getValue() == null) {
            return true;
        }
        if (!StateKt.isSubtypeOf(actualState, expectedType2)) {
            FqName convertibleClassName = IrUtilsKt.getFqNameWhenAvailable(environment.getCallStack().popState().getIrClass());
            UtilsKt.handleUserException(new ClassCastException(convertibleClassName + " cannot be cast to " + RenderIrElementKt.render(expectedType2)), environment);
            return false;
        }
        return true;
    }

    @NotNull
    public static final List<Object> getArgsForMethodInvocation(@NotNull IrFunction $this$getArgsForMethodInvocation, @NotNull CallInterceptor callInterceptor, @NotNull MethodType methodType, @NotNull List<? extends State> args2) {
        Intrinsics.checkNotNullParameter($this$getArgsForMethodInvocation, "<this>");
        Intrinsics.checkNotNullParameter(callInterceptor, "callInterceptor");
        Intrinsics.checkNotNullParameter(methodType, "methodType");
        Intrinsics.checkNotNullParameter(args2, "args");
        List<Object> argsValues = CollectionsKt.toMutableList((Collection)ProxyKt.wrap(args2, callInterceptor, $this$getArgsForMethodInvocation, methodType));
        IrValueParameter irValueParameter = CollectionsKt.lastOrNull($this$getArgsForMethodInvocation.getValueParameters());
        if ((irValueParameter == null ? null : irValueParameter.getVarargElementType()) != null) {
            Object varargValue = CollectionsKt.last(argsValues);
            argsValues.remove(argsValues.size() - 1);
            if (varargValue == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<out kotlin.Any?>");
            }
            CollectionsKt.addAll((Collection)argsValues, (Object[])varargValue);
        }
        return argsValues;
    }

    @NotNull
    public static final String getOnlyName(@NotNull IrType $this$getOnlyName) {
        Intrinsics.checkNotNullParameter($this$getOnlyName, "<this>");
        if (!($this$getOnlyName instanceof IrSimpleType)) {
            return RenderIrElementKt.render($this$getOnlyName);
        }
        return Intrinsics.stringPlus(((IrDeclarationWithName)IrTypesKt.getClassifierOrFail($this$getOnlyName).getOwner()).getName().asString(), ((IrSimpleType)$this$getOnlyName).getHasQuestionMark() ? "?" : "");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean accessesTopLevelOrObjectField(@NotNull IrFieldAccessExpression $this$accessesTopLevelOrObjectField) {
        IrClassifierSymbol irClassifierSymbol;
        IrType irType;
        Intrinsics.checkNotNullParameter($this$accessesTopLevelOrObjectField, "<this>");
        if ($this$accessesTopLevelOrObjectField.getReceiver() == null) return true;
        IrExpression irExpression = $this$accessesTopLevelOrObjectField.getReceiver();
        IrSymbolOwner irSymbolOwner = irExpression == null ? null : ((irType = irExpression.getType()) == null ? null : ((irClassifierSymbol = IrTypesKt.getClassifierOrNull(irType)) == null ? null : irClassifierSymbol.getOwner()));
        if (!(irSymbolOwner instanceof IrClass)) return false;
        IrClass irClass2 = (IrClass)irSymbolOwner;
        IrClass irClass3 = irClass2;
        if (irClass3 == null) {
            return false;
        }
        if (!IrUtilsKt.isObject(irClass3)) return false;
        return true;
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[PrimitiveType.values().length];
            nArray[PrimitiveType.BOOLEAN.ordinal()] = 1;
            nArray[PrimitiveType.CHAR.ordinal()] = 2;
            nArray[PrimitiveType.BYTE.ordinal()] = 3;
            nArray[PrimitiveType.SHORT.ordinal()] = 4;
            nArray[PrimitiveType.INT.ordinal()] = 5;
            nArray[PrimitiveType.FLOAT.ordinal()] = 6;
            nArray[PrimitiveType.LONG.ordinal()] = 7;
            nArray[PrimitiveType.DOUBLE.ordinal()] = 8;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[UnsignedType.values().length];
            nArray[UnsignedType.UBYTE.ordinal()] = 1;
            nArray[UnsignedType.USHORT.ordinal()] = 2;
            nArray[UnsignedType.UINT.ordinal()] = 3;
            nArray[UnsignedType.ULONG.ordinal()] = 4;
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

