/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter.checker;

import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.IrElementBase;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.descriptors.IrBuiltIns;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.interpreter.UtilsKt;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000eJ\u001c\u0010\u000f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000e2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0011H&J\f\u0010\u0012\u001a\u00020\u0003*\u00020\u0013H\u0004J\f\u0010\u0014\u001a\u00020\u0003*\u00020\u0013H\u0002J\n\u0010\u0015\u001a\u00020\u0003*\u00020\u0013J\f\u0010\u0016\u001a\u00020\u0003*\u00020\u0013H\u0002J\u0014\u0010\u0017\u001a\u00020\u0003*\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0019H\u0004R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bj\u0002\b\u001aj\u0002\b\u001bj\u0002\b\u001c\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/checker/EvaluationMode;", "", "mustCheckBody", "", "(Ljava/lang/String;IZ)V", "compileTimeTypeAliases", "", "", "getCompileTimeTypeAliases", "()Ljava/util/Set;", "getMustCheckBody", "()Z", "canEvaluateBody", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "canEvaluateFunction", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "isCompileTimeTypeAlias", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "isContract", "isMarkedAsCompileTime", "isMarkedAsEvaluateIntrinsic", "isMarkedWith", "annotation", "Lorg/jetbrains/kotlin/name/FqName;", "FULL", "WITH_ANNOTATIONS", "ONLY_BUILTINS", "ir.interpreter"})
public abstract class EvaluationMode
extends Enum<EvaluationMode> {
    private final boolean mustCheckBody;
    @NotNull
    private final Set<String> compileTimeTypeAliases;
    public static final /* enum */ EvaluationMode FULL = new FULL("FULL", 0);
    public static final /* enum */ EvaluationMode WITH_ANNOTATIONS = new WITH_ANNOTATIONS("WITH_ANNOTATIONS", 1);
    public static final /* enum */ EvaluationMode ONLY_BUILTINS = new ONLY_BUILTINS("ONLY_BUILTINS", 2);
    private static final /* synthetic */ EvaluationMode[] $VALUES;

    private EvaluationMode(boolean mustCheckBody) {
        this.mustCheckBody = mustCheckBody;
        String[] stringArray = new String[]{"java.lang.StringBuilder", "java.lang.IllegalArgumentException", "java.util.NoSuchElementException"};
        this.compileTimeTypeAliases = SetsKt.setOf(stringArray);
    }

    protected final boolean getMustCheckBody() {
        return this.mustCheckBody;
    }

    public abstract boolean canEvaluateFunction(@NotNull IrFunction var1, @Nullable IrCall var2);

    public static /* synthetic */ boolean canEvaluateFunction$default(EvaluationMode evaluationMode, IrFunction irFunction2, IrCall irCall, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: canEvaluateFunction");
        }
        if ((n & 2) != 0) {
            irCall = null;
        }
        return evaluationMode.canEvaluateFunction(irFunction2, irCall);
    }

    public final boolean canEvaluateBody(@NotNull IrFunction function2) {
        Intrinsics.checkNotNullParameter(function2, "function");
        if (function2 instanceof IrSimpleFunction && ((IrSimpleFunction)function2).getCorrespondingPropertySymbol() != null) {
            return true;
        }
        return (this.mustCheckBody || AdditionalIrUtilsKt.isLocal(function2)) && !this.isContract(function2) && !this.isMarkedAsEvaluateIntrinsic(function2);
    }

    @NotNull
    protected final Set<String> getCompileTimeTypeAliases() {
        return this.compileTimeTypeAliases;
    }

    public final boolean isMarkedAsCompileTime(@NotNull IrDeclaration $this$isMarkedAsCompileTime) {
        Intrinsics.checkNotNullParameter($this$isMarkedAsCompileTime, "<this>");
        return this.isMarkedWith($this$isMarkedAsCompileTime, UtilsKt.getCompileTimeAnnotation());
    }

    private final boolean isContract(IrDeclaration $this$isContract) {
        return this.isMarkedWith($this$isContract, UtilsKt.getContractsDslAnnotation());
    }

    private final boolean isMarkedAsEvaluateIntrinsic(IrDeclaration $this$isMarkedAsEvaluateIntrinsic) {
        return this.isMarkedWith($this$isMarkedAsEvaluateIntrinsic, UtilsKt.getEvaluateIntrinsicAnnotation());
    }

    protected final boolean isCompileTimeTypeAlias(@NotNull IrDeclaration $this$isCompileTimeTypeAlias) {
        FqName fqName2;
        Intrinsics.checkNotNullParameter($this$isCompileTimeTypeAlias, "<this>");
        IrClass irClass2 = IrUtilsKt.getParentClassOrNull($this$isCompileTimeTypeAlias);
        return CollectionsKt.contains((Iterable)this.compileTimeTypeAliases, irClass2 == null ? null : ((fqName2 = IrUtilsKt.getFqNameWhenAvailable(irClass2)) == null ? null : fqName2.asString()));
    }

    protected final boolean isMarkedWith(@NotNull IrDeclaration $this$isMarkedWith, @NotNull FqName annotation2) {
        Intrinsics.checkNotNullParameter($this$isMarkedWith, "<this>");
        Intrinsics.checkNotNullParameter(annotation2, "annotation");
        if ($this$isMarkedWith instanceof IrClass && ((IrClass)$this$isMarkedWith).isCompanion()) {
            return false;
        }
        if (UtilsKt.hasAnnotation($this$isMarkedWith, annotation2)) {
            return true;
        }
        IrDeclarationParent irDeclarationParent = $this$isMarkedWith.getParent();
        IrClass irClass2 = irDeclarationParent instanceof IrClass ? (IrClass)irDeclarationParent : null;
        return irClass2 == null ? false : this.isMarkedWith(irClass2, annotation2);
    }

    public static EvaluationMode[] values() {
        return (EvaluationMode[])$VALUES.clone();
    }

    public static EvaluationMode valueOf(String value2) {
        return Enum.valueOf(EvaluationMode.class, value2);
    }

    public /* synthetic */ EvaluationMode(String $enum$name, int $enum$ordinal, boolean mustCheckBody, DefaultConstructorMarker $constructor_marker) {
        this(mustCheckBody);
    }

    static {
        $VALUES = evaluationModeArray = new EvaluationMode[]{EvaluationMode.FULL, EvaluationMode.WITH_ANNOTATIONS, EvaluationMode.ONLY_BUILTINS};
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u001a\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/checker/EvaluationMode$FULL;", "Lorg/jetbrains/kotlin/ir/interpreter/checker/EvaluationMode;", "canEvaluateFunction", "", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "ir.interpreter"})
    static final class FULL
    extends EvaluationMode {
        /*
         * WARNING - void declaration
         */
        FULL() {
            void var1_1;
        }

        @Override
        public boolean canEvaluateFunction(@NotNull IrFunction function2, @Nullable IrCall expression2) {
            Intrinsics.checkNotNullParameter(function2, "function");
            return true;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u001a\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\u000e\u0010\b\u001a\u00020\u0003*\u0004\u0018\u00010\tH\u0002\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/checker/EvaluationMode$WITH_ANNOTATIONS;", "Lorg/jetbrains/kotlin/ir/interpreter/checker/EvaluationMode;", "canEvaluateFunction", "", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "isCompileTimeProperty", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "ir.interpreter"})
    static final class WITH_ANNOTATIONS
    extends EvaluationMode {
        /*
         * WARNING - void declaration
         */
        WITH_ANNOTATIONS() {
            void var1_1;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean canEvaluateFunction(@NotNull IrFunction function2, @Nullable IrCall expression2) {
            Intrinsics.checkNotNullParameter(function2, "function");
            if (this.isCompileTimeProperty(function2)) {
                return true;
            }
            if (this.isMarkedAsCompileTime(function2)) return true;
            if (Intrinsics.areEqual(function2.getOrigin(), IrBuiltIns.Companion.getBUILTIN_OPERATOR())) return true;
            if (function2 instanceof IrSimpleFunction && ((IrSimpleFunction)function2).isOperator()) {
                if (Intrinsics.areEqual(function2.getName().asString(), "invoke")) return true;
            }
            if (function2 instanceof IrSimpleFunction && ((IrSimpleFunction)function2).isFakeOverride()) {
                boolean bl;
                Iterable $this$any$iv = ((IrSimpleFunction)function2).getOverriddenSymbols();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        IrSimpleFunctionSymbol it = (IrSimpleFunctionSymbol)element$iv;
                        boolean bl2 = false;
                        if (!EvaluationMode.canEvaluateFunction$default(this, it.getOwner(), null, 2, null)) continue;
                        return true;
                    }
                    bl = false;
                }
                if (bl) return true;
            }
            if (!this.isCompileTimeTypeAlias(function2)) return false;
            return true;
        }

        private final boolean isCompileTimeProperty(IrDeclaration $this$isCompileTimeProperty) {
            IrExpressionBody irExpressionBody;
            Object object;
            IrProperty irProperty2;
            IrSimpleFunction irSimpleFunction;
            IrSimpleFunction irSimpleFunction2 = irSimpleFunction = $this$isCompileTimeProperty instanceof IrSimpleFunction ? (IrSimpleFunction)$this$isCompileTimeProperty : null;
            IrProperty irProperty3 = irSimpleFunction == null ? null : (irProperty2 = (object = irSimpleFunction.getCorrespondingPropertySymbol()) == null ? null : (IrProperty)object.getOwner());
            if (irProperty2 == null) {
                return false;
            }
            IrProperty property2 = irProperty2;
            if (property2.isConst()) {
                return true;
            }
            if (this.isMarkedAsCompileTime(property2) || this.isCompileTimeTypeAlias(property2)) {
                return true;
            }
            IrField backingField2 = property2.getBackingField();
            IrField irField = backingField2;
            object = irField == null ? null : ((irExpressionBody = irField.getInitializer()) == null ? null : irExpressionBody.getExpression());
            IrGetValue backingFieldExpression = object instanceof IrGetValue ? (IrGetValue)object : null;
            object = backingFieldExpression;
            return Intrinsics.areEqual(object == null ? null : ((IrValueAccessExpression)object).getOrigin(), IrStatementOrigin.INITIALIZE_PROPERTY_FROM_PARAMETER.INSTANCE);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u001a\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/checker/EvaluationMode$ONLY_BUILTINS;", "Lorg/jetbrains/kotlin/ir/interpreter/checker/EvaluationMode;", "forbiddenMethodsOnPrimitives", "", "", "forbiddenMethodsOnStrings", "canEvaluateFunction", "", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "ir.interpreter"})
    static final class ONLY_BUILTINS
    extends EvaluationMode {
        @NotNull
        private final Set<String> forbiddenMethodsOnPrimitives;
        @NotNull
        private final Set<String> forbiddenMethodsOnStrings;

        /*
         * WARNING - void declaration
         */
        ONLY_BUILTINS() {
            void var1_1;
            String[] stringArray = new String[]{"inc", "dec", "rangeTo", "hashCode"};
            this.forbiddenMethodsOnPrimitives = SetsKt.setOf(stringArray);
            stringArray = new String[]{"subSequence", "hashCode", "<init>"};
            this.forbiddenMethodsOnStrings = SetsKt.setOf(stringArray);
        }

        @Override
        public boolean canEvaluateFunction(@NotNull IrFunction function2, @Nullable IrCall expression2) {
            boolean bl;
            IrElementBase irElementBase;
            Object object;
            IrSimpleFunction irSimpleFunction;
            Intrinsics.checkNotNullParameter(function2, "function");
            IrSimpleFunction irSimpleFunction2 = irSimpleFunction = function2 instanceof IrSimpleFunction ? (IrSimpleFunction)function2 : null;
            if (irSimpleFunction == null ? false : ((object = irSimpleFunction.getCorrespondingPropertySymbol()) == null ? false : ((irElementBase = (IrProperty)object.getOwner()) == null ? false : ((IrProperty)irElementBase).isConst()))) {
                return true;
            }
            object = IrUtilsKt.getParentClassOrNull(function2);
            if (object == null) {
                return false;
            }
            Object parent2 = object;
            IrSimpleType parentType = IrUtilsKt.getDefaultType((IrClass)parent2);
            if (IrTypePredicatesKt.isPrimitiveType$default(parentType, false, 1, null)) {
                bl = !this.forbiddenMethodsOnPrimitives.contains(function2.getName().asString());
            } else if (IrTypePredicatesKt.isString(parentType)) {
                bl = !this.forbiddenMethodsOnStrings.contains(function2.getName().asString());
            } else if (IrTypePredicatesKt.isAny(parentType)) {
                bl = Intrinsics.areEqual(function2.getName().asString(), "toString") && !(((irElementBase = expression2) == null ? null : ((IrMemberAccessExpression)irElementBase).getDispatchReceiver()) instanceof IrGetObjectValue);
            } else if (IrUtilsKt.isObject((IrClass)parent2)) {
                irElementBase = IrUtilsKt.getParentClassOrNull((IrDeclaration)parent2);
                if (irElementBase == null) {
                    bl = false;
                } else {
                    IrSimpleType irSimpleType = IrUtilsKt.getDefaultType((IrClass)irElementBase);
                    if (irSimpleType == null) {
                        bl = false;
                    } else {
                        IrSimpleType irSimpleType2 = irSimpleType;
                        boolean bl2 = false;
                        boolean bl3 = false;
                        IrSimpleType it = irSimpleType2;
                        boolean bl4 = false;
                        bl = IrTypePredicatesKt.isPrimitiveType$default(it, false, 1, null) || UtilsKt.isUnsigned(it);
                    }
                }
            } else {
                bl = IrTypePredicatesKt.isUnsignedType$default(parentType, false, 1, null) && function2 instanceof IrConstructor;
            }
            return bl;
        }
    }
}

