/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.DeclarationTransformer;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.backend.js.JsCommonBackendContext;
import org.jetbrains.kotlin.ir.backend.js.lower.PropertyLazyInitLoweringKt;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrProperty;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u0007H\u0002J\u0018\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/RemoveInitializersForLazyProperties;", "Lorg/jetbrains/kotlin/backend/common/DeclarationTransformer;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsCommonBackendContext;", "(Lorg/jetbrains/kotlin/ir/backend/js/JsCommonBackendContext;)V", "fileToInitializerPureness", "", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "", "getFileToInitializerPureness", "()Ljava/util/Map;", "calculateFileFieldsPureness", "file", "transformFlat", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "declaration", "backend.js"})
public final class RemoveInitializersForLazyProperties
implements DeclarationTransformer {
    @NotNull
    private final JsCommonBackendContext context;

    public RemoveInitializersForLazyProperties(@NotNull JsCommonBackendContext context) {
        Intrinsics.checkNotNullParameter(context, "context");
        this.context = context;
    }

    private final Map<IrFile, Boolean> getFileToInitializerPureness() {
        return this.context.getPropertyLazyInitialization().getFileToInitializerPureness();
    }

    @Override
    @Nullable
    public List<IrDeclaration> transformFlat(@NotNull IrDeclaration declaration) {
        block7: {
            IrElement irElement;
            IrElement irElement2;
            boolean allFieldsInFilePure;
            Intrinsics.checkNotNullParameter(declaration, "declaration");
            if (!this.context.getPropertyLazyInitialization().getEnabled()) {
                return null;
            }
            if (!(declaration instanceof IrField)) {
                return null;
            }
            if (!PropertyLazyInitLoweringKt.access$isCompatibleDeclaration(declaration, this.context)) {
                return null;
            }
            IrElement irElement3 = declaration.getParent();
            IrFile irFile = irElement3 instanceof IrFile ? (IrFile)irElement3 : null;
            if (irFile == null) {
                return null;
            }
            IrFile file2 = irFile;
            if (Intrinsics.areEqual(this.getFileToInitializerPureness().get(file2), true)) {
                return null;
            }
            Boolean bl = this.getFileToInitializerPureness().get(file2);
            boolean bl2 = allFieldsInFilePure = bl != null ? bl.booleanValue() : this.calculateFileFieldsPureness(file2);
            if (allFieldsInFilePure) {
                return null;
            }
            irElement3 = PropertyLazyInitLoweringKt.access$getCorrespondingProperty(declaration);
            if (irElement3 == null) break block7;
            IrElement it = irElement2 = irElement3;
            boolean bl3 = false;
            IrElement irElement4 = irElement = PropertyLazyInitLoweringKt.access$isForLazyInit((IrProperty)it) ? irElement2 : null;
            if (irElement != null && (irElement2 = ((IrProperty)irElement).getBackingField()) != null) {
                IrElement it2 = irElement2;
                boolean bl4 = false;
                ((IrField)it2).setInitializer(null);
            }
        }
        return null;
    }

    private final boolean calculateFileFieldsPureness(IrFile file2) {
        List declarations2 = CollectionsKt.toList((Iterable)file2.getDeclarations());
        Collection expressions = PropertyLazyInitLoweringKt.access$calculateFieldToExpression(declarations2, this.context).values();
        boolean allFieldsInFilePure = PropertyLazyInitLoweringKt.access$allFieldsInFilePure(expressions);
        Boolean bl = allFieldsInFilePure;
        this.getFileToInitializerPureness().put(file2, bl);
        return allFieldsInFilePure;
    }

    @Override
    public boolean getWithLocalDeclarations() {
        return DeclarationTransformer.DefaultImpls.getWithLocalDeclarations(this);
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        DeclarationTransformer.DefaultImpls.lower(this, irFile);
    }
}

