/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.ScopeWithIr;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.ir.IrInlineReferenceLocatorKt;
import org.jetbrains.kotlin.backend.jvm.ir.IrInlineScopeResolver;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrUtilsKt;
import org.jetbrains.kotlin.backend.jvm.lower.SyntheticAccessorLoweringKt;
import org.jetbrains.kotlin.backend.jvm.lower.SyntheticAccessorTransformer;
import org.jetbrains.kotlin.backend.jvm.lower.ToArrayLoweringKt;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithVisibility;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrOverridableDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrFakeOverrideUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/SyntheticAccessorLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "Companion", "backend.jvm.lower"})
public final class SyntheticAccessorLowering
implements FileLoweringPass {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JvmBackendContext context;

    public SyntheticAccessorLowering(@NotNull JvmBackendContext context) {
        Intrinsics.checkNotNullParameter(context, "context");
        this.context = context;
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter(irFile, "irFile");
        List pendingAccessorsToAdd = new ArrayList();
        IrElementTransformerVoidKt.transformChildrenVoid(irFile, new SyntheticAccessorTransformer(this.context, IrInlineReferenceLocatorKt.findInlineCallSites(irFile, this.context), pendingAccessorsToAdd));
        for (IrFunction accessor : pendingAccessorsToAdd) {
            boolean bl = Intrinsics.areEqual(IrUtilsKt.getFileOrNull(accessor), irFile);
            if (_Assertions.ENABLED && !bl) {
                boolean bl2 = false;
                String string2 = "SyntheticAccessorLowering should not attempt to modify other files!\nWhile lowering this file: " + RenderIrElementKt.render(irFile) + "\nTrying to add this accessor: " + RenderIrElementKt.render(accessor);
                throw new AssertionError((Object)string2);
            }
            IrDeclarationParent irDeclarationParent = accessor.getParent();
            Intrinsics.checkNotNull(irDeclarationParent, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer");
            ((IrDeclarationContainer)irDeclarationParent).getDeclarations().add(accessor);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0003\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00042\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/SyntheticAccessorLowering$Companion;", "", "()V", "isAccessible", "", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "currentScope", "Lorg/jetbrains/kotlin/backend/common/ScopeWithIr;", "inlineScopeResolver", "Lorg/jetbrains/kotlin/backend/jvm/ir/IrInlineScopeResolver;", "withSuper", "thisObjReference", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "backend.jvm.lower"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isAccessible(@NotNull IrSymbol $this$isAccessible, @NotNull JvmBackendContext context, @Nullable ScopeWithIr currentScope2, @NotNull IrInlineScopeResolver inlineScopeResolver, boolean withSuper, @Nullable IrClassSymbol thisObjReference) {
            boolean bl;
            IrDeclarationWithVisibility irDeclarationWithVisibility;
            Integer jvmVisibility;
            Intrinsics.checkNotNullParameter($this$isAccessible, "<this>");
            Intrinsics.checkNotNullParameter(context, "context");
            Intrinsics.checkNotNullParameter(inlineScopeResolver, "inlineScopeResolver");
            IrSymbolOwner irSymbolOwner = $this$isAccessible.getOwner();
            Intrinsics.checkNotNull(irSymbolOwner, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclarationWithVisibility");
            IrDeclarationWithVisibility declarationRaw = (IrDeclarationWithVisibility)irSymbolOwner;
            if (declarationRaw instanceof IrFunction && (((IrFunction)declarationRaw).isInline() || context.getGetIntrinsic().invoke(((IrFunction)declarationRaw).getSymbol()) != null)) {
                return true;
            }
            if (declarationRaw instanceof IrConstructor && IrUtilsKt.isEnumEntry(AdditionalIrUtilsKt.getConstructedClass((IrConstructor)declarationRaw))) {
                return true;
            }
            Integer n = jvmVisibility = AsmUtil.getVisibilityAccessFlag(declarationRaw.getVisibility().getDelegate());
            int n2 = 1;
            if (n != null && n == n2 && !withSuper) {
                return true;
            }
            if (declarationRaw instanceof IrSimpleFunction && (ToArrayLoweringKt.isNonGenericToArray((IrSimpleFunction)declarationRaw) || ToArrayLoweringKt.isGenericToArray((IrSimpleFunction)declarationRaw, context)) && ToArrayLoweringKt.isCollectionSubClass(IrUtilsKt.getParentAsClass(declarationRaw))) {
                return true;
            }
            if (declarationRaw instanceof IrField && JvmIrUtilsKt.isAssertionsDisabledField((IrField)declarationRaw, context)) {
                return true;
            }
            IrDeclarationWithVisibility irDeclarationWithVisibility2 = declarationRaw;
            if (irDeclarationWithVisibility2 instanceof IrSimpleFunction) {
                IrOverridableDeclaration irOverridableDeclaration = IrFakeOverrideUtilsKt.resolveFakeOverride$default((IrOverridableDeclaration)declarationRaw, true, null, 2, null);
                Intrinsics.checkNotNull(irOverridableDeclaration);
                irDeclarationWithVisibility = irOverridableDeclaration;
            } else {
                irDeclarationWithVisibility = irDeclarationWithVisibility2 instanceof IrField ? (IrDeclarationWithVisibility)SyntheticAccessorLoweringKt.access$resolveFakeOverride((IrField)declarationRaw) : declarationRaw;
            }
            IrDeclarationWithVisibility declaration = irDeclarationWithVisibility;
            IrDeclarationParent irDeclarationParent = declaration.getParent();
            IrClass irClass2 = irDeclarationParent instanceof IrClass ? (IrClass)irDeclarationParent : null;
            if (irClass2 == null) {
                return true;
            }
            IrClass ownerClass = irClass2;
            ScopeWithIr scopeWithIr = currentScope2;
            Intrinsics.checkNotNull(scopeWithIr);
            IrDeclarationContainer irDeclarationContainer = inlineScopeResolver.findContainer(scopeWithIr.getIrElement());
            if (irDeclarationContainer == null) {
                return false;
            }
            IrDeclarationContainer scopeClassOrPackage = irDeclarationContainer;
            IrPackageFragment irPackageFragment = IrUtilsKt.getPackageFragment(ownerClass);
            IrPackageFragment irPackageFragment2 = IrUtilsKt.getPackageFragment(scopeClassOrPackage);
            boolean samePackage = Intrinsics.areEqual(irPackageFragment != null ? irPackageFragment.getFqName() : null, irPackageFragment2 != null ? irPackageFragment2.getFqName() : null);
            Integer n3 = jvmVisibility;
            if (n3 != null && n3 == 0) {
                bl = samePackage;
            } else {
                Integer n4 = jvmVisibility;
                int n5 = 2;
                bl = n4 != null && n4 == n5 ? Intrinsics.areEqual(ownerClass, scopeClassOrPackage) : (!withSuper && samePackage ? true : scopeClassOrPackage instanceof IrClass && IrUtilsKt.isSubclassOf((IrClass)scopeClassOrPackage, ownerClass) && (thisObjReference == null || IrUtilsKt.isSubclassOf((IrClass)thisObjReference.getOwner(), (IrClass)scopeClassOrPackage)));
            }
            return bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

