/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.asJava.classes;

import com.intellij.lang.Language;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.augment.PsiAugmentProvider;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.light.LightClass;
import com.intellij.psi.impl.light.LightMethod;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtil;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.asJava.classes.KtLightClassForFacade;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiUtil;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a0\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\b\b\u0000\u0010\u0002*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u00020\u0006H\u0000\u001a\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u00032\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"collectAugments", "", "Psi", "Lcom/intellij/psi/PsiElement;", "element", "type", "Ljava/lang/Class;", "getParentForLocalDeclaration", "classOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "light-classes-base"})
public final class LightClassPlatformUtilsKt {
    @NotNull
    public static final <Psi extends PsiElement> List<Psi> collectAugments(@NotNull PsiElement element, @NotNull Class<? extends Psi> type2) {
        Intrinsics.checkNotNullParameter(element, "element");
        Intrinsics.checkNotNullParameter(type2, "type");
        List list2 = PsiAugmentProvider.collectAugments((PsiElement)element, type2, null);
        Intrinsics.checkNotNullExpressionValue(list2, "collectAugments(element, type, null)");
        return list2;
    }

    @Nullable
    public static final PsiElement getParentForLocalDeclaration(@NotNull KtClassOrObject classOrObject) {
        Intrinsics.checkNotNullParameter(classOrObject, "classOrObject");
        Class[] classArray = new Class[]{KtNamedFunction.class, KtConstructor.class, KtProperty.class, KtAnonymousInitializer.class, KtParameter.class};
        PsiElement declaration = KtPsiUtil.getTopmostParentOfTypes(classOrObject, classArray);
        if (declaration instanceof KtParameter) {
            PsiElement $this$getStrictParentOfType$iv = declaration;
            boolean $i$f$getStrictParentOfType = false;
            declaration = PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtNamedDeclaration.class, (boolean)true);
        }
        if (declaration instanceof KtFunction) {
            return LightClassPlatformUtilsKt.getParentForLocalDeclaration$getParentByPsiMethod(classOrObject, LightClassUtil.INSTANCE.getLightClassMethod((KtFunction)declaration), ((KtFunction)declaration).getName(), false);
        }
        if (declaration instanceof KtProperty) {
            return LightClassPlatformUtilsKt.getParentForLocalDeclaration$getParentByPsiMethod(classOrObject, LightClassUtil.INSTANCE.getLightClassPropertyMethods((KtProperty)declaration).getGetter(), ((KtProperty)declaration).getName(), true);
        }
        if (declaration instanceof KtAnonymousInitializer) {
            PsiElement parent2 = ((KtAnonymousInitializer)declaration).getParent();
            PsiElement grandparent = parent2.getParent();
            if (parent2 instanceof KtClassBody && grandparent instanceof KtClassOrObject) {
                return LightClassUtilsKt.toLightClass((KtClassOrObject)grandparent);
            }
        }
        return declaration instanceof KtClass ? (PsiElement)LightClassUtilsKt.toLightClass((KtClassOrObject)declaration) : null;
    }

    private static final PsiElement getParentForLocalDeclaration$getParentByPsiMethod(KtClassOrObject $classOrObject, PsiMethod method, String name, boolean forceMethodWrapping) {
        KotlinLanguage kotlinLanguage;
        if (method == null || name == null) {
            return null;
        }
        Ref.ObjectRef<PsiClass> containingClass = new Ref.ObjectRef<PsiClass>();
        PsiClass psiClass = method.getContainingClass();
        if (psiClass == null) {
            return null;
        }
        containingClass.element = psiClass;
        String string2 = $classOrObject.getContainingFile().getName();
        Intrinsics.checkNotNullExpressionValue(string2, "classOrObject.containingFile.name");
        String currentFileName = string2;
        boolean createWrapper = forceMethodWrapping;
        if (containingClass.element instanceof KtLightClassForFacade) {
            kotlinLanguage = KotlinLanguage.INSTANCE;
            containingClass.element = new LightClass(containingClass, currentFileName, kotlinLanguage){
                final /* synthetic */ String $currentFileName;
                {
                    this.$currentFileName = $currentFileName;
                    T t = $containingClass.element;
                    Intrinsics.checkNotNull(t, "null cannot be cast to non-null type org.jetbrains.kotlin.asJava.classes.KtLightClassForFacade");
                    super((PsiClass)((KtLightClassForFacade)t), (Language)$super_call_param$1);
                }

                @NotNull
                public String getName() {
                    return this.$currentFileName;
                }
            };
            createWrapper = true;
        }
        if (createWrapper) {
            kotlinLanguage = $classOrObject.getManager();
            Object t = containingClass.element;
            Intrinsics.checkNotNull(t);
            PsiClass psiClass2 = (PsiClass)t;
            KotlinLanguage kotlinLanguage2 = KotlinLanguage.INSTANCE;
            return (PsiElement)new LightMethod(method, name, (PsiManagerEx)kotlinLanguage, psiClass2, kotlinLanguage2){
                final /* synthetic */ String $name;
                {
                    this.$name = $name;
                    super((PsiManager)$super_call_param$1, $method, $super_call_param$2, (Language)$super_call_param$3);
                }

                @NotNull
                public PsiElement getParent() {
                    PsiClass psiClass = this.getContainingClass();
                    Intrinsics.checkNotNullExpressionValue(psiClass, "getContainingClass()");
                    return (PsiElement)psiClass;
                }

                @NotNull
                public String getName() {
                    return this.$name;
                }
            };
        }
        return (PsiElement)method;
    }
}

