/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.serialization.linkerissues;

import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.serialization.KotlinIrLinker;
import org.jetbrains.kotlin.backend.common.serialization.linkerissues.IrDisallowedErrorNode;
import org.jetbrains.kotlin.backend.common.serialization.linkerissues.IrSymbolTypeMismatchException;
import org.jetbrains.kotlin.backend.common.serialization.linkerissues.UnexpectedUnboundIrSymbols;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.util.IrMessageLogger;
import org.jetbrains.kotlin.ir.util.IrMessageLoggerKt;
import org.jetbrains.kotlin.ir.util.SymbolTable;
import org.jetbrains.kotlin.ir.util.SymbolTableKt;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a(\u0010\u0000\u001a\u00020\u0001\"\n\b\u0000\u0010\u0002\u0018\u0001*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0080\b\u0082\u0002\b\n\u0006\b\u0000\u001a\u0002\u0010\u0001\u001a/\u0010\u0006\u001a\u0002H\u0002\"\n\b\u0000\u0010\u0002\u0018\u0001*\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0080\b\u0082\u0002\n\n\b\b\u0000\u001a\u0004\u0010\u0001(\u0000\u00a2\u0006\u0002\u0010\t\u001a\u001a\u0010\n\u001a\u00020\u0001*\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u001a\u0010\n\u001a\u00020\u0001*\u00020\u00102\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u001a\u0010\n\u001a\u00020\u0001*\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f\u00f2\u0001\u0004\n\u00028\u0000\u00a8\u0006\u0012"}, d2={"checkErrorNodesAllowed", "", "T", "Lorg/jetbrains/kotlin/ir/declarations/IrAnnotationContainer;", "errorNodesAllowed", "", "checkSymbolType", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "symbol", "(Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;)Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "checkNoUnboundSymbols", "Lorg/jetbrains/kotlin/backend/common/serialization/KotlinIrLinker;", "symbolTable", "Lorg/jetbrains/kotlin/ir/util/SymbolTable;", "whenDetected", "", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "Lorg/jetbrains/kotlin/ir/util/IrMessageLogger;", "ir.serialization.common"})
public final class ChecksKt {
    public static final /* synthetic */ <T extends IrSymbol> T checkSymbolType(IrSymbol symbol2) {
        Intrinsics.checkNotNullParameter(symbol2, "symbol");
        boolean $i$f$checkSymbolType = false;
        Intrinsics.reifiedOperationMarker(3, "T");
        if (!(symbol2 instanceof IrSymbol)) {
            Intrinsics.reifiedOperationMarker(4, "T");
            throw new IrSymbolTypeMismatchException(IrSymbol.class, symbol2);
        }
        return (T)symbol2;
    }

    public static final /* synthetic */ <T extends IrAnnotationContainer> void checkErrorNodesAllowed(boolean errorNodesAllowed) {
        boolean $i$f$checkErrorNodesAllowed = false;
        if (!errorNodesAllowed) {
            Intrinsics.reifiedOperationMarker(4, "T");
            throw new IrDisallowedErrorNode(IrAnnotationContainer.class);
        }
    }

    public static final void checkNoUnboundSymbols(@NotNull KotlinIrLinker $this$checkNoUnboundSymbols, @NotNull SymbolTable symbolTable, @NotNull String whenDetected) {
        Intrinsics.checkNotNullParameter($this$checkNoUnboundSymbols, "<this>");
        Intrinsics.checkNotNullParameter(symbolTable, "symbolTable");
        Intrinsics.checkNotNullParameter(whenDetected, "whenDetected");
        if (!$this$checkNoUnboundSymbols.getUnlinkedDeclarationsSupport().getAllowUnboundSymbols()) {
            ChecksKt.checkNoUnboundSymbols($this$checkNoUnboundSymbols.getMessageLogger(), symbolTable, whenDetected);
        }
    }

    public static final void checkNoUnboundSymbols(@NotNull IrMessageLogger $this$checkNoUnboundSymbols, @NotNull SymbolTable symbolTable, @NotNull String whenDetected) {
        Intrinsics.checkNotNullParameter($this$checkNoUnboundSymbols, "<this>");
        Intrinsics.checkNotNullParameter(symbolTable, "symbolTable");
        Intrinsics.checkNotNullParameter(whenDetected, "whenDetected");
        Set<IrSymbol> unboundSymbols = SymbolTableKt.getAllUnbound(symbolTable);
        if (!((Collection)unboundSymbols).isEmpty()) {
            new UnexpectedUnboundIrSymbols(unboundSymbols, whenDetected).raiseIssue($this$checkNoUnboundSymbols);
            throw null;
        }
    }

    public static final void checkNoUnboundSymbols(@NotNull CompilerConfiguration $this$checkNoUnboundSymbols, @NotNull SymbolTable symbolTable, @NotNull String whenDetected) {
        Intrinsics.checkNotNullParameter($this$checkNoUnboundSymbols, "<this>");
        Intrinsics.checkNotNullParameter(symbolTable, "symbolTable");
        Intrinsics.checkNotNullParameter(whenDetected, "whenDetected");
        Set<IrSymbol> unboundSymbols = SymbolTableKt.getAllUnbound(symbolTable);
        if (!((Collection)unboundSymbols).isEmpty()) {
            new UnexpectedUnboundIrSymbols(unboundSymbols, whenDetected).raiseIssue(IrMessageLoggerKt.getIrMessageLogger($this$checkNoUnboundSymbols));
            throw null;
        }
    }
}

