/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.signaturer;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirVisibilityCheckerKt;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.backend.Fir2IrSignatureComposer;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousObject;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirField;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.impl.FirDefaultPropertyGetter;
import org.jetbrains.kotlin.fir.declarations.impl.FirDefaultPropertySetter;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.signaturer.FirMangler;
import org.jetbrains.kotlin.fir.signaturer.FirManglerUtilKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.visitors.FirVisitor;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0002,-B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000bH\u0002J,\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0014H\u0016J$\u0010\u0018\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0014H\u0016J$\u0010\u001b\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u0010H\u0016J\u0010\u0010!\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u001e\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00062\f\u0010%\u001a\b\u0012\u0004\u0012\u00020#0&H\u0016J\u0014\u0010'\u001a\u00020\u0006*\u00020\u001a2\u0006\u0010(\u001a\u00020\fH\u0002J\f\u0010)\u001a\u00020**\u00020\u0012H\u0002J\f\u0010+\u001a\u00020**\u00020\u0012H\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lorg/jetbrains/kotlin/fir/signaturer/FirBasedSignatureComposer;", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrSignatureComposer;", "mangler", "Lorg/jetbrains/kotlin/fir/signaturer/FirMangler;", "(Lorg/jetbrains/kotlin/fir/signaturer/FirMangler;)V", "fileSignature", "Lorg/jetbrains/kotlin/ir/util/IdSignature$FileSignature;", "getMangler", "()Lorg/jetbrains/kotlin/fir/signaturer/FirMangler;", "signatureCache", "", "Lorg/jetbrains/kotlin/fir/signaturer/FirBasedSignatureComposer$FirDeclarationWithParentId;", "Lorg/jetbrains/kotlin/ir/util/IdSignature$CommonSignature;", "calculatePublicSignature", "declarationWithParentId", "composeAccessorSignature", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "property", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "isSetter", "", "containingClass", "Lorg/jetbrains/kotlin/fir/symbols/ConeClassLikeLookupTag;", "forceTopLevelPrivate", "composeSignature", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "composeTypeParameterSignature", "typeParameter", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeParameter;", "index", "", "containerSignature", "isTopLevelPrivate", "withFileSignature", "", "sig", "body", "Lkotlin/Function0;", "fakeFileSignature", "commonSignature", "getterOrDefault", "Lorg/jetbrains/kotlin/fir/declarations/FirPropertyAccessor;", "setterOrDefault", "FirDeclarationWithParentId", "SignatureBuilder", "fir2ir"})
public final class FirBasedSignatureComposer
implements Fir2IrSignatureComposer {
    @NotNull
    private final FirMangler mangler;
    @Nullable
    private IdSignature.FileSignature fileSignature;
    @NotNull
    private final Map<FirDeclarationWithParentId, IdSignature.CommonSignature> signatureCache;

    public FirBasedSignatureComposer(@NotNull FirMangler mangler) {
        Intrinsics.checkNotNullParameter(mangler, "mangler");
        this.mangler = mangler;
        this.signatureCache = new LinkedHashMap();
    }

    @Override
    @NotNull
    public FirMangler getMangler() {
        return this.mangler;
    }

    @Override
    public void withFileSignature(@NotNull IdSignature.FileSignature sig, @NotNull Function0<Unit> body2) {
        Intrinsics.checkNotNullParameter(sig, "sig");
        Intrinsics.checkNotNullParameter(body2, "body");
        this.fileSignature = sig;
        body2.invoke();
        this.fileSignature = null;
    }

    @Override
    @Nullable
    public IdSignature composeSignature(@NotNull FirDeclaration declaration, @Nullable ConeClassLikeLookupTag containingClass, boolean forceTopLevelPrivate) {
        IdSignature idSignature;
        IdSignature.CommonSignature commonSignature;
        block11: {
            block12: {
                Intrinsics.checkNotNullParameter(declaration, "declaration");
                if (declaration instanceof FirAnonymousObject || declaration instanceof FirAnonymousFunction) {
                    return null;
                }
                if (declaration instanceof FirRegularClass && FirDeclarationUtilKt.getClassId((FirClass)declaration).isLocal()) {
                    return null;
                }
                if (!(declaration instanceof FirCallableDeclaration)) break block11;
                FirMemberDeclaration $this$visibility$iv = (FirMemberDeclaration)declaration;
                boolean $i$f$getVisibility = false;
                if (Intrinsics.areEqual($this$visibility$iv.getStatus().getVisibility(), Visibilities.Local.INSTANCE)) {
                    return null;
                }
                Object object = ClassMembersKt.dispatchReceiverClassOrNull((FirCallableDeclaration)declaration);
                if (object != null && (object = ((ConeClassLikeLookupTag)object).getClassId()) != null ? ((ClassId)object).isLocal() : false) break block12;
                Object object2 = containingClass;
                boolean bl = object2 != null && (object2 = ((ConeClassLikeLookupTag)object2).getClassId()) != null ? ((ClassId)object2).isLocal() : false;
                if (!bl) break block11;
            }
            return null;
        }
        ConeClassLikeLookupTag coneClassLikeLookupTag = containingClass;
        FirDeclarationWithParentId declarationWithParentId = new FirDeclarationWithParentId(declaration, coneClassLikeLookupTag != null ? coneClassLikeLookupTag.getClassId() : null);
        Map<FirDeclarationWithParentId, IdSignature.CommonSignature> $this$getOrPut$iv = this.signatureCache;
        boolean $i$f$getOrPut = false;
        IdSignature.CommonSignature value$iv = $this$getOrPut$iv.get(declarationWithParentId);
        if (value$iv == null) {
            boolean bl = false;
            IdSignature.CommonSignature answer$iv = this.calculatePublicSignature(declarationWithParentId);
            $this$getOrPut$iv.put(declarationWithParentId, answer$iv);
            commonSignature = answer$iv;
        } else {
            commonSignature = value$iv;
        }
        IdSignature.CommonSignature publicSignature = commonSignature;
        if (this.isTopLevelPrivate(declaration) || forceTopLevelPrivate) {
            IdSignature.FileSignature fileSignature = this.fileSignature;
            if (fileSignature == null) {
                fileSignature = this.fakeFileSignature(declaration, publicSignature);
            }
            IdSignature.FileSignature fileSig = fileSignature;
            idSignature = new IdSignature.CompositeSignature(fileSig, publicSignature);
        } else {
            idSignature = publicSignature;
        }
        IdSignature resultSignature = idSignature;
        return resultSignature;
    }

    private final IdSignature.CommonSignature calculatePublicSignature(FirDeclarationWithParentId declarationWithParentId) {
        IdSignature.CommonSignature commonSignature;
        FirDeclaration declaration = declarationWithParentId.component1();
        ClassId containingClassId = declarationWithParentId.component2();
        SignatureBuilder builder2 = new SignatureBuilder();
        try {
            declaration.accept(builder2, null);
        }
        catch (Throwable t) {
            throw new IllegalStateException("Error while composing signature for " + UtilsKt.render(declaration), t);
        }
        FirDeclaration firDeclaration = declaration;
        if (firDeclaration instanceof FirRegularClass) {
            ClassId classId = FirDeclarationUtilKt.getClassId((FirClass)declaration);
            String string2 = classId.getPackageFqName().asString();
            Intrinsics.checkNotNullExpressionValue(string2, "classId.packageFqName.asString()");
            String string3 = classId.getRelativeClassName().asString();
            Intrinsics.checkNotNullExpressionValue(string3, "classId.relativeClassName.asString()");
            commonSignature = new IdSignature.CommonSignature(string2, string3, builder2.getHashId(), builder2.getMask());
        } else if (firDeclaration instanceof FirTypeAlias) {
            ClassId classId = ((FirTypeAlias)declaration).getSymbol().getClassId();
            String string4 = classId.getPackageFqName().asString();
            Intrinsics.checkNotNullExpressionValue(string4, "classId.packageFqName.asString()");
            String string5 = classId.getRelativeClassName().asString();
            Intrinsics.checkNotNullExpressionValue(string5, "classId.relativeClassName.asString()");
            commonSignature = new IdSignature.CommonSignature(string4, string5, builder2.getHashId(), builder2.getMask());
        } else if (firDeclaration instanceof FirCallableDeclaration) {
            ClassId classId;
            Object object;
            ClassId classId2 = containingClassId;
            if (classId2 == null) {
                ConeClassLikeLookupTag coneClassLikeLookupTag = ClassMembersKt.containingClass((FirCallableDeclaration)declaration);
                classId2 = coneClassLikeLookupTag != null ? coneClassLikeLookupTag.getClassId() : null;
            }
            if ((object = (classId = classId2)) == null || (object = ((ClassId)object).getPackageFqName()) == null) {
                object = ((FirCallableDeclaration)declaration).getSymbol().getCallableId().getPackageName();
            }
            Intrinsics.checkNotNullExpressionValue(object, "classId?.packageFqName ?\u2026ol.callableId.packageName");
            Object packageName = object;
            Name callableName = FirManglerUtilKt.getIrName((FirCallableDeclaration)declaration);
            String string6 = ((FqName)packageName).asString();
            Intrinsics.checkNotNullExpressionValue(string6, "packageName.asString()");
            Object object2 = classId;
            if (object2 == null || (object2 = ((ClassId)object2).getRelativeClassName()) == null || (object2 = ((FqName)object2).child(callableName)) == null || (object2 = ((FqName)object2).asString()) == null) {
                object2 = callableName.asString();
            }
            Intrinsics.checkNotNullExpressionValue(object2, "classId?.relativeClassNa\u2026: callableName.asString()");
            commonSignature = new IdSignature.CommonSignature(string6, (String)object2, builder2.getHashId(), builder2.getMask());
        } else {
            throw new IllegalStateException(("Unsupported FIR declaration in signature composer: " + UtilsKt.render(declaration)).toString());
        }
        return commonSignature;
    }

    @Override
    @Nullable
    public IdSignature composeTypeParameterSignature(@NotNull FirTypeParameter typeParameter, int index2, @Nullable IdSignature containerSignature) {
        Intrinsics.checkNotNullParameter(typeParameter, "typeParameter");
        if (containerSignature == null) {
            return null;
        }
        return new IdSignature.CompositeSignature(containerSignature, new IdSignature.LocalSignature("<TP>", Long.valueOf(index2), null));
    }

    @Override
    @Nullable
    public IdSignature composeAccessorSignature(@NotNull FirProperty property2, boolean isSetter, @Nullable ConeClassLikeLookupTag containingClass, boolean forceTopLevelPrivate) {
        Intrinsics.checkNotNullParameter(property2, "property");
        IdSignature.CommonSignature propSig = null;
        IdSignature.FileSignature fileSig = null;
        IdSignature propertySignature = this.composeSignature(property2, containingClass, forceTopLevelPrivate);
        if (propertySignature instanceof IdSignature.CompositeSignature) {
            IdSignature idSignature = ((IdSignature.CompositeSignature)propertySignature).getInner();
            IdSignature.CommonSignature commonSignature = idSignature instanceof IdSignature.CommonSignature ? (IdSignature.CommonSignature)idSignature : null;
            if (commonSignature == null) {
                return null;
            }
            propSig = commonSignature;
            idSignature = ((IdSignature.CompositeSignature)propertySignature).getContainer();
            IdSignature.FileSignature fileSignature = idSignature instanceof IdSignature.FileSignature ? (IdSignature.FileSignature)idSignature : null;
            if (fileSignature == null) {
                return null;
            }
            fileSig = fileSignature;
        } else if (propertySignature instanceof IdSignature.CommonSignature) {
            propSig = (IdSignature.CommonSignature)propertySignature;
            fileSig = null;
        } else {
            return null;
        }
        FirMangler $this$composeAccessorSignature_u24lambda_u241 = this.getMangler();
        boolean bl = false;
        long id = isSetter ? $this$composeAccessorSignature_u24lambda_u241.signatureMangle(this.setterOrDefault(property2), false) : $this$composeAccessorSignature_u24lambda_u241.signatureMangle(this.getterOrDefault(property2), false);
        String accessorFqName = isSetter ? propSig.getDeclarationFqName() + ".<set-" + property2.getName().asString() + '>' : propSig.getDeclarationFqName() + ".<get-" + property2.getName().asString() + '>';
        IdSignature.CommonSignature commonSig = new IdSignature.CommonSignature(propSig.getPackageFqName(), accessorFqName, id, propSig.getMask());
        IdSignature.AccessorSignature accessorSig = new IdSignature.AccessorSignature(propSig, commonSig);
        return fileSig != null ? (IdSignature)new IdSignature.CompositeSignature(fileSig, accessorSig) : (IdSignature)accessorSig;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isTopLevelPrivate(FirDeclaration declaration) {
        if (FirVisibilityCheckerKt.getOwnerLookupTag(declaration.getSymbol()) != null) return false;
        if (!(declaration instanceof FirMemberDeclaration)) return false;
        FirMemberDeclaration $this$visibility$iv = (FirMemberDeclaration)declaration;
        boolean $i$f$getVisibility = false;
        if (!Intrinsics.areEqual($this$visibility$iv.getStatus().getVisibility(), Visibilities.Private.INSTANCE)) return false;
        return true;
    }

    private final IdSignature.FileSignature fakeFileSignature(FirDeclaration $this$fakeFileSignature, IdSignature.CommonSignature commonSignature) {
        return new IdSignature.FileSignature($this$fakeFileSignature, new FqName(commonSignature.getPackageFqName() + '.' + commonSignature.getDeclarationFqName()), "<unknown>");
    }

    private final FirPropertyAccessor getterOrDefault(FirProperty $this$getterOrDefault) {
        FirPropertyAccessor firPropertyAccessor = $this$getterOrDefault.getGetter();
        if (firPropertyAccessor == null) {
            FirMemberDeclaration $this$visibility$iv = $this$getterOrDefault;
            boolean $i$f$getVisibility = false;
            firPropertyAccessor = new FirDefaultPropertyGetter(null, $this$getterOrDefault.getModuleData(), $this$getterOrDefault.getOrigin(), $this$getterOrDefault.getReturnTypeRef(), $this$visibility$iv.getStatus().getVisibility(), $this$getterOrDefault.getSymbol(), null, null, null, 448, null);
        }
        return firPropertyAccessor;
    }

    private final FirPropertyAccessor setterOrDefault(FirProperty $this$setterOrDefault) {
        FirPropertyAccessor firPropertyAccessor = $this$setterOrDefault.getSetter();
        if (firPropertyAccessor == null) {
            FirMemberDeclaration $this$visibility$iv = $this$setterOrDefault;
            boolean $i$f$getVisibility = false;
            firPropertyAccessor = new FirDefaultPropertySetter(null, $this$setterOrDefault.getModuleData(), $this$setterOrDefault.getOrigin(), $this$setterOrDefault.getReturnTypeRef(), $this$visibility$iv.getStatus().getVisibility(), $this$setterOrDefault.getSymbol(), null, null, null, null, 960, null);
        }
        return firPropertyAccessor;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u001f\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/fir/signaturer/FirBasedSignatureComposer$FirDeclarationWithParentId;", "", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "(Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;Lorg/jetbrains/kotlin/name/ClassId;)V", "getClassId", "()Lorg/jetbrains/kotlin/name/ClassId;", "getDeclaration", "()Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "fir2ir"})
    private static final class FirDeclarationWithParentId {
        @NotNull
        private final FirDeclaration declaration;
        @Nullable
        private final ClassId classId;

        public FirDeclarationWithParentId(@NotNull FirDeclaration declaration, @Nullable ClassId classId) {
            Intrinsics.checkNotNullParameter(declaration, "declaration");
            this.declaration = declaration;
            this.classId = classId;
        }

        @NotNull
        public final FirDeclaration getDeclaration() {
            return this.declaration;
        }

        @Nullable
        public final ClassId getClassId() {
            return this.classId;
        }

        @NotNull
        public final FirDeclaration component1() {
            return this.declaration;
        }

        @Nullable
        public final ClassId component2() {
            return this.classId;
        }

        @NotNull
        public final FirDeclarationWithParentId copy(@NotNull FirDeclaration declaration, @Nullable ClassId classId) {
            Intrinsics.checkNotNullParameter(declaration, "declaration");
            return new FirDeclarationWithParentId(declaration, classId);
        }

        public static /* synthetic */ FirDeclarationWithParentId copy$default(FirDeclarationWithParentId firDeclarationWithParentId, FirDeclaration firDeclaration, ClassId classId, int n, Object object) {
            if ((n & 1) != 0) {
                firDeclaration = firDeclarationWithParentId.declaration;
            }
            if ((n & 2) != 0) {
                classId = firDeclarationWithParentId.classId;
            }
            return firDeclarationWithParentId.copy(firDeclaration, classId);
        }

        @NotNull
        public String toString() {
            return "FirDeclarationWithParentId(declaration=" + this.declaration + ", classId=" + this.classId + ')';
        }

        public int hashCode() {
            int result2 = this.declaration.hashCode();
            result2 = result2 * 31 + (this.classId == null ? 0 : this.classId.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FirDeclarationWithParentId)) {
                return false;
            }
            FirDeclarationWithParentId firDeclarationWithParentId = (FirDeclarationWithParentId)other;
            if (!Intrinsics.areEqual(this.declaration, firDeclarationWithParentId.declaration)) {
                return false;
            }
            return Intrinsics.areEqual(this.classId, firDeclarationWithParentId.classId);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001a\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u001e\u001a\u00020\u00022\u0006\u0010\u001f\u001a\u00020 2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010!\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020#2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010$\u001a\u00020\u00022\u0006\u0010%\u001a\u00020&2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010'\u001a\u00020\u00022\u0006\u0010(\u001a\u00020)2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010*\u001a\u00020\u00022\u0006\u0010+\u001a\u00020,2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0003H\u0016R\u001e\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000b\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\f\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006-"}, d2={"Lorg/jetbrains/kotlin/fir/signaturer/FirBasedSignatureComposer$SignatureBuilder;", "Lorg/jetbrains/kotlin/fir/visitors/FirVisitor;", "", "", "(Lorg/jetbrains/kotlin/fir/signaturer/FirBasedSignatureComposer;)V", "hashId", "", "getHashId", "()Ljava/lang/Long;", "setHashId", "(Ljava/lang/Long;)V", "Ljava/lang/Long;", "mask", "getMask", "()J", "setMask", "(J)V", "setExpected", "f", "", "visitConstructor", "constructor", "Lorg/jetbrains/kotlin/fir/declarations/FirConstructor;", "data", "visitElement", "element", "Lorg/jetbrains/kotlin/fir/FirElement;", "visitEnumEntry", "enumEntry", "Lorg/jetbrains/kotlin/fir/declarations/FirEnumEntry;", "visitField", "field", "Lorg/jetbrains/kotlin/fir/declarations/FirField;", "visitProperty", "property", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "visitRegularClass", "regularClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "visitSimpleFunction", "simpleFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "visitTypeAlias", "typeAlias", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;", "fir2ir"})
    public final class SignatureBuilder
    extends FirVisitor<Unit, Object> {
        @Nullable
        private Long hashId;
        private long mask;

        @Nullable
        public final Long getHashId() {
            return this.hashId;
        }

        public final void setHashId(@Nullable Long l) {
            this.hashId = l;
        }

        public final long getMask() {
            return this.mask;
        }

        public final void setMask(long l) {
            this.mask = l;
        }

        private final void setExpected(boolean f) {
            this.mask |= IdSignature.Flags.IS_EXPECT.encode(f);
        }

        @Override
        public void visitElement(@NotNull FirElement element, @Nullable Object data2) {
            Intrinsics.checkNotNullParameter(element, "element");
            String string2 = "Should not be here";
            throw new NotImplementedError("An operation is not implemented: " + string2);
        }

        @Override
        public void visitRegularClass(@NotNull FirRegularClass regularClass, @Nullable Object data2) {
            Intrinsics.checkNotNullParameter(regularClass, "regularClass");
            FirMemberDeclaration $this$isExpect$iv = regularClass;
            boolean $i$f$isExpect = false;
            this.setExpected($this$isExpect$iv.getStatus().isExpect());
        }

        @Override
        public void visitTypeAlias(@NotNull FirTypeAlias typeAlias, @Nullable Object data2) {
            Intrinsics.checkNotNullParameter(typeAlias, "typeAlias");
            FirMemberDeclaration $this$isExpect$iv = typeAlias;
            boolean $i$f$isExpect = false;
            this.setExpected($this$isExpect$iv.getStatus().isExpect());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void visitConstructor(@NotNull FirConstructor constructor2, @Nullable Object data2) {
            void $this$visitConstructor_u24lambda_u240;
            Intrinsics.checkNotNullParameter(constructor2, "constructor");
            FirMangler firMangler = FirBasedSignatureComposer.this.getMangler();
            SignatureBuilder signatureBuilder = this;
            boolean bl = false;
            signatureBuilder.hashId = $this$visitConstructor_u24lambda_u240.signatureMangle(constructor2, false);
            FirMemberDeclaration $this$isExpect$iv = constructor2;
            boolean $i$f$isExpect = false;
            this.setExpected($this$isExpect$iv.getStatus().isExpect());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void visitSimpleFunction(@NotNull FirSimpleFunction simpleFunction, @Nullable Object data2) {
            void $this$visitSimpleFunction_u24lambda_u241;
            Intrinsics.checkNotNullParameter(simpleFunction, "simpleFunction");
            FirMangler firMangler = FirBasedSignatureComposer.this.getMangler();
            SignatureBuilder signatureBuilder = this;
            boolean bl = false;
            signatureBuilder.hashId = $this$visitSimpleFunction_u24lambda_u241.signatureMangle(simpleFunction, false);
            FirMemberDeclaration $this$isExpect$iv = simpleFunction;
            boolean $i$f$isExpect = false;
            this.setExpected($this$isExpect$iv.getStatus().isExpect());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void visitProperty(@NotNull FirProperty property2, @Nullable Object data2) {
            void $this$visitProperty_u24lambda_u242;
            Intrinsics.checkNotNullParameter(property2, "property");
            FirMangler firMangler = FirBasedSignatureComposer.this.getMangler();
            SignatureBuilder signatureBuilder = this;
            boolean bl = false;
            signatureBuilder.hashId = $this$visitProperty_u24lambda_u242.signatureMangle(property2, false);
            FirMemberDeclaration $this$isExpect$iv = property2;
            boolean $i$f$isExpect = false;
            this.setExpected($this$isExpect$iv.getStatus().isExpect());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void visitField(@NotNull FirField field2, @Nullable Object data2) {
            void $this$visitField_u24lambda_u243;
            Intrinsics.checkNotNullParameter(field2, "field");
            FirMangler firMangler = FirBasedSignatureComposer.this.getMangler();
            SignatureBuilder signatureBuilder = this;
            boolean bl = false;
            signatureBuilder.hashId = $this$visitField_u24lambda_u243.signatureMangle(field2, false);
            FirMemberDeclaration $this$isExpect$iv = field2;
            boolean $i$f$isExpect = false;
            this.setExpected($this$isExpect$iv.getStatus().isExpect());
        }

        @Override
        public void visitEnumEntry(@NotNull FirEnumEntry enumEntry, @Nullable Object data2) {
            Intrinsics.checkNotNullParameter(enumEntry, "enumEntry");
            FirMemberDeclaration $this$isExpect$iv = enumEntry;
            boolean $i$f$isExpect = false;
            this.setExpected($this$isExpect$iv.getStatus().isExpect());
        }
    }
}

