/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.storage;

import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.incremental.storage.BasicStringMap;
import org.jetbrains.kotlin.incremental.storage.ICClassesAttributes;
import org.jetbrains.kotlin.incremental.storage.ICClassesAttributesExternalizer;
import org.jetbrains.kotlin.incremental.storage.LazyStorage;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0010\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0014J\u0013\u0010\t\u001a\u0004\u0018\u00010\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0086\u0002J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bJ\u0019\u0010\u000e\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u0002H\u0086\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/incremental/storage/ClassAttributesMap;", "Lorg/jetbrains/kotlin/incremental/storage/BasicStringMap;", "Lorg/jetbrains/kotlin/incremental/storage/ICClassesAttributes;", "storageFile", "Ljava/io/File;", "(Ljava/io/File;)V", "dumpValue", "", "value", "get", "key", "Lorg/jetbrains/kotlin/name/FqName;", "remove", "", "set", "kotlin-build-common"})
public class ClassAttributesMap
extends BasicStringMap<ICClassesAttributes> {
    public ClassAttributesMap(@NotNull File storageFile) {
        Intrinsics.checkNotNullParameter(storageFile, "storageFile");
        super(storageFile, ICClassesAttributesExternalizer.INSTANCE);
    }

    @Override
    @NotNull
    protected String dumpValue(@NotNull ICClassesAttributes value2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        return value2.toString();
    }

    public final void set(@NotNull FqName key, @NotNull ICClassesAttributes value2) {
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(value2, "value");
        LazyStorage<String, ICClassesAttributes> lazyStorage = this.getStorage();
        String string2 = key.asString();
        Intrinsics.checkNotNullExpressionValue(string2, "key.asString()");
        lazyStorage.set(string2, value2);
    }

    @Nullable
    public final ICClassesAttributes get(@NotNull FqName key) {
        Intrinsics.checkNotNullParameter(key, "key");
        LazyStorage lazyStorage = this.getStorage();
        String string2 = key.asString();
        Intrinsics.checkNotNullExpressionValue(string2, "key.asString()");
        return (ICClassesAttributes)lazyStorage.get(string2);
    }

    public final void remove(@NotNull FqName key) {
        Intrinsics.checkNotNullParameter(key, "key");
        LazyStorage lazyStorage = this.getStorage();
        String string2 = key.asString();
        Intrinsics.checkNotNullExpressionValue(string2, "key.asString()");
        lazyStorage.remove(string2);
    }
}

