/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.dce;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.JsStatementOrigins;
import org.jetbrains.kotlin.ir.backend.js.dce.JsUsefulDeclarationProcessorKt;
import org.jetbrains.kotlin.ir.backend.js.dce.UsefulDeclarationProcessor;
import org.jetbrains.kotlin.ir.backend.js.export.ExportModelGeneratorKt;
import org.jetbrains.kotlin.ir.backend.js.lower.MoveBodilessDeclarationsToSeparatePlaceKt;
import org.jetbrains.kotlin.ir.backend.js.utils.AnnotationUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.JsInlineClassesUtils;
import org.jetbrains.kotlin.ir.backend.js.utils.MiscKt;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0016\u001a\u00020\u0017H\u0014J\u0010\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u000fH\u0014J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u0015H\u0014J\u0010\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u000fH\u0014J\u0010\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001fH\u0014J\u0010\u0010 \u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u0015H\u0014J\f\u0010!\u001a\u00020\u0005*\u00020\u0015H\u0002R\u0018\u0010\b\u001a\u00060\tR\u00020\u0001X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0011\u001a\u0012\u0012\u0004\u0012\u00020\u000f0\u0012j\b\u0012\u0004\u0012\u00020\u000f`\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0014\u001a\u0012\u0012\u0004\u0012\u00020\u00150\u0012j\b\u0012\u0004\u0012\u00020\u0015`\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/dce/JsUsefulDeclarationProcessor;", "Lorg/jetbrains/kotlin/ir/backend/js/dce/UsefulDeclarationProcessor;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "printReachabilityInfo", "", "removeUnusedAssociatedObjects", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;ZZ)V", "bodyVisitor", "Lorg/jetbrains/kotlin/ir/backend/js/dce/UsefulDeclarationProcessor$BodyVisitorBase;", "getBodyVisitor", "()Lorg/jetbrains/kotlin/ir/backend/js/dce/UsefulDeclarationProcessor$BodyVisitorBase;", "getContext", "()Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "equalsMethod", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "hashCodeMethod", "referencedJsClasses", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "referencedJsClassesFromExpressions", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "handleAssociatedObjects", "", "isExported", "declaration", "processClass", "irClass", "processConstructedClassDeclaration", "processSimpleFunction", "irFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "processSuperTypes", "containsMetadata", "backend.js"})
public final class JsUsefulDeclarationProcessor
extends UsefulDeclarationProcessor {
    @NotNull
    private final JsIrBackendContext context;
    @NotNull
    private final IrDeclaration equalsMethod;
    @NotNull
    private final IrDeclaration hashCodeMethod;
    @NotNull
    private final UsefulDeclarationProcessor.BodyVisitorBase bodyVisitor;
    @NotNull
    private final HashSet<IrDeclaration> referencedJsClasses;
    @NotNull
    private final HashSet<IrClass> referencedJsClassesFromExpressions;

    public JsUsefulDeclarationProcessor(@NotNull JsIrBackendContext context, boolean printReachabilityInfo, boolean removeUnusedAssociatedObjects) {
        Intrinsics.checkNotNullParameter(context, "context");
        super(printReachabilityInfo, removeUnusedAssociatedObjects);
        this.context = context;
        this.equalsMethod = this.getMethodOfAny("equals");
        this.hashCodeMethod = this.getMethodOfAny("hashCode");
        this.bodyVisitor = new UsefulDeclarationProcessor.BodyVisitorBase(this){
            final /* synthetic */ JsUsefulDeclarationProcessor this$0;
            {
                this.this$0 = $receiver;
                super($receiver);
            }

            public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @NotNull IrDeclaration data2) {
                Intrinsics.checkNotNullParameter(expression2, "expression");
                Intrinsics.checkNotNullParameter(data2, "data");
                if (!Intrinsics.areEqual(expression2.getSymbol(), this.this$0.getContext().getIntrinsics().getImplementSymbol())) {
                    super.visitFunctionAccess(expression2, data2);
                }
            }

            /*
             * WARNING - void declaration
             */
            public void visitCall(@NotNull IrCall expression2, @NotNull IrDeclaration data2) {
                Intrinsics.checkNotNullParameter(expression2, "expression");
                Intrinsics.checkNotNullParameter(data2, "data");
                super.visitCall(expression2, data2);
                IrSimpleFunctionSymbol irSimpleFunctionSymbol = expression2.getSymbol();
                if (Intrinsics.areEqual(irSimpleFunctionSymbol, this.this$0.getContext().getIntrinsics().getJsBoxIntrinsic())) {
                    void $this$single$iv;
                    void $this$filterIsInstanceTo$iv$iv;
                    JsInlineClassesUtils jsInlineClassesUtils = this.this$0.getContext().getInlineClassesUtils();
                    IrType irType = expression2.getTypeArgument(0);
                    Intrinsics.checkNotNull(irType);
                    IrClass irClass2 = jsInlineClassesUtils.getInlinedClass(irType);
                    Intrinsics.checkNotNull(irClass2);
                    IrClass inlineClass = irClass2;
                    Iterable $this$filterIsInstance$iv = inlineClass.getDeclarations();
                    boolean $i$f$filterIsInstance = false;
                    Iterable iterable = $this$filterIsInstance$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterIsInstanceTo = false;
                    for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                        if (!(element$iv$iv instanceof IrConstructor)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$filterIsInstance$iv = (List)destination$iv$iv;
                    boolean $i$f$single = false;
                    Object single$iv = null;
                    boolean found$iv = false;
                    for (T element$iv : $this$single$iv) {
                        IrConstructor it = (IrConstructor)element$iv;
                        boolean bl = false;
                        if (!it.isPrimary()) continue;
                        if (found$iv) {
                            throw new IllegalArgumentException("Collection contains more than one matching element.");
                        }
                        single$iv = element$iv;
                        found$iv = true;
                    }
                    if (!found$iv) {
                        throw new NoSuchElementException("Collection contains no element matching the predicate.");
                    }
                    IrConstructor constructor2 = single$iv;
                    UsefulDeclarationProcessor.enqueue$default(this.this$0, constructor2, data2, "intrinsic: jsBoxIntrinsic", false, 4, null);
                } else if (Intrinsics.areEqual(irSimpleFunctionSymbol, this.this$0.getContext().getIntrinsics().getJsClass())) {
                    IrType irType = expression2.getTypeArgument(0);
                    Intrinsics.checkNotNull(irType);
                    IrSymbolOwner irSymbolOwner = IrTypesKt.getClassifierOrFail(irType).getOwner();
                    Intrinsics.checkNotNull(irSymbolOwner, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclaration");
                    IrDeclaration ref = (IrDeclaration)irSymbolOwner;
                    UsefulDeclarationProcessor.enqueue$default(this.this$0, ref, data2, "intrinsic: jsClass", false, 4, null);
                    ((Collection)JsUsefulDeclarationProcessor.access$getReferencedJsClasses$p(this.this$0)).add(ref);
                    if (Intrinsics.areEqual(expression2.getOrigin(), JsStatementOrigins.CLASS_REFERENCE.INSTANCE)) {
                        void $this$forEach$iv;
                        Sequence<IrConstructor> constructor2 = IrUtilsKt.getConstructors((IrClass)ref);
                        JsUsefulDeclarationProcessor $this$single$iv = this.this$0;
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            IrConstructor it = (IrConstructor)element$iv;
                            boolean bl = false;
                            UsefulDeclarationProcessor.enqueue$default($this$single$iv, it, data2, "intrinsic: jsClass (constructor)", false, 4, null);
                        }
                    }
                } else if (Intrinsics.areEqual(irSimpleFunctionSymbol, this.this$0.getContext().getReflectionSymbols().getGetKClassFromExpression())) {
                    Object object = expression2.getTypeArgument(0);
                    if (object == null || (object = IrTypesKt.getClassOrNull((IrType)object)) == null) {
                        object = this.this$0.getContext().getIrBuiltIns().getAnyClass();
                    }
                    Object ref = object;
                    ((Collection)JsUsefulDeclarationProcessor.access$getReferencedJsClassesFromExpressions$p(this.this$0)).add(ref.getOwner());
                } else if (Intrinsics.areEqual(irSimpleFunctionSymbol, this.this$0.getContext().getIntrinsics().getJsObjectCreate())) {
                    IrType irType = expression2.getTypeArgument(0);
                    Intrinsics.checkNotNull(irType);
                    IrSymbolOwner irSymbolOwner = IrTypesKt.getClassifierOrFail(irType).getOwner();
                    Intrinsics.checkNotNull(irSymbolOwner, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
                    IrClass classToCreate = (IrClass)irSymbolOwner;
                    UsefulDeclarationProcessor.enqueue$default(this.this$0, classToCreate, data2, "intrinsic: jsObjectCreate", false, 4, null);
                    ((Collection)this.this$0.getConstructedClasses()).add(classToCreate);
                } else if (Intrinsics.areEqual(irSimpleFunctionSymbol, this.this$0.getContext().getIntrinsics().getJsEquals())) {
                    UsefulDeclarationProcessor.enqueue$default(this.this$0, JsUsefulDeclarationProcessor.access$getEqualsMethod$p(this.this$0), data2, "intrinsic: jsEquals", false, 4, null);
                } else if (Intrinsics.areEqual(irSimpleFunctionSymbol, this.this$0.getContext().getIntrinsics().getJsToString())) {
                    UsefulDeclarationProcessor.enqueue$default(this.this$0, this.this$0.getToStringMethod(), data2, "intrinsic: jsToString", false, 4, null);
                } else if (Intrinsics.areEqual(irSimpleFunctionSymbol, this.this$0.getContext().getIntrinsics().getJsHashCode())) {
                    UsefulDeclarationProcessor.enqueue$default(this.this$0, JsUsefulDeclarationProcessor.access$getHashCodeMethod$p(this.this$0), data2, "intrinsic: jsHashCode", false, 4, null);
                } else if (Intrinsics.areEqual(irSimpleFunctionSymbol, this.this$0.getContext().getIntrinsics().getJsPlus())) {
                    Object object = expression2.getValueArgument(0);
                    if (Intrinsics.areEqual(object != null && (object = ((IrExpression)object).getType()) != null ? IrTypesKt.getClassOrNull((IrType)object) : null, this.this$0.getContext().getIrBuiltIns().getStringClass())) {
                        UsefulDeclarationProcessor.enqueue$default(this.this$0, this.this$0.getToStringMethod(), data2, "intrinsic: jsPlus", false, 4, null);
                    }
                } else if (Intrinsics.areEqual(irSimpleFunctionSymbol, this.this$0.getContext().getIntrinsics().getJsConstruct())) {
                    IrType irType = expression2.getTypeArgument(0);
                    Intrinsics.checkNotNull(irType);
                    IrType callType = irType;
                    IrClass irClass3 = IrTypesKt.getClass(callType);
                    Intrinsics.checkNotNull(irClass3);
                    IrConstructor constructor3 = IrUtilsKt.getPrimaryConstructor(irClass3);
                    UsefulDeclarationProcessor usefulDeclarationProcessor = this.this$0;
                    IrConstructor irConstructor2 = constructor3;
                    Intrinsics.checkNotNull(irConstructor2);
                    UsefulDeclarationProcessor.enqueue$default(usefulDeclarationProcessor, irConstructor2, data2, "ctor call from jsConstruct-intrinsic", false, 4, null);
                } else if (Intrinsics.areEqual(irSimpleFunctionSymbol, this.this$0.getContext().getIntrinsics().getEs6DefaultType())) {
                    IrType irType = expression2.getTypeArgument(0);
                    Intrinsics.checkNotNull(irType);
                    IrSymbolOwner irSymbolOwner = IrTypesKt.getClassifierOrFail(irType).getOwner();
                    Intrinsics.checkNotNull(irSymbolOwner, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclaration");
                    IrDeclaration ref = (IrDeclaration)irSymbolOwner;
                    UsefulDeclarationProcessor.enqueue$default(this.this$0, ref, data2, "intrinsic: jsClass", false, 4, null);
                    ((Collection)JsUsefulDeclarationProcessor.access$getReferencedJsClasses$p(this.this$0)).add(ref);
                    IrType irType2 = expression2.getTypeArgument(0);
                    Intrinsics.checkNotNull(irType2);
                    IrType arg = irType2;
                    IrClass klass = IrTypesKt.getClass(arg);
                    if (klass != null) {
                        this.this$0.getConstructedClasses().add(klass);
                    }
                } else if ((Intrinsics.areEqual(irSimpleFunctionSymbol, this.this$0.getContext().getIntrinsics().getJsInvokeSuspendSuperType()) ? true : Intrinsics.areEqual(irSimpleFunctionSymbol, this.this$0.getContext().getIntrinsics().getJsInvokeSuspendSuperTypeWithReceiver())) ? true : Intrinsics.areEqual(irSimpleFunctionSymbol, this.this$0.getContext().getIntrinsics().getJsInvokeSuspendSuperTypeWithReceiverAndParam())) {
                    UsefulDeclarationProcessor.enqueue$default(this.this$0, MiscKt.invokeFunForLambda(expression2), data2, "intrinsic: suspendSuperType", false, 4, null);
                }
            }
        };
        this.referencedJsClasses = new HashSet();
        this.referencedJsClassesFromExpressions = new HashSet();
    }

    @Override
    @NotNull
    public JsIrBackendContext getContext() {
        return this.context;
    }

    @Override
    @NotNull
    protected UsefulDeclarationProcessor.BodyVisitorBase getBodyVisitor() {
        return this.bodyVisitor;
    }

    @Override
    protected void processSuperTypes(@NotNull IrClass irClass2) {
        Intrinsics.checkNotNullParameter(irClass2, "irClass");
        Iterable $this$forEach$iv = irClass2.getSuperTypes();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object;
            IrClassSymbol irClassSymbol;
            IrType it = (IrType)element$iv;
            boolean bl = false;
            if (IrTypeUtilsKt.isInterface(it) || (irClassSymbol = (object = IrTypesKt.getClassifierOrNull(it)) instanceof IrClassSymbol ? (IrClassSymbol)object : null) == null || (object = (IrClass)irClassSymbol.getOwner()) == null) continue;
            UsefulDeclarationProcessor.enqueue$default(this, (IrDeclaration)object, irClass2, "superTypes", false, 4, null);
        }
    }

    @Override
    protected void processClass(@NotNull IrClass irClass2) {
        Intrinsics.checkNotNullParameter(irClass2, "irClass");
        super.processClass(irClass2);
        if (this.containsMetadata(irClass2)) {
            if (IrUtilsKt.isObject(irClass2)) {
                UsefulDeclarationProcessor.enqueue$default(this, (IrDeclaration)this.getContext().getIntrinsics().getMetadataObjectConstructorSymbol().getOwner(), irClass2, "object metadata", false, 4, null);
            } else if (IrUtilsKt.isInterface(irClass2)) {
                UsefulDeclarationProcessor.enqueue$default(this, (IrDeclaration)this.getContext().getIntrinsics().getImplementSymbol().getOwner(), irClass2, "interface metadata", false, 4, null);
                UsefulDeclarationProcessor.enqueue$default(this, (IrDeclaration)this.getContext().getIntrinsics().getMetadataInterfaceConstructorSymbol().getOwner(), irClass2, "interface metadata", false, 4, null);
            } else {
                UsefulDeclarationProcessor.enqueue$default(this, (IrDeclaration)this.getContext().getIntrinsics().getMetadataClassConstructorSymbol().getOwner(), irClass2, "class metadata", false, 4, null);
            }
            UsefulDeclarationProcessor.enqueue$default(this, (IrDeclaration)this.getContext().getIntrinsics().getSetMetadataForSymbol().getOwner(), irClass2, "metadata", false, 4, null);
        }
    }

    @Override
    protected void processSimpleFunction(@NotNull IrSimpleFunction irFunction2) {
        IrClass irClass2;
        Intrinsics.checkNotNullParameter(irFunction2, "irFunction");
        super.processSimpleFunction(irFunction2);
        if (AdditionalIrUtilsKt.isReal(irFunction2) && irFunction2.getBody() != null && (irClass2 = IrUtilsKt.getParentClassOrNull(irFunction2)) != null) {
            IrClass irClass3;
            IrClass irClass4;
            IrClass it = irClass4 = irClass2;
            boolean bl = false;
            IrClass irClass5 = irClass3 = IrUtilsKt.isInterface(it) ? irClass4 : null;
            if (irClass3 != null) {
                UsefulDeclarationProcessor.enqueue$default(this, irClass3, irFunction2, "interface default method is used", false, 4, null);
            }
        }
    }

    private final boolean containsMetadata(IrClass $this$containsMetadata) {
        return !$this$containsMetadata.isExternal() && !$this$containsMetadata.isExpect() && !MoveBodilessDeclarationsToSeparatePlaceKt.isBuiltInClass($this$containsMetadata);
    }

    @Override
    protected void processConstructedClassDeclaration(@NotNull IrDeclaration declaration) {
        Object object;
        Object object2;
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        if (this.getResult().contains(declaration)) {
            return;
        }
        super.processConstructedClassDeclaration(declaration);
        if (declaration instanceof IrSimpleFunction && Intrinsics.areEqual(AnnotationUtilsKt.getJsNameOrKotlinName((IrDeclarationWithName)declaration).asString(), "valueOf")) {
            UsefulDeclarationProcessor.enqueue$default(this, declaration, declaration, "valueOf", false, 4, null);
        }
        if (AnnotationUtilsKt.getJsName(declaration) != null || declaration instanceof IrField && ((object2 = ((IrField)declaration).getCorrespondingPropertySymbol()) != null && (object2 = (IrProperty)object2.getOwner()) != null ? AnnotationUtilsKt.getJsName((IrAnnotationContainer)object2) : null) != null || declaration instanceof IrSimpleFunction && ((object = ((IrSimpleFunction)declaration).getCorrespondingPropertySymbol()) != null && (object = (IrProperty)object.getOwner()) != null ? AnnotationUtilsKt.getJsName((IrAnnotationContainer)object) : null) != null) {
            UsefulDeclarationProcessor.enqueue$default(this, declaration, declaration, "annotated by @JsName", false, 4, null);
        }
    }

    @Override
    protected void handleAssociatedObjects() {
        CollectionsKt.addAll((Collection)this.referencedJsClassesFromExpressions, JsUsefulDeclarationProcessorKt.access$filterDescendantsOf(this.getConstructedClasses(), this.referencedJsClassesFromExpressions));
        for (IrClass klass : this.getClassesWithObjectAssociations()) {
            if (this.getRemoveUnusedAssociatedObjects() && !this.referencedJsClasses.contains(klass) && !this.referencedJsClassesFromExpressions.contains(klass)) continue;
            for (IrConstructorCall annotation2 : klass.getAnnotations()) {
                IrClass obj;
                IrClass annotationClass = AdditionalIrUtilsKt.getConstructedClass((IrConstructor)annotation2.getSymbol().getOwner());
                if (this.getRemoveUnusedAssociatedObjects() && !this.referencedJsClasses.contains(annotationClass)) continue;
                if (AnnotationUtilsKt.associatedObject(annotation2) == null) continue;
                boolean bl = false;
                IrSimpleFunction irSimpleFunction = this.getContext().getMapping().getObjectToGetInstanceFunction().get((IrClass)((IrDeclaration)obj));
                if (irSimpleFunction == null) continue;
                UsefulDeclarationProcessor usefulDeclarationProcessor = this;
                IrDeclaration irDeclaration2 = irSimpleFunction;
                Intrinsics.checkNotNullExpressionValue(klass, "klass");
                UsefulDeclarationProcessor.enqueue$default(usefulDeclarationProcessor, irDeclaration2, klass, "associated object factory", false, 4, null);
            }
        }
    }

    @Override
    protected boolean isExported(@NotNull IrDeclaration declaration) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        return ExportModelGeneratorKt.isExported(declaration, this.getContext());
    }

    public static final /* synthetic */ HashSet access$getReferencedJsClasses$p(JsUsefulDeclarationProcessor $this) {
        return $this.referencedJsClasses;
    }

    public static final /* synthetic */ HashSet access$getReferencedJsClassesFromExpressions$p(JsUsefulDeclarationProcessor $this) {
        return $this.referencedJsClassesFromExpressions;
    }

    public static final /* synthetic */ IrDeclaration access$getEqualsMethod$p(JsUsefulDeclarationProcessor $this) {
        return $this.equalsMethod;
    }

    public static final /* synthetic */ IrDeclaration access$getHashCodeMethod$p(JsUsefulDeclarationProcessor $this) {
        return $this.hashCodeMethod;
    }
}

