/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.jvm.serialization;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.overrides.FakeOverrideBuilder;
import org.jetbrains.kotlin.backend.common.serialization.BasicIrModuleDeserializer;
import org.jetbrains.kotlin.backend.common.serialization.CurrentModuleDeserializer;
import org.jetbrains.kotlin.backend.common.serialization.DescriptorByIdSignatureFinderImpl;
import org.jetbrains.kotlin.backend.common.serialization.DeserializationStrategy;
import org.jetbrains.kotlin.backend.common.serialization.IrModuleDeserializer;
import org.jetbrains.kotlin.backend.common.serialization.IrModuleDeserializerKind;
import org.jetbrains.kotlin.backend.common.serialization.KotlinIrLinker;
import org.jetbrains.kotlin.backend.common.serialization.encodings.BinarySymbolData;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeserializedDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.konan.KlibModuleOrigin;
import org.jetbrains.kotlin.ir.backend.jvm.serialization.JvmDescriptorMangler;
import org.jetbrains.kotlin.ir.backend.jvm.serialization.JvmIrMangler;
import org.jetbrains.kotlin.ir.builders.TranslationPluginContext;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.impl.IrModuleFragmentImpl;
import org.jetbrains.kotlin.ir.symbols.IrFieldSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrTypeSystemContext;
import org.jetbrains.kotlin.ir.util.DeclarationStubGenerator;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.ir.util.IrMessageLogger;
import org.jetbrains.kotlin.ir.util.SymbolTable;
import org.jetbrains.kotlin.library.IrLibrary;
import org.jetbrains.kotlin.library.KotlinAbiVersion;
import org.jetbrains.kotlin.library.KotlinLibrary;
import org.jetbrains.kotlin.load.java.descriptors.JavaCallableMemberDescriptor;
import org.jetbrains.kotlin.load.java.descriptors.JavaClassDescriptor;
import org.jetbrains.kotlin.load.java.lazy.descriptors.LazyJavaPackageFragment;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0003567BI\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\u001e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001c0 H\u0014J.\u0010!\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020\u00032\b\u0010#\u001a\u0004\u0018\u00010$2\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020(0&H\u0014J\u0010\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0002J\u0012\u0010-\u001a\u0004\u0018\u00010.2\u0006\u0010+\u001a\u00020/H\u0016J\u0010\u00100\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020\u0003H\u0014J\u0010\u00101\u001a\u00020\u00112\u0006\u0010+\u001a\u00020/H\u0014J\f\u00102\u001a\u00020\u0011*\u000203H\u0002J\f\u00104\u001a\u00020\u0011*\u000203H\u0002R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u00068"}, d2={"Lorg/jetbrains/kotlin/ir/backend/jvm/serialization/JvmIrLinker;", "Lorg/jetbrains/kotlin/backend/common/serialization/KotlinIrLinker;", "currentModule", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "messageLogger", "Lorg/jetbrains/kotlin/ir/util/IrMessageLogger;", "typeSystem", "Lorg/jetbrains/kotlin/ir/types/IrTypeSystemContext;", "symbolTable", "Lorg/jetbrains/kotlin/ir/util/SymbolTable;", "translationPluginContext", "Lorg/jetbrains/kotlin/ir/builders/TranslationPluginContext;", "stubGenerator", "Lorg/jetbrains/kotlin/ir/util/DeclarationStubGenerator;", "manglerDesc", "Lorg/jetbrains/kotlin/ir/backend/jvm/serialization/JvmDescriptorMangler;", "enableIdSignatures", "", "(Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lorg/jetbrains/kotlin/ir/util/IrMessageLogger;Lorg/jetbrains/kotlin/ir/types/IrTypeSystemContext;Lorg/jetbrains/kotlin/ir/util/SymbolTable;Lorg/jetbrains/kotlin/ir/builders/TranslationPluginContext;Lorg/jetbrains/kotlin/ir/util/DeclarationStubGenerator;Lorg/jetbrains/kotlin/ir/backend/jvm/serialization/JvmDescriptorMangler;Z)V", "fakeOverrideBuilder", "Lorg/jetbrains/kotlin/backend/common/overrides/FakeOverrideBuilder;", "getFakeOverrideBuilder", "()Lorg/jetbrains/kotlin/backend/common/overrides/FakeOverrideBuilder;", "javaName", "Lorg/jetbrains/kotlin/name/Name;", "getTranslationPluginContext", "()Lorg/jetbrains/kotlin/ir/builders/TranslationPluginContext;", "createCurrentModuleDeserializer", "Lorg/jetbrains/kotlin/backend/common/serialization/IrModuleDeserializer;", "moduleFragment", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "dependencies", "", "createModuleDeserializer", "moduleDescriptor", "klib", "Lorg/jetbrains/kotlin/library/KotlinLibrary;", "strategyResolver", "Lkotlin/Function1;", "", "Lorg/jetbrains/kotlin/backend/common/serialization/DeserializationStrategy;", "declareJavaFieldStub", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "symbol", "Lorg/jetbrains/kotlin/ir/symbols/IrFieldSymbol;", "getDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "isBuiltInModule", "platformSpecificSymbol", "isCleanDescriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "isJavaDescriptor", "JvmCurrentModuleDeserializer", "JvmModuleDeserializer", "MetadataJVMModuleDeserializer", "ir.serialization.jvm"})
public final class JvmIrLinker
extends KotlinIrLinker {
    @Nullable
    private final TranslationPluginContext translationPluginContext;
    @NotNull
    private final DeclarationStubGenerator stubGenerator;
    @NotNull
    private final JvmDescriptorMangler manglerDesc;
    private final boolean enableIdSignatures;
    @NotNull
    private final FakeOverrideBuilder fakeOverrideBuilder;
    @NotNull
    private final Name javaName;

    public JvmIrLinker(@Nullable ModuleDescriptor currentModule, @NotNull IrMessageLogger messageLogger, @NotNull IrTypeSystemContext typeSystem, @NotNull SymbolTable symbolTable, @Nullable TranslationPluginContext translationPluginContext, @NotNull DeclarationStubGenerator stubGenerator, @NotNull JvmDescriptorMangler manglerDesc, boolean enableIdSignatures) {
        Intrinsics.checkNotNullParameter(messageLogger, "messageLogger");
        Intrinsics.checkNotNullParameter(typeSystem, "typeSystem");
        Intrinsics.checkNotNullParameter(symbolTable, "symbolTable");
        Intrinsics.checkNotNullParameter(stubGenerator, "stubGenerator");
        Intrinsics.checkNotNullParameter(manglerDesc, "manglerDesc");
        super(currentModule, messageLogger, typeSystem.getIrBuiltIns(), symbolTable, CollectionsKt.emptyList(), null, 32, null);
        this.translationPluginContext = translationPluginContext;
        this.stubGenerator = stubGenerator;
        this.manglerDesc = manglerDesc;
        this.enableIdSignatures = enableIdSignatures;
        this.fakeOverrideBuilder = new FakeOverrideBuilder(this, symbolTable, JvmIrMangler.INSTANCE, typeSystem, MapsKt.emptyMap(), null, null, 96, null);
        Name name = Name.identifier("java");
        Intrinsics.checkNotNullExpressionValue(name, "identifier(\"java\")");
        this.javaName = name;
    }

    @Override
    @Nullable
    public TranslationPluginContext getTranslationPluginContext() {
        return this.translationPluginContext;
    }

    @Override
    @NotNull
    public FakeOverrideBuilder getFakeOverrideBuilder() {
        return this.fakeOverrideBuilder;
    }

    @Override
    protected boolean isBuiltInModule(@NotNull ModuleDescriptor moduleDescriptor) {
        Intrinsics.checkNotNullParameter(moduleDescriptor, "moduleDescriptor");
        String string2 = moduleDescriptor.getName().asString();
        Intrinsics.checkNotNullExpressionValue(string2, "moduleDescriptor.name.asString()");
        return StringsKt.startsWith$default(string2, "<dependencies of ", false, 2, null);
    }

    @Override
    @NotNull
    protected IrModuleDeserializer createModuleDeserializer(@NotNull ModuleDescriptor moduleDescriptor, @Nullable KotlinLibrary klib, @NotNull Function1<? super String, ? extends DeserializationStrategy> strategyResolver2) {
        Intrinsics.checkNotNullParameter(moduleDescriptor, "moduleDescriptor");
        Intrinsics.checkNotNullParameter(strategyResolver2, "strategyResolver");
        if (klib != null) {
            boolean bl;
            boolean bl2 = bl = moduleDescriptor.getCapability(KlibModuleOrigin.Companion.getCAPABILITY()) != null;
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            IrLibrary irLibrary = klib;
            KotlinAbiVersion kotlinAbiVersion = klib.getVersions().getAbiVersion();
            if (kotlinAbiVersion == null) {
                kotlinAbiVersion = KotlinAbiVersion.Companion.getCURRENT();
            }
            return new JvmModuleDeserializer(moduleDescriptor, irLibrary, kotlinAbiVersion, strategyResolver2);
        }
        return new MetadataJVMModuleDeserializer(moduleDescriptor, CollectionsKt.emptyList());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isJavaDescriptor(DeclarationDescriptor $this$isJavaDescriptor) {
        if ($this$isJavaDescriptor instanceof PackageFragmentDescriptor) {
            if ($this$isJavaDescriptor instanceof LazyJavaPackageFragment) return true;
            if (!((PackageFragmentDescriptor)$this$isJavaDescriptor).getFqName().startsWith(this.javaName)) return false;
            return true;
        }
        if ($this$isJavaDescriptor instanceof JavaClassDescriptor) return true;
        if ($this$isJavaDescriptor instanceof JavaCallableMemberDescriptor) return true;
        DeclarationDescriptor declarationDescriptor = $this$isJavaDescriptor.getContainingDeclaration();
        if (declarationDescriptor == null) return false;
        if (!this.isJavaDescriptor(declarationDescriptor)) return false;
        return true;
    }

    private final boolean isCleanDescriptor(DeclarationDescriptor $this$isCleanDescriptor) {
        if ($this$isCleanDescriptor instanceof PropertyAccessorDescriptor) {
            PropertyDescriptor propertyDescriptor = ((PropertyAccessorDescriptor)$this$isCleanDescriptor).getCorrespondingProperty();
            Intrinsics.checkNotNullExpressionValue(propertyDescriptor, "correspondingProperty");
            return this.isCleanDescriptor(propertyDescriptor);
        }
        return $this$isCleanDescriptor instanceof DeserializedDescriptor;
    }

    @Override
    protected boolean platformSpecificSymbol(@NotNull IrSymbol symbol2) {
        Intrinsics.checkNotNullParameter(symbol2, "symbol");
        return this.isJavaDescriptor(symbol2.getDescriptor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final IrField declareJavaFieldStub(IrFieldSymbol symbol2) {
        IrField irField;
        DeclarationStubGenerator $this$declareJavaFieldStub_u24lambda_u240 = this.stubGenerator;
        boolean bl = false;
        boolean old = this.stubGenerator.getUnboundSymbolGeneration();
        try {
            this.stubGenerator.setUnboundSymbolGeneration(true);
            irField = $this$declareJavaFieldStub_u24lambda_u240.generateFieldStub((PropertyDescriptor)symbol2.getDescriptor());
        }
        finally {
            this.stubGenerator.setUnboundSymbolGeneration(old);
        }
        return irField;
    }

    @Override
    @Nullable
    public IrDeclaration getDeclaration(@NotNull IrSymbol symbol2) {
        Intrinsics.checkNotNullParameter(symbol2, "symbol");
        return this.deserializeOrResolveDeclaration(symbol2, !this.enableIdSignatures);
    }

    @Override
    @NotNull
    protected IrModuleDeserializer createCurrentModuleDeserializer(@NotNull IrModuleFragment moduleFragment2, @NotNull Collection<? extends IrModuleDeserializer> dependencies2) {
        Intrinsics.checkNotNullParameter(moduleFragment2, "moduleFragment");
        Intrinsics.checkNotNullParameter(dependencies2, "dependencies");
        return new JvmCurrentModuleDeserializer(moduleFragment2, dependencies2);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\u0002\u0010\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/ir/backend/jvm/serialization/JvmIrLinker$JvmModuleDeserializer;", "Lorg/jetbrains/kotlin/backend/common/serialization/BasicIrModuleDeserializer;", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "klib", "Lorg/jetbrains/kotlin/library/IrLibrary;", "libraryAbiVersion", "Lorg/jetbrains/kotlin/library/KotlinAbiVersion;", "strategyResolver", "Lkotlin/Function1;", "", "Lorg/jetbrains/kotlin/backend/common/serialization/DeserializationStrategy;", "(Lorg/jetbrains/kotlin/ir/backend/jvm/serialization/JvmIrLinker;Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lorg/jetbrains/kotlin/library/IrLibrary;Lorg/jetbrains/kotlin/library/KotlinAbiVersion;Lkotlin/jvm/functions/Function1;)V", "ir.serialization.jvm"})
    private final class JvmModuleDeserializer
    extends BasicIrModuleDeserializer {
        public JvmModuleDeserializer(@NotNull ModuleDescriptor moduleDescriptor, @NotNull IrLibrary klib, @NotNull KotlinAbiVersion libraryAbiVersion, Function1<? super String, ? extends DeserializationStrategy> strategyResolver2) {
            Intrinsics.checkNotNullParameter(moduleDescriptor, "moduleDescriptor");
            Intrinsics.checkNotNullParameter(klib, "klib");
            Intrinsics.checkNotNullParameter(libraryAbiVersion, "libraryAbiVersion");
            Intrinsics.checkNotNullParameter(strategyResolver2, "strategyResolver");
            super(JvmIrLinker.this, moduleDescriptor, klib, strategyResolver2, libraryAbiVersion, false, 32, null);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0011\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0096\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0012\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u001a\u0010!\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020#H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00010\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/ir/backend/jvm/serialization/JvmIrLinker$MetadataJVMModuleDeserializer;", "Lorg/jetbrains/kotlin/backend/common/serialization/IrModuleDeserializer;", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "dependencies", "", "(Lorg/jetbrains/kotlin/ir/backend/jvm/serialization/JvmIrLinker;Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Ljava/util/List;)V", "descriptorFinder", "Lorg/jetbrains/kotlin/backend/common/serialization/DescriptorByIdSignatureFinderImpl;", "kind", "Lorg/jetbrains/kotlin/backend/common/serialization/IrModuleDeserializerKind;", "getKind", "()Lorg/jetbrains/kotlin/backend/common/serialization/IrModuleDeserializerKind;", "moduleDependencies", "", "getModuleDependencies", "()Ljava/util/Collection;", "moduleFragment", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "getModuleFragment", "()Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "contains", "", "idSig", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "declareIrSymbol", "", "symbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "deserializedSymbolNotFound", "", "resolveDescriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "tryDeserializeIrSymbol", "symbolKind", "Lorg/jetbrains/kotlin/backend/common/serialization/encodings/BinarySymbolData$SymbolKind;", "ir.serialization.jvm"})
    private final class MetadataJVMModuleDeserializer
    extends IrModuleDeserializer {
        @NotNull
        private final DescriptorByIdSignatureFinderImpl descriptorFinder;
        @NotNull
        private final IrModuleFragment moduleFragment;
        @NotNull
        private final Collection<IrModuleDeserializer> moduleDependencies;

        public MetadataJVMModuleDeserializer(@NotNull ModuleDescriptor moduleDescriptor, List<? extends IrModuleDeserializer> dependencies2) {
            Intrinsics.checkNotNullParameter(moduleDescriptor, "moduleDescriptor");
            Intrinsics.checkNotNullParameter(dependencies2, "dependencies");
            super(moduleDescriptor, KotlinAbiVersion.Companion.getCURRENT());
            this.descriptorFinder = new DescriptorByIdSignatureFinderImpl(moduleDescriptor, JvmIrLinker.this.manglerDesc, DescriptorByIdSignatureFinderImpl.LookupMode.MODULE_ONLY);
            this.moduleFragment = new IrModuleFragmentImpl(moduleDescriptor, JvmIrLinker.this.getBuiltIns(), CollectionsKt.emptyList());
            this.moduleDependencies = dependencies2;
        }

        @Override
        public boolean contains(@NotNull IdSignature idSig) {
            Intrinsics.checkNotNullParameter(idSig, "idSig");
            return true;
        }

        private final DeclarationDescriptor resolveDescriptor(IdSignature idSig) {
            return this.descriptorFinder.findDescriptorBySignature(idSig);
        }

        @Override
        @Nullable
        public IrSymbol tryDeserializeIrSymbol(@NotNull IdSignature idSig, @NotNull BinarySymbolData.SymbolKind symbolKind) {
            IrDeclaration irDeclaration2;
            Intrinsics.checkNotNullParameter(idSig, "idSig");
            Intrinsics.checkNotNullParameter((Object)symbolKind, "symbolKind");
            DeclarationDescriptor declarationDescriptor = this.resolveDescriptor(idSig);
            if (declarationDescriptor == null) {
                return null;
            }
            DeclarationDescriptor descriptor2 = declarationDescriptor;
            DeclarationStubGenerator $this$tryDeserializeIrSymbol_u24lambda_u240 = JvmIrLinker.this.stubGenerator;
            boolean bl = false;
            switch (WhenMappings.$EnumSwitchMapping$0[symbolKind.ordinal()]) {
                case 1: {
                    irDeclaration2 = $this$tryDeserializeIrSymbol_u24lambda_u240.generateClassStub((ClassDescriptor)descriptor2);
                    break;
                }
                case 2: {
                    irDeclaration2 = $this$tryDeserializeIrSymbol_u24lambda_u240.generatePropertyStub((PropertyDescriptor)descriptor2);
                    break;
                }
                case 3: {
                    irDeclaration2 = DeclarationStubGenerator.generateFunctionStub$default($this$tryDeserializeIrSymbol_u24lambda_u240, (FunctionDescriptor)descriptor2, false, 2, null);
                    break;
                }
                case 4: {
                    irDeclaration2 = $this$tryDeserializeIrSymbol_u24lambda_u240.generateConstructorStub((ClassConstructorDescriptor)descriptor2);
                    break;
                }
                case 5: {
                    irDeclaration2 = $this$tryDeserializeIrSymbol_u24lambda_u240.generateEnumEntryStub((ClassDescriptor)descriptor2);
                    break;
                }
                case 6: {
                    irDeclaration2 = $this$tryDeserializeIrSymbol_u24lambda_u240.generateTypeAliasStub((TypeAliasDescriptor)descriptor2);
                    break;
                }
                default: {
                    throw new IllegalStateException(("Unexpected type " + (Object)((Object)symbolKind) + " for sig " + idSig).toString());
                }
            }
            IrDeclaration declaration = irDeclaration2;
            return ((IrDeclarationBase)declaration).getSymbol();
        }

        @Override
        @NotNull
        public Void deserializedSymbolNotFound(@NotNull IdSignature idSig) {
            Intrinsics.checkNotNullParameter(idSig, "idSig");
            throw new IllegalStateException(("No descriptor found for " + idSig).toString());
        }

        @Override
        public void declareIrSymbol(@NotNull IrSymbol symbol2) {
            Intrinsics.checkNotNullParameter(symbol2, "symbol");
            if (symbol2 instanceof IrFieldSymbol) {
                JvmIrLinker.this.declareJavaFieldStub((IrFieldSymbol)symbol2);
            } else {
                JvmIrLinker.this.stubGenerator.generateMemberStub(symbol2.getDescriptor());
            }
        }

        @Override
        @NotNull
        public IrModuleFragment getModuleFragment() {
            return this.moduleFragment;
        }

        @Override
        @NotNull
        public Collection<IrModuleDeserializer> getModuleDependencies() {
            return this.moduleDependencies;
        }

        @Override
        @NotNull
        public IrModuleDeserializerKind getKind() {
            return IrModuleDeserializerKind.SYNTHETIC;
        }

        @Metadata(mv={1, 8, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[BinarySymbolData.SymbolKind.values().length];
                try {
                    nArray[BinarySymbolData.SymbolKind.CLASS_SYMBOL.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[BinarySymbolData.SymbolKind.PROPERTY_SYMBOL.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[BinarySymbolData.SymbolKind.FUNCTION_SYMBOL.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[BinarySymbolData.SymbolKind.CONSTRUCTOR_SYMBOL.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[BinarySymbolData.SymbolKind.ENUM_ENTRY_SYMBOL.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[BinarySymbolData.SymbolKind.TYPEALIAS_SYMBOL.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/ir/backend/jvm/serialization/JvmIrLinker$JvmCurrentModuleDeserializer;", "Lorg/jetbrains/kotlin/backend/common/serialization/CurrentModuleDeserializer;", "moduleFragment", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "dependencies", "", "Lorg/jetbrains/kotlin/backend/common/serialization/IrModuleDeserializer;", "(Lorg/jetbrains/kotlin/ir/backend/jvm/serialization/JvmIrLinker;Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;Ljava/util/Collection;)V", "declareIrSymbol", "", "symbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "ir.serialization.jvm"})
    private final class JvmCurrentModuleDeserializer
    extends CurrentModuleDeserializer {
        public JvmCurrentModuleDeserializer(@NotNull IrModuleFragment moduleFragment2, Collection<? extends IrModuleDeserializer> dependencies2) {
            Intrinsics.checkNotNullParameter(moduleFragment2, "moduleFragment");
            Intrinsics.checkNotNullParameter(dependencies2, "dependencies");
            super(moduleFragment2, dependencies2);
        }

        @Override
        public void declareIrSymbol(@NotNull IrSymbol symbol2) {
            Intrinsics.checkNotNullParameter(symbol2, "symbol");
            DeclarationDescriptor descriptor2 = symbol2.getDescriptor();
            if (JvmIrLinker.this.isJavaDescriptor(descriptor2)) {
                if (symbol2 instanceof IrFieldSymbol) {
                    JvmIrLinker.this.declareJavaFieldStub((IrFieldSymbol)symbol2);
                } else {
                    JvmIrLinker.this.stubGenerator.generateMemberStub(descriptor2);
                }
                return;
            }
            if (JvmIrLinker.this.isCleanDescriptor(descriptor2)) {
                JvmIrLinker.this.stubGenerator.generateMemberStub(descriptor2);
                return;
            }
            super.declareIrSymbol(symbol2);
        }
    }
}

