/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u000e\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u000e\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u000e\u0010\b\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006\u001a\n\u0010\t\u001a\u00020\u0001*\u00020\n\u001a\n\u0010\t\u001a\u00020\u0001*\u00020\u000b\u001a\f\u0010\f\u001a\u00020\u0001*\u00020\u000bH\u0002\u001a\f\u0010\r\u001a\u00020\u0001*\u00020\u000bH\u0002\u00a8\u0006\u000e"}, d2={"isDontMangleClass", "", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "requiresFunctionNameManglingForParameterTypes", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "requiresFunctionNameManglingForReturnType", "shouldHideConstructorDueToInlineClassTypeValueParameters", "isInlineClassThatRequiresMangling", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "Lorg/jetbrains/kotlin/types/KotlinType;", "isTypeParameterWithUpperBoundThatRequiresMangling", "requiresFunctionNameManglingInParameterTypes", "descriptors.jvm"})
public final class InlineClassManglingRulesKt {
    public static final boolean shouldHideConstructorDueToInlineClassTypeValueParameters(@NotNull CallableMemberDescriptor descriptor2) {
        boolean bl;
        block7: {
            Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
            ClassConstructorDescriptor classConstructorDescriptor = descriptor2 instanceof ClassConstructorDescriptor ? (ClassConstructorDescriptor)descriptor2 : null;
            if (classConstructorDescriptor == null) {
                return false;
            }
            ClassConstructorDescriptor constructorDescriptor = classConstructorDescriptor;
            if (DescriptorVisibilities.isPrivate(constructorDescriptor.getVisibility())) {
                return false;
            }
            ClassDescriptor classDescriptor2 = constructorDescriptor.getConstructedClass();
            Intrinsics.checkNotNullExpressionValue(classDescriptor2, "constructorDescriptor.constructedClass");
            if (InlineClassesUtilsKt.isInlineClass(classDescriptor2)) {
                return false;
            }
            if (DescriptorUtils.isSealedClass(constructorDescriptor.getConstructedClass())) {
                return false;
            }
            List<ValueParameterDescriptor> list2 = constructorDescriptor.getValueParameters();
            Intrinsics.checkNotNullExpressionValue(list2, "constructorDescriptor.valueParameters");
            Iterable $this$any$iv = list2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ValueParameterDescriptor it = (ValueParameterDescriptor)element$iv;
                    boolean bl2 = false;
                    KotlinType kotlinType = it.getType();
                    Intrinsics.checkNotNullExpressionValue(kotlinType, "it.type");
                    if (!InlineClassManglingRulesKt.requiresFunctionNameManglingInParameterTypes(kotlinType)) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean requiresFunctionNameManglingForParameterTypes(@NotNull CallableMemberDescriptor descriptor2) {
        KotlinType kotlinType;
        KotlinType extensionReceiverType;
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        ReceiverParameterDescriptor receiverParameterDescriptor = descriptor2.getExtensionReceiverParameter();
        KotlinType kotlinType2 = extensionReceiverType = receiverParameterDescriptor != null ? receiverParameterDescriptor.getType() : null;
        if (extensionReceiverType != null) {
            if (InlineClassManglingRulesKt.requiresFunctionNameManglingInParameterTypes(extensionReceiverType)) return true;
        }
        List<ValueParameterDescriptor> list2 = descriptor2.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list2, "descriptor.valueParameters");
        Iterable $this$any$iv = list2;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            ValueParameterDescriptor it = (ValueParameterDescriptor)element$iv;
            boolean bl = false;
            kotlinType = it.getType();
            Intrinsics.checkNotNullExpressionValue(kotlinType, "it.type");
        } while (!InlineClassManglingRulesKt.requiresFunctionNameManglingInParameterTypes(kotlinType));
        return true;
    }

    public static final boolean requiresFunctionNameManglingForReturnType(@NotNull CallableMemberDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        if (!(descriptor2.getContainingDeclaration() instanceof ClassDescriptor)) {
            return false;
        }
        KotlinType kotlinType = descriptor2.getReturnType();
        if (kotlinType == null) {
            return false;
        }
        KotlinType returnType2 = kotlinType;
        return InlineClassesUtilsKt.isInlineClassType(returnType2) || InlineClassManglingRulesKt.isTypeParameterWithUpperBoundThatRequiresMangling(returnType2);
    }

    public static final boolean isInlineClassThatRequiresMangling(@NotNull DeclarationDescriptor $this$isInlineClassThatRequiresMangling) {
        Intrinsics.checkNotNullParameter($this$isInlineClassThatRequiresMangling, "<this>");
        return InlineClassesUtilsKt.isInlineClass($this$isInlineClassThatRequiresMangling) && !InlineClassManglingRulesKt.isDontMangleClass((ClassDescriptor)$this$isInlineClassThatRequiresMangling);
    }

    public static final boolean isInlineClassThatRequiresMangling(@NotNull KotlinType $this$isInlineClassThatRequiresMangling) {
        Intrinsics.checkNotNullParameter($this$isInlineClassThatRequiresMangling, "<this>");
        ClassifierDescriptor classifierDescriptor = $this$isInlineClassThatRequiresMangling.getConstructor().getDeclarationDescriptor();
        return classifierDescriptor != null ? InlineClassManglingRulesKt.isInlineClassThatRequiresMangling(classifierDescriptor) : false;
    }

    private static final boolean requiresFunctionNameManglingInParameterTypes(KotlinType $this$requiresFunctionNameManglingInParameterTypes) {
        return InlineClassManglingRulesKt.isInlineClassThatRequiresMangling($this$requiresFunctionNameManglingInParameterTypes) || InlineClassManglingRulesKt.isTypeParameterWithUpperBoundThatRequiresMangling($this$requiresFunctionNameManglingInParameterTypes);
    }

    private static final boolean isDontMangleClass(ClassDescriptor classDescriptor2) {
        return Intrinsics.areEqual(DescriptorUtilsKt.getFqNameSafe(classDescriptor2), StandardNames.RESULT_FQ_NAME);
    }

    private static final boolean isTypeParameterWithUpperBoundThatRequiresMangling(KotlinType $this$isTypeParameterWithUpperBoundThatRequiresMangling) {
        ClassifierDescriptor classifierDescriptor = $this$isTypeParameterWithUpperBoundThatRequiresMangling.getConstructor().getDeclarationDescriptor();
        TypeParameterDescriptor typeParameterDescriptor = classifierDescriptor instanceof TypeParameterDescriptor ? (TypeParameterDescriptor)classifierDescriptor : null;
        if (typeParameterDescriptor == null) {
            return false;
        }
        TypeParameterDescriptor descriptor2 = typeParameterDescriptor;
        return InlineClassManglingRulesKt.requiresFunctionNameManglingInParameterTypes(TypeUtilsKt.getRepresentativeUpperBound(descriptor2));
    }
}

