/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.disk.client;

import com.yandex.disk.client.ProgressListener;
import com.yandex.disk.client.exceptions.CancelledUploadingException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.http.entity.AbstractHttpEntity;

public class FileProgressHttpEntity
extends AbstractHttpEntity {
    private File file;
    private long start;
    private ProgressListener progressListener;

    public FileProgressHttpEntity(File file, long start, ProgressListener progressListener) {
        this.file = file;
        this.start = start;
        this.progressListener = progressListener;
    }

    public boolean isRepeatable() {
        return true;
    }

    public long getContentLength() {
        return this.file.length() - this.start;
    }

    public InputStream getContent() throws IOException, IllegalStateException {
        return new FileInputStream(this.file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(OutputStream outputStream) throws IOException {
        if (outputStream == null) {
            throw new IllegalArgumentException("Output stream may not be null");
        }
        FileInputStream inputStream = new FileInputStream(this.file);
        if (this.start > 0L) {
            long skipped = ((InputStream)inputStream).skip(this.start);
        }
        long loaded = 0L;
        this.updateProgress(loaded);
        try {
            int count;
            byte[] buf = new byte[1024];
            while ((count = ((InputStream)inputStream).read(buf)) != -1) {
                outputStream.write(buf, 0, count);
                this.updateProgress(loaded += (long)count);
            }
            outputStream.flush();
        }
        finally {
            ((InputStream)inputStream).close();
        }
    }

    public boolean isStreaming() {
        return false;
    }

    private void updateProgress(long loaded) throws CancelledUploadingException {
        if (this.progressListener != null) {
            if (this.progressListener.hasCancelled()) {
                throw new CancelledUploadingException();
            }
            this.progressListener.updateProgress(loaded + this.start, this.getContentLength() + this.start);
        }
    }
}

