/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.disk.client;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.format.Time;
import android.util.Log;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class ListItem
implements Parcelable {
    private static final String TAG = "ListItem";
    private String displayName;
    private String fullPath;
    private String etag;
    private String contentType;
    private String ownerName;
    private String publicUrl;
    private boolean isCollection;
    private boolean aliasEnabled;
    private boolean shared;
    private boolean readOnly;
    private boolean visible;
    private long contentLength;
    private long lastUpdated;
    private long etime;
    private static final Map<String, Integer> MONTH = new HashMap<String, Integer>();
    public static final Parcelable.Creator<ListItem> CREATOR;

    private ListItem(String fullPath, String displayName, long contentLength, String lastUpdated, boolean isCollection, String etag, String contentType, boolean shared, String ownerName, boolean aliasEnabled, boolean readOnly, boolean visible, String publicUrl, long etime) {
        this.fullPath = fullPath;
        this.displayName = displayName != null ? displayName : new File(fullPath).getName();
        this.contentLength = contentLength;
        this.lastUpdated = ListItem.parseDateTime(lastUpdated);
        this.isCollection = isCollection;
        this.etag = etag;
        this.contentType = contentType;
        this.shared = shared;
        this.ownerName = ownerName;
        this.aliasEnabled = aliasEnabled;
        this.readOnly = readOnly;
        this.visible = visible;
        this.publicUrl = publicUrl;
        this.etime = etime;
    }

    private ListItem(String fullPath, String displayName, long contentLength, long lastUpdated, boolean isCollection, String etag, boolean aliasEnabled, String contentType, boolean shared, boolean readonly, String ownerName, String publicUrl, long etime) {
        this.fullPath = fullPath;
        this.displayName = displayName;
        this.contentLength = contentLength;
        this.lastUpdated = lastUpdated;
        this.isCollection = isCollection;
        this.etag = etag;
        this.aliasEnabled = aliasEnabled;
        this.contentType = contentType;
        this.shared = shared;
        this.readOnly = readonly;
        this.ownerName = ownerName;
        this.publicUrl = publicUrl;
        this.etime = etime;
    }

    private static long parseDateTime(String datetime) {
        try {
            String[] s;
            if (datetime != null && datetime.length() > 0 && (s = datetime.split("(\\s+|\\-|\\:)+")).length >= 7) {
                Time time = new Time(s[7]);
                time.set(Integer.valueOf(s[6]).intValue(), Integer.valueOf(s[5]).intValue(), Integer.valueOf(s[4]).intValue(), Integer.valueOf(s[1]).intValue(), MONTH.get(s[2]).intValue(), Integer.valueOf(s[3]).intValue());
                return time.toMillis(true);
            }
        }
        catch (Throwable ex) {
            Log.w((String)TAG, (String)"parseDateTime", (Throwable)ex);
        }
        return 0L;
    }

    public String toString() {
        return "ListItem { fullPath='" + this.fullPath + '\'' + ", displayName='" + this.displayName + '\'' + ", contentLength=" + this.contentLength + ", lastUpdated=" + this.lastUpdated + ", isCollection=" + this.isCollection + ", etag=" + this.etag + ", contentType=" + this.contentType + ", shared=" + this.shared + ", ownerName=" + this.ownerName + ", aliasEnabled=" + this.aliasEnabled + ", readOnly=" + this.readOnly + ", visible=" + this.visible + ", publicUrl=" + this.publicUrl + " }";
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int i) {
        parcel.writeString(this.fullPath);
        parcel.writeString(this.displayName);
        parcel.writeLong(this.contentLength);
        parcel.writeLong(this.lastUpdated);
        parcel.writeByte((byte)(this.isCollection ? 1 : 0));
        parcel.writeString(this.etag);
        parcel.writeByte((byte)(this.aliasEnabled ? 1 : 0));
        parcel.writeString(this.contentType);
        parcel.writeByte((byte)(this.shared ? 1 : 0));
        parcel.writeByte((byte)(this.readOnly ? 1 : 0));
        parcel.writeString(this.ownerName);
        parcel.writeString(this.publicUrl);
        parcel.writeLong(this.etime);
    }

    public String getFullPath() {
        return this.fullPath;
    }

    public String getName() {
        return new File(this.fullPath).getName();
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public long getLastUpdated() {
        return this.lastUpdated;
    }

    public boolean isCollection() {
        return this.isCollection;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public boolean isAliasEnabled() {
        return this.aliasEnabled;
    }

    public boolean isShared() {
        return this.shared;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public String getPublicUrl() {
        return this.publicUrl;
    }

    public long getEtime() {
        return this.etime;
    }

    static {
        MONTH.put("Jan", 0);
        MONTH.put("Feb", 1);
        MONTH.put("Mar", 2);
        MONTH.put("Apr", 3);
        MONTH.put("May", 4);
        MONTH.put("Jun", 5);
        MONTH.put("Jul", 6);
        MONTH.put("Aug", 7);
        MONTH.put("Sep", 8);
        MONTH.put("Oct", 9);
        MONTH.put("Nov", 10);
        MONTH.put("Dec", 11);
        CREATOR = new Parcelable.Creator<ListItem>(){

            public ListItem createFromParcel(Parcel parcel) {
                return new ListItem(parcel.readString(), parcel.readString(), parcel.readLong(), parcel.readLong(), parcel.readByte() > 0, parcel.readString(), parcel.readByte() > 0, parcel.readString(), parcel.readByte() > 0, parcel.readByte() > 0, parcel.readString(), parcel.readString(), parcel.readLong());
            }

            public ListItem[] newArray(int size) {
                return new ListItem[size];
            }
        };
    }

    public static final class Builder {
        private String fullPath;
        private String displayName;
        private String lastModified;
        private String etag;
        private String contentType;
        private String ownerName;
        private String publicUrl;
        private long contentLength;
        private long etime;
        private boolean isCollection;
        private boolean aliasEnabled;
        private boolean visible;
        private boolean shared;
        private boolean readOnly;

        public void setFullPath(String fullPath) {
            this.fullPath = fullPath;
        }

        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public void setContentLength(long contentLength) {
            this.contentLength = contentLength;
        }

        public void setLastModified(String lastModified) {
            this.lastModified = lastModified;
        }

        public void setEtag(String etag) {
            this.etag = etag;
        }

        public void setContentType(String contentType) {
            this.contentType = contentType;
        }

        public void setOwnerName(String ownerName) {
            this.ownerName = ownerName;
        }

        public void addCollection() {
            this.isCollection = true;
        }

        public void setAliasEnabled(boolean aliasEnabled) {
            this.aliasEnabled = aliasEnabled;
        }

        public void setVisible(boolean visible) {
            this.visible = visible;
        }

        public void setShared(boolean shared) {
            this.shared = shared;
        }

        public void setReadOnly(boolean readOnly) {
            this.readOnly = readOnly;
        }

        public void setPublicUrl(String publicUrl) {
            this.publicUrl = publicUrl;
        }

        public void setEtime(long etime) {
            this.etime = etime;
        }

        public ListItem build() {
            return new ListItem(this.fullPath, this.displayName, this.contentLength, this.lastModified, this.isCollection, this.etag, this.contentType, this.shared, this.ownerName, this.aliasEnabled, this.readOnly, this.visible, this.publicUrl, this.etime);
        }
    }
}

