/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.disk.client;

import com.yandex.disk.client.ListItem;
import com.yandex.disk.client.ListParsingHandler;
import com.yandex.disk.client.Parser;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import org.apache.http.HttpEntity;
import org.xmlpull.v1.XmlPullParserException;

public class ListParser
extends Parser {
    private static final String TAG = "ListParser";
    public static final String SERVER_ENCODING = "UTF-8";
    private ListParsingHandler handler;
    private int parsedCount;
    private ListItem.Builder builder;
    private boolean isStatusOK;

    public ListParser(HttpEntity entity, ListParsingHandler handler) throws XmlPullParserException, IOException {
        super(entity.getContent(), SERVER_ENCODING);
        this.handler = handler;
        this.parsedCount = 0;
    }

    @Override
    public void tagStart(String path) {
        if ("/multistatus/response".equals(path)) {
            this.builder = new ListItem.Builder();
        } else if ("/multistatus/response/propstat".equals(path)) {
            this.isStatusOK = false;
        }
    }

    @Override
    public void tagEnd(String path, String text) throws UnsupportedEncodingException {
        if ("/multistatus/response/href".equals(path)) {
            String href = URLDecoder.decode(text, SERVER_ENCODING);
            if (href.endsWith("/")) {
                href = href.substring(0, href.length() - 1);
            }
            this.builder.setFullPath(href);
        } else if ("/multistatus/response/propstat/status".equals(path)) {
            this.isStatusOK = "HTTP/1.1 200 OK".equals(text);
        } else if ("/multistatus/response".equals(path)) {
            ListItem item = this.builder.build();
            if (this.handler.handleItem(item)) {
                ++this.parsedCount;
            }
        } else if (this.isStatusOK) {
            if ("/multistatus/response/propstat/prop/displayname".equals(path)) {
                this.builder.setDisplayName(text);
            } else if ("/multistatus/response/propstat/prop/getcontentlength".equals(path)) {
                this.builder.setContentLength(ListParser.parseLong(text));
            } else if ("/multistatus/response/propstat/prop/getlastmodified".equals(path)) {
                this.builder.setLastModified(text);
            } else if ("/multistatus/response/propstat/prop/getetag".equals(path)) {
                this.builder.setEtag(text);
            } else if ("/multistatus/response/propstat/prop/alias_enabled".equals(path)) {
                this.builder.setAliasEnabled(ListParser.parseBooleanAsNumber(text));
            } else if ("/multistatus/response/propstat/prop/visible".equals(path)) {
                this.builder.setVisible(ListParser.parseBooleanAsNumber(text));
            } else if ("/multistatus/response/propstat/prop/resourcetype/collection".equals(path)) {
                this.builder.addCollection();
            } else if ("/multistatus/response/propstat/prop/getcontenttype".equals(path)) {
                this.builder.setContentType(text);
            } else if ("/multistatus/response/propstat/prop/shared".equals(path)) {
                this.builder.setShared(Boolean.parseBoolean(text));
            } else if ("/multistatus/response/propstat/prop/readonly".equals(path)) {
                this.builder.setReadOnly(Boolean.parseBoolean(text));
            } else if ("/multistatus/response/propstat/prop/owner_name".equals(path)) {
                this.builder.setOwnerName(text);
            } else if ("/multistatus/response/propstat/prop/public_url".equals(path)) {
                this.builder.setPublicUrl(text);
            } else if ("/multistatus/response/propstat/prop/etime".equals(path)) {
                this.builder.setEtime(ListParser.parseLong(text));
            }
        }
    }

    @Override
    public void parse() throws IOException, XmlPullParserException {
        super.parse();
        this.handler.onPageFinished(this.parsedCount);
    }

    public int getParsedCount() {
        return this.parsedCount;
    }

    private static boolean parseBooleanAsNumber(String text) {
        try {
            return Integer.parseInt(text) == 1;
        }
        catch (NumberFormatException ex) {
            return false;
        }
    }

    private static long parseLong(String text) {
        try {
            return Long.parseLong(text);
        }
        catch (NumberFormatException nfe) {
            return 0L;
        }
    }
}

