/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.disk.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public abstract class Parser {
    private XmlPullParser xml = Parser.init();

    private static XmlPullParser init() throws XmlPullParserException {
        XmlPullParserFactory factory = XmlPullParserFactory.newInstance();
        factory.setNamespaceAware(true);
        return factory.newPullParser();
    }

    public Parser(Reader reader) throws XmlPullParserException {
        this.xml.setInput(reader);
    }

    public Parser(InputStream in, String encoding) throws XmlPullParserException {
        this.xml.setInput(in, encoding);
    }

    public abstract void tagStart(String var1) throws IOException;

    public abstract void tagEnd(String var1, String var2) throws IOException;

    public void parse() throws IOException, XmlPullParserException {
        int event;
        StringBuilder path = new StringBuilder();
        String text = null;
        do {
            event = this.xml.next();
            switch (event) {
                case 2: {
                    path.append("/").append(this.xml.getName());
                    this.tagStart(path.toString());
                    break;
                }
                case 4: {
                    text = this.xml.getText();
                    break;
                }
                case 3: {
                    this.tagEnd(path.toString(), text);
                    path.setLength(path.length() - this.xml.getName().length() - 1);
                    break;
                }
            }
        } while (event != 1);
    }
}

