/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.disk.client;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.yandex.disk.client.ContentRangeResponse;
import com.yandex.disk.client.Credentials;
import com.yandex.disk.client.FileProgressHttpEntity;
import com.yandex.disk.client.ListParser;
import com.yandex.disk.client.ListParsingHandler;
import com.yandex.disk.client.ProgressListener;
import com.yandex.disk.client.SSLSocketFactoryWithTimeout;
import com.yandex.disk.client.exceptions.CancelledDownloadException;
import com.yandex.disk.client.exceptions.CancelledPropfindException;
import com.yandex.disk.client.exceptions.DuplicateFolderException;
import com.yandex.disk.client.exceptions.FileDownloadException;
import com.yandex.disk.client.exceptions.FileTooBigServerException;
import com.yandex.disk.client.exceptions.FilesLimitExceededServerException;
import com.yandex.disk.client.exceptions.IntermediateFolderNotExistException;
import com.yandex.disk.client.exceptions.PreconditionFailedException;
import com.yandex.disk.client.exceptions.RangeNotSatisfiableException;
import com.yandex.disk.client.exceptions.ServerWebdavException;
import com.yandex.disk.client.exceptions.UnknownServerWebdavException;
import com.yandex.disk.client.exceptions.UnsupportedMediaTypeException;
import com.yandex.disk.client.exceptions.WebdavClientInitException;
import com.yandex.disk.client.exceptions.WebdavException;
import com.yandex.disk.client.exceptions.WebdavFileNotFoundException;
import com.yandex.disk.client.exceptions.WebdavForbiddenException;
import com.yandex.disk.client.exceptions.WebdavInvalidUserException;
import com.yandex.disk.client.exceptions.WebdavNotAuthorizedException;
import com.yandex.disk.client.exceptions.WebdavSharingForbiddenException;
import com.yandex.disk.client.exceptions.WebdavUserNotInitialized;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.StatusLine;
import org.apache.http.client.CookieStore;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.RedirectHandler;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.params.ConnManagerParams;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.DefaultRedirectHandler;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.message.AbstractHttpMessage;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.xmlpull.v1.XmlPullParserException;

public class TransportClient {
    private static final String TAG = "TransportClient";
    protected static URL serverURL;
    protected static final String userAgent = "Webdav Android Client Example/1.0";
    protected static final String LOCATION_HEADER = "Location";
    protected static final String NO_REDIRECT_CONTEXT = "yandex.no-redirect";
    protected static final String WEBDAV_PROTO_DEPTH = "Depth";
    protected static final int NETWORK_TIMEOUT = 30000;
    protected static final int UPLOAD_NETWORK_TIMEOUT = 300000;
    protected Context context;
    protected Credentials creds;
    protected final HttpClient httpClient;
    private static final HttpRequestRetryHandler requestRetryHandler;
    private static final RedirectHandler redirectHandler;
    private static final String PROPFIND_REQUEST = "<?xml version='1.0' encoding='utf-8' ?><d:propfind xmlns:d='DAV:'><d:prop xmlns:m='urn:yandex:disk:meta'><d:resourcetype/><d:displayname/><d:getcontentlength/><d:getlastmodified/><d:getetag/><d:getcontenttype/><m:alias_enabled/><m:visible/><m:shared/><m:readonly/><m:public_url/><m:etime/></d:prop></d:propfind>";
    private static final int MAX_ITEMS_PER_PAGE = Integer.MAX_VALUE;
    private static Pattern CONTENT_RANGE_HEADER_PATTERN;

    public static TransportClient getInstance(Context context, Credentials credentials) throws WebdavClientInitException {
        return new TransportClient(context, credentials, 30000);
    }

    public static TransportClient getUploadInstance(Context context, Credentials credentials) throws WebdavClientInitException {
        return new TransportClient(context, credentials, 300000);
    }

    public TransportClient(Context context, Credentials credentials, HttpClient httpClient) throws WebdavClientInitException {
        this.context = context;
        this.creds = credentials;
        this.httpClient = httpClient;
    }

    protected TransportClient(Context context, Credentials credentials, int timeout) throws WebdavClientInitException {
        this(context, credentials, userAgent, timeout);
    }

    protected TransportClient(Context context, Credentials credentials, String userAgent, int timeout) throws WebdavClientInitException {
        this.context = context;
        this.creds = credentials;
        DefaultHttpClient httpClient = TransportClient.getNewHttpClient(userAgent, timeout);
        httpClient.setCookieStore((CookieStore)new BasicCookieStore());
        this.httpClient = httpClient;
    }

    protected static DefaultHttpClient getNewHttpClient(String userAgent, int timeout) throws WebdavClientInitException {
        SSLSocketFactoryWithTimeout sf;
        BasicHttpParams params = new BasicHttpParams();
        HttpProtocolParams.setVersion((HttpParams)params, (ProtocolVersion)HttpVersion.HTTP_1_1);
        HttpProtocolParams.setContentCharset((HttpParams)params, (String)"UTF-8");
        HttpConnectionParams.setSocketBufferSize((HttpParams)params, (int)8192);
        HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)timeout);
        HttpConnectionParams.setSoTimeout((HttpParams)params, (int)timeout);
        ConnManagerParams.setMaxTotalConnections((HttpParams)params, (int)1);
        try {
            sf = new SSLSocketFactoryWithTimeout(timeout);
        }
        catch (GeneralSecurityException ex) {
            Log.e((String)TAG, (String)"getNewHttpClient", (Throwable)ex);
            throw new WebdavClientInitException();
        }
        sf.setHostnameVerifier(SSLSocketFactory.STRICT_HOSTNAME_VERIFIER);
        SchemeRegistry registry = new SchemeRegistry();
        registry.register(new Scheme("http", (SocketFactory)PlainSocketFactory.getSocketFactory(), 80));
        registry.register(new Scheme("https", (SocketFactory)sf, 443));
        ThreadSafeClientConnManager ccm = new ThreadSafeClientConnManager((HttpParams)params, registry);
        DefaultHttpClient res = new DefaultHttpClient((ClientConnectionManager)ccm, (HttpParams)params);
        if (userAgent != null) {
            res.getParams().setParameter("http.useragent", (Object)userAgent);
        }
        res.getParams().setParameter("http.protocol.expect-continue", (Object)true);
        res.getParams().setParameter("http.protocol.wait-for-continue", (Object)timeout);
        res.setHttpRequestRetryHandler(requestRetryHandler);
        res.setRedirectHandler(redirectHandler);
        return res;
    }

    protected HttpResponse executeRequest(HttpUriRequest request) throws IOException {
        return this.httpClient.execute(request, (HttpContext)null);
    }

    protected HttpResponse executeRequest(HttpUriRequest request, HttpContext httpContext) throws IOException {
        return this.httpClient.execute(request, httpContext);
    }

    public void shutdown() {
        this.httpClient.getConnectionManager().shutdown();
    }

    public static void shutdown(TransportClient client) {
        if (client != null) {
            client.shutdown();
        }
    }

    protected String getUrl() {
        return serverURL.toExternalForm();
    }

    protected static void consumeContent(HttpResponse response) throws IOException {
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            entity.consumeContent();
        }
    }

    public static String encodeURL(String url) {
        if (url == null) {
            return null;
        }
        String[] segments = url.split("/");
        StringBuilder sb = new StringBuilder(20);
        try {
            for (String segment : segments) {
                if ("".equals(segment)) continue;
                sb.append("/").append(URLEncoder.encode(segment, "UTF-8"));
            }
            Log.d((String)TAG, (String)("url encoded: " + sb.toString()));
        }
        catch (UnsupportedEncodingException e) {
            Log.d((String)TAG, (String)("Exception occured: " + e.getMessage()));
        }
        return sb.toString().replace("+", "%20");
    }

    protected static void logMethod(HttpRequestBase method) {
        TransportClient.logMethod(method, null);
    }

    protected static void logMethod(HttpRequestBase method, String add) {
        Log.d((String)TAG, (String)("logMethod(): " + method.getMethod() + ": " + method.getURI() + (add != null ? " " + add : "")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] makeHashBytes(File file, HashType hashType) throws IOException {
        try (FileInputStream is = null;){
            int count;
            MessageDigest digest;
            is = new FileInputStream(file);
            try {
                digest = MessageDigest.getInstance(hashType.name());
            }
            catch (NoSuchAlgorithmException ex) {
                throw new RuntimeException(ex);
            }
            byte[] buf = new byte[8192];
            while ((count = is.read(buf)) > 0) {
                digest.update(buf, 0, count);
            }
            byte[] byArray = digest.digest();
            return byArray;
        }
    }

    public static String makeHash(File file, HashType hashType) throws IOException {
        long time = System.currentTimeMillis();
        String hash = TransportClient.hash(TransportClient.makeHashBytes(file, hashType));
        Log.d((String)TAG, (String)(hashType.name() + ": " + file.getAbsolutePath() + " hash=" + hash + " time=" + (System.currentTimeMillis() - time)));
        return hash;
    }

    public static String hash(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        StringBuilder out = new StringBuilder();
        for (byte b : bytes) {
            String n = Integer.toHexString(b & 0xFF);
            if (n.length() == 1) {
                out.append('0');
            }
            out.append(n);
        }
        return out.toString();
    }

    protected void checkStatusCodes(HttpResponse response, String details) throws WebdavNotAuthorizedException, WebdavUserNotInitialized, FileTooBigServerException, FilesLimitExceededServerException, ServerWebdavException, PreconditionFailedException, UnknownServerWebdavException {
        StatusLine statusLine = response.getStatusLine();
        int statusCode = statusLine.getStatusCode();
        switch (statusCode) {
            case 401: {
                Log.d((String)TAG, (String)("Not authorized: " + statusLine.getReasonPhrase()));
                throw new WebdavNotAuthorizedException(statusLine.getReasonPhrase() != null ? statusLine.getReasonPhrase() : "");
            }
            case 403: {
                Log.d((String)TAG, (String)("User not initialized: " + statusLine.getReasonPhrase()));
                throw new WebdavUserNotInitialized("Error (http code 403): " + details);
            }
            case 412: {
                Log.d((String)TAG, (String)("Http code 412 (Precondition failed): " + details));
                throw new PreconditionFailedException("Error (http code 412): " + details);
            }
            case 413: {
                Log.d((String)TAG, (String)("Http code 413 (File too big): " + details));
                throw new FileTooBigServerException();
            }
            case 507: {
                Log.d((String)TAG, (String)("Http code 507 (Insufficient Storage): " + details));
                throw new FilesLimitExceededServerException();
            }
        }
        if (statusCode >= 500 && statusCode < 600) {
            Log.d((String)TAG, (String)("Server error " + statusCode));
            throw new ServerWebdavException("Server error while " + details);
        }
        Log.d((String)TAG, (String)("Unknown code " + statusCode));
        throw new UnknownServerWebdavException("Server error while " + details);
    }

    public void getList(String path, ListParsingHandler handler) throws WebdavException, IOException {
        this.getList(path, Integer.MAX_VALUE, null, null, handler);
    }

    public void getList(String path, int itemsPerPage, ListParsingHandler handler) throws WebdavException, IOException {
        this.getList(path, itemsPerPage, null, null, handler);
    }

    public void getList(String path, int itemsPerPage, String sortBy, String orderBy, ListParsingHandler handler) throws WebdavException, IOException {
        Log.d((String)TAG, (String)("getList for " + path));
        boolean itemsFinished = false;
        int offset = 0;
        while (!itemsFinished) {
            int countOnPage;
            if (handler.hasCancelled()) {
                throw new CancelledPropfindException();
            }
            String url = this.getUrl() + TransportClient.encodeURL(path);
            if (itemsPerPage != Integer.MAX_VALUE) {
                url = url + "?offset=" + offset + "&amount=" + itemsPerPage;
                if (sortBy != null && orderBy != null) {
                    url = url + "&sort=" + sortBy + "&order=" + orderBy;
                }
            }
            PropFind propFind = new PropFind(url);
            TransportClient.logMethod((HttpRequestBase)propFind);
            this.creds.addAuthHeader((AbstractHttpMessage)propFind);
            propFind.setHeader(WEBDAV_PROTO_DEPTH, "1");
            propFind.setEntity((HttpEntity)new StringEntity(PROPFIND_REQUEST));
            HttpResponse response = this.executeRequest((HttpUriRequest)propFind);
            StatusLine statusLine = response.getStatusLine();
            if (statusLine != null) {
                int code = statusLine.getStatusCode();
                switch (code) {
                    case 207: {
                        break;
                    }
                    case 401: {
                        TransportClient.consumeContent(response);
                        throw new WebdavNotAuthorizedException(statusLine.getReasonPhrase() != null ? statusLine.getReasonPhrase() : "");
                    }
                    case 402: {
                        TransportClient.consumeContent(response);
                        throw new WebdavInvalidUserException();
                    }
                    case 403: {
                        TransportClient.consumeContent(response);
                        throw new WebdavForbiddenException();
                    }
                    case 404: {
                        TransportClient.consumeContent(response);
                        throw new WebdavFileNotFoundException("Directory not found: " + path);
                    }
                    default: {
                        TransportClient.consumeContent(response);
                        this.checkStatusCodes(response, "PROPFIND " + path);
                    }
                }
            }
            HttpEntity entity = response.getEntity();
            try {
                ListParser parser = new ListParser(entity, handler);
                parser.parse();
                countOnPage = parser.getParsedCount();
                Log.d((String)TAG, (String)("countOnPage=" + countOnPage));
            }
            catch (XmlPullParserException ex) {
                throw new WebdavException(ex);
            }
            finally {
                TransportClient.consumeContent(response);
            }
            if (countOnPage != itemsPerPage) {
                itemsFinished = true;
            }
            offset += itemsPerPage;
        }
    }

    public long headFile(File file, String dir, String destName, String md5, String sha256) throws IOException, NumberFormatException, WebdavUserNotInitialized, UnknownServerWebdavException, PreconditionFailedException, WebdavNotAuthorizedException, ServerWebdavException {
        String url = this.getUrl() + TransportClient.encodeURL(dir + "/" + destName);
        HttpHead head = new HttpHead(url);
        TransportClient.logMethod((HttpRequestBase)head, ", file " + file);
        this.creds.addAuthHeader((AbstractHttpMessage)head);
        head.addHeader("Etag", md5);
        if (sha256 != null) {
            head.addHeader("Sha256", sha256);
        }
        head.addHeader("Size", String.valueOf(file.length()));
        HttpResponse response = this.executeRequest((HttpUriRequest)head);
        TransportClient.consumeContent(response);
        StatusLine statusLine = response.getStatusLine();
        if (statusLine != null) {
            int statusCode = statusLine.getStatusCode();
            if (statusLine.getStatusCode() == 200) {
                Header[] headers = response.getHeaders("Content-Length");
                if (headers.length > 0) {
                    String contentLength = headers[0].getValue();
                    return Long.valueOf(contentLength);
                }
                return 0L;
            }
            if (statusCode == 409 || statusCode == 404 || statusCode == 412) {
                Log.d((String)TAG, (String)(statusLine + " for file " + file.getAbsolutePath() + " in dir " + dir));
                return 0L;
            }
            this.checkStatusCodes(response, "HEAD " + url);
        }
        return 0L;
    }

    public void uploadFile(String localPath, String serverDir, ProgressListener progressListener) throws IOException, UnknownServerWebdavException, PreconditionFailedException, IntermediateFolderNotExistException, WebdavUserNotInitialized, ServerWebdavException, WebdavNotAuthorizedException {
        File file = new File(localPath);
        this.uploadFile(file, serverDir, file.getName(), TransportClient.makeHash(file, HashType.MD5), null, progressListener);
    }

    public void uploadFile(File file, String dir, String destFileName, String md5, String sha256, ProgressListener progressListener) throws IntermediateFolderNotExistException, IOException, WebdavUserNotInitialized, PreconditionFailedException, WebdavNotAuthorizedException, ServerWebdavException, UnknownServerWebdavException {
        long uploadedSize;
        String destName = TextUtils.isEmpty((CharSequence)destFileName) ? file.getName() : destFileName;
        String url = this.getUrl() + TransportClient.encodeURL(dir + "/" + destName);
        Log.d((String)TAG, (String)("uploadFile: put to " + this.getUrl() + dir + "/" + destName));
        try {
            uploadedSize = this.headFile(file, dir, destName, md5, sha256);
        }
        catch (NumberFormatException ex) {
            Log.w((String)TAG, (String)("Uploading " + file.getAbsolutePath() + " to " + dir + ": HEAD failed"), (Throwable)ex);
            uploadedSize = 0L;
        }
        HttpPut put = new HttpPut(url);
        this.creds.addAuthHeader((AbstractHttpMessage)put);
        put.addHeader("Etag", md5);
        if (sha256 != null) {
            Log.d((String)TAG, (String)("Sha256: " + sha256));
            put.addHeader("Sha256", sha256);
        }
        if (uploadedSize > 0L) {
            StringBuffer contentRange = new StringBuffer();
            contentRange.append("bytes ").append(uploadedSize).append("-").append(file.length() - 1L).append("/").append(file.length());
            Log.d((String)TAG, (String)("Content-Range: " + contentRange));
            put.addHeader("Content-Range", contentRange.toString());
        }
        FileProgressHttpEntity entity = new FileProgressHttpEntity(file, uploadedSize, progressListener);
        put.setEntity((HttpEntity)entity);
        TransportClient.logMethod((HttpRequestBase)put, ", file to upload " + file);
        HttpResponse response = this.executeRequest((HttpUriRequest)put);
        StatusLine statusLine = response.getStatusLine();
        if (statusLine != null) {
            TransportClient.consumeContent(response);
            switch (statusLine.getStatusCode()) {
                case 201: {
                    Log.d((String)TAG, (String)("File uploaded successfully: " + file));
                    return;
                }
                case 409: {
                    Log.d((String)TAG, (String)("Parent not exist for dir " + dir));
                    throw new IntermediateFolderNotExistException("Parent folder not exists for '" + dir + "'");
                }
            }
            this.checkStatusCodes(response, "PUT '" + file + "' to " + url);
        }
    }

    public void downloadFile(String path, File saveTo, ProgressListener progressListener) throws IOException, WebdavUserNotInitialized, PreconditionFailedException, WebdavNotAuthorizedException, ServerWebdavException, CancelledDownloadException, UnknownServerWebdavException {
        this.downloadFile(path, saveTo, 0L, 0L, progressListener);
    }

    public void downloadFile(String path, File saveTo, long length, long fileSize, ProgressListener progressListener) throws IOException, WebdavUserNotInitialized, PreconditionFailedException, WebdavNotAuthorizedException, ServerWebdavException, CancelledDownloadException, UnknownServerWebdavException {
        long loaded;
        String url = this.getUrl() + TransportClient.encodeURL(path);
        HttpGet get = new HttpGet(url);
        TransportClient.logMethod((HttpRequestBase)get, " to " + saveTo);
        this.creds.addAuthHeader((AbstractHttpMessage)get);
        if (length > 0L) {
            StringBuffer contentRange = new StringBuffer();
            contentRange.append("bytes=").append(length).append("-");
            if (fileSize > 0L) {
                contentRange.append(fileSize - 1L);
            }
            Log.d((String)TAG, (String)("Range: " + contentRange));
            get.addHeader("Range", contentRange.toString());
        }
        boolean partialContent = false;
        HttpResponse httpResponse = this.executeRequest((HttpUriRequest)get);
        StatusLine statusLine = httpResponse.getStatusLine();
        if (statusLine != null) {
            int statusCode = statusLine.getStatusCode();
            switch (statusCode) {
                case 200: {
                    break;
                }
                case 206: {
                    partialContent = true;
                    break;
                }
                case 404: {
                    TransportClient.consumeContent(httpResponse);
                    throw new FileDownloadException("error while downloading file " + url);
                }
                case 416: {
                    TransportClient.consumeContent(httpResponse);
                    throw new RangeNotSatisfiableException("error while downloading file " + url);
                }
                default: {
                    this.checkStatusCodes(httpResponse, "GET '" + url + "'");
                }
            }
        }
        HttpEntity response = httpResponse.getEntity();
        long contentLength = response.getContentLength();
        Log.d((String)TAG, (String)("downloadFile: contentLength=" + contentLength));
        if (partialContent) {
            ContentRangeResponse contentRangeResponse = this.parseContentRangeHeader(httpResponse.getLastHeader("Content-Range"));
            Log.d((String)TAG, (String)("downloadFile: contentRangeResponse=" + contentRangeResponse));
            if (contentRangeResponse != null) {
                loaded = contentRangeResponse.getStart();
                contentLength = contentRangeResponse.getSize();
            } else {
                loaded = length;
                contentLength = fileSize;
            }
        } else {
            loaded = 0L;
            if (contentLength < 0L) {
                contentLength = 0L;
            }
        }
        InputStream content = response.getContent();
        FileOutputStream fos = new FileOutputStream(saveTo, partialContent);
        try {
            int count;
            byte[] downloadBuffer = new byte[1024];
            while ((count = content.read(downloadBuffer)) != -1) {
                if (progressListener.hasCancelled()) {
                    Log.i((String)TAG, (String)("Downloading " + path + " canceled"));
                    get.abort();
                    throw new CancelledDownloadException();
                }
                fos.write(downloadBuffer, 0, count);
                progressListener.updateProgress(loaded += (long)count, contentLength);
            }
        }
        catch (CancelledDownloadException ex) {
            throw ex;
        }
        catch (Exception e) {
            Log.w((String)TAG, (Throwable)e);
            get.abort();
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        finally {
            try {
                fos.close();
            }
            catch (IOException ex) {}
            try {
                response.consumeContent();
            }
            catch (IOException e) {
                Log.w((String)TAG, (Throwable)e);
            }
        }
    }

    private ContentRangeResponse parseContentRangeHeader(Header header) {
        if (header == null) {
            return null;
        }
        Log.d((String)TAG, (String)(header.getName() + ": " + header.getValue()));
        Matcher matcher = CONTENT_RANGE_HEADER_PATTERN.matcher(header.getValue());
        if (!matcher.matches()) {
            return null;
        }
        try {
            return new ContentRangeResponse(Long.parseLong(matcher.group(1)), Long.parseLong(matcher.group(2)));
        }
        catch (IllegalStateException ex) {
            Log.d((String)TAG, (String)("parseContentRangeHeader: " + header), (Throwable)ex);
            return null;
        }
        catch (NumberFormatException ex) {
            Log.d((String)TAG, (String)("parseContentRangeHeader: " + header), (Throwable)ex);
            return null;
        }
    }

    public void makeFolder(String dir) throws IOException, DuplicateFolderException, IntermediateFolderNotExistException, WebdavUserNotInitialized, PreconditionFailedException, WebdavNotAuthorizedException, ServerWebdavException, UnsupportedMediaTypeException, UnknownServerWebdavException {
        String url = this.getUrl() + TransportClient.encodeURL(dir);
        HttpMkcol mkcol = new HttpMkcol(url);
        TransportClient.logMethod((HttpRequestBase)mkcol);
        this.creds.addAuthHeader((AbstractHttpMessage)mkcol);
        HttpResponse response = this.executeRequest((HttpUriRequest)mkcol);
        TransportClient.consumeContent(response);
        StatusLine statusLine = response.getStatusLine();
        if (statusLine != null) {
            int statusCode = statusLine.getStatusCode();
            switch (statusCode) {
                case 201: {
                    Log.d((String)TAG, (String)"Folder created successfully");
                    return;
                }
                case 405: {
                    throw new DuplicateFolderException("Folder '" + dir + "' already exists");
                }
                case 409: {
                    throw new IntermediateFolderNotExistException("Parent folder not exists for '" + dir + "'");
                }
                case 415: {
                    throw new UnsupportedMediaTypeException("Folder '" + dir + "' creation error (http code 415)");
                }
            }
            this.checkStatusCodes(response, "MKCOL '" + dir + "'");
        }
    }

    public void delete(String path) throws IOException, WebdavFileNotFoundException, WebdavUserNotInitialized, UnknownServerWebdavException, PreconditionFailedException, WebdavNotAuthorizedException, ServerWebdavException {
        String url = this.getUrl() + TransportClient.encodeURL(path);
        HttpDelete delete = new HttpDelete(url);
        TransportClient.logMethod((HttpRequestBase)delete);
        this.creds.addAuthHeader((AbstractHttpMessage)delete);
        HttpResponse response = this.executeRequest((HttpUriRequest)delete);
        TransportClient.consumeContent(response);
        StatusLine statusLine = response.getStatusLine();
        if (statusLine != null) {
            switch (statusLine.getStatusCode()) {
                case 200: {
                    Log.d((String)TAG, (String)"Delete successfully completed");
                    return;
                }
                case 404: {
                    throw new WebdavFileNotFoundException("'" + path + "' cannot be deleted");
                }
            }
            this.checkStatusCodes(response, "DELETE '" + path + "'");
        }
    }

    public void move(String src, String dest) throws WebdavException, IOException {
        Move move = new Move(this.getUrl() + TransportClient.encodeURL(src));
        move.setHeader("Destination", TransportClient.encodeURL(dest));
        move.setHeader("Overwrite", "F");
        TransportClient.logMethod((HttpRequestBase)move, "to " + TransportClient.encodeURL(dest));
        this.creds.addAuthHeader((AbstractHttpMessage)move);
        HttpResponse response = this.executeRequest((HttpUriRequest)move);
        TransportClient.consumeContent(response);
        StatusLine statusLine = response.getStatusLine();
        if (statusLine != null) {
            int statusCode = statusLine.getStatusCode();
            switch (statusCode) {
                case 201: {
                    Log.d((String)TAG, (String)"Rename successfully completed");
                    return;
                }
                case 202: 
                case 207: {
                    Log.d((String)TAG, (String)("HTTP code " + statusCode + ": " + statusLine));
                    return;
                }
                case 404: {
                    throw new WebdavFileNotFoundException("'" + src + "' not found");
                }
                case 409: {
                    throw new DuplicateFolderException("File or folder " + dest + " already exist");
                }
            }
            this.checkStatusCodes(response, "MOVE '" + src + "' to '" + dest + "'");
        }
    }

    public String publish(String path) throws IOException, WebdavException {
        HttpPost post = new HttpPost(this.getUrl() + TransportClient.encodeURL(path) + "?publish");
        TransportClient.logMethod((HttpRequestBase)post, "(publish)");
        this.creds.addAuthHeader((AbstractHttpMessage)post);
        BasicHttpContext shareHttpContext = new BasicHttpContext();
        shareHttpContext.setAttribute(NO_REDIRECT_CONTEXT, (Object)true);
        HttpResponse httpResponse = this.executeRequest((HttpUriRequest)post, (HttpContext)shareHttpContext);
        TransportClient.consumeContent(httpResponse);
        StatusLine statusLine = httpResponse.getStatusLine();
        if (statusLine != null) {
            int statusCode = statusLine.getStatusCode();
            switch (statusCode) {
                case 302: {
                    Header[] locationHeaders = httpResponse.getHeaders(LOCATION_HEADER);
                    if (locationHeaders.length == 1) {
                        String url = httpResponse.getHeaders(LOCATION_HEADER)[0].getValue();
                        Log.d((String)TAG, (String)("publish: " + url));
                        return url;
                    }
                    this.checkStatusCodes(httpResponse, "publish");
                    break;
                }
                case 403: {
                    throw new WebdavSharingForbiddenException("Folder " + path + " can't be shared");
                }
                default: {
                    this.checkStatusCodes(httpResponse, "publish");
                }
            }
        }
        return null;
    }

    public void unpublish(String path) throws IOException, WebdavException {
        HttpPost post = new HttpPost(this.getUrl() + TransportClient.encodeURL(path) + "?unpublish");
        TransportClient.logMethod((HttpRequestBase)post, "(unpublish)");
        this.creds.addAuthHeader((AbstractHttpMessage)post);
        HttpResponse httpResponse = this.executeRequest((HttpUriRequest)post);
        TransportClient.consumeContent(httpResponse);
        StatusLine statusLine = httpResponse.getStatusLine();
        if (statusLine != null && statusLine.getStatusCode() == 200) {
            return;
        }
        this.checkStatusCodes(httpResponse, "unpublish");
    }

    static {
        try {
            serverURL = new URL("https://webdav.yandex.ru:443");
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException(ex);
        }
        requestRetryHandler = new HttpRequestRetryHandler(){

            public boolean retryRequest(IOException ex, int count, HttpContext httpContext) {
                return false;
            }
        };
        redirectHandler = new DefaultRedirectHandler(){

            public boolean isRedirectRequested(HttpResponse httpResponse, HttpContext httpContext) {
                Object noRedirect = httpContext.getAttribute(TransportClient.NO_REDIRECT_CONTEXT);
                if (noRedirect != null && ((Boolean)noRedirect).booleanValue()) {
                    return false;
                }
                return super.isRedirectRequested(httpResponse, httpContext);
            }
        };
        CONTENT_RANGE_HEADER_PATTERN = Pattern.compile("bytes\\D+(\\d+)-\\d+/(\\d+)");
    }

    private static class Move
    extends HttpPut {
        public Move(String url) {
            super(url);
        }

        public String getMethod() {
            return "MOVE";
        }
    }

    private static class HttpMkcol
    extends HttpPut {
        public HttpMkcol(String url) {
            super(url);
        }

        public String getMethod() {
            return "MKCOL";
        }
    }

    public static class PropFind
    extends HttpPost {
        public PropFind() {
        }

        public PropFind(String url) {
            super(url);
        }

        public String getMethod() {
            return "PROPFIND";
        }
    }

    public static enum HashType {
        MD5,
        SHA256;

    }
}

