/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.iap.model;

import android.os.Parcel;
import android.os.Parcelable;
import com.amazon.device.iap.internal.model.ProductBuilder;
import com.amazon.device.iap.internal.util.d;
import com.amazon.device.iap.model.ProductType;
import org.json.JSONException;
import org.json.JSONObject;

public final class Product
implements Parcelable {
    private static final String SKU = "sku";
    private static final String PRODUCT_TYPE = "productType";
    private static final String DESCRIPTION = "description";
    private static final String PRICE = "price";
    private static final String SMALL_ICON_URL = "smallIconUrl";
    private static final String TITLE = "title";
    private final String sku;
    private final ProductType productType;
    private final String description;
    private final String price;
    private final String smallIconUrl;
    private final String title;
    public static final Parcelable.Creator<Product> CREATOR = new Parcelable.Creator<Product>(){

        public Product createFromParcel(Parcel parcel) {
            return new Product(parcel);
        }

        public Product[] newArray(int n) {
            return new Product[n];
        }
    };

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeString(this.sku);
        parcel.writeString(this.productType.toString());
        parcel.writeString(this.description);
        parcel.writeString(this.price);
        parcel.writeString(this.smallIconUrl);
        parcel.writeString(this.title);
    }

    private Product(Parcel parcel) {
        this.sku = parcel.readString();
        this.productType = ProductType.valueOf(parcel.readString());
        this.description = parcel.readString();
        this.price = parcel.readString();
        this.smallIconUrl = parcel.readString();
        this.title = parcel.readString();
    }

    public Product(ProductBuilder productBuilder) {
        d.a((Object)productBuilder.getSku(), SKU);
        d.a((Object)productBuilder.getProductType(), PRODUCT_TYPE);
        d.a((Object)productBuilder.getDescription(), DESCRIPTION);
        d.a((Object)productBuilder.getTitle(), TITLE);
        d.a((Object)productBuilder.getSmallIconUrl(), SMALL_ICON_URL);
        if (ProductType.SUBSCRIPTION != productBuilder.getProductType()) {
            d.a((Object)productBuilder.getPrice(), PRICE);
        }
        this.sku = productBuilder.getSku();
        this.productType = productBuilder.getProductType();
        this.description = productBuilder.getDescription();
        this.price = productBuilder.getPrice();
        this.smallIconUrl = productBuilder.getSmallIconUrl();
        this.title = productBuilder.getTitle();
    }

    public String getSku() {
        return this.sku;
    }

    public ProductType getProductType() {
        return this.productType;
    }

    public String getDescription() {
        return this.description;
    }

    public String getPrice() {
        return this.price;
    }

    public String getSmallIconUrl() {
        return this.smallIconUrl;
    }

    public String getTitle() {
        return this.title;
    }

    public JSONObject toJSON() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put(SKU, (Object)this.sku);
        jSONObject.put(PRODUCT_TYPE, (Object)this.productType);
        jSONObject.put(DESCRIPTION, (Object)this.description);
        jSONObject.put(PRICE, (Object)this.price);
        jSONObject.put(SMALL_ICON_URL, (Object)this.smallIconUrl);
        jSONObject.put(TITLE, (Object)this.title);
        return jSONObject;
    }

    public String toString() {
        String string = null;
        try {
            string = this.toJSON().toString(4);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return string;
    }
}

