/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import com.google.android.gms.analytics.ExceptionReporter;
import com.google.android.gms.analytics.GoogleAnalytics;
import com.google.android.gms.analytics.TrackerHandler;
import com.google.android.gms.analytics.aa;
import com.google.android.gms.analytics.ad;
import com.google.android.gms.analytics.ae;
import com.google.android.gms.analytics.aj;
import com.google.android.gms.analytics.ak;
import com.google.android.gms.analytics.g;
import com.google.android.gms.analytics.h;
import com.google.android.gms.analytics.i;
import com.google.android.gms.analytics.u;
import com.google.android.gms.analytics.z;
import com.google.android.gms.internal.er;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tracker {
    private final TrackerHandler up;
    private final Map<String, String> uq = new HashMap<String, String>();
    private ad ur;
    private final h us;
    private final ae ut;
    private final g uu;
    private boolean uv;
    private a uw;
    private aj ux;

    Tracker(String trackingId, TrackerHandler handler) {
        this(trackingId, handler, h.bu(), ae.cs(), g.bt(), new z("tracking"));
    }

    Tracker(String trackingId, TrackerHandler handler, h clientIdDefaultProvider, ae screenResolutionDefaultProvider, g appFieldsDefaultProvider, ad rateLimiter) {
        this.up = handler;
        if (trackingId != null) {
            this.uq.put("&tid", trackingId);
        }
        this.uq.put("useSecure", "1");
        this.us = clientIdDefaultProvider;
        this.ut = screenResolutionDefaultProvider;
        this.uu = appFieldsDefaultProvider;
        this.ur = rateLimiter;
        this.uw = new a();
    }

    void a(Context context, aj aj2) {
        Object object;
        aa.v("Loading Tracker config values.");
        this.ux = aj2;
        if (this.ux.cB()) {
            object = this.ux.cC();
            this.set("&tid", (String)object);
            aa.v("[Tracker] trackingId loaded: " + (String)object);
        }
        if (this.ux.cD()) {
            object = Double.toString(this.ux.cE());
            this.set("&sf", (String)object);
            aa.v("[Tracker] sample frequency loaded: " + (String)object);
        }
        if (this.ux.cF()) {
            this.setSessionTimeout(this.ux.getSessionTimeout());
            aa.v("[Tracker] session timeout loaded: " + this.cu());
        }
        if (this.ux.cG()) {
            this.enableAutoActivityTracking(this.ux.cH());
            aa.v("[Tracker] auto activity tracking loaded: " + this.cv());
        }
        if (this.ux.cI()) {
            if (this.ux.cJ()) {
                this.set("&aip", "1");
                aa.v("[Tracker] anonymize ip loaded: true");
            }
            aa.v("[Tracker] anonymize ip loaded: false");
        }
        this.uv = this.ux.cK();
        if (this.ux.cK()) {
            object = new ExceptionReporter(this, Thread.getDefaultUncaughtExceptionHandler(), context);
            Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)object);
            aa.v("[Tracker] report uncaught exceptions loaded: " + this.uv);
        }
    }

    public void setSessionTimeout(long sessionTimeout) {
        this.uw.setSessionTimeout(sessionTimeout * 1000L);
    }

    long cu() {
        return this.uw.cu();
    }

    public void enableAutoActivityTracking(boolean enabled) {
        this.uw.enableAutoActivityTracking(enabled);
    }

    boolean cv() {
        return this.uw.cv();
    }

    public void send(Map<String, String> params) {
        String string2;
        u.bR().a(u.a.sw);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.putAll(this.uq);
        if (params != null) {
            hashMap.putAll(params);
        }
        if (TextUtils.isEmpty((CharSequence)((CharSequence)hashMap.get("&tid")))) {
            aa.w(String.format("Missing tracking id (%s) parameter.", "&tid"));
        }
        if (TextUtils.isEmpty((CharSequence)(string2 = (String)hashMap.get("&t")))) {
            aa.w(String.format("Missing hit type (%s) parameter.", "&t"));
            string2 = "";
        }
        if (this.uw.cw()) {
            hashMap.put("&sc", "start");
        }
        if (!(string2.equals("transaction") || string2.equals("item") || this.ur.cl())) {
            aa.w("Too many hits sent too quickly, rate limiting invoked.");
        } else {
            this.up.n(hashMap);
        }
    }

    public String get(String key) {
        u.bR().a(u.a.su);
        if (TextUtils.isEmpty((CharSequence)key)) {
            return null;
        }
        if (this.uq.containsKey(key)) {
            return this.uq.get(key);
        }
        if (key.equals("&ul")) {
            return ak.a(Locale.getDefault());
        }
        if (this.us != null && this.us.x(key)) {
            return this.us.getValue(key);
        }
        if (this.ut != null && this.ut.x(key)) {
            return this.ut.getValue(key);
        }
        if (this.uu != null && this.uu.x(key)) {
            return this.uu.getValue(key);
        }
        return null;
    }

    public void set(String key, String value) {
        er.b(key, (Object)"Key should be non-null");
        u.bR().a(u.a.sv);
        this.uq.put(key, value);
    }

    public void setSampleRate(double sampleRate) {
        this.set("&sf", Double.toHexString(sampleRate));
    }

    public void setUseSecure(boolean useSecure) {
        this.set("useSecure", ak.s(useSecure));
    }

    public void setScreenName(String screenName) {
        this.set("&cd", screenName);
    }

    public void setLocation(String location) {
        this.set("&dl", location);
    }

    public void setReferrer(String referrer) {
        this.set("&dr", referrer);
    }

    public void setPage(String page) {
        this.set("&dp", page);
    }

    public void setHostname(String hostname) {
        this.set("&dh", hostname);
    }

    public void setTitle(String title) {
        this.set("&dt", title);
    }

    public void setLanguage(String language) {
        this.set("&ul", language);
    }

    public void setEncoding(String encoding) {
        this.set("&de", encoding);
    }

    public void setScreenColors(String screenColors) {
        this.set("&sd", screenColors);
    }

    public void setScreenResolution(int width, int height) {
        if (width < 0 && height < 0) {
            aa.w("Invalid width or height. The values should be non-negative.");
            return;
        }
        this.set("&sr", width + "x" + height);
    }

    public void setViewportSize(String viewportSize) {
        this.set("&vp", viewportSize);
    }

    public void setClientId(String clientId) {
        this.set("&cid", clientId);
    }

    public void setAppName(String appName) {
        this.set("&an", appName);
    }

    public void setAppId(String appId) {
        this.set("&aid", appId);
    }

    public void setAppInstallerId(String appInstallerId) {
        this.set("&aiid", appInstallerId);
    }

    public void setAppVersion(String appVersion) {
        this.set("&av", appVersion);
    }

    public void setAnonymizeIp(boolean anonymize) {
        this.set("&aip", ak.s(anonymize));
    }

    public void enableAdvertisingIdCollection(boolean enabled) {
        if (!enabled) {
            this.uq.put("&ate", null);
            this.uq.put("&adid", null);
        } else {
            if (this.uq.containsKey("&ate")) {
                this.uq.remove("&ate");
            }
            if (this.uq.containsKey("&adid")) {
                this.uq.remove("&adid");
            }
        }
    }

    private class com.google.android.gms.analytics.Tracker$a
    implements GoogleAnalytics.a {
        private Timer uy;
        private TimerTask uz;
        private boolean uA = false;
        private boolean uB = false;
        private int uC = 0;
        private long uD = -1L;
        private boolean uE = false;
        private long uF;
        private i rJ;

        public com.google.android.gms.analytics.Tracker$a() {
            this.rJ = new i(){

                public long currentTimeMillis() {
                    return System.currentTimeMillis();
                }
            };
        }

        public void setSessionTimeout(long sessionTimeout) {
            this.uD = sessionTimeout;
            this.cx();
        }

        public long cu() {
            return this.uD;
        }

        public void enableAutoActivityTracking(boolean enabled) {
            this.uB = enabled;
            this.cx();
        }

        public boolean cv() {
            return this.uB;
        }

        public boolean cw() {
            boolean bl2 = this.uE;
            this.uE = false;
            return bl2;
        }

        private void cx() {
            GoogleAnalytics googleAnalytics = GoogleAnalytics.cf();
            if (googleAnalytics == null) {
                aa.t("GoogleAnalytics isn't initialized for the Tracker!");
                return;
            }
            if (this.uD >= 0L || this.uB) {
                googleAnalytics.a(Tracker.this.uw);
            } else {
                googleAnalytics.b(Tracker.this.uw);
            }
        }

        public void f(Activity activity) {
            u.bR().a(u.a.tt);
            this.cy();
            if (!this.uA && this.uC == 0 && this.cz()) {
                this.uE = true;
            }
            this.uA = true;
            ++this.uC;
            if (this.uB) {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("&t", "appview");
                u.bR().r(true);
                Tracker.this.set("&cd", Tracker.this.ux != null ? Tracker.this.ux.h(activity) : activity.getClass().getCanonicalName());
                Tracker.this.send(hashMap);
                u.bR().r(false);
            }
        }

        public void g(Activity activity) {
            u.bR().a(u.a.tu);
            --this.uC;
            this.uC = Math.max(0, this.uC);
            this.uF = this.rJ.currentTimeMillis();
            if (this.uC == 0) {
                this.cy();
                this.uz = new a();
                this.uy = new Timer("waitForActivityStart");
                this.uy.schedule(this.uz, 1000L);
            }
        }

        private synchronized void cy() {
            if (this.uy != null) {
                this.uy.cancel();
                this.uy = null;
            }
        }

        boolean cz() {
            return this.uD == 0L || this.uD > 0L && this.rJ.currentTimeMillis() > this.uF + this.uD;
        }

        private class a
        extends TimerTask {
            private a() {
            }

            public void run() {
                a.this.uA = false;
            }
        }
    }
}

