/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.appstate;

import android.content.Context;
import android.os.Looper;
import com.google.android.gms.appstate.AppStateBuffer;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Releasable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.a;
import com.google.android.gms.internal.dl;
import com.google.android.gms.internal.ee;
import com.google.android.gms.internal.er;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AppStateManager {
    static final Api.b<dl> va = new Api.b<dl>(){

        public dl a(Context context, Looper looper, ee ee2, GoogleApiClient.ApiOptions apiOptions, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            return new dl(context, looper, connectionCallbacks, onConnectionFailedListener, ee2.dR(), ee2.dT().toArray(new String[0]));
        }

        @Override
        public int getPriority() {
            return Integer.MAX_VALUE;
        }

        @Override
        public /* synthetic */ Api.a b(Context context, Looper looper, ee ee2, GoogleApiClient.ApiOptions apiOptions, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            return this.a(context, looper, ee2, apiOptions, connectionCallbacks, onConnectionFailedListener);
        }
    };
    public static final Scope SCOPE_APP_STATE = new Scope("https://www.googleapis.com/auth/appstate");
    public static final Api API = new Api(va, SCOPE_APP_STATE);

    private AppStateManager() {
    }

    public static dl a(GoogleApiClient googleApiClient) {
        er.b(googleApiClient != null, (Object)"GoogleApiClient parameter is required.");
        er.a(googleApiClient.isConnected(), "GoogleApiClient must be connected.");
        dl dl2 = googleApiClient.a(va);
        er.a(dl2 != null, "GoogleApiClient is not configured to use the AppState API. Pass AppStateManager.API into GoogleApiClient.Builder#addApi() to use this feature.");
        return dl2;
    }

    public static int getMaxStateSize(GoogleApiClient googleApiClient) {
        return AppStateManager.a(googleApiClient).cN();
    }

    public static int getMaxNumKeys(GoogleApiClient googleApiClient) {
        return AppStateManager.a(googleApiClient).cO();
    }

    private static StateResult a(final Status status) {
        return new StateResult(){

            public Status getStatus() {
                return status;
            }

            public StateLoadedResult getLoadedResult() {
                return null;
            }

            public StateConflictResult getConflictResult() {
                return null;
            }

            public void release() {
            }
        };
    }

    public static void update(GoogleApiClient googleApiClient, final int stateKey, final byte[] data) {
        googleApiClient.b(new e(){

            protected void a(dl dl2) {
                dl2.a(null, stateKey, data);
            }
        });
    }

    public static PendingResult<StateResult> updateImmediate(GoogleApiClient googleApiClient, final int stateKey, final byte[] data) {
        return googleApiClient.b(new e(){

            protected void a(dl dl2) {
                dl2.a(this, stateKey, data);
            }
        });
    }

    public static PendingResult<StateDeletedResult> delete(GoogleApiClient googleApiClient, final int stateKey) {
        return googleApiClient.b(new b(){

            protected void a(dl dl2) {
                dl2.a(this, stateKey);
            }

            public StateDeletedResult c(final Status status) {
                return new StateDeletedResult(){

                    public Status getStatus() {
                        return status;
                    }

                    public int getStateKey() {
                        return stateKey;
                    }
                };
            }

            public /* synthetic */ Result d(Status status) {
                return this.c(status);
            }
        });
    }

    public static PendingResult<StateResult> load(GoogleApiClient googleApiClient, final int stateKey) {
        return googleApiClient.a(new e(){

            protected void a(dl dl2) {
                dl2.b(this, stateKey);
            }
        });
    }

    public static PendingResult<StateListResult> list(GoogleApiClient googleApiClient) {
        return googleApiClient.a(new c(){

            protected void a(dl dl2) {
                dl2.a(this);
            }
        });
    }

    public static PendingResult<StateResult> resolve(GoogleApiClient googleApiClient, final int stateKey, final String resolvedVersion, final byte[] resolvedData) {
        return googleApiClient.b(new e(){

            protected void a(dl dl2) {
                dl2.a(this, stateKey, resolvedVersion, resolvedData);
            }
        });
    }

    public static PendingResult<Status> signOut(GoogleApiClient googleApiClient) {
        return googleApiClient.b(new d(){

            protected void a(dl dl2) {
                dl2.b(this);
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class d
    extends a<Status> {
        private d() {
        }

        public Status f(Status status) {
            return status;
        }

        @Override
        public /* synthetic */ Result d(Status status) {
            return this.f(status);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class c
    extends a<StateListResult> {
        private c() {
        }

        public StateListResult e(final Status status) {
            return new StateListResult(){

                public Status getStatus() {
                    return status;
                }

                public AppStateBuffer getStateBuffer() {
                    return new AppStateBuffer(null);
                }
            };
        }

        @Override
        public /* synthetic */ Result d(Status status) {
            return this.e(status);
        }
    }

    public static interface StateListResult
    extends Result {
        public AppStateBuffer getStateBuffer();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class b
    extends a<StateDeletedResult> {
        private b() {
        }
    }

    public static interface StateDeletedResult
    extends Result {
        public int getStateKey();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class e
    extends a<StateResult> {
        private e() {
        }

        public StateResult g(Status status) {
            return AppStateManager.a(status);
        }

        @Override
        public /* synthetic */ Result d(Status status) {
            return this.g(status);
        }
    }

    public static interface StateConflictResult
    extends Releasable,
    Result {
        public int getStateKey();

        public String getResolvedVersion();

        public byte[] getLocalData();

        public byte[] getServerData();
    }

    public static interface StateLoadedResult
    extends Releasable,
    Result {
        public int getStateKey();

        public byte[] getLocalData();
    }

    public static interface StateResult
    extends Releasable,
    Result {
        public StateLoadedResult getLoadedResult();

        public StateConflictResult getConflictResult();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class a<R extends Result>
    extends a.a<R, dl>
    implements PendingResult<R> {
        public a() {
            super(va);
        }
    }
}

