/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.cast.b;
import com.google.android.gms.common.images.WebImage;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.dr;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CastDevice
implements SafeParcelable {
    public static final Parcelable.Creator<CastDevice> CREATOR = new b();
    private final int wj;
    private String wC;
    String wD;
    private Inet4Address wE;
    private String wF;
    private String wG;
    private String wH;
    private int wI;
    private List<WebImage> wJ;

    CastDevice(int versionCode, String deviceId, String hostAddress, String friendlyName, String modelName, String deviceVersion, int servicePort, List<WebImage> icons) {
        this.wj = versionCode;
        this.wC = deviceId;
        this.wD = hostAddress;
        if (this.wD != null) {
            try {
                InetAddress inetAddress = InetAddress.getByName(this.wD);
                if (inetAddress instanceof Inet4Address) {
                    this.wE = (Inet4Address)inetAddress;
                }
            }
            catch (UnknownHostException unknownHostException) {
                this.wE = null;
            }
        }
        this.wF = friendlyName;
        this.wG = modelName;
        this.wH = deviceVersion;
        this.wI = servicePort;
        this.wJ = icons;
    }

    private CastDevice() {
        this(1, null, null, null, null, null, -1, new ArrayList<WebImage>());
    }

    int getVersionCode() {
        return this.wj;
    }

    public String getDeviceId() {
        return this.wC;
    }

    public Inet4Address getIpAddress() {
        return this.wE;
    }

    public String getFriendlyName() {
        return this.wF;
    }

    public String getModelName() {
        return this.wG;
    }

    public String getDeviceVersion() {
        return this.wH;
    }

    public int getServicePort() {
        return this.wI;
    }

    public List<WebImage> getIcons() {
        return Collections.unmodifiableList(this.wJ);
    }

    public WebImage getIcon(int preferredWidth, int preferredHeight) {
        if (this.wJ.isEmpty()) {
            return null;
        }
        if (preferredWidth <= 0 || preferredHeight <= 0) {
            return this.wJ.get(0);
        }
        WebImage webImage = null;
        WebImage webImage2 = null;
        for (WebImage webImage3 : this.wJ) {
            int n2 = webImage3.getWidth();
            int n3 = webImage3.getHeight();
            if (n2 >= preferredWidth && n3 >= preferredHeight) {
                if (webImage != null && (webImage.getWidth() <= n2 || webImage.getHeight() <= n3)) continue;
                webImage = webImage3;
                continue;
            }
            if (n2 >= preferredWidth || n3 >= preferredHeight || webImage2 != null && (webImage2.getWidth() >= n2 || webImage2.getHeight() >= n3)) continue;
            webImage2 = webImage3;
        }
        Object object = null;
        object = webImage != null ? webImage : (webImage2 != null ? webImage2 : this.wJ.get(0));
        return object;
    }

    public boolean hasIcons() {
        return !this.wJ.isEmpty();
    }

    public String toString() {
        return String.format("\"%s\" (%s)", this.wF, this.wC);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        b.a(this, out, flags);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CastDevice)) {
            return false;
        }
        CastDevice castDevice = (CastDevice)obj;
        if (this.getDeviceId() == null) {
            return castDevice.getDeviceId() == null;
        }
        return dr.a(this.wC, castDevice.wC) && dr.a(this.wE, castDevice.wE) && dr.a(this.wG, castDevice.wG) && dr.a(this.wF, castDevice.wF) && dr.a(this.wH, castDevice.wH) && this.wI == castDevice.wI && dr.a(this.wJ, castDevice.wJ);
    }

    public boolean isSameDevice(CastDevice castDevice) {
        if (castDevice == null) {
            return false;
        }
        if (this.getDeviceId() == null) {
            return castDevice.getDeviceId() == null;
        }
        return dr.a(this.getDeviceId(), castDevice.getDeviceId());
    }

    public int hashCode() {
        return this.wC == null ? 0 : this.wC.hashCode();
    }

    public void putInBundle(Bundle bundle) {
        if (bundle == null) {
            return;
        }
        bundle.putParcelable("com.google.android.gms.cast.EXTRA_CAST_DEVICE", (Parcelable)this);
    }

    public static CastDevice getFromBundle(Bundle extras) {
        if (extras == null) {
            return null;
        }
        extras.setClassLoader(CastDevice.class.getClassLoader());
        return (CastDevice)extras.getParcelable("com.google.android.gms.cast.EXTRA_CAST_DEVICE");
    }
}

