/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.os.Bundle;
import android.text.TextUtils;
import com.google.android.gms.common.images.WebImage;
import com.google.android.gms.internal.dz;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediaMetadata {
    public static final int MEDIA_TYPE_GENERIC = 0;
    public static final int MEDIA_TYPE_MOVIE = 1;
    public static final int MEDIA_TYPE_TV_SHOW = 2;
    public static final int MEDIA_TYPE_MUSIC_TRACK = 3;
    public static final int MEDIA_TYPE_PHOTO = 4;
    public static final int MEDIA_TYPE_USER = 100;
    private static final String[] wR = new String[]{null, "String", "int", "double", "ISO-8601 date String"};
    private static final a wS = new a().a("com.google.android.gms.cast.metadata.CREATION_DATE", "creationDateTime", 4).a("com.google.android.gms.cast.metadata.RELEASE_DATE", "releaseDate", 4).a("com.google.android.gms.cast.metadata.BROADCAST_DATE", "originalAirdate", 4).a("com.google.android.gms.cast.metadata.TITLE", "title", 1).a("com.google.android.gms.cast.metadata.SUBTITLE", "subtitle", 1).a("com.google.android.gms.cast.metadata.ARTIST", "artist", 1).a("com.google.android.gms.cast.metadata.ALBUM_ARTIST", "albumArtist", 1).a("com.google.android.gms.cast.metadata.ALBUM_TITLE", "albumName", 1).a("com.google.android.gms.cast.metadata.COMPOSER", "composer", 1).a("com.google.android.gms.cast.metadata.DISC_NUMBER", "discNumber", 2).a("com.google.android.gms.cast.metadata.TRACK_NUMBER", "trackNumber", 2).a("com.google.android.gms.cast.metadata.SEASON_NUMBER", "season", 2).a("com.google.android.gms.cast.metadata.EPISODE_NUMBER", "episode", 2).a("com.google.android.gms.cast.metadata.SERIES_TITLE", "seriesTitle", 1).a("com.google.android.gms.cast.metadata.STUDIO", "studio", 1).a("com.google.android.gms.cast.metadata.WIDTH", "width", 2).a("com.google.android.gms.cast.metadata.HEIGHT", "height", 2).a("com.google.android.gms.cast.metadata.LOCATION_NAME", "location", 1).a("com.google.android.gms.cast.metadata.LOCATION_LATITUDE", "latitude", 3).a("com.google.android.gms.cast.metadata.LOCATION_LONGITUDE", "longitude", 3);
    private final List<WebImage> wl = new ArrayList<WebImage>();
    private final Bundle wT = new Bundle();
    private int wU;
    public static final String KEY_CREATION_DATE = "com.google.android.gms.cast.metadata.CREATION_DATE";
    public static final String KEY_RELEASE_DATE = "com.google.android.gms.cast.metadata.RELEASE_DATE";
    public static final String KEY_BROADCAST_DATE = "com.google.android.gms.cast.metadata.BROADCAST_DATE";
    public static final String KEY_TITLE = "com.google.android.gms.cast.metadata.TITLE";
    public static final String KEY_SUBTITLE = "com.google.android.gms.cast.metadata.SUBTITLE";
    public static final String KEY_ARTIST = "com.google.android.gms.cast.metadata.ARTIST";
    public static final String KEY_ALBUM_ARTIST = "com.google.android.gms.cast.metadata.ALBUM_ARTIST";
    public static final String KEY_ALBUM_TITLE = "com.google.android.gms.cast.metadata.ALBUM_TITLE";
    public static final String KEY_COMPOSER = "com.google.android.gms.cast.metadata.COMPOSER";
    public static final String KEY_DISC_NUMBER = "com.google.android.gms.cast.metadata.DISC_NUMBER";
    public static final String KEY_TRACK_NUMBER = "com.google.android.gms.cast.metadata.TRACK_NUMBER";
    public static final String KEY_SEASON_NUMBER = "com.google.android.gms.cast.metadata.SEASON_NUMBER";
    public static final String KEY_EPISODE_NUMBER = "com.google.android.gms.cast.metadata.EPISODE_NUMBER";
    public static final String KEY_SERIES_TITLE = "com.google.android.gms.cast.metadata.SERIES_TITLE";
    public static final String KEY_STUDIO = "com.google.android.gms.cast.metadata.STUDIO";
    public static final String KEY_WIDTH = "com.google.android.gms.cast.metadata.WIDTH";
    public static final String KEY_HEIGHT = "com.google.android.gms.cast.metadata.HEIGHT";
    public static final String KEY_LOCATION_NAME = "com.google.android.gms.cast.metadata.LOCATION_NAME";
    public static final String KEY_LOCATION_LATITUDE = "com.google.android.gms.cast.metadata.LOCATION_LATITUDE";
    public static final String KEY_LOCATION_LONGITUDE = "com.google.android.gms.cast.metadata.LOCATION_LONGITUDE";

    public MediaMetadata() {
        this(0);
    }

    public MediaMetadata(int mediaType) {
        this.wU = mediaType;
    }

    public int getMediaType() {
        return this.wU;
    }

    public void clear() {
        this.wT.clear();
        this.wl.clear();
    }

    public boolean containsKey(String key) {
        return this.wT.containsKey(key);
    }

    public Set<String> keySet() {
        return this.wT.keySet();
    }

    public void putString(String key, String value) {
        this.d(key, 1);
        this.wT.putString(key, value);
    }

    public String getString(String key) {
        this.d(key, 1);
        return this.wT.getString(key);
    }

    public void putInt(String key, int value) {
        this.d(key, 2);
        this.wT.putInt(key, value);
    }

    public int getInt(String key) {
        this.d(key, 2);
        return this.wT.getInt(key);
    }

    public void putDouble(String key, double value) {
        this.d(key, 3);
        this.wT.putDouble(key, value);
    }

    public double getDouble(String key) {
        this.d(key, 3);
        return this.wT.getDouble(key);
    }

    public void putDate(String key, Calendar value) {
        this.d(key, 4);
        this.wT.putString(key, dz.a(value));
    }

    public Calendar getDate(String key) {
        this.d(key, 4);
        String string = this.wT.getString(key);
        return string != null ? dz.V(string) : null;
    }

    public String getDateAsString(String key) {
        this.d(key, 4);
        return this.wT.getString(key);
    }

    private void d(String string, int n2) throws IllegalArgumentException {
        if (TextUtils.isEmpty((CharSequence)string)) {
            throw new IllegalArgumentException("null and empty keys are not allowed");
        }
        int n3 = wS.O(string);
        if (n3 != n2 && n3 != 0) {
            throw new IllegalArgumentException("Value for " + string + " must be a " + wR[n2]);
        }
    }

    public JSONObject cT() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("metadataType", this.wU);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        dz.a(jSONObject, this.wl);
        switch (this.wU) {
            case 0: {
                this.a(jSONObject, KEY_TITLE, KEY_ARTIST, KEY_SUBTITLE, KEY_RELEASE_DATE);
                break;
            }
            case 1: {
                this.a(jSONObject, KEY_TITLE, KEY_STUDIO, KEY_SUBTITLE, KEY_RELEASE_DATE);
                break;
            }
            case 2: {
                this.a(jSONObject, KEY_TITLE, KEY_SERIES_TITLE, KEY_SEASON_NUMBER, KEY_EPISODE_NUMBER, KEY_BROADCAST_DATE);
                break;
            }
            case 3: {
                this.a(jSONObject, KEY_TITLE, KEY_ARTIST, KEY_ALBUM_TITLE, KEY_ALBUM_ARTIST, KEY_COMPOSER, KEY_TRACK_NUMBER, KEY_DISC_NUMBER, KEY_RELEASE_DATE);
                break;
            }
            case 4: {
                this.a(jSONObject, KEY_TITLE, KEY_ARTIST, KEY_LOCATION_NAME, KEY_LOCATION_LATITUDE, KEY_LOCATION_LONGITUDE, KEY_WIDTH, KEY_HEIGHT, KEY_CREATION_DATE);
                break;
            }
            default: {
                this.a(jSONObject, new String[0]);
            }
        }
        return jSONObject;
    }

    public void b(JSONObject jSONObject) {
        this.clear();
        this.wU = 0;
        try {
            this.wU = jSONObject.getInt("metadataType");
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        dz.a(this.wl, jSONObject);
        switch (this.wU) {
            case 0: {
                this.b(jSONObject, KEY_TITLE, KEY_ARTIST, KEY_SUBTITLE, KEY_RELEASE_DATE);
                break;
            }
            case 1: {
                this.b(jSONObject, KEY_TITLE, KEY_STUDIO, KEY_SUBTITLE, KEY_RELEASE_DATE);
                break;
            }
            case 2: {
                this.b(jSONObject, KEY_TITLE, KEY_SERIES_TITLE, KEY_SEASON_NUMBER, KEY_EPISODE_NUMBER, KEY_BROADCAST_DATE);
                break;
            }
            case 3: {
                this.b(jSONObject, KEY_TITLE, KEY_ALBUM_TITLE, KEY_ARTIST, KEY_ALBUM_ARTIST, KEY_COMPOSER, KEY_TRACK_NUMBER, KEY_DISC_NUMBER, KEY_RELEASE_DATE);
                break;
            }
            case 4: {
                this.b(jSONObject, KEY_TITLE, KEY_ARTIST, KEY_LOCATION_NAME, KEY_LOCATION_LATITUDE, KEY_LOCATION_LONGITUDE, KEY_WIDTH, KEY_HEIGHT, KEY_CREATION_DATE);
                break;
            }
            default: {
                this.b(jSONObject, new String[0]);
            }
        }
    }

    private void a(JSONObject jSONObject, String ... stringArray) {
        try {
            block7: for (String string : stringArray) {
                if (!this.wT.containsKey(string)) continue;
                int n2 = wS.O(string);
                switch (n2) {
                    case 1: 
                    case 4: {
                        jSONObject.put(wS.M(string), (Object)this.wT.getString(string));
                        continue block7;
                    }
                    case 2: {
                        jSONObject.put(wS.M(string), this.wT.getInt(string));
                        continue block7;
                    }
                    case 3: {
                        jSONObject.put(wS.M(string), this.wT.getDouble(string));
                        continue block7;
                    }
                }
            }
            for (String string : this.wT.keySet()) {
                if (string.startsWith("com.google.")) continue;
                Object object = this.wT.get(string);
                if (object instanceof String) {
                    jSONObject.put(string, object);
                    continue;
                }
                if (object instanceof Integer) {
                    jSONObject.put(string, object);
                    continue;
                }
                if (!(object instanceof Double)) continue;
                jSONObject.put(string, object);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    private void b(JSONObject jSONObject, String ... stringArray) {
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList(stringArray));
        try {
            Iterator iterator = jSONObject.keys();
            block10: while (iterator.hasNext()) {
                Object object;
                String string = (String)iterator.next();
                if ("metadataType".equals(string)) continue;
                String string2 = wS.N(string);
                if (string2 != null) {
                    if (!hashSet.contains(string2)) continue;
                    try {
                        object = jSONObject.get(string);
                        if (object == null) continue;
                        switch (wS.O(string2)) {
                            case 1: {
                                if (!(object instanceof String)) break;
                                this.wT.putString(string2, (String)object);
                                break;
                            }
                            case 4: {
                                if (!(object instanceof String)) break;
                                Calendar calendar = dz.V((String)object);
                                if (calendar == null) continue block10;
                                this.wT.putString(string2, (String)object);
                                break;
                            }
                            case 2: {
                                if (!(object instanceof Integer)) break;
                                this.wT.putInt(string2, ((Integer)object).intValue());
                                break;
                            }
                            case 3: {
                                if (!(object instanceof Double)) break;
                                this.wT.putDouble(string2, ((Double)object).doubleValue());
                            }
                        }
                    }
                    catch (JSONException jSONException) {}
                    continue;
                }
                object = jSONObject.get(string);
                if (object instanceof String) {
                    this.wT.putString(string, (String)object);
                    continue;
                }
                if (object instanceof Integer) {
                    this.wT.putInt(string, ((Integer)object).intValue());
                    continue;
                }
                if (!(object instanceof Double)) continue;
                this.wT.putDouble(string, ((Double)object).doubleValue());
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MediaMetadata)) {
            return false;
        }
        MediaMetadata mediaMetadata = (MediaMetadata)other;
        return this.a(this.wT, mediaMetadata.wT) && ((Object)this.wl).equals(mediaMetadata.wl);
    }

    public int hashCode() {
        int n2 = 17;
        Set set = this.wT.keySet();
        for (String string : set) {
            n2 = 31 * n2 + this.wT.get(string).hashCode();
        }
        n2 = 31 * n2 + ((Object)this.wl).hashCode();
        return n2;
    }

    public List<WebImage> getImages() {
        return this.wl;
    }

    public boolean hasImages() {
        return this.wl != null && !this.wl.isEmpty();
    }

    public void clearImages() {
        this.wl.clear();
    }

    public void addImage(WebImage image) {
        this.wl.add(image);
    }

    private boolean a(Bundle bundle, Bundle bundle2) {
        if (bundle.size() != bundle2.size()) {
            return false;
        }
        Set set = bundle.keySet();
        for (String string : set) {
            Object object = bundle.get(string);
            Object object2 = bundle2.get(string);
            if (object instanceof Bundle && object2 instanceof Bundle && !this.a((Bundle)object, (Bundle)object2)) {
                return false;
            }
            if (!(object == null ? object2 != null || !bundle2.containsKey(string) : !object.equals(object2))) continue;
            return false;
        }
        return true;
    }

    private static class a {
        private final Map<String, String> wV = new HashMap<String, String>();
        private final Map<String, String> wW = new HashMap<String, String>();
        private final Map<String, Integer> wX = new HashMap<String, Integer>();

        public a a(String string, String string2, int n2) {
            this.wV.put(string, string2);
            this.wW.put(string2, string);
            this.wX.put(string, n2);
            return this;
        }

        public String M(String string) {
            return this.wV.get(string);
        }

        public String N(String string) {
            return this.wW.get(string);
        }

        public int O(String string) {
            Integer n2 = this.wX.get(string);
            return n2 != null ? n2 : 0;
        }
    }
}

