/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.content.Context;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Releasable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.a;
import com.google.android.gms.internal.ee;
import com.google.android.gms.internal.ei;
import com.google.android.gms.internal.er;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class b
implements GoogleApiClient {
    private final Lock zv = new ReentrantLock();
    private final Condition zw = this.zv.newCondition();
    private final ei zx;
    final Queue<c<?>> zy = new LinkedList();
    private ConnectionResult zz;
    private int zA;
    private int zB = 4;
    private int zC = 0;
    private boolean zD = false;
    private int zE;
    private long zF = 5000L;
    final Handler zG;
    private final Bundle zH = new Bundle();
    private final Map<Api.b<?>, Api.a> zI = new HashMap();
    private boolean zJ;
    final Set<c> zK = new HashSet<c>();
    private final a zm = new a(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void b(c c2) {
            b.this.zv.lock();
            try {
                b.this.zK.remove(c2);
            }
            finally {
                b.this.zv.unlock();
            }
        }
    };
    final GoogleApiClient.ConnectionCallbacks zL = new GoogleApiClient.ConnectionCallbacks(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onConnected(Bundle connectionHint) {
            b.this.zv.lock();
            try {
                if (b.this.zB == 1) {
                    if (connectionHint != null) {
                        b.this.zH.putAll(connectionHint);
                    }
                    b.this.dy();
                }
            }
            finally {
                b.this.zv.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void onConnectionSuspended(int cause) {
            b.this.zv.lock();
            try {
                b.this.G(cause);
                switch (cause) {
                    case 2: {
                        b.this.connect();
                        return;
                    }
                    case 1: {
                        if (b.this.dA()) {
                            return;
                        }
                        b.this.zC = 2;
                        b.this.zG.sendMessageDelayed(b.this.zG.obtainMessage(1), b.this.zF);
                        return;
                    }
                }
                return;
            }
            finally {
                b.this.zv.unlock();
            }
        }
    };
    private final ei.b zM = new ei.b(){

        public boolean dC() {
            return b.this.zJ;
        }

        public boolean isConnected() {
            return b.this.isConnected();
        }

        public Bundle cY() {
            return null;
        }
    };

    public b(Context context, Looper looper, ee ee2, Map<Api, GoogleApiClient.ApiOptions> map, Set<GoogleApiClient.ConnectionCallbacks> set, Set<GoogleApiClient.OnConnectionFailedListener> set2) {
        this.zx = new ei(context, looper, this.zM);
        this.zG = new b(looper);
        for (GoogleApiClient.ConnectionCallbacks object : set) {
            this.zx.registerConnectionCallbacks(object);
        }
        for (GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener : set2) {
            this.zx.registerConnectionFailedListener(onConnectionFailedListener);
        }
        for (Api api : map.keySet()) {
            final Api.b<?> b2 = api.dp();
            GoogleApiClient.ApiOptions apiOptions = map.get(api);
            this.zI.put(b2, (Api.a)b2.b(context, looper, ee2, apiOptions, this.zL, new GoogleApiClient.OnConnectionFailedListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onConnectionFailed(ConnectionResult result) {
                    b.this.zv.lock();
                    try {
                        if (b.this.zz == null || b2.getPriority() < b.this.zA) {
                            b.this.zz = result;
                            b.this.zA = b2.getPriority();
                        }
                        b.this.dy();
                    }
                    finally {
                        b.this.zv.unlock();
                    }
                }
            }));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dy() {
        this.zv.lock();
        try {
            --this.zE;
            if (this.zE == 0) {
                if (this.zz != null) {
                    this.zD = false;
                    this.G(3);
                    if (this.dA()) {
                        --this.zC;
                    }
                    if (this.dA()) {
                        this.zG.sendMessageDelayed(this.zG.obtainMessage(1), this.zF);
                    } else {
                        this.zx.a(this.zz);
                    }
                    this.zJ = false;
                } else {
                    this.zB = 2;
                    this.dB();
                    this.zw.signalAll();
                    this.dz();
                    if (this.zD) {
                        this.zD = false;
                        this.G(-1);
                    } else {
                        Bundle bundle = this.zH.isEmpty() ? null : this.zH;
                        this.zx.b(bundle);
                    }
                }
            }
        }
        finally {
            this.zv.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A extends Api.a, T extends a.a<? extends Result, A>> T a(T t2) {
        this.zv.lock();
        try {
            if (this.isConnected()) {
                this.b(t2);
            } else {
                this.zy.add(t2);
            }
            T t3 = t2;
            return t3;
        }
        finally {
            this.zv.unlock();
        }
    }

    @Override
    public <A extends Api.a, T extends a.a<? extends Result, A>> T b(T t2) {
        er.a(this.isConnected(), "GoogleApiClient is not connected yet.");
        this.dz();
        try {
            this.a((c<A>)t2);
        }
        catch (DeadObjectException deadObjectException) {
            this.G(1);
        }
        return t2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <A extends Api.a> void a(c<A> c2) throws DeadObjectException {
        this.zv.lock();
        try {
            er.a(this.isConnected(), "GoogleApiClient is not connected yet.");
            er.a(c2.dp() != null, "This task can not be executed or enqueued (it's probably a Batch or malformed)");
            if (c2 instanceof Releasable) {
                this.zK.add(c2);
                c2.a(this.zm);
            }
            A a2 = this.a(c2.dp());
            c2.b(a2);
        }
        finally {
            this.zv.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dz() {
        er.a(this.isConnected(), "GoogleApiClient is not connected yet.");
        this.zv.lock();
        try {
            while (!this.zy.isEmpty()) {
                try {
                    this.a(this.zy.remove());
                }
                catch (DeadObjectException deadObjectException) {
                    Log.w((String)"GoogleApiClientImpl", (String)"Service died while flushing queue", (Throwable)deadObjectException);
                }
            }
        }
        finally {
            this.zv.unlock();
        }
    }

    @Override
    public <C extends Api.a> C a(Api.b<C> b2) {
        Api.a a2 = this.zI.get(b2);
        er.b(a2, (Object)"Appropriate Api was not requested.");
        return (C)a2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect() {
        this.zv.lock();
        try {
            this.zD = false;
            if (this.isConnected() || this.isConnecting()) {
                return;
            }
            this.zJ = true;
            this.zz = null;
            this.zB = 1;
            this.zH.clear();
            this.zE = this.zI.size();
            for (Api.a a2 : this.zI.values()) {
                a2.connect();
            }
        }
        finally {
            this.zv.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectionResult blockingConnect(long timeout, TimeUnit unit) {
        er.a(Looper.myLooper() != Looper.getMainLooper(), "blockingConnect must not be called on the UI thread");
        this.zv.lock();
        try {
            this.connect();
            long l2 = unit.toNanos(timeout);
            while (this.isConnecting()) {
                try {
                    l2 = this.zw.awaitNanos(l2);
                    if (l2 > 0L) continue;
                    ConnectionResult connectionResult = new ConnectionResult(14, null);
                    return connectionResult;
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    ConnectionResult connectionResult = new ConnectionResult(15, null);
                    return connectionResult;
                }
            }
            if (this.isConnected()) {
                ConnectionResult connectionResult = ConnectionResult.yI;
                return connectionResult;
            }
            if (this.zz != null) {
                ConnectionResult connectionResult = this.zz;
                return connectionResult;
            }
            ConnectionResult connectionResult = new ConnectionResult(13, null);
            return connectionResult;
        }
        finally {
            this.zv.unlock();
        }
    }

    @Override
    public void disconnect() {
        this.dB();
        this.G(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void G(int n2) {
        this.zv.lock();
        try {
            if (this.zB != 3) {
                if (n2 == -1) {
                    if (this.isConnecting()) {
                        Iterator iterator = this.zy.iterator();
                        while (iterator.hasNext()) {
                            c c2 = (c)iterator.next();
                            if (c2.dr() == 1) continue;
                            iterator.remove();
                        }
                    } else {
                        this.zy.clear();
                    }
                    if (this.zz == null && !this.zy.isEmpty()) {
                        this.zD = true;
                        return;
                    }
                }
                boolean bl2 = this.isConnecting();
                boolean bl3 = this.isConnected();
                this.zB = 3;
                if (bl2) {
                    if (n2 == -1) {
                        this.zz = null;
                    }
                    this.zw.signalAll();
                }
                for (c object : this.zK) {
                    object.du();
                }
                this.zK.clear();
                this.zJ = false;
                for (Api.a a2 : this.zI.values()) {
                    if (!a2.isConnected()) continue;
                    a2.disconnect();
                }
                this.zJ = true;
                this.zB = 4;
                if (bl3) {
                    if (n2 != -1) {
                        this.zx.P(n2);
                    }
                    this.zJ = false;
                }
            }
        }
        finally {
            this.zv.unlock();
        }
    }

    @Override
    public void reconnect() {
        this.disconnect();
        this.connect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConnected() {
        this.zv.lock();
        try {
            boolean bl2 = this.zB == 2;
            return bl2;
        }
        finally {
            this.zv.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConnecting() {
        this.zv.lock();
        try {
            boolean bl2 = this.zB == 1;
            return bl2;
        }
        finally {
            this.zv.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean dA() {
        this.zv.lock();
        try {
            boolean bl2 = this.zC != 0;
            return bl2;
        }
        finally {
            this.zv.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dB() {
        this.zv.lock();
        try {
            this.zC = 0;
            this.zG.removeMessages(1);
        }
        finally {
            this.zv.unlock();
        }
    }

    @Override
    public void registerConnectionCallbacks(GoogleApiClient.ConnectionCallbacks listener) {
        this.zx.registerConnectionCallbacks(listener);
    }

    @Override
    public boolean isConnectionCallbacksRegistered(GoogleApiClient.ConnectionCallbacks listener) {
        return this.zx.isConnectionCallbacksRegistered(listener);
    }

    @Override
    public void unregisterConnectionCallbacks(GoogleApiClient.ConnectionCallbacks listener) {
        this.zx.unregisterConnectionCallbacks(listener);
    }

    @Override
    public void registerConnectionFailedListener(GoogleApiClient.OnConnectionFailedListener listener) {
        this.zx.registerConnectionFailedListener(listener);
    }

    @Override
    public boolean isConnectionFailedListenerRegistered(GoogleApiClient.OnConnectionFailedListener listener) {
        return this.zx.isConnectionFailedListenerRegistered(listener);
    }

    @Override
    public void unregisterConnectionFailedListener(GoogleApiClient.OnConnectionFailedListener listener) {
        this.zx.unregisterConnectionFailedListener(listener);
    }

    class b
    extends Handler {
        b(Looper looper) {
            super(looper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message msg) {
            if (msg.what == 1) {
                b.this.zv.lock();
                try {
                    if (!b.this.isConnected() && !b.this.isConnecting()) {
                        b.this.connect();
                    }
                    return;
                }
                finally {
                    b.this.zv.unlock();
                }
            }
            Log.wtf((String)"GoogleApiClientImpl", (String)"Don't know how to handle this message.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface c<A extends Api.a> {
        public Api.b<A> dp();

        public void b(A var1) throws DeadObjectException;

        public void a(a var1);

        public void du();

        public int dr();
    }

    static interface a {
        public void b(c var1);
    }
}

