/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.data;

import android.os.Bundle;
import com.google.android.gms.common.data.DataBuffer;
import com.google.android.gms.common.data.Freezable;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DataBufferUtils {
    private DataBufferUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, E extends Freezable<T>> ArrayList<T> freezeAndClose(DataBuffer<E> buffer) {
        ArrayList arrayList = new ArrayList(buffer.getCount());
        try {
            for (Freezable freezable : buffer) {
                arrayList.add(freezable.freeze());
            }
        }
        finally {
            buffer.close();
        }
        return arrayList;
    }

    public static boolean hasNextPage(DataBuffer<?> buffer) {
        Bundle bundle = buffer.getMetadata();
        return bundle != null && bundle.getString("next_page_token") != null;
    }

    public static boolean hasPrevPage(DataBuffer<?> buffer) {
        Bundle bundle = buffer.getMetadata();
        return bundle != null && bundle.getString("prev_page_token") != null;
    }
}

