/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.internal;

import android.os.RemoteException;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.a;
import com.google.android.gms.drive.Contents;
import com.google.android.gms.drive.Drive;
import com.google.android.gms.drive.DriveApi;
import com.google.android.gms.drive.DriveFile;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.MetadataChangeSet;
import com.google.android.gms.drive.internal.CloseContentsAndUpdateMetadataRequest;
import com.google.android.gms.drive.internal.CloseContentsRequest;
import com.google.android.gms.drive.internal.OnContentsResponse;
import com.google.android.gms.drive.internal.OnDownloadProgressResponse;
import com.google.android.gms.drive.internal.OpenContentsRequest;
import com.google.android.gms.drive.internal.ak;
import com.google.android.gms.drive.internal.l;
import com.google.android.gms.drive.internal.m;
import com.google.android.gms.drive.internal.n;
import com.google.android.gms.drive.internal.r;
import com.google.android.gms.drive.internal.v;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class o
extends r
implements DriveFile {
    public o(DriveId driveId) {
        super(driveId);
    }

    @Override
    public PendingResult<DriveApi.ContentsResult> openContents(GoogleApiClient apiClient, final int mode, final DriveFile.DownloadProgressListener listener) {
        if (mode != 0x10000000 && mode != 0x20000000 && mode != 0x30000000) {
            throw new IllegalArgumentException("Invalid mode provided.");
        }
        return apiClient.a(new d(){

            protected void a(n n2) throws RemoteException {
                n2.eT().a(new OpenContentsRequest(o.this.getDriveId(), mode), (v)new c(this, listener));
            }
        });
    }

    @Override
    public PendingResult<Status> commitAndCloseContents(GoogleApiClient apiClient, final Contents contents) {
        if (contents == null) {
            throw new IllegalArgumentException("Contents must be provided.");
        }
        return apiClient.b(new b(){

            protected void a(n n2) throws RemoteException {
                contents.close();
                n2.eT().a(new CloseContentsRequest(contents, true), (v)new ak(this));
            }
        });
    }

    @Override
    public PendingResult<Status> commitAndCloseContents(GoogleApiClient apiClient, final Contents contents, final MetadataChangeSet changeSet) {
        if (contents == null) {
            throw new IllegalArgumentException("Contents must be provided.");
        }
        return apiClient.b(new a(){

            protected void a(n n2) throws RemoteException {
                contents.close();
                n2.eT().a(new CloseContentsAndUpdateMetadataRequest(o.this.CS, changeSet.eS(), contents), (v)new ak(this));
            }
        });
    }

    @Override
    public PendingResult<Status> discardContents(GoogleApiClient apiClient, Contents contents) {
        return Drive.DriveApi.discardContents(apiClient, contents);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class a
    extends m<Status> {
        private a() {
        }

        public Status f(Status status) {
            return status;
        }

        @Override
        public /* synthetic */ Result d(Status status) {
            return this.f(status);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class b
    extends m<Status> {
        private b() {
        }

        public Status f(Status status) {
            return status;
        }

        @Override
        public /* synthetic */ Result d(Status status) {
            return this.f(status);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class c
    extends com.google.android.gms.drive.internal.c {
        private final a.c<DriveApi.ContentsResult> vj;
        private final DriveFile.DownloadProgressListener DL;

        public c(a.c<DriveApi.ContentsResult> c2, DriveFile.DownloadProgressListener downloadProgressListener) {
            this.vj = c2;
            this.DL = downloadProgressListener;
        }

        @Override
        public void a(OnContentsResponse onContentsResponse) throws RemoteException {
            this.vj.b(new l.a(Status.zQ, onContentsResponse.eX()));
        }

        @Override
        public void a(OnDownloadProgressResponse onDownloadProgressResponse) throws RemoteException {
            if (this.DL != null) {
                this.DL.onProgress(onDownloadProgressResponse.eY(), onDownloadProgressResponse.eZ());
            }
        }

        @Override
        public void l(Status status) throws RemoteException {
            this.vj.b(new l.a(status, null));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class d
    extends m<DriveApi.ContentsResult> {
        private d() {
        }

        public DriveApi.ContentsResult n(Status status) {
            return new l.a(status, null);
        }

        @Override
        public /* synthetic */ Result d(Status status) {
            return this.n(status);
        }
    }
}

