/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.turnbased;

import android.os.Bundle;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.games.multiplayer.InvitationBuffer;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchBuffer;
import com.google.android.gms.internal.gv;

public final class LoadMatchesResponse {
    private final InvitationBuffer JV;
    private final TurnBasedMatchBuffer JW;
    private final TurnBasedMatchBuffer JX;
    private final TurnBasedMatchBuffer JY;

    public LoadMatchesResponse(Bundle matchData) {
        DataHolder dataHolder = LoadMatchesResponse.a(matchData, 0);
        this.JV = dataHolder != null ? new InvitationBuffer(dataHolder) : null;
        DataHolder dataHolder2 = LoadMatchesResponse.a(matchData, 1);
        this.JW = dataHolder2 != null ? new TurnBasedMatchBuffer(dataHolder2) : null;
        DataHolder dataHolder3 = LoadMatchesResponse.a(matchData, 2);
        this.JX = dataHolder3 != null ? new TurnBasedMatchBuffer(dataHolder3) : null;
        DataHolder dataHolder4 = LoadMatchesResponse.a(matchData, 3);
        this.JY = dataHolder4 != null ? new TurnBasedMatchBuffer(dataHolder4) : null;
    }

    private static DataHolder a(Bundle bundle, int n2) {
        String string = gv.aW(n2);
        if (!bundle.containsKey(string)) {
            return null;
        }
        return (DataHolder)bundle.getParcelable(string);
    }

    public InvitationBuffer getInvitations() {
        return this.JV;
    }

    public TurnBasedMatchBuffer getMyTurnMatches() {
        return this.JW;
    }

    public TurnBasedMatchBuffer getTheirTurnMatches() {
        return this.JX;
    }

    public TurnBasedMatchBuffer getCompletedMatches() {
        return this.JY;
    }

    public void close() {
        if (this.JV != null) {
            this.JV.close();
        }
        if (this.JW != null) {
            this.JW.close();
        }
        if (this.JX != null) {
            this.JX.close();
        }
        if (this.JY != null) {
            this.JY.close();
        }
    }

    public boolean hasData() {
        if (this.JV != null && this.JV.getCount() > 0) {
            return true;
        }
        if (this.JW != null && this.JW.getCount() > 0) {
            return true;
        }
        if (this.JX != null && this.JX.getCount() > 0) {
            return true;
        }
        return this.JY != null && this.JY.getCount() > 0;
    }
}

