/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.turnbased;

import android.database.CharArrayBuffer;
import android.os.Bundle;
import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantEntity;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatch;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchEntityCreator;
import com.google.android.gms.internal.ep;
import com.google.android.gms.internal.fm;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TurnBasedMatchEntity
implements SafeParcelable,
TurnBasedMatch {
    public static final TurnBasedMatchEntityCreator CREATOR = new TurnBasedMatchEntityCreator();
    private final int wj;
    private final GameEntity Jq;
    private final String GV;
    private final String JS;
    private final long Jr;
    private final String Ka;
    private final long Kb;
    private final String Kc;
    private final int Kd;
    private final int Jv;
    private final int Ke;
    private final byte[] Kf;
    private final ArrayList<ParticipantEntity> Ju;
    private final String Kg;
    private final byte[] Kh;
    private final int Ki;
    private final Bundle JO;
    private final int Kj;
    private final boolean Kk;
    private final String FH;
    private final String Kl;

    public TurnBasedMatchEntity(TurnBasedMatch match) {
        this.wj = 2;
        this.Jq = new GameEntity(match.getGame());
        this.GV = match.getMatchId();
        this.JS = match.getCreatorId();
        this.Jr = match.getCreationTimestamp();
        this.Ka = match.getLastUpdaterId();
        this.Kb = match.getLastUpdatedTimestamp();
        this.Kc = match.getPendingParticipantId();
        this.Kd = match.getStatus();
        this.Kj = match.getTurnStatus();
        this.Jv = match.getVariant();
        this.Ke = match.getVersion();
        this.Kg = match.getRematchId();
        this.Ki = match.getMatchNumber();
        this.JO = match.getAutoMatchCriteria();
        this.Kk = match.isLocallyModified();
        this.FH = match.getDescription();
        this.Kl = match.getDescriptionParticipantId();
        byte[] byArray = match.getData();
        if (byArray == null) {
            this.Kf = null;
        } else {
            this.Kf = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.Kf, 0, byArray.length);
        }
        byte[] byArray2 = match.getPreviousMatchData();
        if (byArray2 == null) {
            this.Kh = null;
        } else {
            this.Kh = new byte[byArray2.length];
            System.arraycopy(byArray2, 0, this.Kh, 0, byArray2.length);
        }
        ArrayList arrayList = match.getParticipants();
        int n2 = arrayList.size();
        this.Ju = new ArrayList(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.Ju.add((ParticipantEntity)((Participant)arrayList.get(i2)).freeze());
        }
    }

    TurnBasedMatchEntity(int versionCode, GameEntity game, String matchId, String creatorId, long creationTimestamp, String lastUpdaterId, long lastUpdatedTimestamp, String pendingParticipantId, int matchStatus, int variant, int version, byte[] data, ArrayList<ParticipantEntity> participants, String rematchId, byte[] previousData, int matchNumber, Bundle autoMatchCriteria, int turnStatus, boolean isLocallyModified, String description, String descriptionParticipantId) {
        this.wj = versionCode;
        this.Jq = game;
        this.GV = matchId;
        this.JS = creatorId;
        this.Jr = creationTimestamp;
        this.Ka = lastUpdaterId;
        this.Kb = lastUpdatedTimestamp;
        this.Kc = pendingParticipantId;
        this.Kd = matchStatus;
        this.Kj = turnStatus;
        this.Jv = variant;
        this.Ke = version;
        this.Kf = data;
        this.Ju = participants;
        this.Kg = rematchId;
        this.Kh = previousData;
        this.Ki = matchNumber;
        this.JO = autoMatchCriteria;
        this.Kk = isLocallyModified;
        this.FH = description;
        this.Kl = descriptionParticipantId;
    }

    public int getVersionCode() {
        return this.wj;
    }

    @Override
    public Game getGame() {
        return this.Jq;
    }

    @Override
    public String getMatchId() {
        return this.GV;
    }

    @Override
    public String getCreatorId() {
        return this.JS;
    }

    @Override
    public long getCreationTimestamp() {
        return this.Jr;
    }

    @Override
    public String getLastUpdaterId() {
        return this.Ka;
    }

    @Override
    public long getLastUpdatedTimestamp() {
        return this.Kb;
    }

    @Override
    public String getPendingParticipantId() {
        return this.Kc;
    }

    @Override
    public int getStatus() {
        return this.Kd;
    }

    @Override
    public int getTurnStatus() {
        return this.Kj;
    }

    @Override
    public String getDescription() {
        return this.FH;
    }

    @Override
    public String getDescriptionParticipantId() {
        return this.Kl;
    }

    @Override
    public Participant getDescriptionParticipant() {
        return this.getParticipant(this.getDescriptionParticipantId());
    }

    @Override
    public void getDescription(CharArrayBuffer dataOut) {
        fm.b(this.FH, dataOut);
    }

    @Override
    public int getVariant() {
        return this.Jv;
    }

    @Override
    public byte[] getData() {
        return this.Kf;
    }

    @Override
    public int getVersion() {
        return this.Ke;
    }

    @Override
    public String getRematchId() {
        return this.Kg;
    }

    @Override
    public byte[] getPreviousMatchData() {
        return this.Kh;
    }

    @Override
    public int getMatchNumber() {
        return this.Ki;
    }

    @Override
    public Bundle getAutoMatchCriteria() {
        return this.JO;
    }

    @Override
    public int getAvailableAutoMatchSlots() {
        if (this.JO == null) {
            return 0;
        }
        return this.JO.getInt("max_automatch_players");
    }

    @Override
    public boolean canRematch() {
        return this.Kd == 2 && this.Kg == null;
    }

    @Override
    public boolean isLocallyModified() {
        return this.Kk;
    }

    @Override
    public int getParticipantStatus(String participantId) {
        return TurnBasedMatchEntity.a((TurnBasedMatch)this, participantId);
    }

    @Override
    public ArrayList<String> getParticipantIds() {
        return TurnBasedMatchEntity.c(this);
    }

    @Override
    public String getParticipantId(String playerId) {
        return TurnBasedMatchEntity.b(this, playerId);
    }

    @Override
    public Participant getParticipant(String participantId) {
        return TurnBasedMatchEntity.c(this, participantId);
    }

    @Override
    public ArrayList<Participant> getParticipants() {
        return new ArrayList<Participant>(this.Ju);
    }

    @Override
    public TurnBasedMatch freeze() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return TurnBasedMatchEntity.a(this);
    }

    static int a(TurnBasedMatch turnBasedMatch) {
        return ep.hashCode(turnBasedMatch.getGame(), turnBasedMatch.getMatchId(), turnBasedMatch.getCreatorId(), turnBasedMatch.getCreationTimestamp(), turnBasedMatch.getLastUpdaterId(), turnBasedMatch.getLastUpdatedTimestamp(), turnBasedMatch.getPendingParticipantId(), turnBasedMatch.getStatus(), turnBasedMatch.getTurnStatus(), turnBasedMatch.getDescription(), turnBasedMatch.getVariant(), turnBasedMatch.getVersion(), turnBasedMatch.getParticipants(), turnBasedMatch.getRematchId(), turnBasedMatch.getMatchNumber(), turnBasedMatch.getAutoMatchCriteria(), turnBasedMatch.getAvailableAutoMatchSlots(), turnBasedMatch.isLocallyModified());
    }

    public boolean equals(Object obj) {
        return TurnBasedMatchEntity.a((TurnBasedMatch)this, obj);
    }

    static boolean a(TurnBasedMatch turnBasedMatch, Object object) {
        if (!(object instanceof TurnBasedMatch)) {
            return false;
        }
        if (turnBasedMatch == object) {
            return true;
        }
        TurnBasedMatch turnBasedMatch2 = (TurnBasedMatch)object;
        return ep.equal(turnBasedMatch2.getGame(), turnBasedMatch.getGame()) && ep.equal(turnBasedMatch2.getMatchId(), turnBasedMatch.getMatchId()) && ep.equal(turnBasedMatch2.getCreatorId(), turnBasedMatch.getCreatorId()) && ep.equal(turnBasedMatch2.getCreationTimestamp(), turnBasedMatch.getCreationTimestamp()) && ep.equal(turnBasedMatch2.getLastUpdaterId(), turnBasedMatch.getLastUpdaterId()) && ep.equal(turnBasedMatch2.getLastUpdatedTimestamp(), turnBasedMatch.getLastUpdatedTimestamp()) && ep.equal(turnBasedMatch2.getPendingParticipantId(), turnBasedMatch.getPendingParticipantId()) && ep.equal(turnBasedMatch2.getStatus(), turnBasedMatch.getStatus()) && ep.equal(turnBasedMatch2.getTurnStatus(), turnBasedMatch.getTurnStatus()) && ep.equal(turnBasedMatch2.getDescription(), turnBasedMatch.getDescription()) && ep.equal(turnBasedMatch2.getVariant(), turnBasedMatch.getVariant()) && ep.equal(turnBasedMatch2.getVersion(), turnBasedMatch.getVersion()) && ep.equal(turnBasedMatch2.getParticipants(), turnBasedMatch.getParticipants()) && ep.equal(turnBasedMatch2.getRematchId(), turnBasedMatch.getRematchId()) && ep.equal(turnBasedMatch2.getMatchNumber(), turnBasedMatch.getMatchNumber()) && ep.equal(turnBasedMatch2.getAutoMatchCriteria(), turnBasedMatch.getAutoMatchCriteria()) && ep.equal(turnBasedMatch2.getAvailableAutoMatchSlots(), turnBasedMatch.getAvailableAutoMatchSlots()) && ep.equal(turnBasedMatch2.isLocallyModified(), turnBasedMatch.isLocallyModified());
    }

    public String toString() {
        return TurnBasedMatchEntity.b(this);
    }

    static String b(TurnBasedMatch turnBasedMatch) {
        return ep.e(turnBasedMatch).a("Game", turnBasedMatch.getGame()).a("MatchId", turnBasedMatch.getMatchId()).a("CreatorId", turnBasedMatch.getCreatorId()).a("CreationTimestamp", turnBasedMatch.getCreationTimestamp()).a("LastUpdaterId", turnBasedMatch.getLastUpdaterId()).a("LastUpdatedTimestamp", turnBasedMatch.getLastUpdatedTimestamp()).a("PendingParticipantId", turnBasedMatch.getPendingParticipantId()).a("MatchStatus", turnBasedMatch.getStatus()).a("TurnStatus", turnBasedMatch.getTurnStatus()).a("Description", turnBasedMatch.getDescription()).a("Variant", turnBasedMatch.getVariant()).a("Data", turnBasedMatch.getData()).a("Version", turnBasedMatch.getVersion()).a("Participants", turnBasedMatch.getParticipants()).a("RematchId", turnBasedMatch.getRematchId()).a("PreviousData", turnBasedMatch.getPreviousMatchData()).a("MatchNumber", turnBasedMatch.getMatchNumber()).a("AutoMatchCriteria", turnBasedMatch.getAutoMatchCriteria()).a("AvailableAutoMatchSlots", turnBasedMatch.getAvailableAutoMatchSlots()).a("LocallyModified", turnBasedMatch.isLocallyModified()).a("DescriptionParticipantId", turnBasedMatch.getDescriptionParticipantId()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        TurnBasedMatchEntityCreator.a(this, out, flags);
    }

    static int a(TurnBasedMatch turnBasedMatch, String string) {
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n2 = arrayList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Participant participant = (Participant)arrayList.get(i2);
            if (!participant.getParticipantId().equals(string)) continue;
            return participant.getStatus();
        }
        throw new IllegalStateException("Participant " + string + " is not in match " + turnBasedMatch.getMatchId());
    }

    static ArrayList<String> c(TurnBasedMatch turnBasedMatch) {
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n2 = arrayList.size();
        ArrayList<String> arrayList2 = new ArrayList<String>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            Participant participant = (Participant)arrayList.get(i2);
            arrayList2.add(participant.getParticipantId());
        }
        return arrayList2;
    }

    static String b(TurnBasedMatch turnBasedMatch, String string) {
        String string2 = null;
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n2 = arrayList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Participant participant = (Participant)arrayList.get(i2);
            Player player = participant.getPlayer();
            if (player == null || !player.getPlayerId().equals(string)) continue;
            string2 = participant.getParticipantId();
            break;
        }
        return string2;
    }

    static Participant c(TurnBasedMatch turnBasedMatch, String string) {
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n2 = arrayList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Participant participant = (Participant)arrayList.get(i2);
            if (!participant.getParticipantId().equals(string)) continue;
            return participant;
        }
        throw new IllegalStateException("Participant " + string + " is not in match " + turnBasedMatch.getMatchId());
    }
}

