/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.media.AudioManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import com.google.android.gms.internal.cv;
import com.google.android.gms.internal.cz;
import java.util.Locale;

public final class cm {
    public final int oM;
    public final boolean oN;
    public final boolean oO;
    public final String oP;
    public final String oQ;
    public final boolean oR;
    public final boolean oS;
    public final boolean oT;
    public final String oU;
    public final String oV;
    public final int oW;
    public final int oX;
    public final int oY;
    public final int oZ;
    public final int pa;
    public final int pb;
    public final float pc;
    public final int pd;
    public final int pe;

    public cm(Context context) {
        AudioManager audioManager = (AudioManager)context.getSystemService("audio");
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        Locale locale = Locale.getDefault();
        PackageManager packageManager = context.getPackageManager();
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        this.oM = audioManager.getMode();
        this.oN = cm.a(packageManager, "geo:0,0?q=donuts") != null;
        this.oO = cm.a(packageManager, "http://www.google.com") != null;
        this.oP = telephonyManager.getNetworkOperator();
        this.oQ = locale.getCountry();
        this.oR = cz.aW();
        this.oS = audioManager.isMusicActive();
        this.oT = audioManager.isSpeakerphoneOn();
        this.oU = locale.getLanguage();
        this.oV = cm.a(packageManager);
        this.oW = audioManager.getStreamVolume(3);
        this.oX = cm.a(context, connectivityManager, packageManager);
        this.oY = telephonyManager.getNetworkType();
        this.oZ = telephonyManager.getPhoneType();
        this.pa = audioManager.getRingerMode();
        this.pb = audioManager.getStreamVolume(2);
        this.pc = displayMetrics.density;
        this.pd = displayMetrics.widthPixels;
        this.pe = displayMetrics.heightPixels;
    }

    private static String a(PackageManager packageManager) {
        ResolveInfo resolveInfo = cm.a(packageManager, "market://details?id=com.google.android.gms.ads");
        if (resolveInfo == null) {
            return null;
        }
        ActivityInfo activityInfo = resolveInfo.activityInfo;
        if (activityInfo == null) {
            return null;
        }
        try {
            PackageInfo packageInfo = packageManager.getPackageInfo(activityInfo.packageName, 0);
            return packageInfo != null ? packageInfo.versionCode + "." + activityInfo.packageName : null;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
    }

    private static int a(Context context, ConnectivityManager connectivityManager, PackageManager packageManager) {
        int n2 = -2;
        if (cv.a(packageManager, context.getPackageName(), "android.permission.ACCESS_NETWORK_STATE")) {
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            n2 = networkInfo != null ? networkInfo.getType() : -1;
        }
        return n2;
    }

    private static ResolveInfo a(PackageManager packageManager, String string2) {
        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)string2));
        return packageManager.resolveActivity(intent, 65536);
    }
}

