/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaStatus;
import com.google.android.gms.internal.dp;
import com.google.android.gms.internal.dr;
import com.google.android.gms.internal.dx;
import com.google.android.gms.internal.dy;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class dv
extends dp {
    private static final long yi = TimeUnit.HOURS.toMillis(24L);
    private static final long yj = TimeUnit.HOURS.toMillis(24L);
    private static final long yk = TimeUnit.HOURS.toMillis(24L);
    private static final long yl = TimeUnit.SECONDS.toMillis(1L);
    private long ym;
    private MediaStatus yn;
    private final Handler mHandler = new Handler(Looper.getMainLooper());
    private final dy yo;
    private final dy yp;
    private final dy yq;
    private final dy yr;
    private final dy ys;
    private final dy yt;
    private final dy yu;
    private final dy yv;
    private final Runnable yw = new a();
    private boolean yx;

    public dv() {
        super("urn:x-cast:com.google.cast.media", "MediaControlChannel");
        this.yo = new dy(yj);
        this.yp = new dy(yi);
        this.yq = new dy(yi);
        this.yr = new dy(yi);
        this.ys = new dy(yk);
        this.yt = new dy(yi);
        this.yu = new dy(yi);
        this.yv = new dy(yi);
        this.dj();
    }

    public long a(dx dx2, MediaInfo mediaInfo, boolean bl2, long l2, JSONObject jSONObject) throws IOException {
        JSONObject jSONObject2 = new JSONObject();
        long l3 = this.cW();
        this.yo.a(l3, dx2);
        this.u(true);
        try {
            jSONObject2.put("requestId", l3);
            jSONObject2.put("type", (Object)"LOAD");
            jSONObject2.put("media", (Object)mediaInfo.cT());
            jSONObject2.put("autoplay", bl2);
            jSONObject2.put("currentTime", dr.l(l2));
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.a(jSONObject2.toString(), l3, null);
        return l3;
    }

    public long a(dx dx2, JSONObject jSONObject) throws IOException {
        JSONObject jSONObject2 = new JSONObject();
        long l2 = this.cW();
        this.yp.a(l2, dx2);
        this.u(true);
        try {
            jSONObject2.put("requestId", l2);
            jSONObject2.put("type", (Object)"PAUSE");
            jSONObject2.put("mediaSessionId", this.cU());
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.a(jSONObject2.toString(), l2, null);
        return l2;
    }

    public long b(dx dx2, JSONObject jSONObject) throws IOException {
        JSONObject jSONObject2 = new JSONObject();
        long l2 = this.cW();
        this.yr.a(l2, dx2);
        this.u(true);
        try {
            jSONObject2.put("requestId", l2);
            jSONObject2.put("type", (Object)"STOP");
            jSONObject2.put("mediaSessionId", this.cU());
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.a(jSONObject2.toString(), l2, null);
        return l2;
    }

    public long c(dx dx2, JSONObject jSONObject) throws IOException, IllegalStateException {
        JSONObject jSONObject2 = new JSONObject();
        long l2 = this.cW();
        this.yq.a(l2, dx2);
        this.u(true);
        try {
            jSONObject2.put("requestId", l2);
            jSONObject2.put("type", (Object)"PLAY");
            jSONObject2.put("mediaSessionId", this.cU());
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.a(jSONObject2.toString(), l2, null);
        return l2;
    }

    public long a(dx dx2, long l2, int n2, JSONObject jSONObject) throws IOException, IllegalStateException {
        JSONObject jSONObject2 = new JSONObject();
        long l3 = this.cW();
        this.ys.a(l3, dx2);
        this.u(true);
        try {
            jSONObject2.put("requestId", l3);
            jSONObject2.put("type", (Object)"SEEK");
            jSONObject2.put("mediaSessionId", this.cU());
            jSONObject2.put("currentTime", dr.l(l2));
            if (n2 == 1) {
                jSONObject2.put("resumeState", (Object)"PLAYBACK_START");
            } else if (n2 == 2) {
                jSONObject2.put("resumeState", (Object)"PLAYBACK_PAUSE");
            }
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.a(jSONObject2.toString(), l3, null);
        return l3;
    }

    public long a(dx dx2, double d2, JSONObject jSONObject) throws IOException, IllegalStateException, IllegalArgumentException {
        if (Double.isInfinite(d2) || Double.isNaN(d2)) {
            throw new IllegalArgumentException("Volume cannot be " + d2);
        }
        JSONObject jSONObject2 = new JSONObject();
        long l2 = this.cW();
        this.yt.a(l2, dx2);
        this.u(true);
        try {
            jSONObject2.put("requestId", l2);
            jSONObject2.put("type", (Object)"SET_VOLUME");
            jSONObject2.put("mediaSessionId", this.cU());
            JSONObject jSONObject3 = new JSONObject();
            jSONObject3.put("level", d2);
            jSONObject2.put("volume", (Object)jSONObject3);
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.a(jSONObject2.toString(), l2, null);
        return l2;
    }

    public long a(dx dx2, boolean bl2, JSONObject jSONObject) throws IOException, IllegalStateException {
        JSONObject jSONObject2 = new JSONObject();
        long l2 = this.cW();
        this.yu.a(l2, dx2);
        this.u(true);
        try {
            jSONObject2.put("requestId", l2);
            jSONObject2.put("type", (Object)"SET_VOLUME");
            jSONObject2.put("mediaSessionId", this.cU());
            JSONObject jSONObject3 = new JSONObject();
            jSONObject3.put("muted", bl2);
            jSONObject2.put("volume", (Object)jSONObject3);
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.a(jSONObject2.toString(), l2, null);
        return l2;
    }

    public long a(dx dx2) throws IOException {
        JSONObject jSONObject = new JSONObject();
        long l2 = this.cW();
        this.yv.a(l2, dx2);
        this.u(true);
        try {
            jSONObject.put("requestId", l2);
            jSONObject.put("type", (Object)"GET_STATUS");
            if (this.yn != null) {
                jSONObject.put("mediaSessionId", this.yn.cU());
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.a(jSONObject.toString(), l2, null);
        return l2;
    }

    public long getApproximateStreamPosition() {
        MediaInfo mediaInfo = this.getMediaInfo();
        if (mediaInfo == null) {
            return 0L;
        }
        if (this.ym == 0L) {
            return 0L;
        }
        double d2 = this.yn.getPlaybackRate();
        long l2 = this.yn.getStreamPosition();
        int n2 = this.yn.getPlayerState();
        if (d2 == 0.0 || n2 != 2) {
            return l2;
        }
        long l3 = SystemClock.elapsedRealtime() - this.ym;
        if (l3 < 0L) {
            l3 = 0L;
        }
        if (l3 == 0L) {
            return l2;
        }
        long l4 = l2 + (long)((double)l3 * d2);
        long l5 = mediaInfo.getStreamDuration();
        if (l4 > l5) {
            l4 = l5;
        } else if (l4 < 0L) {
            l4 = 0L;
        }
        return l4;
    }

    public long getStreamDuration() {
        MediaInfo mediaInfo = this.getMediaInfo();
        return mediaInfo != null ? mediaInfo.getStreamDuration() : 0L;
    }

    public MediaStatus getMediaStatus() {
        return this.yn;
    }

    public MediaInfo getMediaInfo() {
        return this.yn == null ? null : this.yn.getMediaInfo();
    }

    public final void P(String string) {
        this.xB.b("message received: %s", string);
        try {
            JSONObject jSONObject = new JSONObject(string);
            String string2 = jSONObject.getString("type");
            long l2 = jSONObject.optLong("requestId", -1L);
            if (string2.equals("MEDIA_STATUS")) {
                JSONArray jSONArray = jSONObject.getJSONArray("status");
                if (jSONArray.length() > 0) {
                    this.a(l2, jSONArray.getJSONObject(0));
                } else {
                    this.yn = null;
                    this.onStatusUpdated();
                    this.onMetadataUpdated();
                    this.yv.c(l2, 0);
                }
            } else if (string2.equals("INVALID_PLAYER_STATE")) {
                this.xB.d("received unexpected error: Invalid Player State.", new Object[0]);
                JSONObject jSONObject2 = jSONObject.optJSONObject("customData");
                this.yo.b(l2, 1, jSONObject2);
                this.yp.b(l2, 1, jSONObject2);
                this.yq.b(l2, 1, jSONObject2);
                this.yr.b(l2, 1, jSONObject2);
                this.ys.b(l2, 1, jSONObject2);
                this.yt.b(l2, 1, jSONObject2);
                this.yu.b(l2, 1, jSONObject2);
                this.yv.b(l2, 1, jSONObject2);
            } else if (string2.equals("LOAD_FAILED")) {
                JSONObject jSONObject3 = jSONObject.optJSONObject("customData");
                this.yo.b(l2, 1, jSONObject3);
            } else if (string2.equals("LOAD_CANCELLED")) {
                JSONObject jSONObject4 = jSONObject.optJSONObject("customData");
                this.yo.b(l2, 2, jSONObject4);
            } else if (string2.equals("INVALID_REQUEST")) {
                this.xB.d("received unexpected error: Invalid Request.", new Object[0]);
                JSONObject jSONObject5 = jSONObject.optJSONObject("customData");
                this.yo.b(l2, 1, jSONObject5);
                this.yp.b(l2, 1, jSONObject5);
                this.yq.b(l2, 1, jSONObject5);
                this.yr.b(l2, 1, jSONObject5);
                this.ys.b(l2, 1, jSONObject5);
                this.yt.b(l2, 1, jSONObject5);
                this.yu.b(l2, 1, jSONObject5);
                this.yv.b(l2, 1, jSONObject5);
            }
        }
        catch (JSONException jSONException) {
            this.xB.d("Message is malformed (%s); ignoring: %s", jSONException.getMessage(), string);
        }
    }

    public void a(long l2, int n2) {
        this.yo.c(l2, n2);
        this.yp.c(l2, n2);
        this.yq.c(l2, n2);
        this.yr.c(l2, n2);
        this.ys.c(l2, n2);
        this.yt.c(l2, n2);
        this.yu.c(l2, n2);
        this.yv.c(l2, n2);
    }

    private void a(long l2, JSONObject jSONObject) throws JSONException {
        boolean bl2 = this.yo.m(l2);
        boolean bl3 = this.ys.dl() && !this.ys.m(l2);
        boolean bl4 = this.yt.dl() && !this.yt.m(l2) || this.yu.dl() && !this.yu.m(l2);
        int n2 = 0;
        if (bl3) {
            n2 |= 2;
        }
        if (bl4) {
            n2 |= 1;
        }
        int n3 = 0;
        if (bl2 || this.yn == null) {
            this.yn = new MediaStatus(jSONObject);
            this.ym = SystemClock.elapsedRealtime();
            n3 = 7;
        } else {
            n3 = this.yn.a(jSONObject, n2);
        }
        if ((n3 & 1) != 0) {
            this.ym = SystemClock.elapsedRealtime();
            this.onStatusUpdated();
        }
        if ((n3 & 2) != 0) {
            this.ym = SystemClock.elapsedRealtime();
            this.onStatusUpdated();
        }
        if ((n3 & 4) != 0) {
            this.onMetadataUpdated();
        }
        this.yo.c(l2, 0);
        this.yp.c(l2, 0);
        this.yq.c(l2, 0);
        this.yr.c(l2, 0);
        this.ys.c(l2, 0);
        this.yt.c(l2, 0);
        this.yu.c(l2, 0);
        this.yv.c(l2, 0);
    }

    public long cU() throws IllegalStateException {
        if (this.yn == null) {
            throw new IllegalStateException("No current media session");
        }
        return this.yn.cU();
    }

    protected void onStatusUpdated() {
    }

    protected void onMetadataUpdated() {
    }

    private void dj() {
        this.u(false);
        this.ym = 0L;
        this.yn = null;
        this.yo.clear();
        this.ys.clear();
        this.yt.clear();
    }

    public void cX() {
        this.dj();
    }

    private void u(boolean bl2) {
        if (this.yx != bl2) {
            this.yx = bl2;
            if (bl2) {
                this.mHandler.postDelayed(this.yw, yl);
            } else {
                this.mHandler.removeCallbacks(this.yw);
            }
        }
    }

    private class a
    implements Runnable {
        private a() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            dv.this.yx = false;
            long l2 = SystemClock.elapsedRealtime();
            dv.this.yo.d(l2, 3);
            dv.this.yp.d(l2, 3);
            dv.this.yq.d(l2, 3);
            dv.this.yr.d(l2, 3);
            dv.this.ys.d(l2, 3);
            dv.this.yt.d(l2, 3);
            dv.this.yu.d(l2, 3);
            dv.this.yv.d(l2, 3);
            boolean bl2 = false;
            Object object = dy.yD;
            synchronized (object) {
                bl2 = dv.this.yo.dl() || dv.this.ys.dl() || dv.this.yt.dl() || dv.this.yu.dl() || dv.this.yv.dl();
            }
            dv.this.u(bl2);
        }
    }
}

