/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.LocalSocket;
import android.net.LocalSocketAddress;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.RemoteException;
import android.view.View;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Releasable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.a;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameBuffer;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.GamesMetadata;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerBuffer;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.Players;
import com.google.android.gms.games.achievement.AchievementBuffer;
import com.google.android.gms.games.achievement.Achievements;
import com.google.android.gms.games.leaderboard.Leaderboard;
import com.google.android.gms.games.leaderboard.LeaderboardBuffer;
import com.google.android.gms.games.leaderboard.LeaderboardScore;
import com.google.android.gms.games.leaderboard.LeaderboardScoreBuffer;
import com.google.android.gms.games.leaderboard.Leaderboards;
import com.google.android.gms.games.leaderboard.ScoreSubmissionData;
import com.google.android.gms.games.multiplayer.Invitation;
import com.google.android.gms.games.multiplayer.InvitationBuffer;
import com.google.android.gms.games.multiplayer.Invitations;
import com.google.android.gms.games.multiplayer.OnInvitationReceivedListener;
import com.google.android.gms.games.multiplayer.ParticipantResult;
import com.google.android.gms.games.multiplayer.ParticipantUtils;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMessage;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMessageReceivedListener;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMultiplayer;
import com.google.android.gms.games.multiplayer.realtime.RealTimeSocket;
import com.google.android.gms.games.multiplayer.realtime.Room;
import com.google.android.gms.games.multiplayer.realtime.RoomConfig;
import com.google.android.gms.games.multiplayer.realtime.RoomEntity;
import com.google.android.gms.games.multiplayer.realtime.RoomStatusUpdateListener;
import com.google.android.gms.games.multiplayer.realtime.RoomUpdateListener;
import com.google.android.gms.games.multiplayer.turnbased.LoadMatchesResponse;
import com.google.android.gms.games.multiplayer.turnbased.OnTurnBasedMatchUpdateReceivedListener;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatch;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchBuffer;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchConfig;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMultiplayer;
import com.google.android.gms.games.request.GameRequest;
import com.google.android.gms.games.request.GameRequestBuffer;
import com.google.android.gms.games.request.OnRequestReceivedListener;
import com.google.android.gms.games.request.Requests;
import com.google.android.gms.internal.eh;
import com.google.android.gms.internal.en;
import com.google.android.gms.internal.er;
import com.google.android.gms.internal.fw;
import com.google.android.gms.internal.fz;
import com.google.android.gms.internal.ga;
import com.google.android.gms.internal.gb;
import com.google.android.gms.internal.gc;
import com.google.android.gms.internal.gd;
import com.google.android.gms.internal.ge;
import com.google.android.gms.internal.gs;
import com.google.android.gms.internal.hb;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class fx
extends eh<gb>
implements GoogleApiClient.ConnectionCallbacks,
GoogleApiClient.OnConnectionFailedListener {
    private final String Gv;
    private final String vi;
    private final Map<String, RealTimeSocket> Gw;
    private PlayerEntity Gx;
    private GameEntity Gy;
    private final gd Gz;
    private boolean GA = false;
    private boolean GB = false;
    private int GC;
    private final Binder GD;
    private final long GE;
    private final boolean GF;
    private final int GG;
    private final boolean GH;

    public fx(Context context, Looper looper, String string, String string2, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, String[] stringArray, int n2, View view, boolean bl2, boolean bl3, int n3, boolean bl4, int n4) {
        super(context, looper, connectionCallbacks, onConnectionFailedListener, stringArray);
        this.Gv = string;
        this.vi = er.f(string2);
        this.GD = new Binder();
        this.Gw = new HashMap<String, RealTimeSocket>();
        this.Gz = gd.a(this, n2);
        this.e(view);
        this.GB = bl3;
        this.GC = n3;
        this.GE = this.hashCode();
        this.GF = bl2;
        this.GH = bl4;
        this.GG = n4;
        this.registerConnectionCallbacks(this);
        this.registerConnectionFailedListener(this);
    }

    @Override
    public void onConnected(Bundle connectionHint) {
        if (this.GA) {
            this.Gz.fN();
            this.GA = false;
        }
    }

    @Override
    public void onConnectionSuspended(int cause) {
    }

    @Override
    public void onConnectionFailed(ConnectionResult result) {
        this.GA = false;
    }

    public void aT(int n2) {
        this.Gz.setGravity(n2);
    }

    public void e(View view) {
        this.Gz.f(view);
    }

    @Override
    protected void b(String ... stringArray) {
        boolean bl2 = false;
        boolean bl3 = false;
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string = stringArray[i2];
            if (string.equals("https://www.googleapis.com/auth/games")) {
                bl2 = true;
                continue;
            }
            if (!string.equals("https://www.googleapis.com/auth/games.firstparty")) continue;
            bl3 = true;
        }
        if (bl3) {
            er.a(!bl2, String.format("Cannot have both %s and %s!", "https://www.googleapis.com/auth/games", "https://www.googleapis.com/auth/games.firstparty"));
        } else {
            er.a(bl2, String.format("Games APIs requires %s to function.", "https://www.googleapis.com/auth/games"));
        }
    }

    @Override
    public void connect() {
        this.fm();
        super.connect();
    }

    @Override
    public void disconnect() {
        this.GA = false;
        if (this.isConnected()) {
            try {
                gb gb2 = (gb)this.eb();
                gb2.fH();
                gb2.n(this.GE);
            }
            catch (RemoteException remoteException) {
                fz.g("GamesClientImpl", "Failed to notify client disconnect.");
            }
        }
        this.fG();
        super.disconnect();
    }

    @Override
    protected String aF() {
        return "com.google.android.gms.games.service.START";
    }

    @Override
    protected String aG() {
        return "com.google.android.gms.games.internal.IGamesService";
    }

    protected gb H(IBinder iBinder) {
        return gb.a.J(iBinder);
    }

    @Override
    public Bundle cY() {
        try {
            Bundle bundle = ((gb)this.eb()).cY();
            if (bundle != null) {
                bundle.setClassLoader(fx.class.getClassLoader());
            }
            return bundle;
        }
        catch (RemoteException remoteException) {
            fz.g("GamesClientImpl", "service died");
            return null;
        }
    }

    private void fm() {
        this.Gx = null;
    }

    @Override
    protected void a(en en2, eh.e e2) throws RemoteException {
        String string = this.getContext().getResources().getConfiguration().locale.toString();
        Bundle bundle = new Bundle();
        bundle.putBoolean("com.google.android.gms.games.key.isHeadless", this.GF);
        bundle.putBoolean("com.google.android.gms.games.key.showConnectingPopup", this.GB);
        bundle.putInt("com.google.android.gms.games.key.connectingPopupGravity", this.GC);
        bundle.putBoolean("com.google.android.gms.games.key.retryingSignIn", this.GH);
        bundle.putInt("com.google.android.gms.games.key.sdkVariant", this.GG);
        en2.a(e2, 4323000, this.getContext().getPackageName(), this.vi, this.ea(), this.Gv, this.Gz.fP(), string, bundle);
    }

    public String fn() {
        try {
            return ((gb)this.eb()).fn();
        }
        catch (RemoteException remoteException) {
            fz.g("GamesClientImpl", "service died");
            return null;
        }
    }

    public String fo() {
        try {
            return ((gb)this.eb()).fo();
        }
        catch (RemoteException remoteException) {
            fz.g("GamesClientImpl", "service died");
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Player fp() {
        this.bm();
        fx fx2 = this;
        synchronized (fx2) {
            if (this.Gx == null) {
                try {
                    PlayerBuffer playerBuffer = new PlayerBuffer(((gb)this.eb()).fI());
                    try {
                        if (playerBuffer.getCount() > 0) {
                            this.Gx = (PlayerEntity)playerBuffer.get(0).freeze();
                        }
                        Object var4_4 = null;
                    }
                    catch (Throwable throwable) {
                        Object var4_5 = null;
                        playerBuffer.close();
                        throw throwable;
                    }
                    playerBuffer.close();
                    {
                    }
                }
                catch (RemoteException remoteException) {
                    fz.g("GamesClientImpl", "service died");
                }
            }
        }
        return this.Gx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Game fq() {
        this.bm();
        fx fx2 = this;
        synchronized (fx2) {
            if (this.Gy == null) {
                try {
                    GameBuffer gameBuffer = new GameBuffer(((gb)this.eb()).fK());
                    try {
                        if (gameBuffer.getCount() > 0) {
                            this.Gy = (GameEntity)gameBuffer.get(0).freeze();
                        }
                        Object var4_4 = null;
                    }
                    catch (Throwable throwable) {
                        Object var4_5 = null;
                        gameBuffer.close();
                        throw throwable;
                    }
                    gameBuffer.close();
                    {
                    }
                }
                catch (RemoteException remoteException) {
                    fz.g("GamesClientImpl", "service died");
                }
            }
        }
        return this.Gy;
    }

    public void a(a.c<Players.LoadPlayersResult> c2, String string) {
        try {
            ((gb)this.eb()).a((ga)new ak(c2), string);
        }
        catch (RemoteException remoteException) {
            fz.g("GamesClientImpl", "service died");
        }
    }

    public void a(a.c<Players.LoadPlayersResult> c2, int n2, boolean bl2, boolean bl3) {
        try {
            ((gb)this.eb()).a((ga)new ak(c2), n2, bl2, bl3);
        }
        catch (RemoteException remoteException) {
            fz.g("GamesClientImpl", "service died");
        }
    }

    public void a(a.c<Players.LoadPlayersResult> c2, String string, int n2, boolean bl2, boolean bl3) {
        if (!string.equals("playedWith")) {
            throw new IllegalArgumentException("Invalid player collection: " + string);
        }
        try {
            ((gb)this.eb()).d(new ak(c2), string, n2, bl2, bl3);
        }
        catch (RemoteException remoteException) {
            fz.g("GamesClientImpl", "service died");
        }
    }

    public void a(a.c<Players.LoadPlayersResult> c2, boolean bl2) {
        try {
            ((gb)this.eb()).c((ga)new ak(c2), bl2);
        }
        catch (RemoteException remoteException) {
            fz.g("GamesClientImpl", "service died");
        }
    }

    public Intent fr() {
        Intent intent;
        try {
            intent = ((gb)this.eb()).fr();
        }
        catch (RemoteException remoteException) {
            fz.g("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public Intent au(String string) {
        Intent intent;
        try {
            intent = ((gb)this.eb()).au(string);
        }
        catch (RemoteException remoteException) {
            fz.g("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public void b(a.c<Leaderboards.LeaderboardMetadataResult> c2, boolean bl2) {
        try {
            ((gb)this.eb()).b((ga)new t(c2), bl2);
        }
        catch (RemoteException remoteException) {
            fz.g("GamesClientImpl", "service died");
        }
    }

    public void a(a.c<Leaderboards.LeaderboardMetadataResult> c2, String string, boolean bl2) {
        try {
            ((gb)this.eb()).c((ga)new t(c2), string, bl2);
        }
        catch (RemoteException remoteException) {
            fz.g("GamesClientImpl", "service died");
        }
    }

    public void a(a.c<Leaderboards.LoadPlayerScoreResult> c2, String string, String string2, int n2, int n3) {
        try {
            ((gb)this.eb()).a((ga)new ai(c2), string, string2, n2, n3);
        }
        catch (RemoteException remoteException) {
            fz.g("GamesClientImpl", "service died");
        }
    }

    public void a(a.c<Leaderboards.LoadScoresResult> c2, String string, int n2, int n3, int n4, boolean bl2) {
        try {
            ((gb)this.eb()).a((ga)new r(c2), string, n2, n3, n4, bl2);
        }
        catch (RemoteException remoteException) {
            fz.g("GamesClientImpl", "service died");
        }
    }

    public void b(a.c<Leaderboards.LoadScoresResult> c2, String string, int n2, int n3, int n4, boolean bl2) {
        try {
            ((gb)this.eb()).b(new r(c2), string, n2, n3, n4, bl2);
        }
        catch (RemoteException remoteException) {
            fz.g("GamesClientImpl", "service died");
        }
    }

    public void a(a.c<Leaderboards.LoadScoresResult> c2, LeaderboardScoreBuffer leaderboardScoreBuffer, int n2, int n3) {
        try {
            ((gb)this.eb()).a((ga)new r(c2), leaderboardScoreBuffer.fX().fY(), n2, n3);
        }
        catch (RemoteException remoteException) {
            fz.g("GamesClientImpl", "service died");
        }
    }

    public void a(a.c<Leaderboards.SubmitScoreResult> c2, String string, long l2, String string2) {
        try {
            bd bd2 = c2 == null ? null : new bd(c2);
            ((gb)this.eb()).a((ga)bd2, string, l2, string2);
        }
        catch (RemoteException remoteException) {
            fz.g("GamesClientImpl", "service died");
        }
    }

    public Intent fs() {
        Intent intent;
        try {
            intent = ((gb)this.eb()).fs();
        }
        catch (RemoteException remoteException) {
            fz.g("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public void c(a.c<Achievements.LoadAchievementsResult> c2, boolean bl2) {
        try {
            ((gb)this.eb()).a((ga)new f(c2), bl2);
        }
        catch (RemoteException remoteException) {
            fz.g("GamesClientImpl", "service died");
        }
    }

    public void b(a.c<Achievements.UpdateAchievementResult> c2, String string) {
        try {
            d d2 = c2 == null ? null : new d(c2);
            ((gb)this.eb()).a((ga)d2, string, this.Gz.fP(), this.Gz.fO());
        }
        catch (RemoteException remoteException) {
            fz.g("GamesClientImpl", "service died");
        }
    }

    public void c(a.c<Achievements.UpdateAchievementResult> c2, String string) {
        try {
            d d2 = c2 == null ? null : new d(c2);
            ((gb)this.eb()).b((ga)d2, string, this.Gz.fP(), this.Gz.fO());
        }
        catch (RemoteException remoteException) {
            fz.g("GamesClientImpl", "service died");
        }
    }

    public void a(a.c<Achievements.UpdateAchievementResult> c2, String string, int n2) {
        try {
            d d2 = c2 == null ? null : new d(c2);
            ((gb)this.eb()).a((ga)d2, string, n2, this.Gz.fP(), this.Gz.fO());
        }
        catch (RemoteException remoteException) {
            fz.g("GamesClientImpl", "service died");
        }
    }

    public void b(a.c<Achievements.UpdateAchievementResult> c2, String string, int n2) {
        try {
            d d2 = c2 == null ? null : new d(c2);
            ((gb)this.eb()).b((ga)d2, string, n2, this.Gz.fP(), this.Gz.fO());
        }
        catch (RemoteException remoteException) {
            fz.g("GamesClientImpl", "service died");
        }
    }

    public Intent ft() {
        Intent intent;
        try {
            intent = ((gb)this.eb()).ft();
        }
        catch (RemoteException remoteException) {
            fz.g("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public Intent fu() {
        Intent intent;
        try {
            intent = ((gb)this.eb()).fu();
        }
        catch (RemoteException remoteException) {
            fz.g("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public void a(OnInvitationReceivedListener onInvitationReceivedListener) {
        try {
            l l2 = new l(onInvitationReceivedListener);
            ((gb)this.eb()).a((ga)l2, this.GE);
        }
        catch (RemoteException remoteException) {
            fz.g("GamesClientImpl", "service died");
        }
    }

    public void fv() {
        try {
            ((gb)this.eb()).o(this.GE);
        }
        catch (RemoteException remoteException) {
            fz.g("GamesClientImpl", "service died");
        }
    }

    public void a(OnTurnBasedMatchUpdateReceivedListener onTurnBasedMatchUpdateReceivedListener) {
        try {
            x x2 = new x(onTurnBasedMatchUpdateReceivedListener);
            ((gb)this.eb()).b((ga)x2, this.GE);
        }
        catch (RemoteException remoteException) {
            fz.g("GamesClientImpl", "service died");
        }
    }

    public void fw() {
        try {
            ((gb)this.eb()).p(this.GE);
        }
        catch (RemoteException remoteException) {
            fz.g("GamesClientImpl", "service died");
        }
    }

    public void a(OnRequestReceivedListener onRequestReceivedListener) {
        try {
            ao ao2 = new ao(onRequestReceivedListener);
            ((gb)this.eb()).c((ga)ao2, this.GE);
        }
        catch (RemoteException remoteException) {
            fz.g("GamesClientImpl", "service died");
        }
    }

    public void fx() {
        try {
            ((gb)this.eb()).q(this.GE);
        }
        catch (RemoteException remoteException) {
            fz.g("GamesClientImpl", "service died");
        }
    }

    public Intent fy() {
        Intent intent;
        try {
            intent = ((gb)this.eb()).fy();
        }
        catch (RemoteException remoteException) {
            fz.g("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public Intent a(Room room, int n2) {
        Intent intent;
        try {
            intent = ((gb)this.eb()).a((RoomEntity)room.freeze(), n2);
        }
        catch (RemoteException remoteException) {
            fz.g("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public Intent fz() {
        Intent intent;
        try {
            intent = ((gb)this.eb()).fz();
        }
        catch (RemoteException remoteException) {
            fz.g("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public void g(a.c<GamesMetadata.LoadGamesResult> c2) {
        try {
            ((gb)this.eb()).d(new j(c2));
        }
        catch (RemoteException remoteException) {
            fz.g("GamesClientImpl", "service died");
        }
    }

    public void b(a.c<Status> c2) {
        try {
            ((gb)this.eb()).a(new bb(c2));
        }
        catch (RemoteException remoteException) {
            fz.g("GamesClientImpl", "service died");
        }
    }

    public int fA() {
        int n2 = 4368;
        try {
            n2 = ((gb)this.eb()).fA();
        }
        catch (RemoteException remoteException) {
            fz.g("GamesClientImpl", "service died");
        }
        return n2;
    }

    public String fB() {
        try {
            return ((gb)this.eb()).fB();
        }
        catch (RemoteException remoteException) {
            fz.g("GamesClientImpl", "service died");
            return null;
        }
    }

    public void c(a.c<Invitations.LoadInvitationsResult> c2, int n2) {
        try {
            ((gb)this.eb()).a((ga)new o(c2), n2);
        }
        catch (RemoteException remoteException) {
            fz.g("GamesClientImpl", "service died");
        }
    }

    public void l(String string, int n2) {
        try {
            ((gb)this.eb()).l(string, n2);
        }
        catch (RemoteException remoteException) {
            fz.g("GamesClientImpl", "service died");
        }
    }

    public void m(String string, int n2) {
        try {
            ((gb)this.eb()).m(string, n2);
        }
        catch (RemoteException remoteException) {
            fz.g("GamesClientImpl", "service died");
        }
    }

    public Intent a(int n2, int n3, boolean bl2) {
        Intent intent;
        try {
            intent = ((gb)this.eb()).a(n2, n3, bl2);
        }
        catch (RemoteException remoteException) {
            fz.g("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public void a(a.c<TurnBasedMultiplayer.InitiateMatchResult> c2, TurnBasedMatchConfig turnBasedMatchConfig) {
        try {
            ((gb)this.eb()).a((ga)new bi(c2), turnBasedMatchConfig.getVariant(), turnBasedMatchConfig.getMinPlayers(), turnBasedMatchConfig.getInvitedPlayerIds(), turnBasedMatchConfig.getAutoMatchCriteria());
        }
        catch (RemoteException remoteException) {
            fz.g("GamesClientImpl", "service died");
        }
    }

    public void d(a.c<TurnBasedMultiplayer.InitiateMatchResult> c2, String string) {
        try {
            ((gb)this.eb()).l(new bi(c2), string);
        }
        catch (RemoteException remoteException) {
            fz.g("GamesClientImpl", "service died");
        }
    }

    public void e(a.c<TurnBasedMultiplayer.InitiateMatchResult> c2, String string) {
        try {
            ((gb)this.eb()).m(new bi(c2), string);
        }
        catch (RemoteException remoteException) {
            fz.g("GamesClientImpl", "service died");
        }
    }

    public int fC() {
        int n2 = 2;
        try {
            n2 = ((gb)this.eb()).fC();
        }
        catch (RemoteException remoteException) {
            fz.g("GamesClientImpl", "service died");
        }
        return n2;
    }

    public void a(a.c<TurnBasedMultiplayer.UpdateMatchResult> c2, String string, byte[] byArray, String string2, ParticipantResult[] participantResultArray) {
        try {
            ((gb)this.eb()).a((ga)new bo(c2), string, byArray, string2, participantResultArray);
        }
        catch (RemoteException remoteException) {
            fz.g("GamesClientImpl", "service died");
        }
    }

    public void a(a.c<TurnBasedMultiplayer.UpdateMatchResult> c2, String string, byte[] byArray, ParticipantResult[] participantResultArray) {
        try {
            ((gb)this.eb()).a((ga)new bo(c2), string, byArray, participantResultArray);
        }
        catch (RemoteException remoteException) {
            fz.g("GamesClientImpl", "service died");
        }
    }

    public void f(a.c<TurnBasedMultiplayer.LeaveMatchResult> c2, String string) {
        try {
            ((gb)this.eb()).o(new bk(c2), string);
        }
        catch (RemoteException remoteException) {
            fz.g("GamesClientImpl", "service died");
        }
    }

    public void a(a.c<TurnBasedMultiplayer.LeaveMatchResult> c2, String string, String string2) {
        try {
            ((gb)this.eb()).c((ga)new bk(c2), string, string2);
        }
        catch (RemoteException remoteException) {
            fz.g("GamesClientImpl", "service died");
        }
    }

    public void g(a.c<TurnBasedMultiplayer.CancelMatchResult> c2, String string) {
        try {
            ((gb)this.eb()).n(new bg(c2), string);
        }
        catch (RemoteException remoteException) {
            fz.g("GamesClientImpl", "service died");
        }
    }

    public void av(String string) {
        try {
            ((gb)this.eb()).aC(string);
        }
        catch (RemoteException remoteException) {
            fz.g("GamesClientImpl", "service died");
        }
    }

    public void a(a.c<TurnBasedMultiplayer.LoadMatchesResult> c2, int n2, int[] nArray) {
        try {
            ((gb)this.eb()).a((ga)new bq(c2), n2, nArray);
        }
        catch (RemoteException remoteException) {
            fz.g("GamesClientImpl", "service died");
        }
    }

    public void h(a.c<TurnBasedMultiplayer.LoadMatchResult> c2, String string) {
        try {
            ((gb)this.eb()).p(new bm(c2), string);
        }
        catch (RemoteException remoteException) {
            fz.g("GamesClientImpl", "service died");
        }
    }

    public Intent b(int n2, int n3, boolean bl2) {
        Intent intent;
        try {
            intent = ((gb)this.eb()).b(n2, n3, bl2);
        }
        catch (RemoteException remoteException) {
            fz.g("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public void a(RoomConfig roomConfig) {
        try {
            ax ax2 = new ax(roomConfig.getRoomUpdateListener(), roomConfig.getRoomStatusUpdateListener(), roomConfig.getMessageReceivedListener());
            ((gb)this.eb()).a((ga)ax2, (IBinder)this.GD, roomConfig.getVariant(), roomConfig.getInvitedPlayerIds(), roomConfig.getAutoMatchCriteria(), roomConfig.isSocketEnabled(), this.GE);
        }
        catch (RemoteException remoteException) {
            fz.g("GamesClientImpl", "service died");
        }
    }

    public void b(RoomConfig roomConfig) {
        try {
            ax ax2 = new ax(roomConfig.getRoomUpdateListener(), roomConfig.getRoomStatusUpdateListener(), roomConfig.getMessageReceivedListener());
            ((gb)this.eb()).a((ga)ax2, (IBinder)this.GD, roomConfig.getInvitationId(), roomConfig.isSocketEnabled(), this.GE);
        }
        catch (RemoteException remoteException) {
            fz.g("GamesClientImpl", "service died");
        }
    }

    public void a(RoomUpdateListener roomUpdateListener, String string) {
        try {
            ((gb)this.eb()).c((ga)new ax(roomUpdateListener), string);
            this.fG();
        }
        catch (RemoteException remoteException) {
            fz.g("GamesClientImpl", "service died");
        }
    }

    public int a(RealTimeMultiplayer.ReliableMessageSentCallback reliableMessageSentCallback, byte[] byArray, String string, String string2) {
        try {
            return ((gb)this.eb()).a((ga)new an(reliableMessageSentCallback), byArray, string, string2);
        }
        catch (RemoteException remoteException) {
            fz.g("GamesClientImpl", "service died");
            return -1;
        }
    }

    public int a(byte[] byArray, String string, String[] stringArray) {
        er.b(stringArray, (Object)"Participant IDs must not be null");
        try {
            return ((gb)this.eb()).b(byArray, string, stringArray);
        }
        catch (RemoteException remoteException) {
            fz.g("GamesClientImpl", "service died");
            return -1;
        }
    }

    public int d(byte[] byArray, String string) {
        try {
            return ((gb)this.eb()).b(byArray, string, null);
        }
        catch (RemoteException remoteException) {
            fz.g("GamesClientImpl", "service died");
            return -1;
        }
    }

    public RealTimeSocket i(String string, String string2) {
        if (string2 == null || !ParticipantUtils.aE(string2)) {
            throw new IllegalArgumentException("Bad participant ID");
        }
        RealTimeSocket realTimeSocket = this.Gw.get(string2);
        if (realTimeSocket == null || realTimeSocket.isClosed()) {
            return this.aw(string2);
        }
        return realTimeSocket;
    }

    private RealTimeSocket aw(String string) {
        try {
            ParcelFileDescriptor parcelFileDescriptor = ((gb)this.eb()).aD(string);
            if (parcelFileDescriptor != null) {
                fz.f("GamesClientImpl", "Created native libjingle socket.");
                gc gc2 = new gc(parcelFileDescriptor);
                this.Gw.put(string, gc2);
                return gc2;
            }
            fz.f("GamesClientImpl", "Unable to create native libjingle socket, resorting to old socket.");
            String string2 = ((gb)this.eb()).ay(string);
            if (string2 == null) {
                return null;
            }
            LocalSocket localSocket = new LocalSocket();
            try {
                localSocket.connect(new LocalSocketAddress(string2));
            }
            catch (IOException iOException) {
                fz.h("GamesClientImpl", "connect() call failed on socket: " + iOException.getMessage());
                return null;
            }
            ge ge2 = new ge(localSocket, string);
            this.Gw.put(string, ge2);
            return ge2;
        }
        catch (RemoteException remoteException) {
            fz.h("GamesClientImpl", "Unable to create socket. Service died.");
            return null;
        }
    }

    public void aU(int n2) {
        try {
            ((gb)this.eb()).aU(n2);
        }
        catch (RemoteException remoteException) {
            fz.g("GamesClientImpl", "service died");
        }
    }

    public Intent fD() {
        Intent intent;
        try {
            intent = ((gb)this.eb()).fD();
        }
        catch (RemoteException remoteException) {
            fz.g("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public Intent a(int n2, byte[] byArray, int n3, Bitmap bitmap, String string) {
        Intent intent;
        try {
            intent = ((gb)this.eb()).a(n2, byArray, n3, string);
            er.b(bitmap, (Object)"Must provide a non null icon");
            intent.putExtra("com.google.android.gms.games.REQUEST_ITEM_ICON", (Parcelable)bitmap);
        }
        catch (RemoteException remoteException) {
            fz.g("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public int fE() {
        int n2 = 2;
        try {
            n2 = ((gb)this.eb()).fE();
        }
        catch (RemoteException remoteException) {
            fz.g("GamesClientImpl", "service died");
        }
        return n2;
    }

    public int fF() {
        int n2 = 2;
        try {
            n2 = ((gb)this.eb()).fF();
        }
        catch (RemoteException remoteException) {
            fz.g("GamesClientImpl", "service died");
        }
        return n2;
    }

    public void a(a.c<Requests.UpdateRequestsResult> c2, String[] stringArray) {
        try {
            ((gb)this.eb()).a((ga)new at(c2), stringArray);
        }
        catch (RemoteException remoteException) {
            fz.g("GamesClientImpl", "service died");
        }
    }

    public void b(a.c<Requests.UpdateRequestsResult> c2, String[] stringArray) {
        try {
            ((gb)this.eb()).b((ga)new at(c2), stringArray);
        }
        catch (RemoteException remoteException) {
            fz.g("GamesClientImpl", "service died");
        }
    }

    public void a(a.c<Requests.LoadRequestsResult> c2, int n2, int n3, int n4) {
        try {
            ((gb)this.eb()).a((ga)new ar(c2), n2, n3, n4);
        }
        catch (RemoteException remoteException) {
            fz.g("GamesClientImpl", "service died");
        }
    }

    private void fG() {
        for (RealTimeSocket realTimeSocket : this.Gw.values()) {
            try {
                realTimeSocket.close();
            }
            catch (IOException iOException) {
                fz.a("GamesClientImpl", "IOException:", iOException);
            }
        }
        this.Gw.clear();
    }

    public void a(IBinder iBinder, Bundle bundle) {
        if (this.isConnected()) {
            try {
                ((gb)this.eb()).a(iBinder, bundle);
            }
            catch (RemoteException remoteException) {
                fz.g("GamesClientImpl", "service died");
            }
        }
    }

    public void fH() {
        if (this.isConnected()) {
            try {
                ((gb)this.eb()).fH();
            }
            catch (RemoteException remoteException) {
                fz.g("GamesClientImpl", "service died");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Room G(DataHolder dataHolder) {
        com.google.android.gms.games.multiplayer.realtime.a a2 = new com.google.android.gms.games.multiplayer.realtime.a(dataHolder);
        Room room = null;
        try {
            if (a2.getCount() > 0) {
                room = (Room)((Room)a2.get(0)).freeze();
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            a2.close();
            throw throwable;
        }
        a2.close();
        return room;
    }

    @Override
    protected void a(int n2, IBinder iBinder, Bundle bundle) {
        if (n2 == 0 && bundle != null) {
            this.GA = bundle.getBoolean("show_welcome_popup");
        }
        super.a(n2, iBinder, bundle);
    }

    @Override
    protected /* synthetic */ IInterface p(IBinder iBinder) {
        return this.H(iBinder);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class as
    extends eh.b<a.c<Requests.LoadRequestsResult>>
    implements Requests.LoadRequestsResult {
        private final Status vl;
        private final Bundle Hj;

        as(a.c<Requests.LoadRequestsResult> c2, Status status, Bundle bundle) {
            super(fx.this, c2);
            this.vl = status;
            this.Hj = bundle;
        }

        protected void c(a.c<Requests.LoadRequestsResult> c2) {
            c2.b(this);
        }

        @Override
        public Status getStatus() {
            return this.vl;
        }

        @Override
        public GameRequestBuffer getRequests(int requestType) {
            String string = gs.aW(requestType);
            if (!this.Hj.containsKey(string)) {
                return null;
            }
            DataHolder dataHolder = (DataHolder)this.Hj.get(string);
            return new GameRequestBuffer(dataHolder);
        }

        @Override
        protected void cP() {
            this.release();
        }

        @Override
        public void release() {
            for (String string : this.Hj.keySet()) {
                DataHolder dataHolder = (DataHolder)this.Hj.getParcelable(string);
                if (dataHolder == null) continue;
                dataHolder.close();
            }
        }

        @Override
        protected /* synthetic */ void a(Object object) {
            this.c((a.c)object);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class au
    extends av<a.c<Requests.UpdateRequestsResult>>
    implements Requests.UpdateRequestsResult {
        private final hb Hl;

        au(a.c<Requests.UpdateRequestsResult> c2, DataHolder dataHolder) {
            super(fx.this, c2, dataHolder);
            this.Hl = hb.H(dataHolder);
        }

        @Override
        protected void a(a.c<Requests.UpdateRequestsResult> c2, DataHolder dataHolder) {
            c2.b(this);
        }

        @Override
        public int getRequestOutcome(String requestId) {
            return this.Hl.getRequestOutcome(requestId);
        }

        @Override
        public Set<String> getRequestIds() {
            return this.Hl.getRequestIds();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class bc
    extends eh.b<a.c<Status>> {
        private final Status vl;

        public bc(a.c<Status> c2, Status status) {
            super(fx.this, c2);
            this.vl = status;
        }

        public void c(a.c<Status> c2) {
            c2.b(this.vl);
        }

        @Override
        protected void cP() {
        }

        @Override
        public /* synthetic */ void a(Object object) {
            this.c((a.c)object);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class am
    extends eh.b<RealTimeMultiplayer.ReliableMessageSentCallback> {
        private final int yJ;
        private final String Hc;
        private final int Hd;

        am(RealTimeMultiplayer.ReliableMessageSentCallback reliableMessageSentCallback, int n2, int n3, String string) {
            super(fx.this, reliableMessageSentCallback);
            this.yJ = n2;
            this.Hd = n3;
            this.Hc = string;
        }

        @Override
        public void a(RealTimeMultiplayer.ReliableMessageSentCallback reliableMessageSentCallback) {
            if (reliableMessageSentCallback != null) {
                reliableMessageSentCallback.onRealTimeMessageSent(this.yJ, this.Hd, this.Hc);
            }
        }

        @Override
        protected void cP() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class z
    extends eh.b<RealTimeMessageReceivedListener> {
        private final RealTimeMessage GY;

        z(RealTimeMessageReceivedListener realTimeMessageReceivedListener, RealTimeMessage realTimeMessage) {
            super(fx.this, realTimeMessageReceivedListener);
            this.GY = realTimeMessage;
        }

        @Override
        public void a(RealTimeMessageReceivedListener realTimeMessageReceivedListener) {
            if (realTimeMessageReceivedListener != null) {
                realTimeMessageReceivedListener.onRealTimeMessageReceived(this.GY);
            }
        }

        @Override
        protected void cP() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class ab
    extends eh.b<RoomStatusUpdateListener> {
        private final String GZ;

        ab(RoomStatusUpdateListener roomStatusUpdateListener, String string) {
            super(fx.this, roomStatusUpdateListener);
            this.GZ = string;
        }

        @Override
        public void a(RoomStatusUpdateListener roomStatusUpdateListener) {
            if (roomStatusUpdateListener != null) {
                roomStatusUpdateListener.onP2PDisconnected(this.GZ);
            }
        }

        @Override
        protected void cP() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class aa
    extends eh.b<RoomStatusUpdateListener> {
        private final String GZ;

        aa(RoomStatusUpdateListener roomStatusUpdateListener, String string) {
            super(fx.this, roomStatusUpdateListener);
            this.GZ = string;
        }

        @Override
        public void a(RoomStatusUpdateListener roomStatusUpdateListener) {
            if (roomStatusUpdateListener != null) {
                roomStatusUpdateListener.onP2PConnected(this.GZ);
            }
        }

        @Override
        protected void cP() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class ae
    extends a {
        ae(RoomStatusUpdateListener roomStatusUpdateListener, DataHolder dataHolder, String[] stringArray) {
            super(roomStatusUpdateListener, dataHolder, stringArray);
        }

        @Override
        protected void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeersDisconnected(room, arrayList);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class ac
    extends a {
        ac(RoomStatusUpdateListener roomStatusUpdateListener, DataHolder dataHolder, String[] stringArray) {
            super(roomStatusUpdateListener, dataHolder, stringArray);
        }

        @Override
        protected void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeersConnected(room, arrayList);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class ad
    extends a {
        ad(RoomStatusUpdateListener roomStatusUpdateListener, DataHolder dataHolder, String[] stringArray) {
            super(roomStatusUpdateListener, dataHolder, stringArray);
        }

        @Override
        protected void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerDeclined(room, arrayList);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class ah
    extends a {
        ah(RoomStatusUpdateListener roomStatusUpdateListener, DataHolder dataHolder, String[] stringArray) {
            super(roomStatusUpdateListener, dataHolder, stringArray);
        }

        @Override
        protected void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerLeft(room, arrayList);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class ag
    extends a {
        ag(RoomStatusUpdateListener roomStatusUpdateListener, DataHolder dataHolder, String[] stringArray) {
            super(roomStatusUpdateListener, dataHolder, stringArray);
        }

        @Override
        protected void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerJoined(room, arrayList);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class af
    extends a {
        af(RoomStatusUpdateListener roomStatusUpdateListener, DataHolder dataHolder, String[] stringArray) {
            super(roomStatusUpdateListener, dataHolder, stringArray);
        }

        @Override
        protected void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerInvitedToRoom(room, arrayList);
        }
    }

    final class i
    extends c {
        i(RoomStatusUpdateListener roomStatusUpdateListener, DataHolder dataHolder) {
            super(roomStatusUpdateListener, dataHolder);
        }

        public void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onDisconnectedFromRoom(room);
        }
    }

    final class h
    extends c {
        h(RoomStatusUpdateListener roomStatusUpdateListener, DataHolder dataHolder) {
            super(roomStatusUpdateListener, dataHolder);
        }

        public void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onConnectedToRoom(room);
        }
    }

    final class aw
    extends c {
        aw(RoomStatusUpdateListener roomStatusUpdateListener, DataHolder dataHolder) {
            super(roomStatusUpdateListener, dataHolder);
        }

        public void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onRoomAutoMatching(room);
        }
    }

    final class az
    extends c {
        az(RoomStatusUpdateListener roomStatusUpdateListener, DataHolder dataHolder) {
            super(roomStatusUpdateListener, dataHolder);
        }

        public void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onRoomConnecting(room);
        }
    }

    final class ay
    extends b {
        ay(RoomUpdateListener roomUpdateListener, DataHolder dataHolder) {
            super(roomUpdateListener, dataHolder);
        }

        public void a(RoomUpdateListener roomUpdateListener, Room room, int n2) {
            roomUpdateListener.onRoomConnected(n2, room);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class v
    extends eh.b<RoomUpdateListener> {
        private final int yJ;
        private final String GU;

        v(RoomUpdateListener roomUpdateListener, int n2, String string) {
            super(fx.this, roomUpdateListener);
            this.yJ = n2;
            this.GU = string;
        }

        @Override
        public void a(RoomUpdateListener roomUpdateListener) {
            roomUpdateListener.onLeftRoom(this.yJ, this.GU);
        }

        @Override
        protected void cP() {
        }
    }

    final class q
    extends b {
        public q(RoomUpdateListener roomUpdateListener, DataHolder dataHolder) {
            super(roomUpdateListener, dataHolder);
        }

        public void a(RoomUpdateListener roomUpdateListener, Room room, int n2) {
            roomUpdateListener.onJoinedRoom(n2, room);
        }
    }

    final class ba
    extends b {
        public ba(RoomUpdateListener roomUpdateListener, DataHolder dataHolder) {
            super(roomUpdateListener, dataHolder);
        }

        public void a(RoomUpdateListener roomUpdateListener, Room room, int n2) {
            roomUpdateListener.onRoomCreated(n2, room);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class a
    extends c {
        private final ArrayList<String> GI;

        a(RoomStatusUpdateListener roomStatusUpdateListener, DataHolder dataHolder, String[] stringArray) {
            super(roomStatusUpdateListener, dataHolder);
            this.GI = new ArrayList();
            int n2 = stringArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                this.GI.add(stringArray[i2]);
            }
        }

        @Override
        protected void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            this.a(roomStatusUpdateListener, room, this.GI);
        }

        protected abstract void a(RoomStatusUpdateListener var1, Room var2, ArrayList<String> var3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class c
    extends eh.d<RoomStatusUpdateListener> {
        c(RoomStatusUpdateListener roomStatusUpdateListener, DataHolder dataHolder) {
            super(fx.this, roomStatusUpdateListener, dataHolder);
        }

        @Override
        protected void a(RoomStatusUpdateListener roomStatusUpdateListener, DataHolder dataHolder) {
            this.a(roomStatusUpdateListener, fx.this.G(dataHolder));
        }

        protected abstract void a(RoomStatusUpdateListener var1, Room var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class b
    extends eh.d<RoomUpdateListener> {
        b(RoomUpdateListener roomUpdateListener, DataHolder dataHolder) {
            super(fx.this, roomUpdateListener, dataHolder);
        }

        @Override
        protected void a(RoomUpdateListener roomUpdateListener, DataHolder dataHolder) {
            this.a(roomUpdateListener, fx.this.G(dataHolder), dataHolder.getStatusCode());
        }

        protected abstract void a(RoomUpdateListener var1, Room var2, int var3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class bh
    extends eh.b<a.c<TurnBasedMultiplayer.CancelMatchResult>>
    implements TurnBasedMultiplayer.CancelMatchResult {
        private final Status vl;
        private final String Hr;

        bh(a.c<TurnBasedMultiplayer.CancelMatchResult> c2, Status status, String string) {
            super(fx.this, c2);
            this.vl = status;
            this.Hr = string;
        }

        public void c(a.c<TurnBasedMultiplayer.CancelMatchResult> c2) {
            c2.b(this);
        }

        @Override
        protected void cP() {
        }

        @Override
        public Status getStatus() {
            return this.vl;
        }

        @Override
        public String getMatchId() {
            return this.Hr;
        }

        @Override
        public /* synthetic */ void a(Object object) {
            this.c((a.c)object);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class bl
    extends bf<a.c<TurnBasedMultiplayer.LeaveMatchResult>>
    implements TurnBasedMultiplayer.LeaveMatchResult {
        bl(a.c<TurnBasedMultiplayer.LeaveMatchResult> c2, DataHolder dataHolder) {
            super(fx.this, c2, dataHolder);
        }

        @Override
        protected void h(a.c<TurnBasedMultiplayer.LeaveMatchResult> c2) {
            c2.b(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class bp
    extends bf<a.c<TurnBasedMultiplayer.UpdateMatchResult>>
    implements TurnBasedMultiplayer.UpdateMatchResult {
        bp(a.c<TurnBasedMultiplayer.UpdateMatchResult> c2, DataHolder dataHolder) {
            super(fx.this, c2, dataHolder);
        }

        @Override
        protected void h(a.c<TurnBasedMultiplayer.UpdateMatchResult> c2) {
            c2.b(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class bj
    extends bf<a.c<TurnBasedMultiplayer.InitiateMatchResult>>
    implements TurnBasedMultiplayer.InitiateMatchResult {
        bj(a.c<TurnBasedMultiplayer.InitiateMatchResult> c2, DataHolder dataHolder) {
            super(fx.this, c2, dataHolder);
        }

        @Override
        protected void h(a.c<TurnBasedMultiplayer.InitiateMatchResult> c2) {
            c2.b(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class bn
    extends bf<a.c<TurnBasedMultiplayer.LoadMatchResult>>
    implements TurnBasedMultiplayer.LoadMatchResult {
        bn(a.c<TurnBasedMultiplayer.LoadMatchResult> c2, DataHolder dataHolder) {
            super(fx.this, c2, dataHolder);
        }

        @Override
        protected void h(a.c<TurnBasedMultiplayer.LoadMatchResult> c2) {
            c2.b(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class bf<T extends a.c<?>>
    extends av<T> {
        final TurnBasedMatch GX;
        final /* synthetic */ fx GJ;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        bf(T t2, DataHolder dataHolder) {
            this.GJ = var1_1;
            super((fx)var1_1, t2, dataHolder);
            TurnBasedMatchBuffer turnBasedMatchBuffer = new TurnBasedMatchBuffer(dataHolder);
            try {
                this.GX = turnBasedMatchBuffer.getCount() > 0 ? (TurnBasedMatch)((TurnBasedMatch)turnBasedMatchBuffer.get(0)).freeze() : null;
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                turnBasedMatchBuffer.close();
                throw throwable;
            }
            turnBasedMatchBuffer.close();
        }

        @Override
        protected void a(T t2, DataHolder dataHolder) {
            this.h(t2);
        }

        abstract void h(T var1);

        public TurnBasedMatch getMatch() {
            return this.GX;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class be
    extends av<a.c<Leaderboards.SubmitScoreResult>>
    implements Leaderboards.SubmitScoreResult {
        private final ScoreSubmissionData Hp;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public be(a.c<Leaderboards.SubmitScoreResult> c2, DataHolder dataHolder) {
            super(fx.this, c2, dataHolder);
            try {
                this.Hp = new ScoreSubmissionData(dataHolder);
                Object var5_4 = null;
                dataHolder.close();
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                dataHolder.close();
                throw throwable;
            }
        }

        @Override
        public void a(a.c<Leaderboards.SubmitScoreResult> c2, DataHolder dataHolder) {
            c2.b(this);
        }

        @Override
        public ScoreSubmissionData getScoreData() {
            return this.Hp;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class al
    extends av<a.c<Players.LoadPlayersResult>>
    implements Players.LoadPlayersResult {
        private final PlayerBuffer Hb;

        al(a.c<Players.LoadPlayersResult> c2, DataHolder dataHolder) {
            super(fx.this, c2, dataHolder);
            this.Hb = new PlayerBuffer(dataHolder);
        }

        @Override
        protected void a(a.c<Players.LoadPlayersResult> c2, DataHolder dataHolder) {
            c2.b(this);
        }

        @Override
        public PlayerBuffer getPlayers() {
            return this.Hb;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class br
    extends eh.b<a.c<TurnBasedMultiplayer.LoadMatchesResult>>
    implements TurnBasedMultiplayer.LoadMatchesResult {
        private final Status vl;
        private final LoadMatchesResponse Hx;

        br(a.c<TurnBasedMultiplayer.LoadMatchesResult> c2, Status status, Bundle bundle) {
            super(fx.this, c2);
            this.vl = status;
            this.Hx = new LoadMatchesResponse(bundle);
        }

        protected void c(a.c<TurnBasedMultiplayer.LoadMatchesResult> c2) {
            c2.b(this);
        }

        @Override
        protected void cP() {
        }

        @Override
        public Status getStatus() {
            return this.vl;
        }

        @Override
        public LoadMatchesResponse getMatches() {
            return this.Hx;
        }

        @Override
        public void release() {
            this.Hx.close();
        }

        @Override
        protected /* synthetic */ void a(Object object) {
            this.c((a.c)object);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class aq
    extends eh.b<OnRequestReceivedListener> {
        private final String Hh;

        aq(OnRequestReceivedListener onRequestReceivedListener, String string) {
            super(fx.this, onRequestReceivedListener);
            this.Hh = string;
        }

        protected void b(OnRequestReceivedListener onRequestReceivedListener) {
            onRequestReceivedListener.onRequestRemoved(this.Hh);
        }

        @Override
        protected void cP() {
        }

        @Override
        protected /* synthetic */ void a(Object object) {
            this.b((OnRequestReceivedListener)object);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class ap
    extends eh.b<OnRequestReceivedListener> {
        private final GameRequest Hg;

        ap(OnRequestReceivedListener onRequestReceivedListener, GameRequest gameRequest) {
            super(fx.this, onRequestReceivedListener);
            this.Hg = gameRequest;
        }

        protected void b(OnRequestReceivedListener onRequestReceivedListener) {
            onRequestReceivedListener.onRequestReceived(this.Hg);
        }

        @Override
        protected void cP() {
        }

        @Override
        protected /* synthetic */ void a(Object object) {
            this.b((OnRequestReceivedListener)object);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class w
    extends eh.b<OnTurnBasedMatchUpdateReceivedListener> {
        private final String GV;

        w(OnTurnBasedMatchUpdateReceivedListener onTurnBasedMatchUpdateReceivedListener, String string) {
            super(fx.this, onTurnBasedMatchUpdateReceivedListener);
            this.GV = string;
        }

        protected void b(OnTurnBasedMatchUpdateReceivedListener onTurnBasedMatchUpdateReceivedListener) {
            onTurnBasedMatchUpdateReceivedListener.onTurnBasedMatchRemoved(this.GV);
        }

        @Override
        protected void cP() {
        }

        @Override
        protected /* synthetic */ void a(Object object) {
            this.b((OnTurnBasedMatchUpdateReceivedListener)object);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class y
    extends eh.b<OnTurnBasedMatchUpdateReceivedListener> {
        private final TurnBasedMatch GX;

        y(OnTurnBasedMatchUpdateReceivedListener onTurnBasedMatchUpdateReceivedListener, TurnBasedMatch turnBasedMatch) {
            super(fx.this, onTurnBasedMatchUpdateReceivedListener);
            this.GX = turnBasedMatch;
        }

        protected void b(OnTurnBasedMatchUpdateReceivedListener onTurnBasedMatchUpdateReceivedListener) {
            onTurnBasedMatchUpdateReceivedListener.onTurnBasedMatchReceived(this.GX);
        }

        @Override
        protected void cP() {
        }

        @Override
        protected /* synthetic */ void a(Object object) {
            this.b((OnTurnBasedMatchUpdateReceivedListener)object);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class n
    extends eh.b<OnInvitationReceivedListener> {
        private final String GP;

        n(OnInvitationReceivedListener onInvitationReceivedListener, String string) {
            super(fx.this, onInvitationReceivedListener);
            this.GP = string;
        }

        protected void b(OnInvitationReceivedListener onInvitationReceivedListener) {
            onInvitationReceivedListener.onInvitationRemoved(this.GP);
        }

        @Override
        protected void cP() {
        }

        @Override
        protected /* synthetic */ void a(Object object) {
            this.b((OnInvitationReceivedListener)object);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class m
    extends eh.b<OnInvitationReceivedListener> {
        private final Invitation GO;

        m(OnInvitationReceivedListener onInvitationReceivedListener, Invitation invitation) {
            super(fx.this, onInvitationReceivedListener);
            this.GO = invitation;
        }

        protected void b(OnInvitationReceivedListener onInvitationReceivedListener) {
            onInvitationReceivedListener.onInvitationReceived(this.GO);
        }

        @Override
        protected void cP() {
        }

        @Override
        protected /* synthetic */ void a(Object object) {
            this.b((OnInvitationReceivedListener)object);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class p
    extends av<a.c<Invitations.LoadInvitationsResult>>
    implements Invitations.LoadInvitationsResult {
        private final InvitationBuffer GQ;

        p(a.c<Invitations.LoadInvitationsResult> c2, DataHolder dataHolder) {
            super(fx.this, c2, dataHolder);
            this.GQ = new InvitationBuffer(dataHolder);
        }

        @Override
        protected void a(a.c<Invitations.LoadInvitationsResult> c2, DataHolder dataHolder) {
            c2.b(this);
        }

        @Override
        public InvitationBuffer getInvitations() {
            return this.GQ;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class aj
    extends eh.d<a.c<Leaderboards.LoadPlayerScoreResult>>
    implements Leaderboards.LoadPlayerScoreResult {
        private final Status vl;
        private final com.google.android.gms.games.leaderboard.d Ha;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        aj(a.c<Leaderboards.LoadPlayerScoreResult> c2, DataHolder dataHolder) {
            super(fx.this, c2, dataHolder);
            this.vl = new Status(dataHolder.getStatusCode());
            LeaderboardScoreBuffer leaderboardScoreBuffer = new LeaderboardScoreBuffer(dataHolder);
            try {
                this.Ha = leaderboardScoreBuffer.getCount() > 0 ? (com.google.android.gms.games.leaderboard.d)leaderboardScoreBuffer.get(0).freeze() : null;
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                leaderboardScoreBuffer.close();
                throw throwable;
            }
            leaderboardScoreBuffer.close();
        }

        @Override
        protected void a(a.c<Leaderboards.LoadPlayerScoreResult> c2, DataHolder dataHolder) {
            c2.b(this);
        }

        @Override
        public Status getStatus() {
            return this.vl;
        }

        @Override
        public LeaderboardScore getScore() {
            return this.Ha;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class s
    extends av<a.c<Leaderboards.LoadScoresResult>>
    implements Leaderboards.LoadScoresResult {
        private final com.google.android.gms.games.leaderboard.a GR;
        private final LeaderboardScoreBuffer GS;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        s(a.c<Leaderboards.LoadScoresResult> c2, DataHolder dataHolder, DataHolder dataHolder2) {
            super(fx.this, c2, dataHolder2);
            LeaderboardBuffer leaderboardBuffer = new LeaderboardBuffer(dataHolder);
            try {
                this.GR = leaderboardBuffer.getCount() > 0 ? (com.google.android.gms.games.leaderboard.a)((Leaderboard)leaderboardBuffer.get(0)).freeze() : null;
                Object var7_6 = null;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                leaderboardBuffer.close();
                throw throwable;
            }
            leaderboardBuffer.close();
            this.GS = new LeaderboardScoreBuffer(dataHolder2);
        }

        @Override
        protected void a(a.c<Leaderboards.LoadScoresResult> c2, DataHolder dataHolder) {
            c2.b(this);
        }

        @Override
        public Leaderboard getLeaderboard() {
            return this.GR;
        }

        @Override
        public LeaderboardScoreBuffer getScores() {
            return this.GS;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class u
    extends av<a.c<Leaderboards.LeaderboardMetadataResult>>
    implements Leaderboards.LeaderboardMetadataResult {
        private final LeaderboardBuffer GT;

        u(a.c<Leaderboards.LeaderboardMetadataResult> c2, DataHolder dataHolder) {
            super(fx.this, c2, dataHolder);
            this.GT = new LeaderboardBuffer(dataHolder);
        }

        @Override
        protected void a(a.c<Leaderboards.LeaderboardMetadataResult> c2, DataHolder dataHolder) {
            c2.b(this);
        }

        @Override
        public LeaderboardBuffer getLeaderboards() {
            return this.GT;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class k
    extends av<a.c<GamesMetadata.LoadGamesResult>>
    implements GamesMetadata.LoadGamesResult {
        private final GameBuffer GM;

        k(a.c<GamesMetadata.LoadGamesResult> c2, DataHolder dataHolder) {
            super(fx.this, c2, dataHolder);
            this.GM = new GameBuffer(dataHolder);
        }

        @Override
        protected void a(a.c<GamesMetadata.LoadGamesResult> c2, DataHolder dataHolder) {
            c2.b(this);
        }

        @Override
        public GameBuffer getGames() {
            return this.GM;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class e
    extends eh.b<a.c<Achievements.UpdateAchievementResult>>
    implements Achievements.UpdateAchievementResult {
        private final Status vl;
        private final String GK;

        e(a.c<Achievements.UpdateAchievementResult> c2, int n2, String string) {
            super(fx.this, c2);
            this.vl = new Status(n2);
            this.GK = string;
        }

        protected void c(a.c<Achievements.UpdateAchievementResult> c2) {
            c2.b(this);
        }

        @Override
        protected void cP() {
        }

        @Override
        public Status getStatus() {
            return this.vl;
        }

        @Override
        public String getAchievementId() {
            return this.GK;
        }

        @Override
        protected /* synthetic */ void a(Object object) {
            this.c((a.c)object);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class g
    extends av<a.c<Achievements.LoadAchievementsResult>>
    implements Achievements.LoadAchievementsResult {
        private final AchievementBuffer GL;

        g(a.c<Achievements.LoadAchievementsResult> c2, DataHolder dataHolder) {
            super(fx.this, c2, dataHolder);
            this.GL = new AchievementBuffer(dataHolder);
        }

        @Override
        protected void a(a.c<Achievements.LoadAchievementsResult> c2, DataHolder dataHolder) {
            c2.b(this);
        }

        @Override
        public AchievementBuffer getAchievements() {
            return this.GL;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class av<R extends a.c<?>>
    extends eh.d<R>
    implements Releasable,
    Result {
        final Status vl;
        final DataHolder zU;
        final /* synthetic */ fx GJ;

        public av(R r2, DataHolder dataHolder) {
            this.GJ = var1_1;
            super(var1_1, r2, dataHolder);
            this.vl = new Status(dataHolder.getStatusCode());
            this.zU = dataHolder;
        }

        @Override
        public Status getStatus() {
            return this.vl;
        }

        @Override
        public void release() {
            if (this.zU != null) {
                this.zU.close();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class ar
    extends fw {
        private final a.c<Requests.LoadRequestsResult> Hi;

        public ar(a.c<Requests.LoadRequestsResult> c2) {
            this.Hi = er.b(c2, (Object)"Holder must not be null");
        }

        @Override
        public void b(int n2, Bundle bundle) {
            bundle.setClassLoader(this.getClass().getClassLoader());
            Status status = new Status(n2);
            fx.this.a(new as(this.Hi, status, bundle));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class at
    extends fw {
        private final a.c<Requests.UpdateRequestsResult> Hk;

        public at(a.c<Requests.UpdateRequestsResult> c2) {
            this.Hk = er.b(c2, (Object)"Holder must not be null");
        }

        @Override
        public void D(DataHolder dataHolder) {
            fx.this.a(new au(this.Hk, dataHolder));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class bb
    extends fw {
        private final a.c<Status> vj;

        public bb(a.c<Status> c2) {
            this.vj = er.b(c2, (Object)"Holder must not be null");
        }

        @Override
        public void cM() {
            Status status = new Status(0);
            fx.this.a(new bc(this.vj, status));
        }
    }

    final class an
    extends fw {
        final RealTimeMultiplayer.ReliableMessageSentCallback He;

        public an(RealTimeMultiplayer.ReliableMessageSentCallback reliableMessageSentCallback) {
            this.He = reliableMessageSentCallback;
        }

        public void b(int n2, int n3, String string) {
            fx.this.a(new am(this.He, n2, n3, string));
        }
    }

    final class ax
    extends fw {
        private final RoomUpdateListener Hm;
        private final RoomStatusUpdateListener Hn;
        private final RealTimeMessageReceivedListener Ho;

        public ax(RoomUpdateListener roomUpdateListener) {
            this.Hm = er.b(roomUpdateListener, (Object)"Callbacks must not be null");
            this.Hn = null;
            this.Ho = null;
        }

        public ax(RoomUpdateListener roomUpdateListener, RoomStatusUpdateListener roomStatusUpdateListener, RealTimeMessageReceivedListener realTimeMessageReceivedListener) {
            this.Hm = er.b(roomUpdateListener, (Object)"Callbacks must not be null");
            this.Hn = roomStatusUpdateListener;
            this.Ho = realTimeMessageReceivedListener;
        }

        public void s(DataHolder dataHolder) {
            fx.this.a(new ba(this.Hm, dataHolder));
        }

        public void t(DataHolder dataHolder) {
            fx.this.a(new q(this.Hm, dataHolder));
        }

        public void onLeftRoom(int statusCode, String externalRoomId) {
            fx.this.a(new v(this.Hm, statusCode, externalRoomId));
        }

        public void w(DataHolder dataHolder) {
            fx.this.a(new ay(this.Hm, dataHolder));
        }

        public void u(DataHolder dataHolder) {
            fx.this.a(new az(this.Hn, dataHolder));
        }

        public void v(DataHolder dataHolder) {
            fx.this.a(new aw(this.Hn, dataHolder));
        }

        public void x(DataHolder dataHolder) {
            fx.this.a(new h(this.Hn, dataHolder));
        }

        public void y(DataHolder dataHolder) {
            fx.this.a(new i(this.Hn, dataHolder));
        }

        public void e(DataHolder dataHolder, String[] stringArray) {
            fx.this.a(new ac(this.Hn, dataHolder, stringArray));
        }

        public void f(DataHolder dataHolder, String[] stringArray) {
            fx.this.a(new ae(this.Hn, dataHolder, stringArray));
        }

        public void a(DataHolder dataHolder, String[] stringArray) {
            fx.this.a(new af(this.Hn, dataHolder, stringArray));
        }

        public void b(DataHolder dataHolder, String[] stringArray) {
            fx.this.a(new ag(this.Hn, dataHolder, stringArray));
        }

        public void c(DataHolder dataHolder, String[] stringArray) {
            fx.this.a(new ah(this.Hn, dataHolder, stringArray));
        }

        public void d(DataHolder dataHolder, String[] stringArray) {
            fx.this.a(new ad(this.Hn, dataHolder, stringArray));
        }

        public void onP2PConnected(String participantId) {
            fx.this.a(new aa(this.Hn, participantId));
        }

        public void onP2PDisconnected(String participantId) {
            fx.this.a(new ab(this.Hn, participantId));
        }

        public void onRealTimeMessageReceived(RealTimeMessage message) {
            fx.this.a(new z(this.Ho, message));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class bg
    extends fw {
        private final a.c<TurnBasedMultiplayer.CancelMatchResult> Hq;

        public bg(a.c<TurnBasedMultiplayer.CancelMatchResult> c2) {
            this.Hq = er.b(c2, (Object)"Holder must not be null");
        }

        @Override
        public void f(int n2, String string) {
            Status status = new Status(n2);
            fx.this.a(new bh(this.Hq, status, string));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class bk
    extends fw {
        private final a.c<TurnBasedMultiplayer.LeaveMatchResult> Ht;

        public bk(a.c<TurnBasedMultiplayer.LeaveMatchResult> c2) {
            this.Ht = er.b(c2, (Object)"Holder must not be null");
        }

        @Override
        public void q(DataHolder dataHolder) {
            fx.this.a(new bl(this.Ht, dataHolder));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class bo
    extends fw {
        private final a.c<TurnBasedMultiplayer.UpdateMatchResult> Hv;

        public bo(a.c<TurnBasedMultiplayer.UpdateMatchResult> c2) {
            this.Hv = er.b(c2, (Object)"Holder must not be null");
        }

        @Override
        public void p(DataHolder dataHolder) {
            fx.this.a(new bp(this.Hv, dataHolder));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class bi
    extends fw {
        private final a.c<TurnBasedMultiplayer.InitiateMatchResult> Hs;

        public bi(a.c<TurnBasedMultiplayer.InitiateMatchResult> c2) {
            this.Hs = er.b(c2, (Object)"Holder must not be null");
        }

        @Override
        public void o(DataHolder dataHolder) {
            fx.this.a(new bj(this.Hs, dataHolder));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class bm
    extends fw {
        private final a.c<TurnBasedMultiplayer.LoadMatchResult> Hu;

        public bm(a.c<TurnBasedMultiplayer.LoadMatchResult> c2) {
            this.Hu = er.b(c2, (Object)"Holder must not be null");
        }

        @Override
        public void n(DataHolder dataHolder) {
            fx.this.a(new bn(this.Hu, dataHolder));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class bq
    extends fw {
        private final a.c<TurnBasedMultiplayer.LoadMatchesResult> Hw;

        public bq(a.c<TurnBasedMultiplayer.LoadMatchesResult> c2) {
            this.Hw = er.b(c2, (Object)"Holder must not be null");
        }

        @Override
        public void a(int n2, Bundle bundle) {
            bundle.setClassLoader(this.getClass().getClassLoader());
            Status status = new Status(n2);
            fx.this.a(new br(this.Hw, status, bundle));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class bd
    extends fw {
        private final a.c<Leaderboards.SubmitScoreResult> vj;

        public bd(a.c<Leaderboards.SubmitScoreResult> c2) {
            this.vj = er.b(c2, (Object)"Holder must not be null");
        }

        @Override
        public void d(DataHolder dataHolder) {
            fx.this.a(new be(this.vj, dataHolder));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class ak
    extends fw {
        private final a.c<Players.LoadPlayersResult> vj;

        ak(a.c<Players.LoadPlayersResult> c2) {
            this.vj = er.b(c2, (Object)"Holder must not be null");
        }

        @Override
        public void e(DataHolder dataHolder) {
            fx.this.a(new al(this.vj, dataHolder));
        }
    }

    final class ao
    extends fw {
        private final OnRequestReceivedListener Hf;

        ao(OnRequestReceivedListener onRequestReceivedListener) {
            this.Hf = onRequestReceivedListener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void m(DataHolder dataHolder) {
            GameRequestBuffer gameRequestBuffer = new GameRequestBuffer(dataHolder);
            GameRequest gameRequest = null;
            try {
                if (gameRequestBuffer.getCount() > 0) {
                    gameRequest = (GameRequest)((GameRequest)gameRequestBuffer.get(0)).freeze();
                }
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                gameRequestBuffer.close();
                throw throwable;
            }
            gameRequestBuffer.close();
            if (gameRequest != null) {
                fx.this.a(new ap(this.Hf, gameRequest));
            }
        }

        public void onRequestRemoved(String requestId) {
            fx.this.a(new aq(this.Hf, requestId));
        }
    }

    final class x
    extends fw {
        private final OnTurnBasedMatchUpdateReceivedListener GW;

        x(OnTurnBasedMatchUpdateReceivedListener onTurnBasedMatchUpdateReceivedListener) {
            this.GW = onTurnBasedMatchUpdateReceivedListener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void r(DataHolder dataHolder) {
            TurnBasedMatchBuffer turnBasedMatchBuffer = new TurnBasedMatchBuffer(dataHolder);
            TurnBasedMatch turnBasedMatch = null;
            try {
                if (turnBasedMatchBuffer.getCount() > 0) {
                    turnBasedMatch = (TurnBasedMatch)((TurnBasedMatch)turnBasedMatchBuffer.get(0)).freeze();
                }
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                turnBasedMatchBuffer.close();
                throw throwable;
            }
            turnBasedMatchBuffer.close();
            if (turnBasedMatch != null) {
                fx.this.a(new y(this.GW, turnBasedMatch));
            }
        }

        public void onTurnBasedMatchRemoved(String matchId) {
            fx.this.a(new w(this.GW, matchId));
        }
    }

    final class l
    extends fw {
        private final OnInvitationReceivedListener GN;

        l(OnInvitationReceivedListener onInvitationReceivedListener) {
            this.GN = onInvitationReceivedListener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void l(DataHolder dataHolder) {
            InvitationBuffer invitationBuffer = new InvitationBuffer(dataHolder);
            Invitation invitation = null;
            try {
                if (invitationBuffer.getCount() > 0) {
                    invitation = (Invitation)((Invitation)invitationBuffer.get(0)).freeze();
                }
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                invitationBuffer.close();
                throw throwable;
            }
            invitationBuffer.close();
            if (invitation != null) {
                fx.this.a(new m(this.GN, invitation));
            }
        }

        public void onInvitationRemoved(String invitationId) {
            fx.this.a(new n(this.GN, invitationId));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class o
    extends fw {
        private final a.c<Invitations.LoadInvitationsResult> vj;

        o(a.c<Invitations.LoadInvitationsResult> c2) {
            this.vj = er.b(c2, (Object)"Holder must not be null");
        }

        @Override
        public void k(DataHolder dataHolder) {
            fx.this.a(new p(this.vj, dataHolder));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class ai
    extends fw {
        private final a.c<Leaderboards.LoadPlayerScoreResult> vj;

        ai(a.c<Leaderboards.LoadPlayerScoreResult> c2) {
            this.vj = er.b(c2, (Object)"Holder must not be null");
        }

        @Override
        public void C(DataHolder dataHolder) {
            fx.this.a(new aj(this.vj, dataHolder));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class r
    extends fw {
        private final a.c<Leaderboards.LoadScoresResult> vj;

        r(a.c<Leaderboards.LoadScoresResult> c2) {
            this.vj = er.b(c2, (Object)"Holder must not be null");
        }

        @Override
        public void a(DataHolder dataHolder, DataHolder dataHolder2) {
            fx.this.a(new s(this.vj, dataHolder, dataHolder2));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class t
    extends fw {
        private final a.c<Leaderboards.LeaderboardMetadataResult> vj;

        t(a.c<Leaderboards.LeaderboardMetadataResult> c2) {
            this.vj = er.b(c2, (Object)"Holder must not be null");
        }

        @Override
        public void c(DataHolder dataHolder) {
            fx.this.a(new u(this.vj, dataHolder));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class j
    extends fw {
        private final a.c<GamesMetadata.LoadGamesResult> vj;

        j(a.c<GamesMetadata.LoadGamesResult> c2) {
            this.vj = er.b(c2, (Object)"Holder must not be null");
        }

        @Override
        public void g(DataHolder dataHolder) {
            fx.this.a(new k(this.vj, dataHolder));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class d
    extends fw {
        private final a.c<Achievements.UpdateAchievementResult> vj;

        d(a.c<Achievements.UpdateAchievementResult> c2) {
            this.vj = er.b(c2, (Object)"Holder must not be null");
        }

        @Override
        public void e(int n2, String string) {
            fx.this.a(new e(this.vj, n2, string));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class f
    extends fw {
        private final a.c<Achievements.LoadAchievementsResult> vj;

        f(a.c<Achievements.LoadAchievementsResult> c2) {
            this.vj = er.b(c2, (Object)"Holder must not be null");
        }

        @Override
        public void b(DataHolder dataHolder) {
            fx.this.a(new g(this.vj, dataHolder));
        }
    }
}

