/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.PendingIntent;
import android.content.Context;
import android.location.Location;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.GooglePlayServicesClient;
import com.google.android.gms.internal.ed;
import com.google.android.gms.internal.eh;
import com.google.android.gms.internal.en;
import com.google.android.gms.internal.er;
import com.google.android.gms.internal.hf;
import com.google.android.gms.internal.hg;
import com.google.android.gms.internal.hh;
import com.google.android.gms.internal.hj;
import com.google.android.gms.internal.hl;
import com.google.android.gms.internal.ib;
import com.google.android.gms.location.LocationClient;
import com.google.android.gms.location.LocationListener;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationStatusCodes;
import java.util.List;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class hi
extends eh<hg> {
    private final hl<hg> Lk = new c();
    private final hh Lq;
    private final ib Lr;
    private final String Ls;
    private final String vi;

    public hi(Context context, GooglePlayServicesClient.ConnectionCallbacks connectionCallbacks, GooglePlayServicesClient.OnConnectionFailedListener onConnectionFailedListener, String string2) {
        super(context, connectionCallbacks, onConnectionFailedListener, new String[0]);
        this.Lq = new hh(context, this.Lk);
        this.Ls = string2;
        this.vi = null;
        this.Lr = new ib(this.getContext(), Locale.getDefault(), this.Lk);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() {
        hh hh2 = this.Lq;
        synchronized (hh2) {
            if (this.isConnected()) {
                this.Lq.removeAllListeners();
                this.Lq.gl();
            }
            super.disconnect();
        }
    }

    @Override
    protected String aF() {
        return "com.google.android.location.internal.GoogleLocationManagerService.START";
    }

    @Override
    protected String aG() {
        return "com.google.android.gms.location.internal.IGoogleLocationManagerService";
    }

    public void requestActivityUpdates(long detectionIntervalMillis, PendingIntent callbackIntent) {
        this.bm();
        er.f(callbackIntent);
        er.b(detectionIntervalMillis >= 0L, (Object)"detectionIntervalMillis must be >= 0");
        try {
            ((hg)this.eb()).a(detectionIntervalMillis, true, callbackIntent);
        }
        catch (RemoteException remoteException) {
            throw new IllegalStateException(remoteException);
        }
    }

    public void removeActivityUpdates(PendingIntent callbackIntent) {
        this.bm();
        er.f(callbackIntent);
        try {
            ((hg)this.eb()).removeActivityUpdates(callbackIntent);
        }
        catch (RemoteException remoteException) {
            throw new IllegalStateException(remoteException);
        }
    }

    public void addGeofences(List<hj> geofences, PendingIntent pendingIntent, LocationClient.OnAddGeofencesResultListener listener) {
        this.bm();
        er.b(geofences != null && geofences.size() > 0, (Object)"At least one geofence must be specified.");
        er.b(pendingIntent, (Object)"PendingIntent must be specified.");
        er.b(listener, (Object)"OnAddGeofencesResultListener not provided.");
        try {
            b b2 = listener == null ? null : new b(listener, this);
            ((hg)this.eb()).a(geofences, pendingIntent, b2, this.getContext().getPackageName());
        }
        catch (RemoteException remoteException) {
            throw new IllegalStateException(remoteException);
        }
    }

    public void removeGeofences(PendingIntent pendingIntent, LocationClient.OnRemoveGeofencesResultListener listener) {
        this.bm();
        er.b(pendingIntent, (Object)"PendingIntent must be specified.");
        er.b(listener, (Object)"OnRemoveGeofencesResultListener not provided.");
        try {
            b b2 = listener == null ? null : new b(listener, this);
            ((hg)this.eb()).a(pendingIntent, (hf)b2, this.getContext().getPackageName());
        }
        catch (RemoteException remoteException) {
            throw new IllegalStateException(remoteException);
        }
    }

    public void removeGeofences(List<String> geofenceRequestIds, LocationClient.OnRemoveGeofencesResultListener listener) {
        this.bm();
        er.b(geofenceRequestIds != null && geofenceRequestIds.size() > 0, (Object)"geofenceRequestIds can't be null nor empty.");
        er.b(listener, (Object)"OnRemoveGeofencesResultListener not provided.");
        String[] stringArray = geofenceRequestIds.toArray(new String[0]);
        try {
            b b2 = listener == null ? null : new b(listener, this);
            ((hg)this.eb()).a(stringArray, (hf)b2, this.getContext().getPackageName());
        }
        catch (RemoteException remoteException) {
            throw new IllegalStateException(remoteException);
        }
    }

    public Location getLastLocation() {
        return this.Lq.getLastLocation();
    }

    public void requestLocationUpdates(LocationRequest request, LocationListener listener) {
        this.requestLocationUpdates(request, listener, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestLocationUpdates(LocationRequest request, LocationListener listener, Looper looper) {
        hh hh2 = this.Lq;
        synchronized (hh2) {
            this.Lq.requestLocationUpdates(request, listener, looper);
        }
    }

    public void requestLocationUpdates(LocationRequest request, PendingIntent callbackIntent) {
        this.Lq.requestLocationUpdates(request, callbackIntent);
    }

    public void removeLocationUpdates(LocationListener listener) {
        this.Lq.removeLocationUpdates(listener);
    }

    public void removeLocationUpdates(PendingIntent callbackIntent) {
        this.Lq.removeLocationUpdates(callbackIntent);
    }

    public void setMockMode(boolean isMockMode) {
        this.Lq.setMockMode(isMockMode);
    }

    public void setMockLocation(Location mockLocation) {
        this.Lq.setMockLocation(mockLocation);
    }

    protected hg Q(IBinder iBinder) {
        return hg.a.P(iBinder);
    }

    @Override
    protected void a(en en2, eh.e e2) throws RemoteException {
        Bundle bundle = new Bundle();
        bundle.putString("client_name", this.Ls);
        en2.e(e2, 4323000, this.getContext().getPackageName(), bundle);
    }

    @Override
    protected /* synthetic */ IInterface p(IBinder iBinder) {
        return this.Q(iBinder);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class d
    extends eh.b<LocationClient.OnRemoveGeofencesResultListener> {
        private final int yJ;
        private final String[] Lt;
        private final PendingIntent mPendingIntent;
        private final int Ly;

        public d(int n2, LocationClient.OnRemoveGeofencesResultListener onRemoveGeofencesResultListener, int n3, String[] stringArray) {
            super(hi.this, onRemoveGeofencesResultListener);
            ed.v(n2 == 2);
            this.Ly = n2;
            this.yJ = LocationStatusCodes.bl(n3);
            this.Lt = stringArray;
            this.mPendingIntent = null;
        }

        public d(int n2, LocationClient.OnRemoveGeofencesResultListener onRemoveGeofencesResultListener, int n3, PendingIntent pendingIntent) {
            super(hi.this, onRemoveGeofencesResultListener);
            ed.v(n2 == 1);
            this.Ly = n2;
            this.yJ = LocationStatusCodes.bl(n3);
            this.mPendingIntent = pendingIntent;
            this.Lt = null;
        }

        @Override
        protected void a(LocationClient.OnRemoveGeofencesResultListener onRemoveGeofencesResultListener) {
            if (onRemoveGeofencesResultListener != null) {
                switch (this.Ly) {
                    case 1: {
                        onRemoveGeofencesResultListener.onRemoveGeofencesByPendingIntentResult(this.yJ, this.mPendingIntent);
                        break;
                    }
                    case 2: {
                        onRemoveGeofencesResultListener.onRemoveGeofencesByRequestIdsResult(this.yJ, this.Lt);
                        break;
                    }
                    default: {
                        Log.wtf((String)"LocationClientImpl", (String)("Unsupported action: " + this.Ly));
                    }
                }
            }
        }

        @Override
        protected void cP() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class a
    extends eh.b<LocationClient.OnAddGeofencesResultListener> {
        private final int yJ;
        private final String[] Lt;

        public a(LocationClient.OnAddGeofencesResultListener onAddGeofencesResultListener, int n2, String[] stringArray) {
            super(hi.this, onAddGeofencesResultListener);
            this.yJ = LocationStatusCodes.bl(n2);
            this.Lt = stringArray;
        }

        @Override
        protected void a(LocationClient.OnAddGeofencesResultListener onAddGeofencesResultListener) {
            if (onAddGeofencesResultListener != null) {
                onAddGeofencesResultListener.onAddGeofencesResult(this.yJ, this.Lt);
            }
        }

        @Override
        protected void cP() {
        }
    }

    private static final class b
    extends hf.a {
        private LocationClient.OnAddGeofencesResultListener Lv;
        private LocationClient.OnRemoveGeofencesResultListener Lw;
        private hi Lx;

        public b(LocationClient.OnAddGeofencesResultListener onAddGeofencesResultListener, hi hi2) {
            this.Lv = onAddGeofencesResultListener;
            this.Lw = null;
            this.Lx = hi2;
        }

        public b(LocationClient.OnRemoveGeofencesResultListener onRemoveGeofencesResultListener, hi hi2) {
            this.Lw = onRemoveGeofencesResultListener;
            this.Lv = null;
            this.Lx = hi2;
        }

        public void onAddGeofencesResult(int statusCode, String[] geofenceRequestIds) throws RemoteException {
            if (this.Lx == null) {
                Log.wtf((String)"LocationClientImpl", (String)"onAddGeofenceResult called multiple times");
                return;
            }
            hi hi2 = this.Lx;
            hi2.getClass();
            this.Lx.a(hi2.new a(this.Lv, statusCode, geofenceRequestIds));
            this.Lx = null;
            this.Lv = null;
            this.Lw = null;
        }

        public void onRemoveGeofencesByRequestIdsResult(int statusCode, String[] geofenceRequestIds) {
            if (this.Lx == null) {
                Log.wtf((String)"LocationClientImpl", (String)"onRemoveGeofencesByRequestIdsResult called multiple times");
                return;
            }
            hi hi2 = this.Lx;
            hi2.getClass();
            this.Lx.a(hi2.new d(2, this.Lw, statusCode, geofenceRequestIds));
            this.Lx = null;
            this.Lv = null;
            this.Lw = null;
        }

        public void onRemoveGeofencesByPendingIntentResult(int statusCode, PendingIntent pendingIntent) {
            if (this.Lx == null) {
                Log.wtf((String)"LocationClientImpl", (String)"onRemoveGeofencesByPendingIntentResult called multiple times");
                return;
            }
            hi hi2 = this.Lx;
            hi2.getClass();
            this.Lx.a(hi2.new d(1, this.Lw, statusCode, pendingIntent));
            this.Lx = null;
            this.Lv = null;
            this.Lw = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class c
    implements hl<hg> {
        private c() {
        }

        @Override
        public void bm() {
            hi.this.bm();
        }

        public hg gm() {
            return (hg)hi.this.eb();
        }

        @Override
        public /* synthetic */ IInterface eb() {
            return this.gm();
        }
    }
}

