/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.Parcel;
import android.os.SystemClock;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.ep;
import com.google.android.gms.location.LocationRequestCreator;

public final class LocationRequest
implements SafeParcelable {
    public static final int PRIORITY_HIGH_ACCURACY = 100;
    public static final int PRIORITY_BALANCED_POWER_ACCURACY = 102;
    public static final int PRIORITY_LOW_POWER = 104;
    public static final int PRIORITY_NO_POWER = 105;
    private final int wj;
    int mPriority;
    long Lc;
    long Ld;
    boolean Le;
    long KV;
    int Lf;
    float Lg;
    public static final LocationRequestCreator CREATOR = new LocationRequestCreator();

    public static LocationRequest create() {
        return new LocationRequest();
    }

    public LocationRequest() {
        this.wj = 1;
        this.mPriority = 102;
        this.Lc = 3600000L;
        this.Ld = 600000L;
        this.Le = false;
        this.KV = Long.MAX_VALUE;
        this.Lf = Integer.MAX_VALUE;
        this.Lg = 0.0f;
    }

    public LocationRequest setPriority(int priority) {
        LocationRequest.bi(priority);
        this.mPriority = priority;
        return this;
    }

    public int getPriority() {
        return this.mPriority;
    }

    public LocationRequest setInterval(long millis) {
        LocationRequest.r(millis);
        this.Lc = millis;
        if (!this.Le) {
            this.Ld = (long)((double)this.Lc / 6.0);
        }
        return this;
    }

    public long getInterval() {
        return this.Lc;
    }

    public LocationRequest setFastestInterval(long millis) {
        LocationRequest.r(millis);
        this.Le = true;
        this.Ld = millis;
        return this;
    }

    public long getFastestInterval() {
        return this.Ld;
    }

    public LocationRequest setExpirationDuration(long millis) {
        long l2 = SystemClock.elapsedRealtime();
        this.KV = millis > Long.MAX_VALUE - l2 ? Long.MAX_VALUE : millis + l2;
        if (this.KV < 0L) {
            this.KV = 0L;
        }
        return this;
    }

    public LocationRequest setExpirationTime(long millis) {
        this.KV = millis;
        if (this.KV < 0L) {
            this.KV = 0L;
        }
        return this;
    }

    public long getExpirationTime() {
        return this.KV;
    }

    public LocationRequest setNumUpdates(int numUpdates) {
        if (numUpdates <= 0) {
            throw new IllegalArgumentException("invalid numUpdates: " + numUpdates);
        }
        this.Lf = numUpdates;
        return this;
    }

    public int getNumUpdates() {
        return this.Lf;
    }

    public LocationRequest setSmallestDisplacement(float smallestDisplacementMeters) {
        LocationRequest.a(smallestDisplacementMeters);
        this.Lg = smallestDisplacementMeters;
        return this;
    }

    public float getSmallestDisplacement() {
        return this.Lg;
    }

    private static void r(long l2) {
        if (l2 < 0L) {
            throw new IllegalArgumentException("invalid interval: " + l2);
        }
    }

    private static void bi(int n2) {
        switch (n2) {
            case 100: 
            case 102: 
            case 104: 
            case 105: {
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid quality: " + n2);
            }
        }
    }

    private static void a(float f2) {
        if (f2 < 0.0f) {
            throw new IllegalArgumentException("invalid displacement: " + f2);
        }
    }

    LocationRequest(int versionCode, int priority, long interval, long fastestInterval, boolean explicitFastestInterval, long expireAt, int numUpdates, float smallestDisplacement) {
        this.wj = versionCode;
        this.mPriority = priority;
        this.Lc = interval;
        this.Ld = fastestInterval;
        this.Le = explicitFastestInterval;
        this.KV = expireAt;
        this.Lf = numUpdates;
        this.Lg = smallestDisplacement;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        LocationRequestCreator.a(this, parcel, flags);
    }

    public static String bj(int n2) {
        switch (n2) {
            case 100: {
                return "PRIORITY_HIGH_ACCURACY";
            }
            case 102: {
                return "PRIORITY_BALANCED_POWER_ACCURACY";
            }
            case 104: {
                return "PRIORITY_LOW_POWER";
            }
            case 105: {
                return "PRIORITY_NO_POWER";
            }
        }
        return "???";
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Request[").append(LocationRequest.bj(this.mPriority));
        if (this.mPriority != 105) {
            stringBuilder.append(" requested=");
            stringBuilder.append(this.Lc + "ms");
        }
        stringBuilder.append(" fastest=");
        stringBuilder.append(this.Ld + "ms");
        if (this.KV != Long.MAX_VALUE) {
            long l2 = this.KV - SystemClock.elapsedRealtime();
            stringBuilder.append(" expireIn=");
            stringBuilder.append(l2 + "ms");
        }
        if (this.Lf != Integer.MAX_VALUE) {
            stringBuilder.append(" num=").append(this.Lf);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public int hashCode() {
        return ep.hashCode(this.mPriority, this.Lc, this.Ld, this.Le, this.KV, this.Lf, Float.valueOf(this.Lg));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof LocationRequest)) {
            return false;
        }
        LocationRequest locationRequest = (LocationRequest)object;
        return this.mPriority == locationRequest.mPriority && this.Lc == locationRequest.Lc && this.Ld == locationRequest.Ld && this.Le == locationRequest.Le && this.KV == locationRequest.KV && this.Lf == locationRequest.Lf && this.Lg == locationRequest.Lg;
    }

    int getVersionCode() {
        return this.wj;
    }
}

