/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.tagmanager;

import android.content.Context;
import com.google.android.gms.internal.c;
import com.google.android.gms.tagmanager.DataLayer;
import com.google.android.gms.tagmanager.ag;
import com.google.android.gms.tagmanager.bh;
import com.google.android.gms.tagmanager.bq;
import com.google.android.gms.tagmanager.ce;
import com.google.android.gms.tagmanager.cr;
import com.google.android.gms.tagmanager.ct;
import com.google.android.gms.tagmanager.di;
import com.google.android.gms.tagmanager.s;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class Container {
    private final Context mContext;
    private final String TM;
    private final DataLayer TN;
    private ct TO;
    private Map<String, FunctionCallMacroCallback> TP = new HashMap<String, FunctionCallMacroCallback>();
    private Map<String, FunctionCallTagCallback> TQ = new HashMap<String, FunctionCallTagCallback>();
    private volatile long TR;
    private volatile String TS = "";

    Container(Context context, DataLayer dataLayer, String containerId, long lastRefreshTime, cr.c resource) {
        this.mContext = context;
        this.TN = dataLayer;
        this.TM = containerId;
        this.TR = lastRefreshTime;
        this.a(resource);
    }

    Container(Context context, DataLayer dataLayer, String containerId, long lastRefreshTime, c.j resource) {
        this.mContext = context;
        this.TN = dataLayer;
        this.TM = containerId;
        this.TR = lastRefreshTime;
        this.a(resource.fV);
        if (resource.fU != null) {
            this.a(resource.fU);
        }
    }

    public String getContainerId() {
        return this.TM;
    }

    public boolean getBoolean(String key) {
        ct ct2 = this.iE();
        if (ct2 == null) {
            bh.t("getBoolean called for closed container.");
            return di.kr();
        }
        try {
            return di.n(ct2.bC(key).getObject());
        }
        catch (Exception exception) {
            bh.t("Calling getBoolean() threw an exception: " + exception.getMessage() + " Returning default value.");
            return di.kr();
        }
    }

    public double getDouble(String key) {
        ct ct2 = this.iE();
        if (ct2 == null) {
            bh.t("getDouble called for closed container.");
            return di.kq();
        }
        try {
            return di.m(ct2.bC(key).getObject());
        }
        catch (Exception exception) {
            bh.t("Calling getDouble() threw an exception: " + exception.getMessage() + " Returning default value.");
            return di.kq();
        }
    }

    public long getLong(String key) {
        ct ct2 = this.iE();
        if (ct2 == null) {
            bh.t("getLong called for closed container.");
            return di.kp();
        }
        try {
            return di.l(ct2.bC(key).getObject());
        }
        catch (Exception exception) {
            bh.t("Calling getLong() threw an exception: " + exception.getMessage() + " Returning default value.");
            return di.kp();
        }
    }

    public String getString(String key) {
        ct ct2 = this.iE();
        if (ct2 == null) {
            bh.t("getString called for closed container.");
            return di.kt();
        }
        try {
            return di.j(ct2.bC(key).getObject());
        }
        catch (Exception exception) {
            bh.t("Calling getString() threw an exception: " + exception.getMessage() + " Returning default value.");
            return di.kt();
        }
    }

    public long getLastRefreshTime() {
        return this.TR;
    }

    public boolean isDefault() {
        return this.getLastRefreshTime() == 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerFunctionCallMacroCallback(String customMacroName, FunctionCallMacroCallback customMacroCallback) {
        if (customMacroCallback == null) {
            throw new NullPointerException("Macro handler must be non-null");
        }
        Map<String, FunctionCallMacroCallback> map = this.TP;
        synchronized (map) {
            this.TP.put(customMacroName, customMacroCallback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterFunctionCallMacroCallback(String customMacroName) {
        Map<String, FunctionCallMacroCallback> map = this.TP;
        synchronized (map) {
            this.TP.remove(customMacroName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FunctionCallMacroCallback aY(String string) {
        Map<String, FunctionCallMacroCallback> map = this.TP;
        synchronized (map) {
            return this.TP.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerFunctionCallTagCallback(String customTagName, FunctionCallTagCallback customTagCallback) {
        if (customTagCallback == null) {
            throw new NullPointerException("Tag callback must be non-null");
        }
        Map<String, FunctionCallTagCallback> map = this.TQ;
        synchronized (map) {
            this.TQ.put(customTagName, customTagCallback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterFunctionCallTagCallback(String customTagName) {
        Map<String, FunctionCallTagCallback> map = this.TQ;
        synchronized (map) {
            this.TQ.remove(customTagName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FunctionCallTagCallback aZ(String string) {
        Map<String, FunctionCallTagCallback> map = this.TQ;
        synchronized (map) {
            return this.TQ.get(string);
        }
    }

    void ba(String string) {
        this.iE().ba(string);
    }

    String iD() {
        return this.TS;
    }

    private void a(c.f f2) {
        if (f2 == null) {
            throw new NullPointerException();
        }
        cr.c c2 = null;
        try {
            c2 = cr.b(f2);
        }
        catch (cr.g g2) {
            bh.t("Not loading resource: " + f2 + " because it is invalid: " + g2.toString());
            return;
        }
        this.a(c2);
    }

    private void a(c.i[] iArray) {
        ArrayList<c.i> arrayList = new ArrayList<c.i>();
        for (c.i i2 : iArray) {
            arrayList.add(i2);
        }
        this.iE().f(arrayList);
    }

    private void a(cr.c c2) {
        this.TS = c2.getVersion();
        ag ag2 = this.bb(this.TS);
        ct ct2 = new ct(this.mContext, c2, this.TN, new a(), new b(), ag2);
        this.a(ct2);
    }

    ag bb(String string) {
        if (ce.ju().jv().equals((Object)ce.a.VY)) {
            // empty if block
        }
        return new bq();
    }

    private synchronized void a(ct ct2) {
        this.TO = ct2;
    }

    private synchronized ct iE() {
        return this.TO;
    }

    void release() {
        this.TO = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class b
    implements s.a {
        private b() {
        }

        @Override
        public Object b(String string, Map<String, Object> map) {
            FunctionCallTagCallback functionCallTagCallback = Container.this.aZ(string);
            if (functionCallTagCallback != null) {
                functionCallTagCallback.execute(string, map);
            }
            return di.kt();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class a
    implements s.a {
        private a() {
        }

        @Override
        public Object b(String string, Map<String, Object> map) {
            FunctionCallMacroCallback functionCallMacroCallback = Container.this.aY(string);
            return functionCallMacroCallback == null ? null : functionCallMacroCallback.getValue(string, map);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface FunctionCallTagCallback {
        public void execute(String var1, Map<String, Object> var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface FunctionCallMacroCallback {
        public Object getValue(String var1, Map<String, Object> var2);
    }
}

