/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.tagmanager;

import com.google.android.gms.tagmanager.bh;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataLayer {
    public static final Object OBJECT_NOT_PRESENT = new Object();
    public static final String EVENT_KEY = "event";
    static final String[] Ur = "gtm.lifetime".toString().split("\\.");
    private static final Pattern Us = Pattern.compile("(\\d+)\\s*([smhd]?)");
    private final ConcurrentHashMap<b, Integer> Ut;
    private final Map<String, Object> Uu;
    private final ReentrantLock Uv;
    private final LinkedList<Map<String, Object>> Uw;
    private final c Ux;
    private final CountDownLatch Uy;

    DataLayer() {
        this(new c(){

            @Override
            public void a(List<a> list, long l2) {
            }

            @Override
            public void a(c.a a2) {
                a2.b(new ArrayList<a>());
            }

            @Override
            public void bi(String string) {
            }
        });
    }

    DataLayer(c persistentStore) {
        this.Ux = persistentStore;
        this.Ut = new ConcurrentHashMap();
        this.Uu = new HashMap<String, Object>();
        this.Uv = new ReentrantLock();
        this.Uw = new LinkedList();
        this.Uy = new CountDownLatch(1);
        this.iP();
    }

    public void pushEvent(String eventName, Map<String, Object> update) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(update);
        hashMap.put(EVENT_KEY, eventName);
        this.push(hashMap);
    }

    public void push(String key, Object value) {
        Map<String, Object> map = this.b(key, value);
        this.push(map);
    }

    public void push(Map<String, Object> update) {
        try {
            this.Uy.await();
        }
        catch (InterruptedException interruptedException) {
            bh.w("DataLayer.push: unexpected InterruptedException");
        }
        this.x(update);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void x(Map<String, Object> map) {
        this.Uv.lock();
        try {
            this.Uw.offer(map);
            if (this.Uv.getHoldCount() == 1) {
                this.iQ();
            }
            this.y(map);
        }
        finally {
            this.Uv.unlock();
        }
    }

    private void iP() {
        this.Ux.a(new c.a(){

            @Override
            public void b(List<a> list) {
                for (a a2 : list) {
                    DataLayer.this.x(DataLayer.this.b(a2.UA, a2.UB));
                }
                DataLayer.this.Uy.countDown();
            }
        });
    }

    private void y(Map<String, Object> map) {
        Long l2 = this.z(map);
        if (l2 == null) {
            return;
        }
        List<a> list = this.B(map);
        list.remove("gtm.lifetime");
        this.Ux.a(list, l2);
    }

    private Long z(Map<String, Object> map) {
        Object object = this.A(map);
        if (object == null) {
            return null;
        }
        return DataLayer.bh(object.toString());
    }

    private Object A(Map<String, Object> map) {
        Object object = map;
        for (String string : Ur) {
            if (!(object instanceof Map)) {
                return null;
            }
            Map<String, Object> map2 = object;
            object = map2.get(string);
        }
        return object;
    }

    void bg(String string) {
        this.push(string, null);
        this.Ux.bi(string);
    }

    private List<a> B(Map<String, Object> map) {
        ArrayList<a> arrayList = new ArrayList<a>();
        this.a(map, "", arrayList);
        return arrayList;
    }

    private void a(Map<String, Object> map, String string, Collection<a> collection) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String string2 = string + (string.length() == 0 ? "" : ".") + entry.getKey();
            if (entry.getValue() instanceof Map) {
                Map map2 = (Map)entry.getValue();
                this.a(map2, string2, collection);
                continue;
            }
            if (string2.equals("gtm.lifetime")) continue;
            collection.add(new a(string2, entry.getValue()));
        }
    }

    static Long bh(String string) {
        Matcher matcher = Us.matcher(string);
        if (!matcher.matches()) {
            bh.u("unknown _lifetime: " + string);
            return null;
        }
        long l2 = 0L;
        try {
            l2 = Long.parseLong(matcher.group(1));
        }
        catch (NumberFormatException numberFormatException) {
            bh.w("illegal number in _lifetime value: " + string);
        }
        if (l2 <= 0L) {
            bh.u("non-positive _lifetime: " + string);
            return null;
        }
        String string2 = matcher.group(2);
        if (string2.length() == 0) {
            return l2;
        }
        switch (string2.charAt(0)) {
            case 's': {
                return l2 * 1000L;
            }
            case 'm': {
                return l2 * 1000L * 60L;
            }
            case 'h': {
                return l2 * 1000L * 60L * 60L;
            }
            case 'd': {
                return l2 * 1000L * 60L * 60L * 24L;
            }
        }
        bh.w("unknown units in _lifetime: " + string);
        return null;
    }

    private void iQ() {
        Map<String, Object> map;
        int n2 = 0;
        while ((map = this.Uw.poll()) != null) {
            this.C(map);
            if (++n2 <= 500) continue;
            this.Uw.clear();
            throw new RuntimeException("Seems like an infinite loop of pushing to the data layer");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void C(Map<String, Object> map) {
        Map<String, Object> map2 = this.Uu;
        synchronized (map2) {
            for (String string : map.keySet()) {
                this.a(this.b(string, map.get(string)), this.Uu);
            }
        }
        this.D(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(String key) {
        Map<String, Object> map = this.Uu;
        synchronized (map) {
            String[] stringArray;
            Object object = this.Uu;
            for (String string : stringArray = key.split("\\.")) {
                if (!(object instanceof Map)) {
                    return null;
                }
                Object object2 = object;
                Object object3 = object2.get(string);
                if (object3 == null) {
                    return null;
                }
                object = object3;
            }
            return object;
        }
    }

    public static Map<String, Object> mapOf(Object ... objects) {
        if (objects.length % 2 != 0) {
            throw new IllegalArgumentException("expected even number of key-value pairs");
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (int i2 = 0; i2 < objects.length; i2 += 2) {
            if (!(objects[i2] instanceof String)) {
                throw new IllegalArgumentException("key is not a string: " + objects[i2]);
            }
            hashMap.put((String)objects[i2], objects[i2 + 1]);
        }
        return hashMap;
    }

    public static List<Object> listOf(Object ... objects) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i2 = 0; i2 < objects.length; ++i2) {
            arrayList.add(objects[i2]);
        }
        return arrayList;
    }

    void a(b b2) {
        this.Ut.put(b2, 0);
    }

    private void D(Map<String, Object> map) {
        for (b b2 : this.Ut.keySet()) {
            b2.v(map);
        }
    }

    Map<String, Object> b(String string, Object object) {
        HashMap<String, Object> hashMap;
        HashMap<String, Object> hashMap2 = hashMap = new HashMap<String, Object>();
        String[] stringArray = string.toString().split("\\.");
        for (int i2 = 0; i2 < stringArray.length - 1; ++i2) {
            HashMap hashMap3 = new HashMap();
            hashMap2.put(stringArray[i2], hashMap3);
            hashMap2 = hashMap3;
        }
        hashMap2.put(stringArray[stringArray.length - 1], object);
        return hashMap;
    }

    void a(Map<String, Object> map, Map<String, Object> map2) {
        for (String string : map.keySet()) {
            Object object;
            Object object2;
            Object object3 = map.get(string);
            if (object3 instanceof List) {
                if (!(map2.get(string) instanceof List)) {
                    map2.put(string, new ArrayList());
                }
                object2 = (List)object3;
                object = (List)map2.get(string);
                this.a((List<Object>)object2, (List<Object>)object);
                continue;
            }
            if (object3 instanceof Map) {
                if (!(map2.get(string) instanceof Map)) {
                    map2.put(string, new HashMap());
                }
                object2 = (Map)object3;
                object = (Map)map2.get(string);
                this.a((Map<String, Object>)object2, (Map<String, Object>)object);
                continue;
            }
            map2.put(string, object3);
        }
    }

    void a(List<Object> list, List<Object> list2) {
        while (list2.size() < list.size()) {
            list2.add(null);
        }
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Object object;
            Object object2;
            Object object3 = list.get(i2);
            if (object3 instanceof List) {
                if (!(list2.get(i2) instanceof List)) {
                    list2.set(i2, new ArrayList());
                }
                object2 = (List)object3;
                object = (List)list2.get(i2);
                this.a((List<Object>)object2, (List<Object>)object);
                continue;
            }
            if (object3 instanceof Map) {
                if (!(list2.get(i2) instanceof Map)) {
                    list2.set(i2, new HashMap());
                }
                object2 = (Map)object3;
                object = (Map)list2.get(i2);
                this.a((Map<String, Object>)object2, (Map<String, Object>)object);
                continue;
            }
            if (object3 == OBJECT_NOT_PRESENT) continue;
            list2.set(i2, object3);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface c {
        public void a(List<com.google.android.gms.tagmanager.DataLayer$a> var1, long var2);

        public void a(a var1);

        public void bi(String var1);

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static interface a {
            public void b(List<com.google.android.gms.tagmanager.DataLayer$a> var1);
        }
    }

    static final class a {
        public final String UA;
        public final Object UB;

        a(String string, Object object) {
            this.UA = string;
            this.UB = object;
        }

        public String toString() {
            return "Key: " + this.UA + " value: " + this.UB.toString();
        }

        public int hashCode() {
            return Arrays.hashCode((Object[])new Integer[]{this.UA.hashCode(), this.UB.hashCode()});
        }

        public boolean equals(Object o2) {
            if (!(o2 instanceof a)) {
                return false;
            }
            a a2 = (a)o2;
            return this.UA.equals(a2.UA) && this.UB.equals(a2.UB);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface b {
        public void v(Map<String, Object> var1);
    }
}

