/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.doubleclick;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.doubleclick.AppEventListener;
import com.google.android.gms.ads.doubleclick.PublisherAdRequest;
import com.google.android.gms.internal.av;

public final class PublisherAdView
extends ViewGroup {
    private final av kv;

    public PublisherAdView(Context context) {
        super(context);
        this.kv = new av(this);
    }

    public PublisherAdView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.kv = new av(this, attrs, true);
    }

    public PublisherAdView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.kv = new av(this, attrs, true);
    }

    public void destroy() {
        this.kv.destroy();
    }

    public AdListener getAdListener() {
        return this.kv.getAdListener();
    }

    public AdSize getAdSize() {
        return this.kv.getAdSize();
    }

    public AdSize[] getAdSizes() {
        return this.kv.getAdSizes();
    }

    public String getAdUnitId() {
        return this.kv.getAdUnitId();
    }

    public AppEventListener getAppEventListener() {
        return this.kv.getAppEventListener();
    }

    public void loadAd(PublisherAdRequest publisherAdRequest) {
        this.kv.a(publisherAdRequest.O());
    }

    public void pause() {
        this.kv.pause();
    }

    public void recordManualImpression() {
        this.kv.recordManualImpression();
    }

    public void resume() {
        this.kv.resume();
    }

    public void setAdListener(AdListener adListener) {
        this.kv.setAdListener(adListener);
    }

    public void setAdSizes(AdSize ... adSizes) {
        if (adSizes == null || adSizes.length < 1) {
            throw new IllegalArgumentException("The supported ad sizes must contain at least one valid ad size.");
        }
        this.kv.a(adSizes);
    }

    public void setAdUnitId(String adUnitId) {
        this.kv.setAdUnitId(adUnitId);
    }

    public void setAppEventListener(AppEventListener appEventListener) {
        this.kv.setAppEventListener(appEventListener);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        View view = this.getChildAt(0);
        if (view != null && view.getVisibility() != 8) {
            int n2 = view.getMeasuredWidth();
            int n3 = view.getMeasuredHeight();
            int n4 = (right - left - n2) / 2;
            int n5 = (bottom - top - n3) / 2;
            view.layout(n4, n5, n4 + n2, n5 + n3);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int n2 = 0;
        int n3 = 0;
        View view = this.getChildAt(0);
        AdSize adSize = this.getAdSize();
        if (view != null && view.getVisibility() != 8) {
            this.measureChild(view, widthMeasureSpec, heightMeasureSpec);
            n2 = view.getMeasuredWidth();
            n3 = view.getMeasuredHeight();
        } else if (adSize != null) {
            Context context = this.getContext();
            n2 = adSize.getWidthInPixels(context);
            n3 = adSize.getHeightInPixels(context);
        }
        n2 = Math.max(n2, this.getSuggestedMinimumWidth());
        n3 = Math.max(n3, this.getSuggestedMinimumHeight());
        this.setMeasuredDimension(View.resolveSize((int)n2, (int)widthMeasureSpec), View.resolveSize((int)n3, (int)heightMeasureSpec));
    }
}

