/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.text.TextUtils;
import com.google.android.gms.analytics.aa;
import com.google.android.gms.analytics.ak;
import com.google.android.gms.analytics.ecommerce.Product;
import com.google.android.gms.analytics.ecommerce.ProductAction;
import com.google.android.gms.analytics.ecommerce.Promotion;
import com.google.android.gms.analytics.o;
import com.google.android.gms.analytics.u;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HitBuilders {

    public static class ScreenViewBuilder
    extends HitBuilder<ScreenViewBuilder> {
        public ScreenViewBuilder() {
            u.cP().a(u.a.wd);
            this.set("&t", "screenview");
        }
    }

    @Deprecated
    public static class AppViewBuilder
    extends HitBuilder<AppViewBuilder> {
        public AppViewBuilder() {
            u.cP().a(u.a.wd);
            this.set("&t", "screenview");
        }
    }

    @Deprecated
    public static class ItemBuilder
    extends HitBuilder<ItemBuilder> {
        public ItemBuilder() {
            u.cP().a(u.a.vS);
            this.set("&t", "item");
        }

        public ItemBuilder setTransactionId(String transactionid) {
            this.set("&ti", transactionid);
            return this;
        }

        public ItemBuilder setName(String name) {
            this.set("&in", name);
            return this;
        }

        public ItemBuilder setSku(String sku) {
            this.set("&ic", sku);
            return this;
        }

        public ItemBuilder setCategory(String category) {
            this.set("&iv", category);
            return this;
        }

        public ItemBuilder setPrice(double price) {
            this.set("&ip", Double.toString(price));
            return this;
        }

        public ItemBuilder setQuantity(long quantity) {
            this.set("&iq", Long.toString(quantity));
            return this;
        }

        public ItemBuilder setCurrencyCode(String currencyCode) {
            this.set("&cu", currencyCode);
            return this;
        }
    }

    @Deprecated
    public static class TransactionBuilder
    extends HitBuilder<TransactionBuilder> {
        public TransactionBuilder() {
            u.cP().a(u.a.vz);
            this.set("&t", "transaction");
        }

        public TransactionBuilder setTransactionId(String transactionid) {
            this.set("&ti", transactionid);
            return this;
        }

        public TransactionBuilder setAffiliation(String affiliation) {
            this.set("&ta", affiliation);
            return this;
        }

        public TransactionBuilder setRevenue(double revenue) {
            this.set("&tr", Double.toString(revenue));
            return this;
        }

        public TransactionBuilder setTax(double tax) {
            this.set("&tt", Double.toString(tax));
            return this;
        }

        public TransactionBuilder setShipping(double shipping) {
            this.set("&ts", Double.toString(shipping));
            return this;
        }

        public TransactionBuilder setCurrencyCode(String currencyCode) {
            this.set("&cu", currencyCode);
            return this;
        }
    }

    public static class ExceptionBuilder
    extends HitBuilder<ExceptionBuilder> {
        public ExceptionBuilder() {
            u.cP().a(u.a.vA);
            this.set("&t", "exception");
        }

        public ExceptionBuilder setDescription(String description) {
            this.set("&exd", description);
            return this;
        }

        public ExceptionBuilder setFatal(boolean fatal) {
            this.set("&exf", ak.v(fatal));
            return this;
        }
    }

    public static class TimingBuilder
    extends HitBuilder<TimingBuilder> {
        public TimingBuilder() {
            u.cP().a(u.a.vC);
            this.set("&t", "timing");
        }

        public TimingBuilder(String category, String variable, long value) {
            this();
            this.setVariable(variable);
            this.setValue(value);
            this.setCategory(category);
        }

        public TimingBuilder setVariable(String variable) {
            this.set("&utv", variable);
            return this;
        }

        public TimingBuilder setValue(long value) {
            this.set("&utt", Long.toString(value));
            return this;
        }

        public TimingBuilder setCategory(String category) {
            this.set("&utc", category);
            return this;
        }

        public TimingBuilder setLabel(String label) {
            this.set("&utl", label);
            return this;
        }
    }

    public static class SocialBuilder
    extends HitBuilder<SocialBuilder> {
        public SocialBuilder() {
            u.cP().a(u.a.vD);
            this.set("&t", "social");
        }

        public SocialBuilder setNetwork(String network) {
            this.set("&sn", network);
            return this;
        }

        public SocialBuilder setAction(String action) {
            this.set("&sa", action);
            return this;
        }

        public SocialBuilder setTarget(String target) {
            this.set("&st", target);
            return this;
        }
    }

    public static class EventBuilder
    extends HitBuilder<EventBuilder> {
        public EventBuilder() {
            u.cP().a(u.a.vR);
            this.set("&t", "event");
        }

        public EventBuilder(String category, String action) {
            this();
            this.setCategory(category);
            this.setAction(action);
        }

        public EventBuilder setCategory(String category) {
            this.set("&ec", category);
            return this;
        }

        public EventBuilder setAction(String action) {
            this.set("&ea", action);
            return this;
        }

        public EventBuilder setLabel(String label) {
            this.set("&el", label);
            return this;
        }

        public EventBuilder setValue(long value) {
            this.set("&ev", Long.toString(value));
            return this;
        }
    }

    protected static class HitBuilder<T extends HitBuilder> {
        private Map<String, String> ww = new HashMap<String, String>();
        ProductAction wx;
        Map<String, List<Product>> wy = new HashMap<String, List<Product>>();
        List<Promotion> wz = new ArrayList<Promotion>();
        List<Product> wA = new ArrayList<Product>();

        protected HitBuilder() {
        }

        public T setNewSession() {
            this.set("&sc", "start");
            return (T)this;
        }

        public T setNonInteraction(boolean nonInteraction) {
            this.set("&ni", ak.v(nonInteraction));
            return (T)this;
        }

        public T setCampaignParamsFromUrl(String utmParams) {
            u.cP().a(u.a.uW);
            String string2 = ak.V(utmParams);
            if (TextUtils.isEmpty((CharSequence)string2)) {
                return (T)this;
            }
            Map<String, String> map = ak.U(string2);
            this.set("&cc", map.get("utm_content"));
            this.set("&cm", map.get("utm_medium"));
            this.set("&cn", map.get("utm_campaign"));
            this.set("&cs", map.get("utm_source"));
            this.set("&ck", map.get("utm_term"));
            this.set("&ci", map.get("utm_id"));
            this.set("&gclid", map.get("gclid"));
            this.set("&dclid", map.get("dclid"));
            this.set("&gmob_t", map.get("gmob_t"));
            return (T)this;
        }

        public T setCustomDimension(int index, String dimension) {
            this.set(o.s(index), dimension);
            return (T)this;
        }

        public T setCustomMetric(int index, float metric) {
            this.set(o.t(index), Float.toString(metric));
            return (T)this;
        }

        public final T set(String paramName, String paramValue) {
            u.cP().a(u.a.uT);
            if (paramName != null) {
                this.ww.put(paramName, paramValue);
            } else {
                aa.D(" HitBuilder.set() called with a null paramName.");
            }
            return (T)this;
        }

        public final T setAll(Map<String, String> params) {
            u.cP().a(u.a.uU);
            if (params == null) {
                return (T)this;
            }
            this.ww.putAll(new HashMap<String, String>(params));
            return (T)this;
        }

        public Map<String, String> build() {
            HashMap<String, String> hashMap = new HashMap<String, String>(this.ww);
            if (this.wx != null) {
                hashMap.putAll(this.wx.build());
            }
            int n2 = 1;
            for (Promotion object : this.wz) {
                hashMap.putAll(object.X(o.v(n2)));
                ++n2;
            }
            n2 = 1;
            for (Product product : this.wA) {
                hashMap.putAll(product.X(o.u(n2)));
                ++n2;
            }
            n2 = 1;
            for (Map.Entry entry : this.wy.entrySet()) {
                List list = (List)entry.getValue();
                String string2 = o.x(n2);
                int n3 = 1;
                for (Product product : list) {
                    hashMap.putAll(product.X(string2 + o.w(n3)));
                    ++n3;
                }
                if (!TextUtils.isEmpty((CharSequence)((CharSequence)entry.getKey()))) {
                    hashMap.put(string2 + "nm", (String)entry.getKey());
                }
                ++n2;
            }
            return hashMap;
        }

        public T setProductAction(ProductAction action) {
            this.wx = action;
            return (T)this;
        }

        public T addImpression(Product product, String impressionList) {
            if (product == null) {
                aa.D("product should be non-null");
                return (T)this;
            }
            if (impressionList == null) {
                impressionList = "";
            }
            if (!this.wy.containsKey(impressionList)) {
                this.wy.put(impressionList, new ArrayList());
            }
            this.wy.get(impressionList).add(product);
            return (T)this;
        }

        public T addPromotion(Promotion promotion) {
            if (promotion == null) {
                aa.D("promotion should be non-null");
                return (T)this;
            }
            this.wz.add(promotion);
            return (T)this;
        }

        public T setPromotionAction(String action) {
            this.ww.put("&promoa", action);
            return (T)this;
        }

        public T addProduct(Product product) {
            if (product == null) {
                aa.D("product should be non-null");
                return (T)this;
            }
            this.wA.add(product);
            return (T)this;
        }

        protected T setHitType(String hitType) {
            this.set("&t", hitType);
            return (T)this;
        }

        protected String get(String paramName) {
            return this.ww.get(paramName);
        }
    }
}

