/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import com.google.android.gms.analytics.ExceptionReporter;
import com.google.android.gms.analytics.GoogleAnalytics;
import com.google.android.gms.analytics.TrackerHandler;
import com.google.android.gms.analytics.aa;
import com.google.android.gms.analytics.ad;
import com.google.android.gms.analytics.ae;
import com.google.android.gms.analytics.aj;
import com.google.android.gms.analytics.ak;
import com.google.android.gms.analytics.g;
import com.google.android.gms.analytics.h;
import com.google.android.gms.analytics.i;
import com.google.android.gms.analytics.u;
import com.google.android.gms.analytics.z;
import com.google.android.gms.internal.hn;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Random;

public class Tracker {
    private final TrackerHandler xb;
    private Context mContext;
    private final Map<String, String> xc = new HashMap<String, String>();
    private ad xd;
    private final h xe;
    private final ae xf;
    private final g xg;
    private boolean xh;
    private a xi;
    private aj xj;
    private ExceptionReporter xk;

    Tracker(String trackingId, TrackerHandler handler, Context context) {
        this(trackingId, handler, h.cq(), ae.dq(), g.cp(), new z("tracking"), context);
    }

    Tracker(String trackingId, TrackerHandler handler, h clientIdDefaultProvider, ae screenResolutionDefaultProvider, g appFieldsDefaultProvider, ad rateLimiter, Context context) {
        this.xb = handler;
        if (context != null) {
            this.mContext = context.getApplicationContext();
        }
        if (trackingId != null) {
            this.xc.put("&tid", trackingId);
        }
        this.xc.put("useSecure", "1");
        this.xe = clientIdDefaultProvider;
        this.xf = screenResolutionDefaultProvider;
        this.xg = appFieldsDefaultProvider;
        this.xc.put("&a", Integer.toString(new Random().nextInt(Integer.MAX_VALUE) + 1));
        this.xd = rateLimiter;
        this.xi = new a();
        this.enableAdvertisingIdCollection(false);
    }

    void a(aj aj2) {
        String string2;
        aa.C("Loading Tracker config values.");
        this.xj = aj2;
        if (this.xj.dz()) {
            string2 = this.xj.dA();
            this.set("&tid", string2);
            aa.C("[Tracker] trackingId loaded: " + string2);
        }
        if (this.xj.dB()) {
            string2 = Double.toString(this.xj.dC());
            this.set("&sf", string2);
            aa.C("[Tracker] sample frequency loaded: " + string2);
        }
        if (this.xj.dD()) {
            this.setSessionTimeout(this.xj.getSessionTimeout());
            aa.C("[Tracker] session timeout loaded: " + this.dt());
        }
        if (this.xj.dE()) {
            this.enableAutoActivityTracking(this.xj.dF());
            aa.C("[Tracker] auto activity tracking loaded: " + this.du());
        }
        if (this.xj.dG()) {
            if (this.xj.dH()) {
                this.set("&aip", "1");
                aa.C("[Tracker] anonymize ip loaded: true");
            }
            aa.C("[Tracker] anonymize ip loaded: false");
        }
        this.enableExceptionReporting(this.xj.dI());
    }

    public void enableExceptionReporting(boolean enabled) {
        if (this.xh == enabled) {
            return;
        }
        this.xh = enabled;
        if (enabled) {
            this.xk = new ExceptionReporter(this, Thread.getDefaultUncaughtExceptionHandler(), this.mContext);
            Thread.setDefaultUncaughtExceptionHandler(this.xk);
            aa.C("Uncaught exceptions will be reported to Google Analytics.");
        } else {
            if (this.xk != null) {
                Thread.setDefaultUncaughtExceptionHandler(this.xk.cy());
            } else {
                Thread.setDefaultUncaughtExceptionHandler(null);
            }
            aa.C("Uncaught exceptions will not be reported to Google Analytics.");
        }
    }

    public void setSessionTimeout(long sessionTimeout) {
        this.xi.setSessionTimeout(sessionTimeout * 1000L);
    }

    long dt() {
        return this.xi.dt();
    }

    public void enableAutoActivityTracking(boolean enabled) {
        this.xi.enableAutoActivityTracking(enabled);
    }

    boolean du() {
        return this.xi.du();
    }

    public void send(Map<String, String> params) {
        String string2;
        u.cP().a(u.a.ve);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.putAll(this.xc);
        if (params != null) {
            hashMap.putAll(params);
        }
        if (TextUtils.isEmpty((CharSequence)((CharSequence)hashMap.get("&tid")))) {
            aa.D(String.format("Missing tracking id (%s) parameter.", "&tid"));
        }
        if (TextUtils.isEmpty((CharSequence)(string2 = (String)hashMap.get("&t")))) {
            aa.D(String.format("Missing hit type (%s) parameter.", "&t"));
            string2 = "";
        }
        if (this.xi.dv()) {
            hashMap.put("&sc", "start");
        }
        if ("screenview".equals(string2 = string2.toLowerCase()) || "pageview".equals(string2) || "appview".equals(string2) || TextUtils.isEmpty((CharSequence)string2)) {
            int n2 = Integer.parseInt(this.xc.get("&a"));
            n2 = ++n2 >= Integer.MAX_VALUE ? 1 : n2;
            this.xc.put("&a", Integer.toString(n2));
        }
        if (!(string2.equals("transaction") || string2.equals("item") || this.xd.dj())) {
            aa.D("Too many hits sent too quickly, rate limiting invoked.");
        } else {
            this.xb.p(hashMap);
        }
    }

    public String get(String key) {
        u.cP().a(u.a.vc);
        if (TextUtils.isEmpty((CharSequence)key)) {
            return null;
        }
        if (this.xc.containsKey(key)) {
            return this.xc.get(key);
        }
        if (key.equals("&ul")) {
            return ak.a(Locale.getDefault());
        }
        if (this.xe != null && this.xe.J(key)) {
            return this.xe.getValue(key);
        }
        if (this.xf != null && this.xf.J(key)) {
            return this.xf.getValue(key);
        }
        if (this.xg != null && this.xg.J(key)) {
            return this.xg.getValue(key);
        }
        return null;
    }

    public void set(String key, String value) {
        hn.b(key, (Object)"Key should be non-null");
        u.cP().a(u.a.vd);
        this.xc.put(key, value);
    }

    public void setSampleRate(double sampleRate) {
        this.set("&sf", Double.toHexString(sampleRate));
    }

    public void setUseSecure(boolean useSecure) {
        this.set("useSecure", ak.v(useSecure));
    }

    public void setScreenName(String screenName) {
        this.set("&cd", screenName);
    }

    public void setLocation(String location) {
        this.set("&dl", location);
    }

    public void setReferrer(String referrer) {
        this.set("&dr", referrer);
    }

    public void setPage(String page) {
        this.set("&dp", page);
    }

    public void setHostname(String hostname) {
        this.set("&dh", hostname);
    }

    public void setTitle(String title) {
        this.set("&dt", title);
    }

    public void setLanguage(String language) {
        this.set("&ul", language);
    }

    public void setEncoding(String encoding) {
        this.set("&de", encoding);
    }

    public void setScreenColors(String screenColors) {
        this.set("&sd", screenColors);
    }

    public void setScreenResolution(int width, int height) {
        if (width < 0 && height < 0) {
            aa.D("Invalid width or height. The values should be non-negative.");
            return;
        }
        this.set("&sr", width + "x" + height);
    }

    public void setViewportSize(String viewportSize) {
        this.set("&vp", viewportSize);
    }

    public void setClientId(String clientId) {
        this.set("&cid", clientId);
    }

    public void setAppName(String appName) {
        this.set("&an", appName);
    }

    public void setAppId(String appId) {
        this.set("&aid", appId);
    }

    public void setAppInstallerId(String appInstallerId) {
        this.set("&aiid", appInstallerId);
    }

    public void setAppVersion(String appVersion) {
        this.set("&av", appVersion);
    }

    public void setAnonymizeIp(boolean anonymize) {
        this.set("&aip", ak.v(anonymize));
    }

    public void enableAdvertisingIdCollection(boolean enabled) {
        if (!enabled) {
            this.xc.put("&ate", null);
            this.xc.put("&adid", null);
        } else {
            if (this.xc.containsKey("&ate")) {
                this.xc.remove("&ate");
            }
            if (this.xc.containsKey("&adid")) {
                this.xc.remove("&adid");
            }
        }
    }

    private class a
    implements GoogleAnalytics.a {
        private boolean xl = false;
        private int xm = 0;
        private long xn = -1L;
        private boolean xo = false;
        private long xp;
        private i ur;

        public a() {
            this.ur = new i(){

                @Override
                public long currentTimeMillis() {
                    return System.currentTimeMillis();
                }
            };
        }

        public void setSessionTimeout(long sessionTimeout) {
            this.xn = sessionTimeout;
            this.dw();
        }

        public long dt() {
            return this.xn;
        }

        public void enableAutoActivityTracking(boolean enabled) {
            this.xl = enabled;
            this.dw();
        }

        public boolean du() {
            return this.xl;
        }

        public boolean dv() {
            boolean bl2 = this.xo;
            this.xo = false;
            return bl2;
        }

        private void dw() {
            GoogleAnalytics googleAnalytics = GoogleAnalytics.dd();
            if (googleAnalytics == null) {
                aa.A("GoogleAnalytics isn't initialized for the Tracker!");
                return;
            }
            if (this.xn >= 0L || this.xl) {
                googleAnalytics.a(Tracker.this.xi);
            } else {
                googleAnalytics.b(Tracker.this.xi);
            }
        }

        @Override
        public void h(Activity activity) {
            u.cP().a(u.a.wb);
            if (this.xm == 0 && this.dx()) {
                this.xo = true;
            }
            ++this.xm;
            if (this.xl) {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("&t", "screenview");
                u.cP().u(true);
                Tracker.this.set("&cd", Tracker.this.xj != null ? Tracker.this.xj.j(activity) : activity.getClass().getCanonicalName());
                Tracker.this.send(hashMap);
                u.cP().u(false);
            }
        }

        @Override
        public void i(Activity activity) {
            u.cP().a(u.a.wc);
            --this.xm;
            this.xm = Math.max(0, this.xm);
            if (this.xm == 0) {
                this.xp = this.ur.currentTimeMillis();
            }
        }

        boolean dx() {
            return this.ur.currentTimeMillis() >= this.xp + Math.max(1000L, this.xn);
        }
    }
}

