/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.IntentSender;
import android.os.Parcel;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.CommonStatusCodes;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.StatusCreator;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.hl;

public final class Status
implements Result,
SafeParcelable {
    public static final Status Ek = new Status(0);
    public static final Status El = new Status(14);
    public static final Status Em = new Status(8);
    public static final Status En = new Status(15);
    public static final Status Eo = new Status(16);
    public static final StatusCreator CREATOR = new StatusCreator();
    private final int xJ;
    private final int CQ;
    private final String Ep;
    private final PendingIntent mPendingIntent;

    Status(int versionCode, int statusCode, String statusMessage, PendingIntent pendingIntent) {
        this.xJ = versionCode;
        this.CQ = statusCode;
        this.Ep = statusMessage;
        this.mPendingIntent = pendingIntent;
    }

    public Status(int statusCode) {
        this(1, statusCode, null, null);
    }

    public Status(int statusCode, String statusMessage, PendingIntent pendingIntent) {
        this(1, statusCode, statusMessage, pendingIntent);
    }

    public void startResolutionForResult(Activity activity, int requestCode) throws IntentSender.SendIntentException {
        if (!this.hasResolution()) {
            return;
        }
        activity.startIntentSenderForResult(this.mPendingIntent.getIntentSender(), requestCode, null, 0, 0, 0);
    }

    PendingIntent eL() {
        return this.mPendingIntent;
    }

    public String getStatusMessage() {
        return this.Ep;
    }

    int getVersionCode() {
        return this.xJ;
    }

    public boolean hasResolution() {
        return this.mPendingIntent != null;
    }

    public boolean isSuccess() {
        return this.CQ <= 0;
    }

    public boolean isCanceled() {
        return this.CQ == 16;
    }

    public boolean isInterrupted() {
        return this.CQ == 14;
    }

    public int getStatusCode() {
        return this.CQ;
    }

    public PendingIntent getResolution() {
        return this.mPendingIntent;
    }

    public int hashCode() {
        return hl.hashCode(this.xJ, this.CQ, this.Ep, this.mPendingIntent);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Status)) {
            return false;
        }
        Status status = (Status)obj;
        return this.xJ == status.xJ && this.CQ == status.CQ && hl.equal(this.Ep, status.Ep) && hl.equal(this.mPendingIntent, status.mPendingIntent);
    }

    private String es() {
        if (this.Ep != null) {
            return this.Ep;
        }
        return CommonStatusCodes.getStatusCodeString(this.CQ);
    }

    public String toString() {
        return hl.e(this).a("statusCode", this.es()).a("resolution", this.mPendingIntent).toString();
    }

    @Deprecated
    public ConnectionResult eM() {
        return new ConnectionResult(this.CQ, this.mPendingIntent);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        StatusCreator.a(this, out, flags);
    }

    @Override
    public Status getStatus() {
        return this;
    }
}

