/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.images;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.images.b;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.hl;
import org.json.JSONException;
import org.json.JSONObject;

public final class WebImage
implements SafeParcelable {
    public static final Parcelable.Creator<WebImage> CREATOR = new b();
    private final int xJ;
    private final Uri Fr;
    private final int ks;
    private final int kt;

    WebImage(int versionCode, Uri url, int width, int height) {
        this.xJ = versionCode;
        this.Fr = url;
        this.ks = width;
        this.kt = height;
    }

    public WebImage(Uri url, int width, int height) throws IllegalArgumentException {
        this(1, url, width, height);
        if (url == null) {
            throw new IllegalArgumentException("url cannot be null");
        }
        if (width < 0 || height < 0) {
            throw new IllegalArgumentException("width and height must not be negative");
        }
    }

    public WebImage(Uri url) throws IllegalArgumentException {
        this(url, 0, 0);
    }

    public WebImage(JSONObject json) throws IllegalArgumentException {
        this(WebImage.c(json), json.optInt("width", 0), json.optInt("height", 0));
    }

    int getVersionCode() {
        return this.xJ;
    }

    private static Uri c(JSONObject jSONObject) {
        Uri uri = null;
        if (jSONObject.has("url")) {
            try {
                uri = Uri.parse((String)jSONObject.getString("url"));
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return uri;
    }

    public Uri getUrl() {
        return this.Fr;
    }

    public int getWidth() {
        return this.ks;
    }

    public int getHeight() {
        return this.kt;
    }

    public String toString() {
        return String.format("Image %dx%d %s", this.ks, this.kt, this.Fr.toString());
    }

    public JSONObject dU() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("url", (Object)this.Fr.toString());
            jSONObject.put("width", this.ks);
            jSONObject.put("height", this.kt);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jSONObject;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !(other instanceof WebImage)) {
            return false;
        }
        WebImage webImage = (WebImage)other;
        return hl.equal(this.Fr, webImage.Fr) && this.ks == webImage.ks && this.kt == webImage.kt;
    }

    public int hashCode() {
        return hl.hashCode(this.Fr, this.ks, this.kt);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        b.a(this, out, flags);
    }
}

