/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.internal;

import android.os.RemoteException;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.a;
import com.google.android.gms.drive.Contents;
import com.google.android.gms.drive.CreateFileActivityBuilder;
import com.google.android.gms.drive.Drive;
import com.google.android.gms.drive.DriveApi;
import com.google.android.gms.drive.DriveFile;
import com.google.android.gms.drive.DriveFolder;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.MetadataBuffer;
import com.google.android.gms.drive.OpenFileActivityBuilder;
import com.google.android.gms.drive.internal.CloseContentsRequest;
import com.google.android.gms.drive.internal.CreateContentsRequest;
import com.google.android.gms.drive.internal.GetMetadataRequest;
import com.google.android.gms.drive.internal.OnContentsResponse;
import com.google.android.gms.drive.internal.OnDriveIdResponse;
import com.google.android.gms.drive.internal.OnListEntriesResponse;
import com.google.android.gms.drive.internal.OnMetadataResponse;
import com.google.android.gms.drive.internal.QueryRequest;
import com.google.android.gms.drive.internal.ab;
import com.google.android.gms.drive.internal.aw;
import com.google.android.gms.drive.internal.q;
import com.google.android.gms.drive.internal.r;
import com.google.android.gms.drive.internal.s;
import com.google.android.gms.drive.internal.u;
import com.google.android.gms.drive.query.Query;

public class p
implements DriveApi {
    @Override
    public PendingResult<DriveApi.MetadataBufferResult> query(GoogleApiClient apiClient, final Query query) {
        if (query == null) {
            throw new IllegalArgumentException("Query must be provided.");
        }
        return apiClient.a(new i(){

            @Override
            protected void a(r r2) throws RemoteException {
                r2.gk().a(new QueryRequest(query), (ab)new h(this));
            }
        });
    }

    @Override
    public PendingResult<DriveApi.ContentsResult> newContents(GoogleApiClient apiClient) {
        return apiClient.a(new g(){

            @Override
            protected void a(r r2) throws RemoteException {
                r2.gk().a(new CreateContentsRequest(), (ab)new f(this));
            }
        });
    }

    @Override
    public PendingResult<Status> discardContents(GoogleApiClient apiClient, final Contents contents) {
        return apiClient.b(new j(){

            @Override
            protected void a(r r2) throws RemoteException {
                r2.gk().a(new CloseContentsRequest(contents, false), (ab)new aw(this));
            }
        });
    }

    @Override
    public PendingResult<DriveApi.DriveIdResult> fetchDriveId(GoogleApiClient apiClient, final String resourceId) {
        return apiClient.a(new d(){

            @Override
            protected void a(r r2) throws RemoteException {
                r2.gk().a(new GetMetadataRequest(DriveId.aL(resourceId)), (ab)new b(this));
            }
        });
    }

    @Override
    public DriveFile getFile(GoogleApiClient apiClient, DriveId id2) {
        if (id2 == null) {
            throw new IllegalArgumentException("Id must be provided.");
        }
        if (!apiClient.isConnected()) {
            throw new IllegalStateException("Client must be connected");
        }
        return new s(id2);
    }

    @Override
    public DriveFolder getFolder(GoogleApiClient apiClient, DriveId id2) {
        if (id2 == null) {
            throw new IllegalArgumentException("Id must be provided.");
        }
        if (!apiClient.isConnected()) {
            throw new IllegalStateException("Client must be connected");
        }
        return new u(id2);
    }

    @Override
    public DriveFolder getRootFolder(GoogleApiClient apiClient) {
        if (!apiClient.isConnected()) {
            throw new IllegalStateException("Client must be connected");
        }
        r r2 = apiClient.a(Drive.yE);
        return new u(r2.gl());
    }

    @Override
    public DriveFolder getAppFolder(GoogleApiClient apiClient) {
        if (!apiClient.isConnected()) {
            throw new IllegalStateException("Client must be connected");
        }
        r r2 = apiClient.a(Drive.yE);
        DriveId driveId = r2.gm();
        return driveId != null ? new u(driveId) : null;
    }

    @Override
    public OpenFileActivityBuilder newOpenFileActivityBuilder() {
        return new OpenFileActivityBuilder();
    }

    @Override
    public CreateFileActivityBuilder newCreateFileActivityBuilder() {
        return new CreateFileActivityBuilder();
    }

    @Override
    public PendingResult<Status> requestSync(GoogleApiClient client) {
        return client.b(new l(){

            @Override
            protected void a(r r2) throws RemoteException {
                r2.gk().a(new aw(this));
            }
        });
    }

    private static class f
    extends com.google.android.gms.drive.internal.c {
        private final a.d<DriveApi.ContentsResult> yO;

        public f(a.d<DriveApi.ContentsResult> d2) {
            this.yO = d2;
        }

        @Override
        public void a(OnContentsResponse onContentsResponse) throws RemoteException {
            this.yO.a(new a(Status.Ek, onContentsResponse.go()));
        }

        @Override
        public void o(Status status) throws RemoteException {
            this.yO.a(new a(status, null));
        }
    }

    private static class b
    extends com.google.android.gms.drive.internal.c {
        private final a.d<DriveApi.DriveIdResult> yO;

        public b(a.d<DriveApi.DriveIdResult> d2) {
            this.yO = d2;
        }

        @Override
        public void a(OnMetadataResponse onMetadataResponse) throws RemoteException {
            this.yO.a(new c(Status.Ek, new com.google.android.gms.drive.internal.l(onMetadataResponse.gw()).getDriveId()));
        }

        @Override
        public void a(OnDriveIdResponse onDriveIdResponse) throws RemoteException {
            this.yO.a(new c(Status.Ek, onDriveIdResponse.getDriveId()));
        }

        @Override
        public void o(Status status) throws RemoteException {
            this.yO.a(new c(status, null));
        }
    }

    static class c
    implements DriveApi.DriveIdResult {
        private final Status yw;
        private final DriveId Hw;

        public c(Status status, DriveId driveId) {
            this.yw = status;
            this.Hw = driveId;
        }

        @Override
        public Status getStatus() {
            return this.yw;
        }

        @Override
        public DriveId getDriveId() {
            return this.Hw;
        }
    }

    public static class a
    implements DriveApi.ContentsResult {
        private final Status yw;
        private final Contents HD;

        public a(Status status, Contents contents) {
            this.yw = status;
            this.HD = contents;
        }

        @Override
        public Status getStatus() {
            return this.yw;
        }

        @Override
        public Contents getContents() {
            return this.HD;
        }
    }

    abstract class l
    extends q<Status> {
        l() {
        }

        public Status d(Status status) {
            return status;
        }

        @Override
        public /* synthetic */ Result c(Status status) {
            return this.d(status);
        }
    }

    abstract class d
    extends q<DriveApi.DriveIdResult> {
        d() {
        }

        public DriveApi.DriveIdResult p(Status status) {
            return new c(status, null);
        }

        @Override
        public /* synthetic */ Result c(Status status) {
            return this.p(status);
        }
    }

    abstract class g
    extends q<DriveApi.ContentsResult> {
        g() {
        }

        public DriveApi.ContentsResult q(Status status) {
            return new a(status, null);
        }

        @Override
        public /* synthetic */ Result c(Status status) {
            return this.q(status);
        }
    }

    abstract class i
    extends q<DriveApi.MetadataBufferResult> {
        i() {
        }

        public DriveApi.MetadataBufferResult r(Status status) {
            return new e(status, null, false);
        }

        @Override
        public /* synthetic */ Result c(Status status) {
            return this.r(status);
        }
    }

    static class k
    extends j {
        k(GoogleApiClient googleApiClient, Status status) {
            this.a(new a.c(googleApiClient.a(Drive.yE).getLooper()));
            this.b(status);
        }

        @Override
        protected void a(r r2) {
        }
    }

    static abstract class j
    extends q<Status> {
        j() {
        }

        public Status d(Status status) {
            return status;
        }

        @Override
        public /* synthetic */ Result c(Status status) {
            return this.d(status);
        }
    }

    static class h
    extends com.google.android.gms.drive.internal.c {
        private final a.d<DriveApi.MetadataBufferResult> yO;

        public h(a.d<DriveApi.MetadataBufferResult> d2) {
            this.yO = d2;
        }

        @Override
        public void a(OnListEntriesResponse onListEntriesResponse) throws RemoteException {
            MetadataBuffer metadataBuffer = new MetadataBuffer(onListEntriesResponse.gt(), null);
            this.yO.a(new e(Status.Ek, metadataBuffer, onListEntriesResponse.gu()));
        }

        @Override
        public void o(Status status) throws RemoteException {
            this.yO.a(new e(status, null, false));
        }
    }

    static class e
    implements DriveApi.MetadataBufferResult {
        private final Status yw;
        private final MetadataBuffer IL;
        private final boolean IM;

        public e(Status status, MetadataBuffer metadataBuffer, boolean bl2) {
            this.yw = status;
            this.IL = metadataBuffer;
            this.IM = bl2;
        }

        @Override
        public Status getStatus() {
            return this.yw;
        }

        @Override
        public MetadataBuffer getMetadataBuffer() {
            return this.IL;
        }
    }
}

